<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\VisitorController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ActionController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\MigrationController;
use App\Http\Controllers\AddressController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ReferredByController;
use App\Http\Controllers\ReminderMasterController;
use App\Http\Controllers\SourceOfLeadController;
use App\Http\Controllers\TemplateController;
use Illuminate\Support\Facades\Queue;

Route::post('customerdetail', [CustomerController::class, 'create']);
Route::post('updateCustomerDetails', [CustomerController::class, 'updateCustomerDetails']);
Route::get('getCustomerDetails', [CustomerController::class, 'list']);
Route::post('updateCode', [UserController::class, 'updateCode']);
Route::post('setup_database', [MigrationController::class, 'setup_database'])->name('setup_database');
Route::get('install_passport', [MigrationController::class, 'install_passport'])->name('install_passport');
Route::get('delete_test_data', [MigrationController::class, 'delete_test_data'])->name('delete_test_data');
Route::post('delete_visit_data', [VisitorController::class, 'delete_visit_data']);

Route::group(['middleware' => 'auth:api'], function () {
    Route::post('empLocation',[UserController::class,'empLocation']);
    Route::post('create-event', [EventController::class, 'create']);
    Route::get('getEventsofUser', [EventController::class, 'getEventsofUser']);
    Route::get('product-list', [ProductController::class, 'list']);
    Route::post('check_status', [UserController::class, 'getUserStatus']);
    Route::post('create-product', [ProductController::class, 'store']);
    Route::post('update-product', [ProductController::class, 'updateProduct']);
    Route::post('getVisitors', [VisitorController::class, 'getVisitors']);
    Route::post('getAllVisitors', [VisitorController::class, 'getAllVisitors']);
    Route::post('create-visitor', [VisitorController::class, 'store']);
    Route::post('update-visitor', [VisitorController::class, 'store']);
    Route::get('category-list', [VisitorController::class, 'getcategoryList']);
    Route::get('action-list', [ProductController::class, 'getactionList']);
    Route::post('create-action', [ActionController::class, 'store']);
    Route::post('update-action', [ActionController::class, 'update']);
    Route::post('create-category', [CategoryController::class, 'store']);
    Route::post('update-category', [CategoryController::class, 'update']);
    // Route::post('SendMail', [UserController::class, 'SendMail']);
    Route::post('create_visit_data', [VisitorController::class, 'create_data']);
    Route::get('get_whatsAppmsg', [VisitorController::class, 'get_whatsAppmsg']);

    Route::get('team-members-list', [UserController::class, 'teamMembersList']);
    Route::get('team-members-list-with-location', [UserController::class, 'getTemaMemeberWithLocation']);
    Route::get('user-current-location', [UserController::class, 'getUserCurrentLocation']);
    Route::post('make_admin_to_team_member', [UserController::class, 'makeAdminToTeamMember']);
    Route::get('event-team-members-list', [UserController::class, 'eventAssignTeamMemberList']);
    Route::post('event_assignments', [UserController::class, 'eventAssignments']);

    Route::post('team_member_delete', [UserController::class, 'teamMemberDelete']);
    Route::post('customer_update_permissions', [UserController::class, 'updatepermission']);
    Route::post('customer_change_password', [UserController::class, 'changePassword']);

    Route::post('add-edit-subcategory', [CategoryController::class, 'addEditSubCategory']);
    Route::get('sub-category-list', [CategoryController::class, 'subCategoryList']);

    Route::post('category-delete', [CategoryController::class, 'categoryDelete']);
    Route::post('sub-category-delete', [CategoryController::class, 'subCategoryDelete']);
    Route::post('action-delete', [ActionController::class, 'delete']);
    Route::post('logout', [UserController::class, 'logout']);
    Route::get('whatsAppTempletes', [TemplateController::class, 'whatsAppTempletes']);

    Route::post('send_whatsapp_test_message', [TemplateController::class, 'send_whatsapp_test_message']);
    Route::post('send_whatsapp_bulk_message', [TemplateController::class, 'send_whatsapp_bulk_message']);
    Route::post('send_whatsapp_single_message', [TemplateController::class, 'send_whatsapp_single_message']);

    Route::post('get_recent_whatsapp_replies', [TemplateController::class, 'get_recent_whatsapp_replies']);
    Route::post('get_single_whatsapp_replies', [TemplateController::class, 'get_single_whatsapp_replies']);

    Route::get('whatsapp_batch_list', [TemplateController::class, 'whatsapp_batch_list']);
    Route::post('whatsappLogByBatch_id', [TemplateController::class, 'whatsappLogByBatch_id']);

    Route::get('source-of-lead-list', [SourceOfLeadController::class, 'list']);
    Route::get('referred-by-list', [ReferredByController::class, 'list']);
    Route::get('reminder-master-list', [ReminderMasterController::class, 'list']);
    Route::post('user_attendance', [UserController::class, 'user_attendance']);
});

Route::get('/webhook', [TemplateController::class, 'verifyToken']);
Route::post('/webhook', [TemplateController::class, 'receiveData']);

Route::post("send_whatsapp_api",[UserController::class, 'send_whatsapp_api']);
Route::post('sendemail', [UserController::class, 'sendemail']);
Route::post('sendfollowupmail', [UserController::class, 'sendfollowupmail']);
Route::post('visitemail', [UserController::class, 'visitemail']);
Route::post('updateAddress', [AddressController::class, 'updateAddress']);

Route::post('resetPassword', [AuthController::class, 'resetPassword']);

Route::get('/run-queue', function () {

    Artisan::call('queue:custom-work');
    return response()->json(['status' => 'Queue processed']);
});

