<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Laravel\Passport\Token;
use Hash;
use App\Models\Sendpush;
use App\Models\Admin;
class   User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = "users";
    protected $primaryKey = 'user_id';
    public $timestamps = false;

    public static function chkUserExists($user_id, $code)
    {
        // DB::enableQueryLog();
        return User::where('code', $code)->where('CustomerID',$user_id)->count();
        // dd(DB::getQueryLog());
    }
    public static function get_email($user_id, $code)
    {
        // DB::enableQueryLog();
        return User::where('CustomerID',$user_id)->where('code', $code)->first();
        // dd(DB::getQueryLog());
    }
    public static function get_user_details($email, $customer_id)
    {
        // DB::enableQueryLog();
        return User::where('CustomerID',$customer_id)->first();
        // dd(DB::getQueryLog());
    }
    public static function get_user_email_config_details($customer_id)
    {
        // DB::enableQueryLog();
        return DB::table('user_email_config')->where('fk_user_id',$customer_id)->first();
        // dd(DB::getQueryLog());
    }
    public static function getUserEmailDraft($primary_email)
    {
        // DB::enableQueryLog();
        return DB::table('email_drafts')->where('id',$primary_email)->first();
        // dd(DB::getQueryLog());
    }
    public static function get_email_config()
    {
        // DB::enableQueryLog();
        return DB::table('email_config')->orderBy('id','desc')->first();
        // dd(DB::getQueryLog());
    }
    public static function getEmailAttachments($id)
    {
        // DB::enableQueryLog();
        return DB::table('email_attachments')->where('email_id',$id)->get();
        // dd(DB::getQueryLog());
    }
    public static function getUserEmailDraft_follow($follow_up_email)
    {
        // DB::enableQueryLog();
        return DB::table('email_drafts')->where('id',$follow_up_email)->first();
        // dd(DB::getQueryLog());
    }

    public function latestLocation(){
        return $this->hasOne(UserLocation::class,'user_id','user_id')->orderBy('created_at','desc');
    }
    public static function insertUser($data)
    {
        $obj = new User();
        $obj->imei = "";
        $obj->CustomerID = $data['user_id'];
        $obj->status = $data['status'];
        $obj->expiry_date = $data['expiry_date'];
        $obj->CustomerName = $data['name'];
        $obj->code = $data['code'];
        $obj->is_admin = "false";

        if(isset($data['email'])){
            if($data['email'] == ""){
                $addemail = "na";
            }else{
                $addemail = $data['email'];
            }
            $obj->Email = $addemail;
        }
        if(isset($data['password'])){
            if($data['password'] == ""){
                $addpassword = NULL;
            }else{
                $addpassword =  Hash::make($data['password']);
            }
            $obj->password = $addpassword;
        }

        $user = $obj->save();

        auth()->loginUsingId($obj->user_id);
        $token = auth()->user()->createToken('API Token')->accessToken;

        return [$obj->is_admin, $token];
    }
    public static function updateUser($data)
    {
        $data_UPDATE = ([
            'imei' => "",
            'CustomerName' => $data['name'],
            'expiry_date' => $data['expiry_date'],
            'status' => $data['status'],
            // 'is_admin' => "false",
        ]);
        DB::table('users')->where('CustomerID',$data['user_id'])->where('code', $data['code'])->update($data_UPDATE);
        $get_user_id = DB::table('users')->where('CustomerID',$data['user_id'])->where('code', $data['code'])->first();

        $user =  auth()->loginUsingId($get_user_id->user_id);
        $user->tokens->each(function (Token $token) { $token->revoke(); });

        auth()->loginUsingId($get_user_id->user_id);
        $token = auth()->user()->createToken('API Token')->accessToken;
        // $isadmin = "false";
        $isadmin =  $get_user_id->is_admin;

        return [$isadmin, $token];
    }
    // public static function update_email($data)
    // {
    //     if($data['email'] == ""){
    //         $addemail = "na";
    //     }else{
    //         $addemail = $data['email'];
    //     }

    //     if($data['password'] == ""){
    //         $addpassword = NULL;
    //     }else{
    //         $addpassword =  Hash::make($data['password']);
    //     }

    //     $data_UPDATE = ([
    //         'Email' =>  $addemail,
    //         'password' =>$addpassword
    //     ]);
    //     return DB::table('users')->where('CustomerID',$data['user_id'])->where('code', $data['code'])->update($data_UPDATE);
    //     $get_user_id = DB::table('users')->where('CustomerID',$data['user_id'])->where('code', $data['code'])->first();


    //     $user =  auth()->loginUsingId($get_user_id->user_id);
    //     $user->tokens->each(function (Token $token) { $token->revoke(); });

    //     auth()->loginUsingId($get_user_id->user_id);
    //     $token = auth()->user()->createToken('API Token')->accessToken;
    //     // $isadmin = "false";

    //     return [$token];
    // }
    public static function update_data_all($data)
    {
        $data_UPDATE = ([
            'imei' => "",
            'CustomerName' => $data['name'],
            'CustomerID' => $data['user_id'],
            'expiry_date' => $data['expiry_date'],
            //'Phone'=> $data['mobile_number'] ?? '',
            'status' => $data['status'],
            'code'=>$data['code'],
            // 'push_token' => $data['token'],
            // 'device_type' => $data['device_type'],
            // 'is_admin' => "false",
        ]);

        return DB::table('users')->where('email',$data['email'])->update($data_UPDATE);
        // $get_user_id = DB::table('users')->where('CustomerID',$data['user_id'])->where('code', $data['code'])->first();
        // $isadmin =  $get_user_id->is_admin;

        // return  [$isadmin, $update];
    }
    public static function insert_email($data)
    {
        // Insert User Data
        $is_admin = User::exists() ? "false" : "true";
        $obj = new User();
        $obj->imei = "";
        $obj->CustomerID = $data['user_id'];
        $obj->status = $data['status'];
        $obj->Phone = $data['mobile_number'] ?? '';
        $obj->expiry_date = $data['expiry_date'];
        $obj->CustomerName = $data['name'];
        $obj->code = $data['code'];

        // $data['push_token'] = $data['token'];

        // $obj->push_token = $data['push_token'];
        // $obj->device_type = $data['device_type'];
        $obj->is_admin = $is_admin;

        if(isset($data['email'])){
            if($data['email'] == ""){
                $addemail = "na";
            }else{
                $addemail = $data['email'];
            }
            $obj->Email = $addemail;
        }
        if(isset($data['password'])){
            if($data['password'] == ""){
                $addpassword = NULL;
            }else{
                $addpassword =  Hash::make($data['password']);
            }
            $obj->password = $addpassword;
        }

        $user = $obj->save();


         // Insert into 'admin' table
         $role = Admin::exists() ? "user" : "admin";
         $admin = new Admin();
         $admin->user_id = $obj->user_id;
         $admin->name = $data['name'];
         $admin->email = $data['email'] ?? 'na';
         $admin->password = $data['password'] !== "" ? Hash::make($data['password']) : NULL;
         $admin->type    = $role; // Set role based on existence in 'admin' table
         $admin->save();

        auth()->loginUsingId($obj->user_id);
        $token = auth()->user()->createToken('API Token')->accessToken;

        return [$obj->is_admin, $token];
    }
    public static function  getemail($email)
    {
        return DB::table('users')->where('Email',$email)->first();
    }

    public static function fetchAllTeamMembersForEvent($event_id)
    {
        return DB::table('event_assignments')->select('users.*', 'event_assignments.fk_event_id')
            ->join('users', 'users.user_id', 'fk_user_id')
            ->where('fk_event_id', $event_id)
            ->where('users.is_delete','false')
            ->where('users.status', 'true')->get();
    }

    public function customerPermissions()
    {
        return $this->hasOne(Permissions::class,'fk_customer_id','CustomerID');
    }
}
