<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;
use DB;
use Carbon\Carbon;

class Product extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'price', 'brochure'];

    public function getCreatedAtAttribute($date)
    {
        return Carbon::parse($date)->setTimezone('Asia/Kolkata')->format('Y-m-d H:i:s');
    }

    public function getUpdatedAtAttribute($date)
    {
        return Carbon::parse($date)->setTimezone('Asia/Kolkata')->format('Y-m-d H:i:s');
    }
	
	 public function product_images()
    {
        return $this->hasMany(ProductImage::class, 'fk_product_id' , 'id');
    }

    public static function fetchAllProducts()
    {
		//EventAssignment::with('event')->where('fk_user_id', $user_id)->get()
        return Product::with('product_images')->orderBy('updated_at')->get();
    }

    public function getQrFileAttribute($value) {
        if(!empty($value)){
            return env("APP_URL")."/frenzincrm/uploads/product_qr/".$value;
        }
        return null;
    }
	
	public function insertProduct($data, $productid = "")
    {
        $product_images = $data['products_images'] ?? "";
        $product_images_arr = [];
 
        $obj = new Product();
        $obj->fk_user_id        = Auth::user()->CustomerID;
        $obj->name              = isset($data['name']) ? $data['name'] : "";
        $obj->save();
        $productid = $obj->id;

        if (isset($data['products_images']) && $data['products_images']!=null ) {
            $images = $data['products_images'];
            foreach ($images as $key => $image) { 
                $ext = $image->getClientOriginalExtension();
                $name = str_replace(' ', '_', $image->getClientOriginalName());                
                $imgname = md5(microtime() . $name) . "." . $ext;
                if ($image->move(public_path('uploads/product/'.$productid.'/'), $imgname)) 
				{
					$imgname = url('uploads/product/'.$productid) .'/'. $imgname;
                    DB::table('product_images')->insert(['fk_product_id' => $productid, 'image' => $imgname, 'description' => $data['description'][$key]]);
                }
            }
        }

        return $productid;
    }

    public function updateProduct($data)
    {
        if(isset($data['product_img_ids'])) {
            $delete_product_imgs = explode(',', $data['product_img_ids']);    
            foreach($delete_product_imgs as $value)
            {
                $proImg = ProductImage::where('id', $value)->first(); 
                if($proImg){
                    $pos = strrpos($proImg->image, '/');
                    $imagename = $pos === false ? $pos : substr($proImg->image, $pos + 1);
    
                    if (file_exists(public_path('uploads/product/').$data['product_id'])) {
                        unlink(public_path('uploads/product/').$data['product_id']."/".$imagename);
                    }
                    ProductImage::where('id', $value)->delete();
                }
            }
        }

        $product_images = $data['products_images'] ?? "";
        $product_images_arr = [];
 
        $obj = Product::find($data['product_id']);
        $obj->fk_user_id        = Auth::user()->CustomerID;
        $obj->name              = isset($data['name']) ? $data['name'] : "";
        $obj->save();
        $productid = $obj->id;

        if (isset($data['products_images']) && $data['products_images']!=null ) {
            $images = $data['products_images'];
            foreach ($images as $key => $image) { 
                $ext = $image->getClientOriginalExtension();
                $name = str_replace(' ', '_', $image->getClientOriginalName());                
                $imgname = md5(microtime() . $name) . "." . $ext;
                if ($image->move(public_path('uploads/product/'.$productid.'/'), $imgname)) 
				{
					$imgname = url('uploads/product/'.$productid) .'/'. $imgname;
                    DB::table('product_images')->insert(['fk_product_id' => $productid, 'image' => $imgname, 'description' => $data['description'][$key]]);
                }
            }
        }

        return $productid;
    }
	
}