<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\LogRequestResponse;
use Illuminate\Support\Facades\Auth;

class LogRequestResponseMW 
{
    protected $errorCodes = [500, 401, 403, 422, 404];

    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);
        $statusCode = $response->getStatusCode();

        // Prepare log data
        $logData = [
            'user_id' =>  Auth::check() ? Auth::user()->CustomerID : null,
            'api_url' => ltrim($request->path(), '/'),
            'api_data' => json_encode($request->except(['password', 'password_confirmation', 'token'])),
            'api_type' => $request->method(),
            'response_code' => $statusCode,
            'error_response' => in_array($statusCode, $this->errorCodes) && method_exists($response, 'getContent')
                ? json_encode($response->getContent())
                : null,
            'date_time' => now(),
        ];

        // Save log to database
        LogRequestResponse::create($logData);

        return $response;
    }
}
