<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Event;
use App\Models\Product;
use App\Models\Permissions;
use App\Models\Sendpush;
use App\Models\Admin;
use App\Models\LocationConfig;
use App\Models\ReferredByMaster;
use App\Models\ReminderMaster;
use App\Models\SourceOfLead;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use DB;
use App\Models\Visitor;
use Config;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Laravel\Passport\Token;
use Illuminate\Support\Facades\Log;
use App\Models\UserAttendance;
use App\Models\UserLocation;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\DB as FacadesDB;

class UserController extends Controller
{
    public $successStatus = 200;
    public $failureStatus = 203;

    public function __construct()
    {
        $this->_user = new User();
        $this->Permissions = new Permissions();
        $this->_Visitor = new Visitor();
    }

    public function updateCode(Request $request)
    {
        try {

            if ($request->email == "" && $request->password == "") {

                $chkUserExists = $this->_user->chkUserExists($request->user_id, $request->code);
                if ($chkUserExists == 0) {
                    $insertUser = $this->_user->insertUser($request->all());
                    $permissions = $this->Permissions->Permissionslist();

                    // dd($request->user_id);
                    $this->Permissions->insertpermission($request->user_id);

                    return response()->json(
                        [
                            'status' => true,
                            'is_admin' => $insertUser[0],
                            'token' => $insertUser[1],
                        ],
                        $this->successStatus
                    );
                } else {

                    $insertUser = $this->_user->updateUser($request->all());

                    return response()->json(
                        [
                            'status' => true,
                            'is_admin' => $insertUser[0],
                            'token' => $insertUser[1],
                        ],
                        $this->successStatus
                    );
                }
            } else {
                // code here
                $check_email = $this->_user->getemail($request->email);

                if ($check_email == null) {
                    $insertUser = $this->_user->insert_email($request->all());
                    $this->Permissions->insertpermission($request->user_id);
                    return response()->json(
                        [
                            'status' => true,
                            'is_admin' => $insertUser[0],
                            'token' => $insertUser[1],
                        ],
                        $this->successStatus
                    );
                } else {

                    $credentials = $request->only('email', 'password');
                    if (Auth::attempt($credentials)) {

                        $user_detail = Auth::user();

                        $user =  auth()->loginUsingId($user_detail->user_id);
                        $user->tokens->each(function (Token $token) {
                            $token->revoke();
                        });

                        auth()->loginUsingId($user_detail->user_id);
                        $token = auth()->user()->createToken('API Token')->accessToken;

                        $updatedata = $this->_user->update_data_all($request->all());

                        $this->Permissions->insertpermission($request->user_id);

                        $get_user_id = DB::table('users')->where('CustomerID', $request->user_id)->where('code', $request->code)->first();

                        if (isset($get_user_id)) {
                            $isadmin =  $get_user_id->is_admin;
                        } else {
                            $isadmin = "false";
                        }


                        return response()->json(array(
                            'status' => true,
                            // 'message' => "Get User Detail successfully ",
                            'is_admin' => $isadmin,
                            'token' =>  $token
                        ), 200);
                    } else {
                        return response()->json(['error' => 'Unauthorized'], 403);
                    }
                }
            }
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function empLocation(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'locations' => 'required',
            'locations.*.current_lat' => 'required',
            'locations.*.current_lng' => 'required',
        ]);

        if($validator->fails()){
            Log::channel('location_log')->info('Validation Failed',['error'=>$validator->errors()]);

            return response()->json([
                'status' => false,
                'message' => $validator->errors()->first(),
            ], 200);
        }

        FacadesDB::beginTransaction();
        try{
            $lastGpsStatus = null;

            foreach($request->locations as $location){
            $userLocation = UserLocation::create([
                'user_id' => Auth::user()?->user_id,
                'lat' => $location['current_lat'],
                'lng' => $location['current_lng'],
                'traveld_km' => $location['traveld_km'],
                'on_demand' => $location['is_pusher_entry'] ?? 'false',
                'date_time' => Carbon::parse($location['date_time'] ?? now()),

            ]);
                $lastGpsStatus = $location['gps_status'];
            }

            $currentGpsStatus = Auth::user()?->gps_status;
            if($lastGpsStatus != $currentGpsStatus){
                FacadesDB::table('users')
                ->where('user_id', Auth::user()?->user_id)
                ->update([
                    'gps_status' => $lastGpsStatus,
                ]);

            }
            FacadesDB::commit();

            return response()->json([
                'status' => true,
                'message' => 'User Location Added Successfully',
            ], 200);
        }catch(Exception $e){
            FacadesDB::rollBack();
            Log::channel('location_log')->error($e->getMessage());
            return response()->json([
                'status' => false,
                'message' => $e->getMessage(),
            ], 500);
        }
    }
    public function send_whatsapp_api(Request $request){
        $mobile_number = $request?->mobile_number;
        $visitor_name = $request?->visitor_name;
        $is_international = $request?->is_international;

        $validator = Validator::make($request->all(),[
            'mobile_number' => 'required|min:7',
            'visitor_name' => 'required',
            'is_international' => 'required|in:true,false',
        ],[
            'mobile_number.required' => 'Mobile number is required',
            'mobile_number.min' => 'Mobile number must be at least 10 digits',
            'visitor_name.required' => 'Visitor name is required',
            'is_international.required' => 'Is international is required',
            'is_international.in' => 'Is international must be true or false',
        ]);

        if($validator->fails()){
            return response()->json([
                'status' => false,
                'message' => $validator->errors()->first(),
                'errors' => $validator->errors(),
            ], 200);
        }

        return response()->json([
            'status' => true,
            'message' => 'WhatsApp message sent successfully',
        ]);
    }

    public function getUserStatus(Request $request)
    {
        try {
            $user = Auth::user();
            $send_whatsapp_api = 0;

            $update_token = User::where('user_id', $user->user_id)->update(['push_token' => isset($request->token) ? $request->token : $user->push_token, 'device_type' => isset($request->device_type) ? $request->device_type : $user->device_type]);

            if ($user->is_admin == "true") {
                $is_admin = "true";
            } else {
                $is_admin = "false";
            }

            $result = $this->Permissions->Permissionslist();
            $result = $result->first();

            if ($result) {
                if ($result->Contact_Share == 1) {
                    $contact_share = "true";
                } else {
                    $contact_share = "false";
                }
                if ($result->Call_Contact == 1) {
                    $call_contact = "true";
                } else {
                    $call_contact = "false";
                }
                if ($result->Send_Whatsapp == 1) {
                    $send_whatsapp = "true";
                } else {
                    $send_whatsapp = "false";
                }
                if ($result->Save_Contact == 1) {
                    $save_contact = "true";
                } else {
                    $save_contact = "false";
                }
                if ($result->Export_Excel == 1) {
                    $export_excel = "true";
                } else {
                    $export_excel = "false";
                }
                if ($result->send_email == 1) {
                    $send_email = "true";
                } else {
                    $send_email = "false";
                }
                if ($result->Bulk_Whatsapp == 1) {
                    $send_bulk_whatsapp = 1;
                } else {
                    $send_bulk_whatsapp = 0;
                }
            } else {
                $contact_share = "true";
                $call_contact = "true";
                $send_whatsapp = "true";
                $save_contact = "true";
                $export_excel = "true";
                $send_email = "false";
                $send_bulk_whatsapp = 1;
            }


            $response = array();
            if (isset($request->products_updated_at) && $request->products_updated_at != null &&  $request->products_updated_at != "") {
                $query = Product::where('updated_at', '>', $request->products_updated_at);

                $query = $query->first();

                if (isset($query) && $query != null)
                    $response['update_products'] = "true";
                else
                    $response['update_products'] = "false";


                $query2 = Product::select('id')->get();
                //$query2->pluck('id')->toArray();
                $idArray = array();

                foreach ($query2 as $pro_id) {
                    $idArray[] = $pro_id->id;
                }
                $response['product_ids'] = $idArray;

                $query3 = DB::table('category')->select('id')->get();
                //$query3->pluck('id')->toArray();
                $idsArray = array();

                foreach ($query3 as $cate_id) {
                    $idsArray[] = $cate_id->id;
                }
                $response['category_ids'] = $idsArray;
            } else {
                $response['update_products'] = "true";
            }

            if (isset($request->events_updated_at) && $request->events_updated_at != null &&  $request->events_updated_at != "") {
                $query = Event::where('updated_at', '>', $request->events_updated_at);

                $query = $query->first();

                if (isset($query) && $query != null)
                    $response['update_events'] = "true";
                else
                    $response['update_events'] = "false";
            } else {
                $response['update_events'] = "true";
            }


            if (isset($request->source_of_lead_updated_at) && $request->source_of_lead_updated_at != null &&  $request->source_of_lead_updated_at != "") {

                $query = SourceOfLead::where('updated_at', '>',Carbon::parse($request->source_of_lead_updated_at)->timezone('Asia/Kolkata')->format('Y-m-d H:i:s'));
                $query = $query->first();
                if (isset($query) && $query != null)
                    $response['update_sourceoflead'] = "true";
                else
                    $response['update_sourceoflead'] = "false";
            } else {
                $response['update_sourceoflead'] = "true";
                if(SourceOfLead::count() == 0){
                    $response['update_sourceoflead'] = "false";
                }
            }

            if (isset($request->referred_by_updated_at) && $request->referred_by_updated_at != null &&  $request->referred_by_updated_at != "") {
                $query = ReferredByMaster::where('updated_at', '>', $request->referred_by_updated_at);
                $query = $query->first();
                if (isset($query) && $query != null)
                    $response['update_referredby'] = "true";
                else
                    $response['update_referredby'] = "false";
            } else {
                $response['update_referredby'] = "true";
                if(ReferredByMaster::count() == 0){
                    $response['update_referredby'] = "false";
                }
            }

            if (isset($request->reminder_master_updated_at) && $request->reminder_master_updated_at != null &&  $request->reminder_master_updated_at != "") {
                $query = ReminderMaster::where('updated_at', '>', $request->reminder_master_updated_at);
                $query = $query->first();
                if (isset($query) && $query != null)
                    $response['update_reminder_master'] = "true";
                else
                    $response['update_reminder_master'] = "false";
            } else {
                $response['update_reminder_master'] = "true";
                if(ReminderMaster::count() == 0){
                    $response['update_reminder_master'] = "false";
                }
            }

            if (isset($request->visitors_updated_at) && $request->visitors_updated_at != null &&  $request->visitors_updated_at != "") {
                $query = Visitor::where('updated_at', '>', $request->visitors_updated_at);

                $query = $query->first();

                if (isset($query) && $query != null)
                    $response['update_visitors'] = "true";
                else
                    $response['update_visitors'] = "false";
            } else {
                $response['update_visitors'] = "true";
            }


            if (isset($request->last_message_time) && $request->last_message_time != null &&  $request->last_message_time != "") {
                $count = DB::table('whatsapp_replies')
                    ->where('created_at', '>', $request->last_message_time)
                    ->where('visitor_id', '!=', 0)
                    ->count();

                $response['whatsapp_message_count'] = $count;
            } else {
                $response['whatsapp_message_count'] = 0;
            }



            $response['is_admin'] = $is_admin;
            $response['customer_id'] = $user->CustomerID;
            $response['Contact_Share'] = $contact_share;
            $response['Call_Contact'] = $call_contact;
            $response['Send_Whatsapp'] = $send_whatsapp;
            $response['Save_Contact'] = $save_contact;
            $response['Export_Excel'] = $export_excel;
            $response['send_email'] = $send_email;
            $response['bulk_whatsapp'] = $send_bulk_whatsapp;
            $response['logo'] = "";
            $response['title'] = "";
            $response['send_whatsapp_api'] = $send_whatsapp_api;
            $response['command'] = ($user->is_delete == "true") ? "deleted" : "";
            $response['location_config'] = isset($user->location_config) ? $user->location_config : 0;
            $response['replaced_with'] = isset($user->replaced_with) ? $user->replaced_with : "0";
            $response['location_interval'] = strval((LocationConfig::first()?->location_interval) ?? 0);

            $wpMsg = DB::table('whatsapp_msg')->first();
            $response['whatsapp_msg'] = isset($wpMsg->message) ? $wpMsg->message : "";
            $response['show_visits'] = true; /// YE NEW API USERS me visits show karne ke liye hai.

            return response()->json(
                [
                    'status' => true,
                    'data' => $response
                ],
                $this->successStatus
            );
        } catch (\Throwable $th) {
            throw $th;
        }
    }
    public function sendemail(Request $request)
    {

        try {
            //Log::channel('emergency')->info($request);
            $chkVisitorExists = $this->_Visitor->get_Visitor_details($request->visitor_id);
            // dd($chkVisitorExists);
            // $chkVisitorExists_name = $this->_Visitor->get_Visitor_name($request->visitor_name);

            // if(isset($chkVisitorExists->name)){
            //     dd($chkVisitorExists->name."if");
            // }else if(isset($chkVisitorExists_name->name)){
            //     dd($chkVisitorExists_name->name);
            // }else{
            //     return response()->json(
            //         [
            //             'status' => false,
            //         ],
            //     );
            // }

            $chkUserExists = $this->_user->get_user_details($request->email, $request->customer_id);

            if (isset($chkUserExists)) {
                $mailConfig = $this->_user->get_user_email_config_details($request->customer_id);
                $email_config = $this->_user->get_email_config();

                $email_draft = $this->_user->getUserEmailDraft($chkUserExists->primary_email);

                if (!empty($email_draft)) {
                    $attachments = $this->_user->getEmailAttachments($email_draft->id);
                } else {
                    $attachments = null;
                }
                if ($chkUserExists->cc_email != null) {
                    $cc_email = explode(',', $chkUserExists->cc_email);
                } else {
                    $cc_email = null;
                }
                if ($chkUserExists->bcc_email != null) {
                    $bcc_email = explode(',', $chkUserExists->bcc_email);
                } else {
                    $bcc_email = null;
                }

                if (isset($request->email2) && !empty($request->email2)) {
                    $emailAddresses = [$request->email, $request->email2];
                } else {
                    $emailAddresses = [$request->email];
                }

                foreach ($emailAddresses as $emailAddress) {

                    // Set the "to_email" to the current email address in the loop
                    $data["to_email"] = $emailAddress;

                    // $data["to_email"] = $request->email;
                    $data["sender_name"] = $chkUserExists->sender_name;
                    $data["sender_email"] = $chkUserExists->sender_email;
                    $data["cc_email"] = $cc_email;
                    $data["bcc_email"] = $bcc_email;
                    $data["subject"] = isset($email_draft->subject) ? $email_draft->subject : "";
                    $emailContent = isset($email_draft->content) ? $email_draft->content : "";
                    $userName =  $request->visitor_name ?? ''; // $chkUserExists->CustomerName
                    $companyName = $request->comapany_name  ?? ''; //$chkUserExists->CompanyName
                    $designation =  $request->designation ?? ''; //$chkVisitorExists->designation
                    //$phone_number =  $request->phone_number ?? ''; //$chkVisitorExists->designation
                    //$is_personalized  =  $request->is_personalized  ?? ''; //$chkVisitorExists->designation

                    $emailContent = str_replace('*user name*', $userName, $emailContent);
                    $emailContent = str_replace('*company name*', $companyName, $emailContent);
                    $emailContent = str_replace('*designation*', $designation, $emailContent);
                    // $emailContent = str_replace('*phone number*', $phone_number, $emailContent);
                    // $emailContent = str_replace('*is personalized*', $is_personalized, $emailContent);
                    $data["body"] = $emailContent . '<br>' . $chkUserExists->signature;
                    //dd($emailContent);
                    if (!empty($mailConfig)) {
                        Config::set('mail.mailers.smtp.transport', $mailConfig->smtp_transport);
                        Config::set('mail.mailers.smtp.host', $mailConfig->host);
                        Config::set('mail.mailers.smtp.port', $mailConfig->port);
                        Config::set('mail.mailers.smtp.encryption', $mailConfig->smtp_encryption); // or 'ssl'
                        Config::set('mail.mailers.smtp.username', $mailConfig->username);
                        Config::set('mail.mailers.smtp.password', $mailConfig->password);
                    } else {
                        // Config::set('mail.mailers.smtp.transport', 'smtp');
                        // Config::set('mail.mailers.smtp.host', 'email-smtp.ap-south-1.amazonaws.com');
                        // Config::set('mail.mailers.smtp.port',587);
                        // Config::set('mail.mailers.smtp.encryption', 'tls'); // or 'ssl'
                        // Config::set('mail.mailers.smtp.username', 'AKIASAHO74KMPZV7Z6HQ');
                        // Config::set('mail.mailers.smtp.password', 'BNSFf2FUd72yaGiKZm+boBm+dmW5Dt/l2VlWt75WLkXt');

                        Config::set('mail.mailers.smtp.transport', $email_config->smtp_transport);
                        Config::set('mail.mailers.smtp.host', $email_config->host);
                        Config::set('mail.mailers.smtp.port', $email_config->smtp_port);
                        Config::set('mail.mailers.smtp.encryption', $email_config->smtp_encryption);
                        Config::set('mail.mailers.smtp.username', $email_config->username);
                        Config::set('mail.mailers.smtp.password', $email_config->password);
                    }
                    if (!empty($email_draft)) {
                        Mail::send('emails.emailContent', ['data' => $data], function ($message) use ($data, $attachments) {
                            $message->to($data["to_email"]);
                            $message->subject($data["subject"]);
                            $message->from($data["sender_email"], $data["sender_name"]);

                            if (isset($data["cc_email"])) {
                                $message->cc($data["cc_email"]);
                            }
                            if (isset($data["bcc_email"])) {
                                $message->bcc($data["bcc_email"]);
                            }
                            if (isset($attachments)) {
                                // $url = "../../frenzincrm_api/public/uploads/email/attachments/";
                                $url = "../../frenzincrm/public/uploads/email/attachments/";
                                foreach ($attachments as $key => $attach) {
                                    $attachmentPath = $url . $attach->attachment;
                                    $message->attach($attachmentPath);
                                }
                            }
                        });
                    }
                }
                return response()->json(
                    [
                        'status' => true,
                    ],
                    $this->successStatus
                );
            }
        } catch (\Throwable $th) {

            throw $th;
        }
    }


    public function sendfollowupmail(Request $request)
    {
        try {

            // $chkVisitorExists = $this->_Visitor->get_Visitor_details($request->visitor_id);
            // $chkVisitorExists_name = $this->_Visitor->get_Visitor_name($request->visitor_name);

            // if(isset($chkVisitorExists->name)){
            //     dd($chkVisitorExists->name."if");
            // }else if(isset($chkVisitorExists_name->name)){
            //     dd($chkVisitorExists_name->name);
            // }else{
            //     return response()->json(
            //         [
            //             'status' => false,
            //         ],
            //     );
            // }

            $chkUserExists = $this->_user->get_user_details($request->email, $request->customer_id);

            if (isset($chkUserExists)) {
                $mailConfig = $this->_user->get_user_email_config_details($request->customer_id);
                $email_config = $this->_user->get_email_config();

                $email_draft = $this->_user->getUserEmailDraft_follow($chkUserExists->follow_up_email);


                if (!empty($email_draft)) {
                    $attachments = $this->_user->getEmailAttachments($email_draft->id);
                } else {
                    $attachments = null;
                }
                if ($chkUserExists->cc_email != null) {
                    $cc_email = explode(',', $chkUserExists->cc_email);
                } else {
                    $cc_email = null;
                }
                if ($chkUserExists->bcc_email != null) {
                    $bcc_email = explode(',', $chkUserExists->bcc_email);
                } else {
                    $bcc_email = null;
                }

                if (isset($request->email2) && !empty($request->email2)) {
                    $emailAddresses = [$request->email, $request->email2];
                } else {
                    $emailAddresses = [$request->email];
                }

                foreach ($emailAddresses as $emailAddress) {
                    // Set the "to_email" to the current email address in the loop
                    $data["to_email"] = $emailAddress;

                    // $data["to_email"] = $request->email;
                    $data["sender_name"] = $chkUserExists->sender_name;
                    $data["sender_email"] = $chkUserExists->sender_email;
                    $data["cc_email"] = $cc_email;
                    $data["bcc_email"] = $bcc_email;
                    $data["subject"] = isset($email_draft->subject) ? $email_draft->subject : "";
                    $data["body"] = isset($email_draft->content) ? $email_draft->content : "";

                    if (!empty($mailConfig)) {
                        Config::set('mail.mailers.smtp.transport', $mailConfig->smtp_transport);
                        Config::set('mail.mailers.smtp.host', $mailConfig->host);
                        Config::set('mail.mailers.smtp.port', $mailConfig->port);
                        Config::set('mail.mailers.smtp.encryption', $mailConfig->smtp_encryption); // or 'ssl'
                        Config::set('mail.mailers.smtp.username', $mailConfig->username);
                        Config::set('mail.mailers.smtp.password', $mailConfig->password);
                    } else {
                        // Config::set('mail.mailers.smtp.transport', 'smtp');
                        // Config::set('mail.mailers.smtp.host', 'email-smtp.ap-south-1.amazonaws.com');
                        // Config::set('mail.mailers.smtp.port',587);
                        // Config::set('mail.mailers.smtp.encryption', 'tls'); // or 'ssl'
                        // Config::set('mail.mailers.smtp.username', 'AKIASAHO74KMPZV7Z6HQ');
                        // Config::set('mail.mailers.smtp.password', 'BNSFf2FUd72yaGiKZm+boBm+dmW5Dt/l2VlWt75WLkXt');

                        Config::set('mail.mailers.smtp.transport', $email_config->smtp_transport);
                        Config::set('mail.mailers.smtp.host', $email_config->host);
                        Config::set('mail.mailers.smtp.port', $email_config->smtp_port);
                        Config::set('mail.mailers.smtp.encryption', $email_config->smtp_encryption);
                        Config::set('mail.mailers.smtp.username', $email_config->username);
                        Config::set('mail.mailers.smtp.password', $email_config->password);
                    }
                    // dd($data);
                    Mail::send('emails.emailContent', ['data' => $data], function ($message) use ($data, $attachments) {
                        $message->to($data["to_email"]);
                        $message->subject($data["subject"]);
                        $message->from($data["sender_email"], $data["sender_name"]);

                        if (isset($data["cc_email"])) {
                            $message->cc($data["cc_email"]);
                        }
                        if (isset($data["bcc_email"])) {
                            $message->bcc($data["bcc_email"]);
                        }
                        if (isset($attachments)) {
                            // $url = "../../frenzincrm_api/public/uploads/email/attachments/";
                            $url = "../../frenzincrm/public/uploads/email/attachments/";
                            foreach ($attachments as $key => $attach) {
                                $attachmentPath = $url . $attach->attachment;
                                $message->attach($attachmentPath);
                            }
                        }
                    });
                }
                return response()->json(
                    [
                        'status' => true,
                    ],
                    $this->successStatus
                );
            }
        } catch (\Throwable $th) {
            throw $th;
        }
    }



    public function sendfollowupmail_(Request $request)
    {
        try {

            $chkUserExists = $this->_user->get_user_details($request->email, $request->customer_id);

            if (isset($chkUserExists)) {
                $email_draft = $this->_user->getUserEmailDraft_follow($chkUserExists->follow_up_email);
                $attachments = $this->_user->getEmailAttachments($email_draft->id);

                $data["to_email"] = $request->email;
                $data["sender_name"] = $chkUserExists->sender_name;
                $data["sender_email"] = $chkUserExists->sender_email;
                $data["cc_email"] = $chkUserExists->cc_email;
                $data["bcc_email"] = $chkUserExists->bcc_email;
                $data["subject"] = $email_draft->subject;
                $data["body"] = $email_draft->content;

                Mail::send('emails.emailContent', ['data' => $data], function ($message) use ($data, $attachments) {
                    $message->to($data["to_email"]);
                    $message->subject($data["subject"]);
                    $message->from($data["sender_email"], $data["sender_name"]);
                    // $url = "../../frenzincrm_api/public/uploads/email/attachments/";

                    if (isset($data["cc_email"])) {
                        $message->cc($data["cc_email"]);
                    }
                    if (isset($data["bcc_email"])) {
                        $message->bcc($data["bcc_email"]);
                    }

                    if (isset($attachments)) {
                        $url = "../../frenzincrm/public/uploads/email/attachments/";
                        foreach ($attachments as $key => $attach) {
                            $attachmentPath = $url . $attach->attachment;
                            $message->attach($attachmentPath);
                        }
                    }
                });

                return response()->json(
                    [
                        'status' => true,
                    ],
                    $this->successStatus
                );
            }
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function getUserCurrentLocation(Request $request){
        $user_id = $request?->user_id;
        $time_in_secodes = $request?->time_in_secodes;
        $past_time = Carbon::now()->subSeconds($time_in_secodes);

        $type = $request->type;
        if($type == "pusher"){


            $pushObj = new Sendpush();
            $user = User::where('user_id',$user_id)->first();
            $title = "";
            $msg = "" ;
            $message = array("notification_type" => "store_user_location", "message" => $msg, "title" => $title);
            if ($user->device_type == "android" || $user->device_type == "Android")
            {

                $pushObj->sendAndriodNotification($user->push_token, $message);
            }
            else
            {

                $pushObj->sendIOSNotification($user->push_token, $message, $title);
            }

            return response()->json([
                'status' => true,
                'message'=>"Pusher Send Successfully",
            ], 200);
        }
        else{
            $latestPusherLocation = UserLocation::where('user_id',$user_id)->orderBy('created_at','desc')->where('on_demand','true')->where('created_at','>=',$past_time)->first();
            if(!empty($latestPusherLocation)){
                return response()->json([
                    'status' => true,
                    'message'=>"Get Latest Location From Pusher Entry",
                    'data' => $latestPusherLocation
                ], $this->successStatus);
            }
            else{
                $latestPusherLocation = UserLocation::where('user_id',$user_id)->orderBy('created_at','desc')->first();
                return response()->json([
                    'status' => true,
                    'message'=>"Get Latest Location From User Location",
                    'data' => $latestPusherLocation
                ], 200);
            }
        }


    }
    public function getTemaMemeberWithLocation(Request $request){

        try {

        $data = User::where('is_delete', '!=', 'true')->where('CustomerID', '!=', '1111111')->orderBy('CustomerID', 'desc')->with('latestLocation')->get();
        if (count($data) > 0) {
            return response()->json(
                [
                    'status' => true,
                    'data' => $data
                ],
                $this->successStatus
            );
        } else {
            return response()->json([
                'status' => false,
                'msg' => 'Team Members Data Not Found'
            ], 404);
        }
    } catch (Exception $e) {
        return response()->json([
            'status' => false,
            'msg' => $e->getMessage(),
        ], 500);
    }
    }


    public function teamMembersList(Request $request)
    {
        try 
		{
            $data = User::where('is_delete', '!=', 'true')->where('CustomerID', '!=', '1111111')->with('customerPermissions')->orderBy('CustomerID', 'desc')->get();
            if (count($data) > 0) {
                return response()->json(
                    [
                        'status' => true,
                        'data' => $data
                    ],
                    $this->successStatus
                );
            } else {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => 'Team Members Data Not Found'
			], 404);}
		} 
		catch (\Throwable $th) 
		{
            throw $th;
        }
		
	}


    public function makeAdminToTeamMember(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'team_member_id' => 'required|exists:users,user_id',
            ], [
                'team_member_id.required' => 'Team member ID is required.',
                'team_member_id.exists' => 'Invalid team member ID.',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => $validator->errors()->first(),
                ], 400);
            }

            $team_member_id = $request->team_member_id;

            $user = User::where('user_id', $team_member_id)->first();
            if (!$user) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => 'User not found.',
                ], 404);
            }

            $user->is_admin = $user->is_admin == "true" ? "false" : "true";
            $user->save();


            $check_data = DB::table('event_assignments')->where('fk_user_id', $team_member_id)->get();

            if ($user->is_admin == "true") {

                $get_all_event = DB::table('events')->get();

                foreach ($get_all_event as $event) {
                    $event_id = $event->id;

                    $is_assigned = $check_data->contains('fk_event_id', $event_id);

                    if (!$is_assigned) {
                        DB::table('event_assignments')->insert([
                            'fk_user_id' => $team_member_id,
                            'fk_event_id' => $event_id,
                            'is_admin' => 'true',
                        ]);
                    }

                    if ($check_data != null) {
                        $data =  [
                            'is_admin' => 'true',
                        ];
                        $update = DB::table('event_assignments')->where('fk_user_id', $request->user_id)->update($data);
                    }
                }



                //Send push notification
                $pushObj = new Sendpush();
                $notificationdata = $user;
                $user_id = $notificationdata->user_id;
                $title = "Admin Assigned";
                $msg = "You have been activated as admin.";
                $message = array("notification_type" => "main_admin_assigned", "message" => $msg, "title" => $title);

                if ($notificationdata->device_type == 'android') {
                    $device_token = $notificationdata->push_token;
                    $pushObj->sendPushAndroid($user_id, $device_token, $message);
                } else {
                    $device_token = $notificationdata->push_token;
                    $pushObj->sendPushIOS($device_token, $message, $title);
                }
            } else {
                if ($check_data != null) {
                    $data =  [
                        'is_admin' => 'false',
                    ];
                    $update = DB::table('event_assignments')->where('fk_user_id', $request->user_id)->update($data);
                }
            }

            return response()->json(
                [
                    'status' => true,
                    'data' => [],
                    'msg' => 'Successfully made as Admin.',
                ],
                $this->successStatus
            );
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => $e,
            ], 500);
        }
    }

    public function eventAssignTeamMemberList(Request $request)
    {
        try {
            $event_id = $request->fk_event_id;
            $data = User::where('is_delete', '!=', 'true')->where('CustomerID', '!=', '1111111')->with('customerPermissions')->orderBy('CustomerID', 'desc')->get();
            if (count($data) > 0) {
                if (isset($event_id) && !empty($event_id)) {
                    foreach ($data as $d) {
                        $eventData = DB::table('event_assignments')->where('fk_user_id', $d->user_id)->where('fk_event_id', $event_id)->first();
                        if (!empty($eventData)) {
                            // $data[$d]['is_event'] = true;
                            // $data[$d]['is_event_admin'] = $eventData->is_admin;
                            $d->is_event = "true";
                            $d->is_event_admin = $eventData->is_admin;
                        } else {
                            $d->is_event = "false";
                            $d->is_event_admin = "false";
                        }
                    }
                }
                $final_array['status'] = true;
                $final_array['data'] = $data;
                // if (isset($event_id) && !empty($event_id)) {
                //     $even_data = DB::table('event_assignments')->where('fk_event_id', $event_id)->get();
                //     $final_array['event_data'] = $even_data;
                // }
                return response()->json(
                    $final_array,
                    $this->successStatus
                );
            } else {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => 'Team Members Data Not Found'
                ], 404);
            }
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function eventAssignments(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'team_member_id' => 'required|exists:users,user_id',
                'fk_event_id' => 'required|exists:events,id',
                'is_event' => 'required',
                'is_event_admin' => 'required'
            ], [
                'team_member_id.required' => 'Team member ID is required.',
                'team_member_id.exists' => 'Invalid Team member ID.',
                'fk_event_id.required' => 'Event ID is required.',
                'fk_event_id.exists' => 'Invalid Event ID.',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => $validator->errors(),
                ], 400);
            }

            $team_member_id = $request->team_member_id;
            $event_id = $request->fk_event_id;
            $eventStatus = $request->is_event;
            $is_event_admin = $request->is_event_admin;
            $check_event_data = DB::table('event_assignments')->where('fk_user_id', $team_member_id)->where('fk_event_id', $event_id)->first();

            if (!empty($check_event_data)) {
                if ($is_event_admin == "true" && $eventStatus == "true") {
                    DB::table('event_assignments')->where('fk_user_id', $team_member_id)->where('fk_event_id', $event_id)->update(['is_admin' => $is_event_admin]);
                    $this->sendPushNotificationAdminAssign($team_member_id);
                } elseif ($is_event_admin == "false" && $eventStatus == "true") {
                    DB::table('event_assignments')->where('fk_user_id', $team_member_id)->where('fk_event_id', $event_id)->update(['is_admin' => 'false']);
                } elseif ($eventStatus == "false") {
                    DB::table('event_assignments')->where('fk_user_id', $team_member_id)->where('fk_event_id', $event_id)->delete();
                }
                // if ($eventStatus == "false" &&  $is_event_admin  == "true") {
                //     $this->sendPushNotificationAdminAssign($team_member_id);
                //     $this->sendPushNotificationEventAssign($team_member_id);
                // } elseif ($eventStatus == "true" && $is_event_admin == "false") {
                //     $this->sendPushNotificationEventAssign($team_member_id);
                // }
            } else {
                // if ($is_event_admin  == "true") {
                $event_assign_data = [
                    'fk_event_id' => $event_id,
                    'fk_user_id' => $team_member_id,
                    'is_admin' => $is_event_admin
                ];
                DB::table('event_assignments')->insert($event_assign_data);
                // }
                $this->sendPushNotificationEventAssign($team_member_id);
                if ($is_event_admin  == "true") {
                    $this->sendPushNotificationAdminAssign($team_member_id);
                }
            }

            return response()->json(
                [
                    'status' => true,
                    'data' => [],
                    'msg' => 'Event Data Updated Successfully',
                ],
                $this->successStatus
            );
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => $e,
            ], 500);
        }
    }


    public function sendPushNotificationEventAssign($user_id)
    {
        $pushObj = new Sendpush();
        $notificationdata = User::where('user_id', $user_id)->first();
        $user_id = $notificationdata->user_id;
        $title = "Event Assigned";
        $msg = "You have been assigned in Event.";
        $message = array("notification_type" => "event_assigned", "message" => $msg, "title" => $title);
        if ($notificationdata->device_type == 'android') {
            $device_token = $notificationdata->push_token;
            $push = $pushObj->sendPushAndroid($user_id, $device_token, $message);
            // $updatenotification = notification_to_driver::where('id', $main_id)->update(['is_sent' => '1']);
        } else {
            $device_token = $notificationdata->push_token;
            $push = $pushObj->sendPushIOS($device_token, $message, $title);
            //     $updatenotification = notification_to_driver::where('id', $main_id)->update(['is_sent' => '1']);
        }
    }

    public function sendPushNotificationAdminAssign($user_id)
    {
        $pushObj = new Sendpush();
        $notificationdata = User::where('user_id', $user_id)->first();
        $user_id = $notificationdata->user_id;
        $title = "Event Admin Assigned";
        $msg = "You have been activated as admin in Event.";
        $message = array("notification_type" => "event_admin_assigned", "message" => $msg, "title" => $title);
        if ($notificationdata->device_type == 'android') {
            $device_token = $notificationdata->push_token;
            $pushObj->sendPushAndroid($user_id, $device_token, $message);
        } else {
            $device_token = $notificationdata->push_token;
            $pushObj->sendPushIOS($device_token, $message, $title);
        }
    }

    public function teamMemberDelete(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'team_member_id' => 'required|exists:users,user_id',
            ], [
                'team_member_id.required' => 'Team member ID is required.',
                'team_member_id.exists' => 'Invalid Team member ID.',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => $validator->errors(),
                ], 400);
            }

            $team_member_id = $request->team_member_id;
            DB::table('users')->where('user_id', $team_member_id)->update(['is_delete' => 'true']);

            return response()->json(
                [
                    'status' => true,
                    'data' => [],
                    'msg' => 'Team Member Deleted Successfully',
                ],
                $this->successStatus
            );
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => $e,
            ], 500);
        }
    }

    public function updatepermission(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'CustomerID' => 'required|exists:users,CustomerID',
            ], [
                'CustomerID.required' => 'Customer ID is required.',
                'CustomerID.exists' => 'Invalid Customer ID.',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => $validator->errors(),
                ], 400);
            }


            $data = [
                'fk_customer_id' => $request->CustomerID,
                'Contact_Share' => isset($request->Contact_Share) ? $request->Contact_Share : '0',
                'Call_Contact' =>  isset($request->Call_Contact) ? $request->Call_Contact : '0',
                'Send_Whatsapp' => isset($request->Send_Whatsapp) ? $request->Send_Whatsapp : '0',
                'Save_Contact' =>  isset($request->Save_Contact) ? $request->Save_Contact : '0',
                'Export_Excel' => isset($request->Export_Excel) ? $request->Export_Excel : '0',
                'send_email' => isset($request->send_email) ? $request->send_email : '0',

            ];
            DB::beginTransaction();

            $check = DB::table('permissions')->where('fk_customer_id', $request->CustomerID)->count();

            if ($check == 0) {
                DB::table('permissions')->insert($data);
            } else {
                DB::table('permissions')->where('fk_customer_id', $request->CustomerID)->update($data);
            }
            $locationConfig = $request->has('location_config') ? $request->location_config : 0;
            $updatedata = [
                'location_config' => $locationConfig,
            ];
            DB::table('users')->where('CustomerID', $request->CustomerID)->update($updatedata);
            DB::commit();


            $pushObj = new Sendpush();
            $notificationdata = User::where('CustomerID', $request->CustomerID)->first();
            $user_id = $notificationdata->user_id;
            $title = "Permission Updated";
            $msg = "Your Permission is Updated by Admin.";
            $message = array("notification_type" => "permission", "message" => $msg, "title" => $title);
            if ($notificationdata->device_type == 'android') {
                $device_token = $notificationdata->push_token;
                $pushObj->sendPushAndroid($user_id, $device_token, $message);
            } else {
                $device_token = $notificationdata->push_token;
                $pushObj->sendPushIOS($device_token, $message, $title);
            }

            return response()->json(
                [
                    'status' => true,
                    'data' => [],
                    'msg' => 'Permission Updated Successfully',
                ],
                $this->successStatus
            );
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => $e,
            ], 500);
        }
    }

    public function changePassword(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'CustomerID' => 'required|exists:users,CustomerID',
                'password' => 'required|min:6',
                'confirm_password' => 'required|same:password',
            ], [
                'CustomerID.required' => 'Customer ID is required.',
                'CustomerID.exists' => 'Invalid Customer ID.',
                'password.required' => 'Password is required.',
                'password.min' => 'Password must be at least 6 characters long.',
                'confirm_password.required' => 'Confirm Password is required.',
                'confirm_password.same' => 'Password and Confirm Passoword not matching.',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => $validator->errors(),
                ], 400);
            }

            $customerID = $request->input('CustomerID');
            $password = Hash::make($request->input('password'));

            $user = User::where('CustomerID', $customerID)->first();
            if (!$user) {
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => 'User not found.',
                ], 404);
            }
            $user->password = $password;
            $user->save();

            return response()->json([
                'status' => true,
                'data' => [],
                'msg' => 'Password updated successfully.',
            ], $this->successStatus);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => $e->getMessage(),
            ], 500);
        }
    }

    public function logout(Request $request)
    {
        try {
            // $validator = Validator::make($request->all(), [
            //     'user_id' => 'required|exists:users,user_id',
            // ], [
            //     'user_id.required' => 'User Id is required.',
            //     'user_id.exists' => 'Invalid User Id.',
            // ]);

            // if ($validator->fails()) {
            //     return response()->json([
            //         'status' => false,
            //         'data' => [],
            //         'msg' => $validator->errors(),
            //     ], 400);
            // }

            $user_id = auth()->user()->user_id;
            DB::table('users')->where('user_id', $user_id)->update(['push_token' => null]);

            return response()->json(
                [
                    'status' => true,
                    'msg' => 'User Logout Successfully',
                ],
                $this->successStatus
            );
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'msg' => $e,
            ], 500);
        }
    }

    public function visitemail(Request $request)
    {
        try {
            //Log::channel('emergency')->info($request);
            $customer_id = $request->customer_id;
            $visitor_id = $request->visitor_id;
            $action = $request->action;
            $attachmentsfile = [];
            if ($files = $request->file('files')) {
                foreach ($files as $key => $file) {
                    if ($request->file('files')[$key]) {
                        $name = $request->file('files')[$key]->getClientOriginalName();
                        $ext = $request->file('files')[$key]->getClientOriginalExtension();
                        $path = public_path('../public/uploads/email/attachments/');
                        $filename = $name . '.' . $ext;
                        $success = $request->file('files')[$key]->move($path, $filename);
                        $attachmentsfile[] = $filename;
                    }
                }
            }

            $chkUserExists = User::where('CustomerID', $customer_id)->first();
            $visitor = Visitor::where('id', $visitor_id)->first();
            $email_draft = DB::table('email_drafts')->where('email_type', $request->action)->first();
            //dd($email_draft);
            if (isset($chkUserExists) && isset($email_draft)) {

                $mailConfig = $this->_user->get_user_email_config_details($request->customer_id);
                $email_config = $this->_user->get_email_config();



                if (!empty($email_draft)) {
                    $attachments = $this->_user->getEmailAttachments($email_draft->id);
                } else {
                    $attachments = null;
                }
                if ($chkUserExists->cc_email != null) {
                    $cc_email = explode(',', $chkUserExists->cc_email);
                } else {
                    $cc_email = null;
                }
                if ($chkUserExists->bcc_email != null) {
                    $bcc_email = explode(',', $chkUserExists->bcc_email);
                } else {
                    $bcc_email = null;
                }

                if (isset($visitor->email2) && !empty($visitor->email2)) {
                    $emailAddresses = [$visitor->email, $visitor->email2];
                } else {
                    $emailAddresses = [$visitor->email];
                }

                foreach ($emailAddresses as $emailAddress) {
                    // Set the "to_email" to the current email address in the loop
                    $data["to_email"] = $emailAddress;

                    // $data["to_email"] = $request->email;
                    $data["sender_name"] = $chkUserExists->sender_name;
                    $data["sender_email"] = $chkUserExists->sender_email;
                    $data["cc_email"] = $cc_email;
                    $data["bcc_email"] = $bcc_email;
                    $data["subject"] = isset($email_draft->subject) ? $email_draft->subject : "";

                    $emailContent = isset($email_draft->content) ? $email_draft->content : "";
                    $userName =  $visitor->name;
                    $companyName = $visitor->company_name;
                    $designation =  $visitor->designation;

                    $emailContent = str_replace('*user name*', $userName, $emailContent);
                    $emailContent = str_replace('*company name*', $companyName, $emailContent);
                    $emailContent = str_replace('*designation*', $designation, $emailContent);

                    $data["body"] = $emailContent . '<br>' . $chkUserExists->signature;

                    if (!empty($mailConfig)) {
                        Config::set('mail.mailers.smtp.transport', $mailConfig->smtp_transport);
                        Config::set('mail.mailers.smtp.host', $mailConfig->host);
                        Config::set('mail.mailers.smtp.port', $mailConfig->port);
                        Config::set('mail.mailers.smtp.encryption', $mailConfig->smtp_encryption); // or 'ssl'
                        Config::set('mail.mailers.smtp.username', $mailConfig->username);
                        Config::set('mail.mailers.smtp.password', $mailConfig->password);
                    } else {
                        // Config::set('mail.mailers.smtp.transport', 'smtp');
                        // Config::set('mail.mailers.smtp.host', 'email-smtp.ap-south-1.amazonaws.com');
                        // Config::set('mail.mailers.smtp.port',587);
                        // Config::set('mail.mailers.smtp.encryption', 'tls'); // or 'ssl'
                        // Config::set('mail.mailers.smtp.username', 'AKIASAHO74KMPZV7Z6HQ');
                        // Config::set('mail.mailers.smtp.password', 'BNSFf2FUd72yaGiKZm+boBm+dmW5Dt/l2VlWt75WLkXt');

                        Config::set('mail.mailers.smtp.transport', $email_config->smtp_transport);
                        Config::set('mail.mailers.smtp.host', $email_config->host);
                        Config::set('mail.mailers.smtp.port', $email_config->smtp_port);
                        Config::set('mail.mailers.smtp.encryption', $email_config->smtp_encryption);
                        Config::set('mail.mailers.smtp.username', $email_config->username);
                        Config::set('mail.mailers.smtp.password', $email_config->password);
                    }
                    // dd($data);
                    Mail::send('emails.emailContent', ['data' => $data], function ($message) use ($data, $attachments, $attachmentsfile) {
                        $message->to($data["to_email"]);
                        $message->subject($data["subject"]);
                        $message->from($data["sender_email"], $data["sender_name"]);

                        if (isset($data["cc_email"])) {
                            $message->cc($data["cc_email"]);
                        }
                        if (isset($data["bcc_email"])) {
                            $message->bcc($data["bcc_email"]);
                        }
                        if (isset($attachments)) {
                            // $url = "../../frenzincrm_api/public/uploads/email/attachments/";
                            $url = "../../frenzincrm/public/uploads/email/attachments/";
                            foreach ($attachments as $key => $attach) {
                                $attachmentPath = $url . $attach->attachment;
                                $message->attach($attachmentPath);
                            }
                        }
                        if (isset($attachmentsfile)) {
                            // $url = "../../frenzincrm_api/public/uploads/email/attachments/";
                            $url = "../../frenzincrm_api/public/uploads/email/attachments/";
                            foreach ($attachmentsfile as $key => $attachfile) {
                                $attachmentPath = $url . $attachfile;
                                $message->attach($attachmentPath);
                            }
                        }
                    });
                }
                /*if(isset($attachmentsfile)){
					// $url = "../../frenzincrm_api/public/uploads/email/attachments/";
					$url = "../../frenzincrm_api/public/uploads/email/attachments/";
					foreach ($attachmentsfile as $key => $attachfile) {
						$attachmentPath = $url . $attachfile;
						unlink($attachmentPath);
					}
				}*/

                return response()->json(
                    [
                        'status' => true,
                    ],
                    $this->successStatus
                );
            } else {
                return response()->json(
                    [
                        'status' => true,
                    ],
                    $this->successStatus
                );
            }
        } catch (\Throwable $th) {
            throw $th;
        }
    }


    public function user_attendance(Request $request)
    {
        // Validate request data
        $validator = Validator::make($request->all(), [
            'customer_id' => 'required',
            'type' => 'required|in:IN,OUT',
            'lat' => 'required|numeric',
            'lng' => 'required|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'Validation failed',
                'errors' => $validator->errors(),
            ], 422);
        }

        if ($request->type == 'IN') {

            $data = [
                'customer_id' => $request->customer_id,
                'checkin_lat' => $request->lat,
                'checkin_lng' => $request->lng,
                'check_in_time' => now()
            ];

            $lastCheckIn =  UserAttendance::create($data);
        } elseif ($request->type == 'OUT') {

            $lastCheckIn = UserAttendance::where('customer_id', $request->customer_id)
                ->whereNull('check_out_time')
                ->orderBy('id', 'desc')
                ->first();

            if ($lastCheckIn) {
                $lastCheckIn->update([
                    'checkout_lat' => $request->lat,
                    'checkout_lng' => $request->lng,
                    'check_out_time' => now()
                ]);
            }
        }

        return response()->json([
            'status' => true,
            'message' => 'Attendance recorded successfully',
            'data' => $lastCheckIn,
        ], 201);
    }
}
