<?php

namespace App\Http\Controllers;

use App\Models\ReferredByMaster;
use Illuminate\Http\Request;

class ReferredByController extends Controller
{
    public $successStatus = 200;
    public $failureStatus = 203;

    public function __construct()
    {

    }

    public function list(Request $request)
    {

        $referredByMaster = ReferredByMaster::orderBy('updated_at')->get();

        if($referredByMaster)
        {
            return response()->json([
                'status' => true,
                'data' => $referredByMaster
            ]);
        }
        else
        {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => 'Referred By Data Not Found'
            ], 201);
        }
    }

}
