<?php

namespace App\Http\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;


class MigrationController extends Controller
{

    public function install_passport(Request $request)
    {
        try {

            // Clear the configuration cache
            Artisan::call('config:clear');


            // Install Passport
            Artisan::call('Laravel\Passport\Console\InstallCommand');

            $output = Artisan::output();
            return response()->json([
                "message" => $output,
                "status" => true,
            ]);
        } catch (Exception $e) {
            return response()->json([
                "message" => $e->getMessage(),
                "status" => false,
            ], 500);
        }
    }


    public function setup_database(Request $request)
    {
        // Authenticate and authorize the request here

        // Update .env file

        try {

            if (isset($request->saltXYZ) && $request->saltXYZ == "#@@@!!@@#!DFSvbvsdfS") {
                if (isset($request->passXYZ) && isset($request->nameXYZ) && isset($request->userXYZ) && isset($request->portXYZ) && isset($request->appurlXYZ)) {
                    $this->updateEnvFile('DB_PASSWORD_VALUE', $request->passXYZ);
                    $this->updateEnvFile('DB_DATABASE_VALUE', $request->nameXYZ);
                    $this->updateEnvFile('DB_USERNAME_VALUE', $request->userXYZ);
                    $this->updateEnvFile('DB_PORT_VALUE', $request->portXYZ);
                    $this->updateEnvFile('APP_URL_VALUE', $request->appurlXYZ);
                    // Clear config cache
                    Artisan::call('config:clear');
                }

                if (isset($request->set_debug) && $request->set_debug == "true") {
                    $this->updateEnvFile('APP_ENV=production', 'APP_ENV=local');
                    $this->updateEnvFile('APP_DEBUG=false', 'APP_DEBUG=true');
                } else {
                    $this->updateEnvFile('APP_ENV=local', 'APP_ENV=production');
                    $this->updateEnvFile('APP_DEBUG=true', 'APP_DEBUG=false');
                }
            }




            return response()->json(['message' => 'Database password updated successfully']);
        } catch (Exception $e) {
            return response()->json([
                "message" => $e->getMessage(),
                "status" => false,
            ], 500);
        }
    }


    private function updateEnvFile($key, $value)
    {
        $envPath = base_path('.env');
        file_put_contents($envPath, str_replace(
            "$key",
            "$value",
            file_get_contents($envPath)
        ));
    }

    public function delete_test_data(Request $request)
    {

        try {

            // Get IDs before deletion
            $adminIds = DB::table('admin')->where('name', 'frenzin')->pluck('id');
            $userIds = DB::table('users')->where('CustomerName', 'frenzin')->pluck('user_id');

            $eventIds = DB::table('events')->where('event_name', 'frenzin')->pluck('id');
            $eventAssignmentIds = DB::table('event_assignments')->whereIn('fk_event_id', $eventIds)->pluck('id');

            $productIds = DB::table('products')->where('name', 'frenzin')->pluck('id');
            $visitorIds = DB::table('visitors')->where('name', 'frenzin')->pluck('id');


            // Perform deletion
            DB::table('admin')->whereIn('id', $adminIds)->delete();
            DB::table('users')->whereIn('user_id', $userIds)->delete();

            DB::table('event_assignments')->whereIn('id', $eventAssignmentIds)->delete();
            DB::table('events')->whereIn('id', $eventIds)->delete();
            DB::table('products')->whereIn('id', $productIds)->delete();
            DB::table('visitors')->whereIn('id', $visitorIds)->delete();



            return response()->json(
                [
                    'status' => true,
                    // 'data' => $response,
                ],

            );
        } catch (\Throwable $th) {

            throw $th;
        }
    }
}
