<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Event;
use App\Models\Product;
use App\Models\Permissions;
use App\Models\Sendpush;
use App\Models\Admin;
use App\Models\AddressData;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use DB;
use App\Models\Visitor;
use Config;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Laravel\Passport\Token;

class AddressController extends Controller
{

    public function updateAddress(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'address_data' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => $validator->errors(),
            ], 400);
        }

        try {
            // Decode JSON into an associative array
            $address_data = json_decode($request->address_data,true);
            if (is_array($address_data) && count($address_data) > 0) {
                
                // Begin a transaction
                DB::beginTransaction();

                foreach ($address_data as $address) {
                    $conditions = [
                        'pin_code' => $address['pin_code'],
                    ];
                    // $address['updated_at'] = now();
                    AddressData::updateOrCreate($conditions, $address);
                }

                // Commit the transaction
                DB::commit();

                return response()->json([
                    'status' => true,
                    'msg' => 'Addresses updated successfully.',
                ], 200);
            } else {
                // Handle the case where address_data is not an array
                return response()->json([
                    'status' => false,
                    'data' => [],
                    'msg' => 'Invalid address data format.',
                ], 400);
            }
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => 'An error occurred while updating addresses. Please try again later.',
            ], 500);
        }
    }
}
