<?php

$currentpath = Route::getFacadeRoot()
    ->current()
    ->uri();

ob_start();

$cut = strpos($currentpath, '/');

if ($cut) {
    $pagename = substr($currentpath, 0, $cut);
} else {
    $pagename = $currentpath;
}
//   echo $pagename; die;

//dd(Auth::user()->getUser()->is_admin);
?>
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a href="#" class="brand-link">
        <img src="<?php echo e(asset('assets/dist/img/AdminLTELogo.png')); ?>" alt="Client"
            class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light">FrenzinCRM</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <!-- <div class="image">
                <img src="<?php echo e(asset('assets/dist/img/user2-160x160.jpg')); ?>" class="img-circle elevation-2"
                    alt="User Image">
            </div> -->
            <div class="info">
                <a href="#" class="d-block"><?php echo e(Auth::user()->name ?? ''); ?></a>
                <a href="#" class="d-block"><?php echo e(Auth::user()->getUser()->Email ?? ''); ?></a>
                <a href="#" class="d-block"><?php echo e(Auth::user()->getUser()->Phone && Auth::user()->getUser()->Phone != 'na'  ? Auth::user()->getUser()->Phone : ''); ?></a>
            </div>
        </div>

        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">
                

                <?php if(Auth::user()->getUser() && Auth::user()->getUser()->is_admin == "true"): ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'dashboard' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>
                            Dashboard
                        </p>
                    </a>
                </li>

                    <li class="nav-item">
                        <a href="<?php echo e(route('users.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'user' ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-table"></i>
                            <p>
                                Team Members
                            </p>
                        </a>
                    </li>


                <?php endif; ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('event.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'event' ? 'active' : ''); ?>">
                        <i class="nav-icon far fa-calendar-alt"></i>
                        <p>
                            Event/Folder
                        </p>
                    </a>
                </li>

                <?php if(Auth::user()->getUser() && Auth::user()->getUser()->is_admin == "true"): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('visitor.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'visitor' ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-table"></i>
                            <p>
                                Client
                            </p>
                        </a>
                    </li>

                  

                    <li class="nav-item">
                        <a href="<?php echo e(route('client.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'client' ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-table"></i>
                            <p>
                                Report
                            </p>
                        </a>
                    </li>
                    <?php if(Session::get('quotation') == 1): ?>

                    <li class="nav-item">
                        <a href="<?php echo e(route('quotations.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'quotations' ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-table"></i>
                            <p>
                                Quotation List
                            </p>
                        </a>
                    </li>
                    <?php endif; ?>




                    

                    <li class="nav-item <?php echo e(isset($pagename) && in_array($pagename, ['referred_by_master','action', 'category', 'source_of_lead', 'product', 'areas']) ? 'active menu-open' : ''); ?>">
                        <a class="nav-link <?php echo e(isset($pagename) && in_array($pagename, ['referred_by_master','action', 'category', 'source_of_lead', 'product', 'areas']) ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-chart-pie"></i>
                            <p>
                               Masters
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?php echo e(route('action.list')); ?>"
                                   class="nav-link <?php echo e(isset($pagename) && $pagename == 'action' ? 'active' : ''); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Action</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('areas.list')); ?>"
                                   class="nav-link <?php echo e(isset($pagename) && $pagename == 'areas' ? 'active' : ''); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Areas</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('category.list')); ?>"
                                   class="nav-link <?php echo e(isset($pagename) && $pagename == 'category' ? 'active' : ''); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Category</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('source_of_lead.list')); ?>"
                                   class="nav-link <?php echo e(isset($pagename) && $pagename == 'source_of_lead' ? 'active' : ''); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p> Source of Lead</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('product.list')); ?>"
                                   class="nav-link <?php echo e(isset($pagename) && $pagename == 'product' ? 'active' : ''); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Product</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('referred_by_master.list')); ?>"
                                   class="nav-link <?php echo e(isset($pagename) && $pagename == 'referred_by_master' ? 'active' : ''); ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Referred By</p>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link <?php echo e(isset($pagename) && $pagename == 'setting' ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-chart-pie"></i>
                            <p>
                               Settings
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <?php if(auth()->user()->type == 'admin'): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('setting.subAdminList')); ?>"
                                       class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Add Sub-Admin</p>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('setting.whatsapp_msg')); ?>" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Whatsapp Settings</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('emails.index')); ?>" class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Email Drafts</p>
                                </a>
                            </li>
                            <?php if(auth()->user()->type == 'admin'): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('setting.martkey')); ?>"
                                       class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Integrations</p>
                                    </a>
                                </li>
                            <?php endif; ?>
                            
                            <li class="nav-item">
                                <a href="<?php echo e(route('setting.region')); ?>"
                                class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Region</p>
                                </a>
                            </li>
                            <?php if(auth()->user()->type == 'admin'): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('setting.divisionList')); ?>"
                                       class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Division</p>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(Session::get('quotation') == 1): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('setting.quotation_config')); ?>"
                                class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Quotation Configuration</p>
                                </a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <?php if(Auth::user()->getUser()->is_admin == "true"): ?>
                    <?php if(Session::get('checkin') == 1): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('user_attendance.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'user_attendances' ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-list-alt"></i>
                            <p>
                            Attendances
                            </p>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(Session::get('location_tracking') == 1): ?>

                    <li class="nav-item">
                        <a href="<?php echo e(route('location_tracking.index')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'location_tracking' ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-search-location"></i>
                            <p>
                                Location Tracking
                            </p>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php endif; ?>


                    <?php if(Session::get('bulk_whatsapp') == 1): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('template.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'template' ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-list-alt"></i>
                            <p>
                                BulkWhatsApp Template
                            </p>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                <?php endif; ?>


                <li class="nav-item">
                    <a href="<?php echo e(route('batch.batch-list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'batch' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-chart-pie"></i>
                        <p>
                            Scheduled Bulk Emails
                        </p>
                    </a>
                </li>
                <?php if(Auth::user()->getUser()->is_admin == "true"): ?>

                <?php if(Session::get('expense') == 1): ?>

                <li class="nav-item">
                    <a href="<?php echo e(route('expence.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'expence' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-list-alt"></i>
                        <p>
                            Expense
                        </p>
                    </a>
                </li>
                <?php endif; ?>
                <?php endif; ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="nav-icon fas fa-power-off"></i>
                        <p>
                            <?php echo e(__('Logout')); ?>

                        </p>
                    </a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                </li>
            </ul>
        </nav>
    </div>
</aside>
<?php /**PATH /home/u974978517/domains/arrowmedicalproducts.com/public_html/frenzincrm/resources/views/layouts/sidebar.blade.php ENDPATH**/ ?>