<?php

use App\Http\Controllers\LocationTrackingController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;

use App\Http\Controllers\MigrationController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\VisitorController;

Route::get('/', function () {
    return redirect('/login');
});

Route::get('/clear', function () {
    \Artisan::call('optimize:clear');
    return "optimize clear successfully";
});


Route::group([], function ()
{
    define('UPLOAD_EMAIL', '/uploads/email/attachments/');
    define('UPLOAD_IMAGE', '/uploads/images/');
});

Route::get('/refresh-config', function (Request $request) {
    Artisan::call('config:clear');
    return Response::json(['message' => 'Config cleared and cached successfully']);
});

Auth::routes();

Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('dashboard');
Route::get('/run_migration', [App\Http\Controllers\MigrationController::class, 'run_migration'])->name('run_migration');  
Route::get('/run_seeders_basic', [App\Http\Controllers\MigrationController::class, 'run_seeders_basic'])->name('run_seeders_basic');  
Route::get('/run_seeders_address', [App\Http\Controllers\MigrationController::class, 'run_seeders_address'])->name('run_seeders_address'); 
Route::get('/run_seeders_countries', [App\Http\Controllers\MigrationController::class, 'run_seeders_countries'])->name('run_seeders_countries');  

Route::post('/setup_database', [App\Http\Controllers\MigrationController::class, 'setup_database'])->name('setup_database');  
// Route::get('charts','HomeController@chartjs');

// users
Route::group(['prefix' => 'user'], function () {
    Route::get('/list', [App\Http\Controllers\UserController::class, 'index'])->name('users.list');
    Route::get('/add-team-member', [App\Http\Controllers\UserController::class, 'addUser'])->name('users.add');
    Route::post('/add-team-member-save', [App\Http\Controllers\UserController::class, 'saveUser'])->name('users.save');
    Route::get('/destroy/{user_id}/{type}', [App\Http\Controllers\UserController::class, 'destroy'])->name('users.destroy');
    Route::get('/permissionsview', [App\Http\Controllers\UserController::class, 'permissionsview'])->name('users.permissionsview');
    Route::post('/update', [App\Http\Controllers\UserController::class, 'updatepermission'])->name('users.updatepermission');
    Route::post('/updateUserName',[UserController::class,'updateUserName'])->name('updateUserName');
    Route::post('/updateUserEmail',[UserController::class,'updateUserEmail'])->name('updateUserEmail');
    Route::post('/updateUserPhone',[UserController::class,'updateUserPhone'])->name('updateUserPhone');
    Route::post('/sendUserPhoneUpdateOtp',[UserController::class,'sendUserPhoneUpdateOtp'])->name('sendUserPhoneUpdateOtp');
    // Route::get('/store', [App\Http\Controllers\UserController::class, 'store'])->name('users.store');
    Route::post('/updateIsAdmin', [App\Http\Controllers\UserController::class, 'updateIsAdmin'])->name('users.updateIsAdmin');
    Route::post('/edit-user-email', [App\Http\Controllers\UserController::class, 'updateEmail'])->name('edit-user-email');
    Route::post('/assign-email-user', [App\Http\Controllers\UserController::class, 'assignEmail'])->name('assign-email-user');
    Route::post('/popup-assign-email/{id}', [App\Http\Controllers\UserController::class, 'emailPopup'])->name('popup-assign-email');
    Route::post('/add_customer_id', [App\Http\Controllers\UserController::class, 'addcustomer_id'])->name('users.add_customer_id');
    Route::post('/update-location', [App\Http\Controllers\UserController::class, 'updateCheckbox'])->name('users.update-location');
    Route::get('/edit_email', [App\Http\Controllers\UserController::class, 'edit_email'])->name('users.edit_email');
    Route::post('/store_email', [App\Http\Controllers\UserController::class, 'store_email'])->name('users.store_email');
    Route::post('/store_email_admin', [App\Http\Controllers\UserController::class, 'store_email_admin'])->name('users.store_email_admin');
    Route::post('/update_user_password', [App\Http\Controllers\UserController::class, 'update_user_password'])->name('users.update_user_password');
    Route::post('/divisionUpdate', [App\Http\Controllers\UserController::class, 'divisionUpdate'])->name('users.divisionUpdate');

    Route::get('/addremoveAdmin/{user_id}/{type}', [App\Http\Controllers\UserController::class, 'addremoveAdmin'])->name('users.addremoveAdmin');

    Route::post('/testnewemail',[App\Http\Controllers\UserController::class, 'testEMailNew'])->name('users.testnewemail');

    Route::post('register/getOtp', [App\Http\Controllers\UserController::class, 'getOtp'])->name('user-register.getOtp');
    Route::post('register/userCreate', [App\Http\Controllers\UserController::class, 'userCreate'])->name('user-register.userCreate');
    Route::get('/member-data/{id}', [App\Http\Controllers\UserController::class, 'memberData'])->name('member.data');
    Route::post('/updatePermissionNew', [App\Http\Controllers\UserController::class, 'updatePermissionNew'])->name('users.updatePermissionNew');
    Route::post('/updateDivisionNew', [App\Http\Controllers\UserController::class, 'updateDivisionNew'])->name('users.updateDivisionNew');

});
//location tracking
Route::group(['prefix' => 'location_tracking'], function () {
    Route::get('/', [LocationTrackingController::class, 'index'])->name('location_tracking.index');
    Route::get('/teamMemeberList/{memberId?}', [LocationTrackingController::class, 'teamMemberList'])->name('location_tracking.teamMemeberList');
    Route::post('/saveDuration', [LocationTrackingController::class, 'saveDuration'])->name('location_tracking.saveDuration');
    Route::get('/getLatestLocation/{memberId?}', [LocationTrackingController::class, 'getLatestLocation'])->name('location_tracking.getLatestLocation');
    Route::post('/locationTrackingModal', [LocationTrackingController::class, 'locationTrackingModal'])->name('location_tracking.locationTrackingModal');
    Route::get('/getAllLocationOfUser/{memberId?}', [LocationTrackingController::class, 'getAllLocationOfUser'])->name('location_tracking.getAllLocationOfUser');
});

// events
Route::group(['prefix' => 'event'], function () {
    Route::get('/list', [App\Http\Controllers\EventController::class, 'index'])->name('event.list');
    Route::get('/destroy/{id}', [App\Http\Controllers\EventController::class, 'destroy'])->name('event.destroy');
    Route::get('/add', [App\Http\Controllers\EventController::class, 'addView'])->name('event.add');
    Route::post('/store', [App\Http\Controllers\EventController::class, 'store'])->name('event.store');
    Route::get('/addevent', [App\Http\Controllers\EventController::class, 'addevent'])->name('event.addevent');
    Route::post('/addeventstore', [App\Http\Controllers\EventController::class, 'addeventstore'])->name('event.addeventstore');
    Route::get('/assignadmin', [App\Http\Controllers\EventController::class, 'assignadminview'])->name('event.assignadmin');
    Route::post('/storeadminassign', [App\Http\Controllers\EventController::class, 'storeadminassign'])->name('event.storeadminassign');
    Route::get('/edit', [App\Http\Controllers\EventController::class, 'editView'])->name('event.edit');
    Route::post('/editeventstore', [App\Http\Controllers\EventController::class, 'editeventstore'])->name('event.editeventstore');
    Route::post('/assignUser', [App\Http\Controllers\EventController::class, 'assignUser'])->name('event.assignUser');
    Route::delete('/EventImageDelete', [App\Http\Controllers\EventController::class, 'EventImageDelete'])->name('event.image.delete');
});

// visitor
Route::group(['prefix' => 'visitor'], function () {
    Route::get('/company-visits/ajax',[App\Http\Controllers\VisitorController::class, 'companyVisitAjax'])->name('visitor.company.visits.ajax');

    Route::get('/list', [App\Http\Controllers\VisitorController::class, 'index'])->name('visitor.list');
    Route::get('/detail', [App\Http\Controllers\VisitorController::class, 'detailview'])->name('visitor.detail');
    Route::get('company/detail', [App\Http\Controllers\VisitorController::class, 'companydetailview'])->name('visitor.companydetail');
    Route::get('user/detail', [App\Http\Controllers\VisitorController::class, 'userdetailview'])->name('visitor.userdetail');

    Route::get('user/detail', [App\Http\Controllers\VisitorController::class, 'userdetailview'])->name('visitor.userdetail');


    // Route::get('/edit', [App\Http\Controllers\VisitorController::class, 'edit'])->name('visitor.edit');
    Route::get('/download-images', [App\Http\Controllers\VisitorController::class, 'downloadImages'])->name('visitor.downloadImages');
	Route::post('/update-email', [App\Http\Controllers\VisitorController::class, 'updateEmail'])->name('visitor.update-email');
    Route::get('/set-mail',[App\Http\Controllers\VisitorController::class, 'setMail'])->name('visitor.set-mail');
    Route::get('/send-bulk-message',[App\Http\Controllers\VisitorController::class, 'sendBulkMessage'])->name('visitor.send-bulk-message');

    Route::get('/batch-delete/{batch_id}',[App\Http\Controllers\VisitorController::class, 'batchDelete'])->name('visitor.batch-delete');
	Route::post('/update_event_name', [App\Http\Controllers\VisitorController::class, 'updateeventname'])->name('visitor.update_event_name');
    Route::post('/fetchevent',[App\Http\Controllers\VisitorController::class, 'fetchevent'])->name('visitor.fetchevent');
    Route::get('/getname_search',[App\Http\Controllers\VisitorController::class, 'getname_search'])->name('visitor.getname_search');
    Route::get('/destroy/{id}', [App\Http\Controllers\VisitorController::class, 'destroy'])->name('visitor.destroy');
	Route::post('/add_event_ids', [App\Http\Controllers\VisitorController::class, 'addevent_ids'])->name('visitor.add_event_ids');
    Route::get('/edit/{visitor}', [App\Http\Controllers\VisitorController::class, 'edit'])->name('visitor.edit');
    Route::post('/update/{visitor}', [App\Http\Controllers\VisitorController::class, 'update'])->name('visitor.update');
    Route::get('/add', [App\Http\Controllers\VisitorController::class, 'add'])->name('visitor.add');
    Route::post('/store', [App\Http\Controllers\VisitorController::class, 'store'])->name('visitor.store');
    Route::get('/Multiple_Entries_destroy/{id}', [App\Http\Controllers\VisitorController::class, 'Multiple_Entries_destroy'])->name('visitor.Multiple_Entries_destroy');
    Route::get('/add/visit/data/modal', [App\Http\Controllers\VisitorController::class, 'addVisitDataModal'])->name('visit.data.modal');
    Route::post('/add/visit/data/store/{id}', [App\Http\Controllers\VisitorController::class, 'addVisitDataStore'])->name('visit.data.store');
    Route::get('/visit/data/delete/{id}', [App\Http\Controllers\VisitorController::class, 'visit_delete'])->name('visit.data.delete');

    Route::get('/listbyevent', [App\Http\Controllers\VisitorController::class, 'listbyevent'])->name('visitor.listbyevent');
    Route::get('/set-mailbyevent',[App\Http\Controllers\VisitorController::class, 'setMailbyevent'])->name('visitor.set-mailbyevent');
    Route::delete('/visitor/image/delete',[App\Http\Controllers\VisitorController::class, 'visitorImageDelete'])->name('visitor.image.delete');


    Route::post('/assigneventids', [App\Http\Controllers\VisitorController::class, 'assigneventids'])->name('visitor.assigneventids');

        Route::get('/map', [App\Http\Controllers\VisitorController::class, 'mapView'])->name('visitor.map');
        Route::post('/mapData', [App\Http\Controllers\VisitorController::class, 'mapData'])->name('visitor.map.data');
});


// visitor
Route::group(['prefix' => 'client'], function () {
    Route::get('/list', [App\Http\Controllers\VisitorController::class, 'clientVisit'])->name('client.list');
    Route::post('/exportclientvisitorlist', [App\Http\Controllers\VisitorController::class, 'exportclientvisitorlist'])->name('client.exportclientvisitorlist');
    Route::get('/clientdashboard', [App\Http\Controllers\VisitorController::class, 'clientdashboard'])->name('client.dashboard');
    Route::get('/clientdashboarddetails', [App\Http\Controllers\VisitorController::class, 'clientdashboarddetails'])->name('client.dashboarddetails');
    Route::post('/exportclientdashboarddetails', [App\Http\Controllers\VisitorController::class, 'exportclientdashboarddetails'])->name('client.exportclientdashboarddetails');

});



Route::group(['prefix' => 'batch'], function () {
    Route::get('/batch',[App\Http\Controllers\VisitorController::class, 'batchList'])->name('batch.batch-list');
    Route::get('/batch/{id}/{status}',[App\Http\Controllers\VisitorController::class, 'batchDetail'])->name('batch.batch');
});
// Product
Route::group(['prefix' => 'product'], function () {
    Route::get('/list', [App\Http\Controllers\ProductController::class, 'index'])->name('product.list');
    Route::get('/add', [App\Http\Controllers\ProductController::class, 'addView'])->name('product.add');
    Route::post('/product.addproductstore', [App\Http\Controllers\ProductController::class, 'addproductstore'])->name('product.addproductstore');
    Route::get('/detail', [App\Http\Controllers\ProductController::class, 'detailview'])->name('product.detail');
    Route::get('/visitorproductcount', [App\Http\Controllers\ProductController::class, 'productcount'])->name('product.visitorproductcount');
    Route::get('/destroy/{id}', [App\Http\Controllers\ProductController::class, 'destroy'])->name('product.destroy');
    Route::get('/editimage', [App\Http\Controllers\ProductController::class, 'editimage'])->name('product.editimage');
    Route::post('/imageStore', [App\Http\Controllers\ProductController::class, 'imageStore'])->name('product.imageStore');
    Route::get('/filedestroy', [App\Http\Controllers\ProductController::class, 'filedestroy'])->name('product.filedestroy');
	Route::post('/updateName', [App\Http\Controllers\ProductController::class, 'updateName'])->name('product.updateName');
    Route::get('/addimage', [App\Http\Controllers\ProductController::class, 'addimageView'])->name('product.addimage');
    Route::post('/imageStorenewadd', [App\Http\Controllers\ProductController::class, 'imageStorenewadd'])->name('product.imageStorenewadd');

});

//category
Route::group(['prefix' => 'category'], function () {
    Route::get('/list', [App\Http\Controllers\CategoryController::class, 'index'])->name('category.list');
    Route::get('/add', [App\Http\Controllers\CategoryController::class, 'addView'])->name('category.add');
    Route::post('/store', [App\Http\Controllers\CategoryController::class, 'store'])->name('category.store');
    Route::get('/destroy/{id}', [App\Http\Controllers\CategoryController::class, 'destroy'])->name('category.destroy');
    Route::get('/view-subcategory', [App\Http\Controllers\CategoryController::class, 'viewSubCategory'])->name('category.view-subcategory');
    Route::post('/save-subcategory', [App\Http\Controllers\CategoryController::class, 'saveSubCategory'])->name('category.save-subcategory');
});

//user_attendances
Route::group(['prefix' => 'user_attendances'], function () {
    Route::get('/list', [App\Http\Controllers\AttendanceController::class, 'index'])->name('user_attendance.list');
    Route::post('/exportuserattendance', [App\Http\Controllers\AttendanceController::class, 'exportuserattendance'])->name('user_attendance.exportuserattendance');
    Route::get('/liveuserattendance', [App\Http\Controllers\AttendanceController::class, 'liveuserattendance'])->name('user_attendance.liveuserattendance');
    Route::get('/fetchAllEmployees', [App\Http\Controllers\AttendanceController::class, 'fetchAllEmployees'])->name('user_attendance.fetchAllEmployees');
    Route::get('/fetchLastRecordOfAllEmployees', [App\Http\Controllers\AttendanceController::class, 'fetchLastRecordOfAllEmployees'])->name('user_attendance.fetchLastRecordOfAllEmployees');
    Route::get('/getEmployeeLocations', [App\Http\Controllers\AttendanceController::class, 'getEmployeeLocations'])->name('user_attendance.getEmployeeLocations');

});


//source_of_lead
Route::group(['prefix' => 'source_of_lead'], function () {
    Route::get('/list', [App\Http\Controllers\SourceOfLeadController::class, 'index'])->name('source_of_lead.list');
    Route::get('/add', [App\Http\Controllers\SourceOfLeadController::class, 'addView'])->name('source_of_lead.add');
    Route::post('/store', [App\Http\Controllers\SourceOfLeadController::class, 'store'])->name('source_of_lead.store');
    Route::get('/destroy/{id}', [App\Http\Controllers\SourceOfLeadController::class, 'destroy'])->name('source_of_lead.destroy');
});

//referred_by_master
Route::group(['prefix' => 'referred_by_master'], function () {
    Route::get('/list', [App\Http\Controllers\ReferredByMasterController::class, 'index'])->name('referred_by_master.list');
    Route::get('/add', [App\Http\Controllers\ReferredByMasterController::class, 'addView'])->name('referred_by_master.add');
    Route::post('/store', [App\Http\Controllers\ReferredByMasterController::class, 'store'])->name('referred_by_master.store');
    Route::get('/destroy/{id}', [App\Http\Controllers\ReferredByMasterController::class, 'destroy'])->name('referred_by_master.destroy');
});
Route::group(['prefix' => 'areas'], function () {
    Route::get('/list', [App\Http\Controllers\AreaController::class, 'index'])->name('areas.list');
    Route::post('/addEdit/{id?}', [App\Http\Controllers\AreaController::class, 'addEdit'])->name('areas.addEdit');
    Route::post('/store/{id?}', [App\Http\Controllers\AreaController::class, 'store'])->name('areas.store');
    Route::delete('/destroy/{id}', [App\Http\Controllers\AreaController::class, 'destroy'])->name('areas.destroy');
    Route::post('/importOpen', [App\Http\Controllers\AreaController::class, 'importOpen'])->name('areas.importOpen');
    Route::post('/importArea', [App\Http\Controllers\AreaController::class, 'importArea'])->name('areas.importArea');
    Route::get('/exportArea', [App\Http\Controllers\AreaController::class, 'exportArea'])->name('areas.exportArea');
});
//sub category
Route::group(['prefix' => 'sub_category'], function () {
    Route::get('/list', [App\Http\Controllers\Sub_CategoryController::class, 'index'])->name('sub_category.list');
    Route::get('/add', [App\Http\Controllers\Sub_CategoryController::class, 'addView'])->name('sub_category.add');
    Route::post('/store', [App\Http\Controllers\Sub_CategoryController::class, 'store'])->name('sub_category.store');
    Route::get('/destroy/{id}', [App\Http\Controllers\Sub_CategoryController::class, 'destroy'])->name('sub_category.destroy');
});

// Export
Route::group(['prefix' => 'export'], function () {
    Route::post('/exportvisitorlist', [App\Http\Controllers\VisitorController::class, 'exportvisitorlist'])->name('export.exportvisitorlist');
    Route::post('/export_pdf', [App\Http\Controllers\VisitorController::class, 'export_pdf'])->name('export.export_pdf');

    Route::post('/exportvisitorlistbyevent', [App\Http\Controllers\VisitorController::class, 'exportvisitorlistbyevent'])->name('export.exportvisitorlistbyevent');
    Route::post('/googlecontactlist', [App\Http\Controllers\VisitorController::class, 'exportgooglecontactlist'])->name('export.googlecontactlist');
});

// settings
Route::group(['prefix' => 'setting'], function () {
    Route::get('/whatsapp_msg', [App\Http\Controllers\SettingController::class, 'whatsappmsg'])->name('setting.whatsapp_msg');
    Route::post('/editwhatsapp_msg', [App\Http\Controllers\SettingController::class, 'editwhatsapp_msg'])->name('setting.editwhatsapp_msg');
    Route::get('/change_password', [App\Http\Controllers\SettingController::class, 'change_password'])->name('setting.change_password');
    Route::post('/update_password', [App\Http\Controllers\SettingController::class, 'update_password'])->name('setting.update_password');
    Route::post('/update_email', [App\Http\Controllers\SettingController::class, 'update_email'])->name('setting.update_email');
    Route::resource('/emails', App\Http\Controllers\EmailController::class);
    Route::get('emails/copy/add/{id}', [App\Http\Controllers\EmailController::class, 'copy'])->name('emails.copy.add');
    Route::post('/sendEmail', [App\Http\Controllers\EmailController::class, 'procsendEmail'])->name('send.email');
    Route::get('/schedule-email-cron', [App\Http\Controllers\EmailController::class, 'scheduleBatchMailCron']);
     Route::post('/email/upload/image', [App\Http\Controllers\EmailController::class, 'upload'])->name('email-upload-image');
     Route::get('/indiamart', [App\Http\Controllers\SettingController::class, 'martkey'])->name('setting.martkey');
     Route::post('/facebookConfigSave', [App\Http\Controllers\SettingController::class, 'facebookConfigSave'])->name('setting.facebookConfigSave');
     Route::post('/facebookSettings/list', [App\Http\Controllers\SettingController::class, 'facebookConfigList'])->name('setting.facebookConfigList');
     Route::post('/update_key', [App\Http\Controllers\SettingController::class, 'updatekey'])->name('setting.update_key');
    Route::get('/delete/{id}', [App\Http\Controllers\EmailController::class, 'delete'])->name('delete');
    Route::get('/upload_image', [App\Http\Controllers\SettingController::class, 'upload_image'])->name('setting.upload_image');
    Route::post('/store_image', [App\Http\Controllers\SettingController::class, 'store_image'])->name('setting.store_image');
    Route::get('/delete_image/{id}', [App\Http\Controllers\SettingController::class, 'delete_image'])->name('delete_image');
    Route::post('/update_emailconfig', [App\Http\Controllers\SettingController::class, 'update_emailconfig'])->name('setting.update_emailconfig');
    Route::get('/region', [App\Http\Controllers\SettingController::class, 'region_list'])->name('setting.region');
    Route::get('/add', [App\Http\Controllers\SettingController::class, 'add'])->name('setting.add');
    Route::post('/add_store', [App\Http\Controllers\SettingController::class, 'add_store'])->name('setting.add_store');
    Route::get('/region_delete/{id}', [App\Http\Controllers\SettingController::class, 'region_delete'])->name('region_delete');
    Route::get('/region_edit', [App\Http\Controllers\SettingController::class, 'region_edit'])->name('region_edit');
    Route::post('/edit_store', [App\Http\Controllers\SettingController::class, 'edit_store'])->name('edit_store');

    Route::get('/division', [App\Http\Controllers\SettingController::class, 'divisionList'])->name('setting.divisionList');
    Route::get('/division_add', [App\Http\Controllers\SettingController::class, 'divisionAdd'])->name('setting.divisionAdd');
    Route::post('/division_insert', [App\Http\Controllers\SettingController::class, 'divisionInsert'])->name('setting.divisionInsert');
    Route::get('/division_delete/{id}', [App\Http\Controllers\SettingController::class, 'divisionDelete'])->name('setting.divisionDelete');
    Route::get('/division_edit', [App\Http\Controllers\SettingController::class, 'divisionEdit'])->name('setting.divisionEdit');
    Route::post('/division_update', [App\Http\Controllers\SettingController::class, 'divisionUpdate'])->name('setting.divisionUpdate');

    Route::get('/subAdmin', [App\Http\Controllers\SettingController::class, 'subAdminList'])->name('setting.subAdminList');
    Route::get('/subAdmin_add', [App\Http\Controllers\SettingController::class, 'subAdminAdd'])->name('setting.subAdminAdd');
    Route::post('/subAdmin_insert', [App\Http\Controllers\SettingController::class, 'subAdminInsert'])->name('setting.subAdminInsert');
    Route::get('/subAdmin_delete/{id}', [App\Http\Controllers\SettingController::class, 'subAdminDelete'])->name('setting.subAdminDelete');
    Route::get('/subAdmin_edit', [App\Http\Controllers\SettingController::class, 'subAdminEdit'])->name('setting.subAdminEdit');
    Route::post('/subAdmin_update', [App\Http\Controllers\SettingController::class, 'subAdminUpdate'])->name('setting.subAdminUpdate');

    Route::get('/quotation_config', [App\Http\Controllers\SettingController::class, 'quotationconfig'])->name('setting.quotation_config');
    Route::post('/editquotation_config', [App\Http\Controllers\SettingController::class, 'editquotationconfig'])->name('setting.editquotation_config');
    Route::get('/deletequotationconfigimage', [App\Http\Controllers\SettingController::class, 'deletequotationconfigimage'])->name('setting.deletequotationconfigimage');
});

// Import
Route::group(['prefix' => 'import'], function () {
    Route::post('/insertexportfile', [App\Http\Controllers\VisitorController::class, 'insertexportfile'])->name('import.insertexportfile');
});

// Ajax Routes
Route::group(['prefix' => 'ajax'], function () {
    Route::get('/get_image', [App\Http\Controllers\VisitorController::class, 'getimage'])->name('get_image');
    Route::get('/get_eventlist', [App\Http\Controllers\VisitorController::class, 'geteventlist'])->name('get_eventlist');
    Route::get('/get_imagefile', [App\Http\Controllers\ProductController::class, 'getimagefile'])->name('get_imagefile');
    Route::get('/get_productlist', [App\Http\Controllers\VisitorController::class, 'getproductlist'])->name('get_productlist');
    Route::get('/get_userlist', [App\Http\Controllers\UserController::class, 'getUserlist'])->name('get_userlist');
    Route::get('/get_eventlist_multi', [App\Http\Controllers\VisitorController::class, 'geteventlist_multi'])->name('get_eventlist_multi');
    Route::get('/get_visitdata', [App\Http\Controllers\VisitorController::class, 'get_visitdata'])->name('get_visitdata');
    Route::get('/get_visit_images', [App\Http\Controllers\VisitorController::class, 'get_visit_images'])->name('get_visit_images');
    Route::get('/categories/getSubcategory', [App\Http\Controllers\VisitorController::class, 'getSubCategories'])->name('get_sub_categories');
    Route::get('/categories/getSubcategoryBulk', [App\Http\Controllers\VisitorController::class, 'getSubCategoriesBulk'])->name('get_sub_categories_bulk');
    Route::get('/states/getCities', [App\Http\Controllers\VisitorController::class, 'getCities'])->name('get_cities');
    Route::get('/cities/getCitiesBulk', [App\Http\Controllers\VisitorController::class, 'getCitiesBulk'])->name('get_cities_bulk');
    Route::get('/cities/getAreas', [App\Http\Controllers\VisitorController::class, 'getAreas'])->name('get_areas');
    Route::get('/areas/getAreasBulk', [App\Http\Controllers\VisitorController::class, 'getAreasBulk'])->name('get_areas_bulk');
    Route::get('/countries/getStates', [App\Http\Controllers\VisitorController::class, 'getStates'])->name('get_states');
    Route::get('/countries/getStatesBulk', [App\Http\Controllers\VisitorController::class, 'getStatesBulk'])->name('get_states_bulk');

    Route::get('/countries/getCountries', [App\Http\Controllers\VisitorController::class, 'getCountries'])->name('get_countries');
    Route::get('/get_visit_product', [App\Http\Controllers\VisitorController::class, 'get_visit_product'])->name('get_visit_product');
    Route::get('/get_visitorlist_id', [App\Http\Controllers\VisitorController::class, 'get_visitorlist_id'])->name('get_visitorlist_id');

});

//Action
Route::group(['prefix' => 'action'], function () {
    Route::get('/list', [App\Http\Controllers\ActionController::class, 'index'])->name('action.list');
    Route::get('/add', [App\Http\Controllers\ActionController::class, 'addView'])->name('action.add');
    Route::post('/store', [App\Http\Controllers\ActionController::class, 'store'])->name('action.store');
    Route::get('/destroy/{id}', [App\Http\Controllers\ActionController::class, 'destroy'])->name('action.destroy');
});

// Send Email

Route::get('/send/email/modal', [App\Http\Controllers\VisitorController::class, 'sendEmailModal'])->name('send.email.modal');

// Route::post('/assign_user_notification', [App\Http\Controllers\NotificationController::class, 'sendUserAssignedNotification'])->name('assign_user_notification');

Route::get('visitormailschedulecron', [App\Http\Controllers\ScheduleCronController::class, 'visitormailschedulecron'])->name('visitormailschedulecron');

Route::get('visitorindiamartschedulecron', [App\Http\Controllers\VisitorIndiaMartScheduleCronController::class, 'visitorindiamartschedulecron'])->name('visitorindiamartschedulecron');
Route::get('visitortradindiaschedulecron', [App\Http\Controllers\VisitorTradIndiaScheduleCronController::class, 'visitortradindiaschedulecron'])->name('visitortradindiaschedulecron');


// TO GET OLD INDIAMART DATA....
Route::get('visitorindiamartcronforolddata', [App\Http\Controllers\VisitorIndiaMartScheduleCronController::class, 'visitorindiamartcronforolddata'])->name('visitorindiamartcronforolddata');


// ZohoCrm
Route::get('zoho_crm', [App\Http\Controllers\ZohoCrmController::class, 'zoho_crm'])->name('zoho_crm');
Route::post('zoho/crm/save', [App\Http\Controllers\ZohoCrmController::class, 'zoho_crm_save'])->name('zohocCrmSave');
Route::get('zohocrmVisitorLeadsCron', [App\Http\Controllers\ZohoCrmController::class, 'zohocrmVisitorLeadsCron'])->name('zohocrmVisitorLeadsCron');



Route::get('/check-file', function () {
    $path = storage_path('app/firebase/service-account-file.json');

    if (file_exists($path)) {
        return response()->json(['message' => 'File exists!', 'path' => $path]);
    } else {
        return response()->json(['message' => 'File does not exist!', 'path' => $path]);
    }
});

// Template
Route::group(['prefix' => 'template'], function () {
    Route::get('/list', [App\Http\Controllers\TemplateController::class, 'index'])->name('template.list');
    Route::get('/add', [App\Http\Controllers\TemplateController::class, 'add'])->name('template.add');
    Route::post('/store', [App\Http\Controllers\TemplateController::class, 'store'])->name('template.store');
    Route::get('/edit/{template}', [App\Http\Controllers\TemplateController::class, 'edit'])->name('template.edit');
    Route::post('/update/{template}', [App\Http\Controllers\TemplateController::class, 'update'])->name('template.update');
    Route::get('/destroy/{id}', [App\Http\Controllers\TemplateController::class, 'destroy'])->name('template.destroy');
    Route::get('/updateDefault/{id}', [App\Http\Controllers\TemplateController::class, 'updateDefault'])->name('template.updateDefault');
    Route::get('/send-approval/{template}', [App\Http\Controllers\TemplateController::class, 'sendApproval'])->name('template.send-approval');
    Route::get('/send-test-message/{template}', [App\Http\Controllers\TemplateController::class, 'sendTestMessage'])->name('template.send-test-message');
});

Route::post('register/getOtp', [App\Http\Controllers\Auth\RegisterController::class, 'getOtp'])->name('register.getOtp');
Route::post('register/userCreate', [App\Http\Controllers\Auth\RegisterController::class, 'userCreate'])->name('register.userCreate');

Route::post('password/getOtp', [App\Http\Controllers\Auth\ResetPasswordController::class, 'getOtp'])->name('password.getOtp');
Route::post('password/newCreate', [App\Http\Controllers\Auth\ResetPasswordController::class, 'newCreate'])->name('password.newCreate');


/*Route::get('quotation', [App\Http\Controllers\QuotationController::class, 'quotation'])->name('quotation');
Route::post('generatequotation', [App\Http\Controllers\QuotationController::class, 'generatequotation'])->name('generatequotation');
Route::get('quotationgenerated', [App\Http\Controllers\QuotationController::class, 'quotationgenerated'])->name('quotationgenerated');*/

Route::get('dailyreport', [App\Http\Controllers\CronController::class, 'dailyreport'])->name('dailyreport');


// Template
Route::group(['prefix' => 'expence'], function () {
    Route::get('/list', [App\Http\Controllers\ExpenceAdminController::class, 'index'])->name('expence.list');
    Route::post('/images/{id}', [App\Http\Controllers\ExpenceAdminController::class, 'expenceImages'])->name('expence.images');
});

Route::get('/createexpence', [App\Http\Controllers\ExpenceController::class, 'createexpence'])->name('createexpence');
Route::post('/saveexpence', [App\Http\Controllers\ExpenceController::class, 'saveexpence'])->name('saveexpence');

// visitor
Route::group(['prefix' => 'newvisitor'], function () {
    Route::get('/list', [App\Http\Controllers\NewVisitorController::class, 'newvisitor'])->name('newvisitor.list');
});


Route::group(['prefix' => 'quotations'], function () {
    Route::get('/list', [App\Http\Controllers\NewQuotationController::class, 'index'])->name('quotations.list');
    Route::get('/destroy/{id}', [App\Http\Controllers\NewQuotationController::class, 'destroy'])->name('quotations.destroy');
    Route::get('/generate_quotation', [App\Http\Controllers\NewQuotationController::class, 'admingenerateQuotation'])->name('quotations.generate_quotation');
    Route::post('/savegenerate_quotation', [App\Http\Controllers\NewQuotationController::class, 'saveadmingenerateQuotation'])->name('quotations.savegenerate_quotation');
});

Route::get('quotation', [App\Http\Controllers\NewQuotationController::class, 'quotation'])->name('quotation');
Route::post('generatequotation', [App\Http\Controllers\NewQuotationController::class, 'generatequotation'])->name('generatequotation');
Route::get('quotationgenerated', [App\Http\Controllers\NewQuotationController::class, 'quotationgenerated'])->name('quotationgenerated');

Route::get("whatsappVisitMessageCron",[VisitorController::class,'whatsappVisitMessageCron'])->name('whatsappVisitMessageCron');
