@extends('layouts.master')
@section('content')
<style>
/* Container to wrap each image and the close icon */
.image-container {
    position: relative;
    display: inline-block;
    margin-right: 10px;
}

/* Style for the close button */
.close-icon {
    position: absolute;
    right: 5px;
    color: white;
}

/* Optional: On hover, the close icon button can have a hover effect */
.close-icon:hover {
    background-color: rgba(255, 0, 0, 1);
}

#overlay {
            position: fixed;
            top: 0;
            z-index: 1070;
            width: 100%;
            height: 100%;
            display: none;
            background: rgba(0, 0, 0, 0.6);
        }

        .cv-spinner {
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 4px #ddd solid;
            border-top: 4px #2e93e6 solid;
            border-radius: 50%;
            animation: sp-anime 0.8s infinite linear;
        }

        @keyframes sp-anime {
            100% {
                transform: rotate(360deg);
            }
        }

</style>
<style>
label.error{
color: red;
}
.select2-selection__choice{
    color: black !important;
}
.card-header {
    color: #fff;
    background-color: #007bff;
}
img {
    height:auto;
    width: 166px;
    object-fit: scale-down;
}

#fullpage {
    display: none;
    position: absolute;
    z-index: 9999;
    top: 0;
    left: 0;
    width: 80.3vw;
    height: 90vh;
    background-size: contain;
    background-repeat: no-repeat no-repeat;
    background-position: center center;
    background-color: black;
}
.image-gallery {
    display: flex;
    flex-wrap: wrap;
    margin: -5px;
}

.gallery-item {
    flex: 1.1 0 calc(33.33% - 10px);
    box-sizing: border-box;
    padding: 5px;
}
.img2 {
    height: 200px; /* Set the height to your desired value */
    object-fit: cover; /* This property ensures that the image retains its aspect ratio and covers the entire container */
}
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Client</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('visitor.list') }}">Client List</a></li>
                        <li class="breadcrumb-item active">Edit Client</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    @if ($message = Session::get('success'))
    <div class="alert alert-success alert-block">
        <button type="button" class="close" data-dismiss="alert">X</button>
        <strong>{{ $message }}</strong>
    </div>
    @endif

    @if ($message = Session::get('error'))
    <div class="alert alert-danger alert-block">
        <button type="button" class="close" data-dismiss="alert">X</button>
        <strong>{{ $message }}</strong>
    </div>
    @endif
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center" onload="getPics()">
                                <div class="gallery">
                                    <div style="overflow-x:scroll;white-space:nowrap;" >
                                        @foreach($event_images as $images)
                                            @php
                                                $modified_image_path = substr($images->event_image, strpos($images->event_image, '/frenzincrm_api'));
                                                $imagePathInfo = pathinfo($images->event_image);
                                                $extension = strtolower($imagePathInfo['extension']);
                                            @endphp

                                            @if ($extension === 'pdf')
                                                <a href="{{$modified_image_path}}" target="_blank" style="text-decoration: none;">
                                                    <img src="{{ asset('pdficon.png') }}" style="width: 139px; height: 166px;"
                                                    class="img" alt="" >
                                                </a>
                                            @else
                                                <img src="{{$modified_image_path}}" style="width: 301px; height: 166px;"
                                                    class="img" alt="" >
                                            @endif
                                        @endforeach
                                        <?php
                                            $images = substr($visitor->front_image, strpos($visitor->front_image, '/frenzincrm_api'));
                                            $back_images = substr($visitor->back_image, strpos($visitor->back_image, '/frenzincrm_api'));
                                        ?>
                                        @if(isset($visitor->front_image) && $visitor->front_image != NULL)
                                                <img src="{{$images}}" class="img" alt="" style="width: 301px; height: 166px;">
                                        @endif
                                        @if(isset($visitor->back_image) && $visitor->back_image != NULL)
                                                <img class="img" src="{{ $back_images }}" alt="" style="width: 301px; height: 166px;">
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div id="fullpage" onclick="this.style.display='none';"></div>
                            <h3 class="profile-username text-center">@if(isset($visitor->name)){{ $visitor->name }}@endif</h3>
                            @if(!empty($visitor->lat))
                                <div style="width: 25px; margin-left: 600px;margin-top: -35px">
                                    <a href="http://www.google.com/maps/place/{{ $visitor->lat }},{{ $visitor->lng }}" class="" target="_blank">
                                        <svg viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><clipPath id="a"><use xlink:href="#b"/></clipPath><rect id="b" fill="#fff" height="512" rx="15%" width="512"/><g clip-path="url(#a)"><path d="m0 512v-512h512z" fill="#35a85b"/><path d="m256 288-224 224h448z" fill="#5881ca"/><path d="m288 256 224-224v448z" fill="#c1c0be"/><path d="m0 512 512-512" stroke="#fadb2a" stroke-width="71"/><path d="m175 173h50a50 54 0 1 1 -15-41" fill="none" stroke="#f2f2f2" stroke-width="22"/><path d="m353 85a70 70 0 0 1 140 0c0 70-70 70-70 157 0-87-70-87-70-157" fill="#de3738"/><circle cx="423" cy="89" fill="#7d2426" r="25"/></g></svg>
                                    </a>
                                </div>
                            @endif
                            <p class="text-muted text-center">
                                @if(isset($visitor->mobile_no))
                                    <a href="tel:{{$visitor->mobile_no}}" style="text-decoration: none;">{{$visitor->mobile_no}}
                                    </a>
                                @endif
                            </p>
                        </div>
                    </div>
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    {{--<i class="fas fa-minus"></i>--}}
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form id="visitorEditForm" method="post" action="{{ route('visitor.update',$visitor->id) }}" name="form" enctype="multipart/form-data">
                                @csrf

                                @if(Auth::user()->getUser() && Auth::user()->getUser()->is_admin == "true")

                                    <div class="form-group">
                                        <label for="">Select Team Member</label>
                                        <select class="form-control custom-select" name="customer_id" id="customer_id" required>
                                            <option value="" >Select member</option>
                                            @foreach($members as $member)
                                                <option value="{{ $member->CustomerID }}" @if($visitor->customer_id == $member->CustomerID) selected @endif>{{$member->CustomerName}}</option>
                                            @endforeach
                                        </select>
                                        @error('customer_id')
                                        <div class="error">{{ $message }}</div>
                                        @enderror
                                    </div>
                                @else
                                    <input type="hidden" name="customer_id" value="$visitor->customer_id" >
                                @endif
                                <div class="form-group">
                                    <label for="">Visited Date</label>
                                    <input type="datetime-local" name="visited_date" value="{{$visitor->visited_date}}" class="form-control" placeholder="Enter Visited Date">
                                    @error('visited_date')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @sessionContactField('name')

                                <div class="form-group">
                                    <label for="">@defaultValue($contactFieldValue['label'] ?? 'Name') @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="name" class="form-control" placeholder="@defaultValue($contactFieldValue['hint'] ?? 'Enter Name')"
                                           value="{{$visitor->name}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('name')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('designation')

                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Designation' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="designation" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Designation')"
                                           value="{{$visitor->designation}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('designation')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('company_name')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Company Name' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="company_name" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Company Name')"
                                        value="{{$visitor->company_name}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('company_name')
                                        <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('company_website')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Website' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="website" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Website')"
                                           value="{{$visitor->website}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('website')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('country_code_for_mobile')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Country Code' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="country_code" id="country_code" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="" @if($visitor->country_code== null ) selected @endif>@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No Country')</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->iso_code }}" @if($country->iso_code==$visitor->country_code) selected
                                                @endif>{{$country->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('country')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('mobile1')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Mobile No.' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="mobile_no" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Mobile No')"
                                           value="{{$visitor->mobile_no}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('mobile_no')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('mobile2')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Mobile No. 2' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="mobile_no2" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Mobile No2')"
                                           value="{{$visitor->mobile_no2}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('mobile_no2')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('mobile3')
                                        <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Mobile No. 3' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="mobile_no3" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Mobile No3')"
                                           value="{{$visitor->mobile_no3}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('mobile_no3')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('email1')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Email' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="email" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Email')"
                                           value="{{$visitor->email}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('email')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('email2')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Email 2' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="email2" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Email2')"
                                           value="{{$visitor->email2}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('email2')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('address_country_code')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Address Country Code' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="address_country_code" id="address_country_code" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="" @if($visitor->address_country_code== null ) selected @endif>@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No Country')</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->iso_code }}" @if($country->iso_code==$visitor->address_country_code) selected
                                                @endif>{{$country->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('country')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('state')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'State' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <div class="states-dropdown">
                                        <select class="form-control custom-select" name="state" id="state_id" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                            @if($states)

                                                <option value="" @if($visitor->state== null ) selected @endif>@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No State')</option>
                                                @foreach($states as $state)
                                                    <option value="{{ $state->id }}" @if($state->id==$visitor->state) selected
                                                        @endif>{{$state->name}}</option>
                                                @endforeach
                                            @else
                                                <option value="" @if($visitor->state== null ) selected @endif>@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No State')</option>
                                            @endif
                                        </select>
                                    </div>
                                    {{-- <div class="states-textbox">
                                        <input type="text" id="state_textbox" name="state" class="form-control" placeholder="Enter State">
                                    </div> --}}
                                    @error('state')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('city')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'City' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <div class="cities-dropdown">
                                        <select class="form-control custom-select" name="city" id="city_id" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                            @if($cities)
                                                <option value="" @if($visitor->city== null ) selected @endif>No City</option>

                                                @foreach($cities as $city)
                                                    <option value="{{ $city->name }}" @if($city->name==$visitor->city) selected
                                                        @endif>{{$city->name}}</option>
                                                @endforeach
                                            @else
                                                <option value="" @if($visitor->city== null ) selected @endif>No City</option>
                                            @endif
                                        </select>
                                    </div>
                                    {{-- <div class="cities-textbox">
                                        <input type="text" id="city_textbox" name="city" class="form-control" placeholder="Enter City">
                                    </div> --}}
                                    @error('city')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('city')

								<div class="form-group" id="other_city" >
                                    <label for="othercity_textbox">@defaultValue(empty($contactFieldValue['label']) ? 'Other City' : $contactFieldValue['label'])</label>
                                    <div class="cities-dropdown">
                                        <input type="text" id="othercity_textbox" name="othercity" class="form-control" placeholder="@defaultValue(empty($contactFieldValue['hint']) ? 'Enter City Name' : $contactFieldValue['hint'])" value="{{ $visitor->city }}">
                                    </div>
                                    @error('city')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('area')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Area' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <div class="cities-dropdown">
                                        <select class="form-control custom-select" name="area" id="area" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                            <option value="">No Area</option>
                                            <option value="Other" @selected($isOtherArea)>Other</option>
                                            @foreach($areas as $area)
                                                <option value="{{ $area->name }}" @if($area->name==$visitor->area) selected
                                                    @endif>{{$area->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    {{-- <div class="cities-textbox">
                                        <input type="text" id="city_textbox" name="city" class="form-control" placeholder="Enter City">
                                    </div> --}}
                                    @error('area')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('area')

								<div class="form-group" id="other_area" style="{{ $isOtherArea ? 'display:block;' : 'display:none;' }}">
                                    <label for="otherarea_textbox">@defaultValue(empty($contactFieldValue['label']) ? 'Other Area' : $contactFieldValue['label'])</label>
                                    <div class="areas-dropdown">
                                        <input type="text" value="{{ $visitor?->area }}" id="otherarea_textbox" name="otherarea" class="form-control" placeholder="@defaultValue(empty($contactFieldValue['hint']) ? 'Enter Area Name' : $contactFieldValue['hint'])">
                                    </div>
                                    @error('area')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('address')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Address' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="address" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Address')"
                                           value="{{$visitor->address}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('address')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('pincode')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Pincode' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="pincode" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Pincode')"
                                           value="{{$visitor->pincode}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('pincode')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('source_of_lead')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Source Of Lead' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control" name="source_of_lead" id="source_of_lead" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="" @if($visitor->source_of_lead== null ) selected @endif>@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select Source Of Lead')</option>
                                        @foreach ($source_of_leads as $lead)
                                        <option value="{{ $lead }}" class="" {{ $visitor->source_of_lead == $lead ? 'selected' : '' }}>{{ $lead }}</option>
                                        @endforeach
                                    </select>
                                    @error('source_of_lead')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField
                                @sessionContactField('referred_by')
                                <div class="form-group referred_by_box" style="{{ $visitor->source_of_lead == 'Referred By' ? 'display: block;' : 'display: none;' }}">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Referred By' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control"  name="referred_by_name" id="referred_by_name" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="">@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select Referred By')</option>
                                        @foreach ($referredBy as $refer)
                                        <option value="{{ $refer }}" class="" @selected($visitor->referred_by == $refer)>{{ $refer }}</option>
                                        @endforeach
                                    </select>
                                    @error('referred_by_name')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('category')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Category' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="category[]" id="category_id" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="" @if($visitor->category== null ) selected @endif>@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select Category')</option>
                                    </select>
                                    @error('category')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('sub_category')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'SubCategory' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="sub_category[]" id="sub_category_id" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        @if($subcategories)
                                            <option value="" @if($visitor->sub_category== null ) selected @endif>@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No SubCategory')</option>
                                            @foreach($subcategories as $subcategory)
                                                <option value="{{ $subcategory->name }}" @if(in_array($subcategory->name,$visitor->sub_category)) selected
                                                    @endif>{{$subcategory->name}}</option>
                                            @endforeach
                                        @else
                                            <option value="" @if($visitor->sub_category== null ) selected @endif>@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No SubCategory')</option>
                                        @endif
                                    </select>
                                    @error('sub_category')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('follow_up')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Follow Up Time' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="datetime-local" name="follow_up_time" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Follow Up Time')"
                                           value="{{$visitor->follow_up_time}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('follow_up_time')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('action')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Action' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="action" id="action" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="" @if($visitor->action== null ) selected @endif>@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'No Action')</option>
                                        @foreach($actions as $action)
                                        <option value="{{ $action->title }}" @if($action->title==$visitor->action) selected
                                                @endif>{{$action->title}}</option>
                                        @endforeach
                                    </select>
                                    @error('action')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('remarks')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Remarks' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="remarks" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Remarks')"
                                           value="{{$visitor->remarks}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('remarks')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('qr_code_value')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'QR Code Value' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="qrcodevalue" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter QR Code Value')"
                                           value="{{$visitor->qrcodevalue}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('qrcodevalue')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('priority')
                                <div class="form-group">
                                    <label for="priority">@defaultValue(empty($contactFieldValue['label']) ? 'Priority' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select name="rating" id="priority" class="form-control" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option value="" @if($visitor->rating== null ) selected @endif>@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select Priority')</option>
                                        <option value="High" {{ $visitor->rating === 'High' ? 'selected' : '' }}>High</option>
                                        <option value="Medium" {{ $visitor->rating === 'Medium' ? 'selected' : '' }}>Medium</option>
                                        <option value="Low" {{ $visitor->rating === 'Low' ? 'selected' : '' }}>Low</option>
                                    </select>
                                    @error('rating')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('monthly_requirement')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Monthly Requirement' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <input type="text" name="monthly_requirement" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Monthly Requirement')"
                                           value="{{$visitor->monthly_requirement}}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    @error('monthly_requirement')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                @endsessionContactField

                                @sessionContactField('products')
                                <div class="form-group">
                                    <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Products' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                    <select class="form-control custom-select" name="products[]" id="product_id" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                        <option></option>
                                    </select>
                                </div>
                                @endsessionContactField

                                <?php
                                    $images = substr($visitor->front_image, strpos($visitor->front_image, '/frenzincrm_api'));
                                    $back_images = substr($visitor->back_image, strpos($visitor->back_image, '/frenzincrm_api'));
                                ?>

                                <!-- Front image starte -->
                                <div class="form-group">
                                    <label for="">Front Image</label> :
                                    <input type="file" name="front_image" class="form-control @error('front_image') is-invalid @enderror" id="front_image" value="">
                                </div>
                                @if(isset($visitor->front_image) && $visitor->front_image != NULL)
                                <div class="col-md-3" id="front_image_{{ $visitor->id }}">
                                    <table id="example" class="table grid table-borderless">
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <div class="form-group">
                                                        <input type="hidden" name="visitor_id" id="visitor_id" value="{{ $visitor->id ?? ''}}">
                                                        <input type="hidden" name="type" id="image_type" value="front_image">
                                                        <img src="{{ $images }}" alt="image" style="width:200px;height:150px;" class="ml-3 mt-2 mb-2">
                                                    </div>
                                                </td>
                                                <td>
                                                    <button type="button" onclick="deleteImage({{ $visitor->id }}, 'front_image')" class="">
                                                        <i class="fa fa-times" style="font-size:30px;color:#0c61aa;"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                @endif
                                 <!-- Front image End -->

                                <!-- Back image Start -->
                                <div class="form-group">
                                    <label for="">Back Image</label> :
                                    <input type="file" name="back_image" class="form-control @error('back_image') is-invalid @enderror" id="back_image" value="">
                                </div>
                                @if(isset($visitor->back_image) && $visitor->back_image != NULL)
                                <div class="col-md-3" id="back_image_{{ $visitor->id }}">
                                    <table id="example" class="table grid table-borderless">
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <div class="form-group">
                                                        <input type="hidden" name="visitor_id" id="visitor_id" value="{{ $visitor->id ?? ''}}">
                                                        <input type="hidden" name="type" id="image_type" value="back_image">
                                                        <img src="{{ $back_images }}" alt="image" style="width:200px;height:150px;" class="ml-3 mt-2 mb-2">
                                                    </div>
                                                </td>
                                                <td>
                                                    <button type="button" onclick="deleteImage({{ $visitor->id }}, 'back_image')" class="">
                                                        <i class="fa fa-times" style="font-size:30px;color:#0c61aa;"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                @endif
                                 <!-- Back image End -->

                                <div class="form-group">
                                    <label for="">Event Images</label> :
                                    <input type="file" name="event_images[]" class="form-control @error('event_images') is-invalid @enderror" id="event_images" value="" multiple>
                                </div>


                                @if(count($event_images) > 0)
                                <div class="row">
                                    <div class="col-md-12">
                                        <p><strong>Event Images :</strong></p>
                                    </div>
                                    @foreach($event_images as $list)
                                        <div class="col-md-3" id="image_{{ $list->id }}">
                                            <table id="example" class="table grid table-borderless">
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <div class="form-group">
                                                                <input type="hidden" name="visitor_id" id="visitor_id" value="{{ $visitor->id ?? '' }}">
                                                                <input type="hidden" name="id" id="id" value="{{ $list->id }}">
                                                                @php
                                                                    $modified_image_path = substr($list->event_image, strpos($list->event_image, '/frenzincrm_api'));
                                                                    $imagePathInfo = pathinfo($list->event_image);
                                                                    $extension = strtolower($imagePathInfo['extension']);
                                                                @endphp

                                                                @if ($extension === 'pdf')
                                                                    <!-- PDF logo dikhao -->
                                                                    <a href="{{ $modified_image_path }}" target="_blank">
                                                                        <img src="{{ asset('pdficon.png') }}" height="50" width="50">
                                                                    </a>
                                                                @else
                                                                    <!-- Image dikhao -->
                                                                    <img src="{{ $modified_image_path }}" alt="image" style="width:200px;height:150px;" class="ml-3 mt-2 mb-2">
                                                                @endif
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <button type="button" class="" onclick="deleteEventImage({{ $list->id }})">
                                                                <i class="fa fa-times delete-user" style="font-size:30px;color:#0c61aa;"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    @endforeach
                                </div>
                            @endif



                                <div class="card-footer">
                                <button type="submit" class="btn btn-primary" >Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="overlay">
        <div class="cv-spinner">
            <span class="spinner"></span>
        </div>
    </div>

<script>
    function getPics() {}
    const imgs = document.querySelectorAll('.gallery img');
    const fullPage = document.querySelector('#fullpage');

    imgs.forEach(img => {
        var imageUrl = img.src;
        var images = imageUrl.substring(imageUrl.indexOf('/frenzincrm_api'));
        console.log(images)
        img.addEventListener('click', function() {
            fullPage.style.backgroundImage = 'url(' + images + ')';

            fullPage.style.display = 'block';
        });
    });
    $(document).ready(function() {
        $('#visitorEditForm').validate()
        var addressCountryCode = "{{$visitor->address_country_code}}";
        if(addressCountryCode === '' ){
            //console.log('null');
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
        }
        if(addressCountryCode === 'IN'){
            //console.log('IN');
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
            fetchStates('99');
            var oldStateId ="{{$visitor->state}}";
            if(oldStateId){
                fetchCities(oldStateId)
            }
        }else{
            //console.log('else');
            $('.states-dropdown').css('display','none');
            $('.cities-dropdown').css('display','none');
            $('.states-textbox').show();
            $('.cities-textbox').show();
            $('#state_textbox').val("{{$visitor->state}}");
            $('#city_textbox').val("{{$visitor->city}}");
        }
        $('#category_id').on("select2:select", function(e) {
            var categoryNames = [];
            $(e.currentTarget).find("option:selected").each(function(i, selected){
                categoryNames[i] = $(selected).text();
            });
            fetchSubCategories(categoryNames);
        });
        $('#category_id').on("select2:unselect", function(e) {
            var categoryNames = [];
            $(e.currentTarget).find("option:selected").each(function(i, selected){
                categoryNames[i] = $(selected).text();
            });
            if(categoryNames.length !== 0){
                fetchSubCategories(categoryNames);
            }else{
                var subCategoryId = $('#sub_category_id');
                $('#sub_category_id').html('');
                subCategoryId.val(null).trigger('change');
            }
        });
        $("#category_id").select2({
            @sessionContactField('category')

placeholder: "@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select a category')",
@endsessionContactField
            multiple: true,
        });
        $("#sub_category_id").select2({
            @sessionContactField('sub_category')

            placeholder: "@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select a sub category')",
            @endsessionContactField
            multiple: true,
        });
        $("#product_id").select2({
            @sessionContactField('products')

placeholder: "@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Select product')",
@endsessionContactField
            multiple: true,
        });
        $("#source_of_lead").on("change",function(){
            var sourceOfLead = $(this).val();
            if(sourceOfLead == 'Referred By'){
                $('.referred_by_box').show();
            }else{
                $('.referred_by_box').hide();
            }
        })
        setSelectedCategories()
        setSelectedProducts()
    });
    function setSelectedProducts()
    {
        var visitorProductIds = "{{ implode(',',$visitor->products) }}";
        var allProducts = @json($allProducts);
        var options = [];
        var productId = $('#product_id');
        productId.html('');
        productId.val(null).trigger('change');
        $.each(JSON.parse(allProducts), function(index, value) {
            var selected = false;
            if(jQuery.inArray(value.id.toString(), visitorProductIds.split(',')) !== -1){
                selected = true;
            }
            var option = new Option(value.name, value.id, false, selected);
            productId.append(option).trigger('change');
            options.push({id:value.id,text:value.name});
        });
        // manually trigger the `select2:select` event
        productId.trigger({
            type: 'select2:select',
            params: {
                data: options
            }
        });
    }
    function setSelectedCategories()
    {
        var categoryNames = "{{implode(',',$visitor->category)}}";
        var allCategories = '{!! ($categories)  !!}';
        var options = [];
        var categoryId = $('#category_id');
        categoryId.html('');
        categoryId.val(null).trigger('change');
        $.each(JSON.parse(allCategories), function(index, value) {
            var selected = false;
            if(jQuery.inArray(value.name, categoryNames.split(',')) !== -1){
                selected = true;
            }
            var option = new Option(value.name, value.name, false, selected);
            categoryId.append(option).trigger('change');
            options.push(value.name);
        });
        // manually trigger the `select2:select` event
        categoryId.trigger({
            type: 'select2:select',
            params: {
                data: options
            }
        });
    }
    function fetchSubCategories(categoryNames) {
        var url = "{{ route('get_sub_categories') }}";
        var selectedSubCategoryNames = "{{ implode(',',$visitor->sub_category) }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                categoryNames: categoryNames,
                selectedSubCategoryNames: selectedSubCategoryNames,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                selectedSubCategoryIds = response.selectedSubCategoryIds;
                var subCategoryId = $('#sub_category_id');
                $('#sub_category_id').html('');
                subCategoryId.val(null).trigger('change');
                $.each(rData, function(index, value) {
                    var selected = false;
                    if(jQuery.inArray(value.id, selectedSubCategoryIds) !== -1){
                        selected = true;
                    }
                    var option = new Option(value.name, value.name, false, selected);
                    subCategoryId.append(option).trigger('change');
                    options.push(value.name);
                });
                // manually trigger the `select2:select` event
                subCategoryId.trigger({
                    type: 'select2:select',
                    params: {
                        data: options
                    }
                });
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#address_country_code').change(function() {
        var countryCode = $(this).val();
        if(countryCode !=='all' && countryCode === 'IN'){
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
            fetchStates('99');
        }else{
            $('.states-dropdown').css('display','none');
            $('.cities-dropdown').css('display','none');
            $('.states-textbox').show();
            $('.cities-textbox').show();
        }
    });
    function fetchStates(countryCode) {
        var oldStateId ="{{$visitor->state}}";
        var url = "{{ route('get_states') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                // countryCode: countryCode,
                countryId: countryCode,
            },
            success: function(response) {
                var options = [];
            var rData = response.data;

            $.each(rData, function(index, value) {
                var selected = '';
                if (value.state == oldStateId) {
                    selected = 'selected'; // Add 'selected' attribute if oldStateId matches
                }
                var selectData = '<option value="' + value.state + '" ' + selected + '>' + value.state + '</option>';
                options.push(selectData);
            });

            $('#state_id').html('<option value="">No State</option>' + options.join(''));
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#state_id').change(function() {
        var stateName = $(this).val();
        fetchCities(stateName);
    });

    // $(document).on('change', '#state_id option', function() {
    //     var stateId = $(this).val();
    //     fetchCities(stateId);
    // });

	$('#city_id').change(function() {
        var city_id = $(this).val();
		$("#othercity_textbox").val('');
		if(city_id == 'Other'){
			$('#other_city').show();
			$("#othercity_textbox").prop('required',true);
		}else{
			$('#other_city').hide();
			$("#othercity_textbox").prop('required',false);
		}
        console.log(city_id);
        fetchArea(city_id);

    });
    $('#area').change(function() {
        let area = $(this).val();
		$("#otherarea_textbox").val('');
		if(area == 'Other'){
			$('#other_area').show();
			$("#otherarea_textbox").prop('required',true);
		}else{
			$('#other_area').hide();
			$("#otherarea_textbox").prop('required',false);
		}
        console.log(area);
        // fetchArea(area);
    });
    function fetchArea(cityName) {
        var url = "{{ route('get_areas') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                city: cityName,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;

                $.each(rData, function(index, value) {
                    var selectData = '';
                    selectData = '<option value="' + value.name + '">' +value.name +
                        '</option>';
                    options.push(selectData);
                });
                $('#area').html('<option value="">No Area</option><option value="Other">Other</option>' +
                    options);
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    function fetchCities(stateName) {
        var oldCityName = "{{$visitor->city}}";
        var url = "{{ route('get_cities') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                stateId: stateName,
            },
            success: function(response) {
                var options = [];
                var rData = response.data;

                $.each(rData, function(index, value) {
                    var selected = '';
                    if (value.district === oldCityName) {
                        selected = 'selected'; // Add 'selected' attribute if city name matches oldCityName
                    }
                    var selectData = '<option value="' + value.district + '" ' + selected + '>' + value.district + '</option>';
                    options.push(selectData);
                });

                $('#city_id').html('<option value="">No City</option><option value="Other">Other</option>' + options.join(''));
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    function validateForm() {
        var result = confirm("are you sure you want to delete ?");
        if (result) {
            return true;
        } else {
            return false;
        }
    }

    function deleteImage(visitorId, imageType) {
        // Confirm the action
        var result = confirm("Are you sure you want to delete this image?");
        if (result) {
            $("#overlay").fadeIn(300);
            // Make an AJAX request to delete the image
            fetch("{{ route('visitor.image.delete') }}", {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    visitor_id: visitorId,
                    type: imageType
                })
            })
            .then(response => response.json())
            .then(data => {
                $("#overlay").fadeOut(300);
                if (data.success) {
                    // If successful, remove the image from the page
                    alert("Image deleted successfully!");
                    if(imageType == 'front_image'){
                        document.getElementById("front_image_" + visitorId).style.display = 'none'; // Hide the image
                    }else{
                        document.getElementById("back_image_" + visitorId).style.display = 'none'; // Hide the image
                    }

                } else {
                    alert("Error: " + data.error);
                }
            })
            .catch(error => {
                $("#overlay").fadeOut(300);
                console.error("Error deleting image:", error);
                alert("An error occurred while deleting the image.");
            });
        }
    }

    function deleteEventImage(eventImageId) {
        // Confirm the action before proceeding
        var result = confirm("Are you sure you want to delete this image?");
        if (result) {
            $("#overlay").fadeIn(300);
            // Send the AJAX request
            fetch("{{ route('event.image.delete') }}", {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    eventimageId: eventImageId
                })
            })
            .then(response => response.json())
            .then(data => {
                $("#overlay").fadeOut(300);
                if (data.success) {
                    // If successful, hide the image
                    alert("Event image deleted successfully!");
                    document.getElementById("image_" + eventImageId).style.display = 'none'; // Hide the image container
                } else {
                    alert("Error: " + data.error);
                }
            })
            .catch(error => {
                $("#overlay").fadeOut(300);
                console.error("Error deleting image:", error);
                alert("An error occurred while deleting the image.");
            });
        }
    }


</script>
@endsection
