@extends('layouts.master')
@section('content')
    <style>
        .card-header {
            color: #fff;
            background-color: #007bff;
        }
        .error{
            color: red;
        }
        .select2-container--default .select2-selection--multiple .select2-selection__choice{
            color: #000;
        }

        #fullpage {
            display: none;
            position: absolute;
            top: 0;
            left: 0;
            width: 81.4vw;
            height: 60vh;
            background-size: contain;
            background-repeat: no-repeat no-repeat;
            background-position: center center;
            background-color: black;
        }


        .item {
            width: 200px;
            text-align: center;
            display: block;
            background-color: transparent;
            border: 1px solid transparent;
            margin-right: 10px;
            margin-bottom: 1px;
            margin-top: 10px;
            float: left;
        }

        img {
            height: auto;
            width: 60px;
            object-fit: scale-down;
        }
        div.dataTables_wrapper div.dataTables_filter {
            text-align: right;
            float: left;
        }
        #overlay {
            position: fixed;
            top: 0;
            z-index: 1070;
            width: 100%;
            height: 100%;
            display: none;
            background: rgba(0, 0, 0, 0.6);
        }

        .cv-spinner {
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 4px #ddd solid;
            border-top: 4px #2e93e6 solid;
            border-radius: 50%;
            animation: sp-anime 0.8s infinite linear;
        }
        .select2-container--default .select2-selection--single {
            height: calc(2.25rem + 2px) !important;
        }
    </style>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Client List</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">Client</li>
                        </ol>
                    </div>
                    <div class="container-fluid">
                        <div class="card-body">
                            <form method="get" id="myform" name="myform" action="{{ route('client.list') }}"
                                enctype="multipart/form-data">
                                <input type="hidden" value="" name="type" id="formType">
                                <div class="form-group row">
                                    <div class="col-2">
                                        <label for="">Select Event/Folder</label>
                                        <select class="form-control custom-select select2-multiple-event" data-placeholder="Select Event/Folder" name="event_id[]" multiple id="event_id">
                                            {{-- <option value="all" @if ($event_id == 'all') selected @endif>All
                                            </option> --}}
                                            @foreach ($events as $val)
                                                <option value="{{ $val->id }}"
                                                    @selected(in_array($val->id,($event_id ?? [])))>{{ $val->event_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @if(Auth::user()->type != "user")
                                    <div class="col-2">
                                        <label for="">Select Team Member</label>
                                        <select class="form-control custom-select select2-multiple-customer" data-placeholder="Select Team Member" name="CustomerID[]" multiple id="CustomerID">
                                            {{-- <option value="all" @if ($CustomerID == 'all') selected @endif>All
                                            </option> --}}
                                            @foreach ($users as $username)
                                                @if($username->is_delete == 'true')
                                                    <option value="{{ $username->CustomerID }}" @selected(in_array($username->CustomerID,($CustomerID ?? []))) style="color:red;"> {{ $username->CustomerName }} (Blocked)</option>
                                                @else
                                                    <option value="{{ $username->CustomerID }}" @selected(in_array($username->CustomerID,($CustomerID ?? [])))> {{ $username->CustomerName }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                    @endif

                            @sessionContactField('source_of_lead')

                                    <div class="col-2">
                                        <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Select Source of Lead' : $contactFieldValue['label'])</label>
                                        <select class="form-control custom-select select2-multiple-sourceoflead" data-placeholder="@defaultValue(empty($contactFieldValue['label']) ? 'Select Source of Lead' : $contactFieldValue['label'])" name="sourceoflead[]" multiple id="sourceoflead">
                                            {{-- <option value="all" @if ($sourceoflead == 'all') selected @endif>All
                                            </option> --}}
                                            @foreach ($sourceofleadList as $val)
                                                <option value="{{ $val->name }}"
                                                    @selected(in_array($val->name,($sourceoflead ?? [])))>{{ $val->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @endsessionContactField
                            @sessionContactField('category')

                                    <div class="col-2">
                                        <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Select Category' : $contactFieldValue['label'])</label>
                                        <select class="form-control custom-select select2-multiple-category" data-placeholder="@defaultValue(empty($contactFieldValue['label']) ? 'Select Category' : $contactFieldValue['label'])" name="category_id[]" multiple id="category_id">
                                                {{-- <option value="all" @if ($category_id == 'all') selected @endif>All
                                                </option> --}}
                                            @foreach ($categories as $val)
                                                <option value="{{ $val->id }}"
                                                    @selected(in_array($val->id,($category_id ?? [])))>{{ $val->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @endsessionContactField
                            @sessionContactField('sub_category')

                                    <div class="col-2">
                                        <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Select Sub Category' : $contactFieldValue['label'])</label>
                                        <select class="form-control custom-select select2-multiple-subcategory" data-placeholder="@defaultValue(empty($contactFieldValue['label']) ? 'Select Sub Category' : $contactFieldValue['label'])" name="sub_category_id[]" multiple id="sub_category_id">
                                            {{-- <option value="all" @if ($sub_category_id == 'all') selected @endif>All
                                            </option> --}}
                                        </select>
                                    </div>
                                    @endsessionContactField
                                    @sessionContactField('action')

                                    <div class="col-2">
                                        <label for="action">@defaultValue(empty($contactFieldValue['label']) ? 'Action' : $contactFieldValue['label'])</label>
                                        <select class="form-control custom-select select2-multiple-action" multiple data-placeholder="@defaultValue(empty($contactFieldValue['label']) ? 'Select Action' : $contactFieldValue['label'])" name="action[]" id="action" style="width: 100%;">
                                            {{-- <option value="all">All</option> --}}
                                            @foreach($actionList as $a)
                                                <option value="{{ $a->title }}" @selected(in_array($a?->title,($action ?? [])))>
                                                    {{ $a->title }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @endsessionContactField
                                    <div class="col-2">
                                        <label for="">Select Start Date</label>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            value="{{ $start_date }}">
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select End Date</label>
                                        <input type="date" name="end_date" id="end_date" class="form-control"
                                            value="{{ $end_date }}">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-2">
                                        <label for="">Region</label>
                                        <select class="form-control custom-select select2-multiple-region" data-placeholder="Select Region" name="region[]" multiple id="region">
                                            {{-- <option value="all" @if ($region == 'all') selected @endif>All
                                            </option> --}}
                                            @if ($regions)
                                                @foreach ($regions as $val)
                                                    <option value="{{ $val->id }}" @selected(in_array($val?->id,($region ?? [])))
                                                        >
                                                        {{ $val->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Is International</label>
                                        <select class="form-control custom-select" name="is_international"
                                            id="is_international">
                                            <option value="all" @selected($is_international == 'all')>All
                                            </option>
                                            <option value="false" @selected($is_international == 'false')>India
                                            </option>
                                            <option value="true" @selected($is_international == 'true')>
                                                International</option>
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select Country</label>
                                        <select class="form-control custom-select select2-multiple-country" multiple data-placeholder="Select Country" name="country_id[]" id="country_id">
                                            {{-- <option value="all" @if ($country_id == 'all') selected @endif>All
                                            </option> --}}
                                            </option>
                                        </select>
                                    </div>
                                    @sessionContactField('state')

                                    <div class="col-2">
                                        <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Select State' : $contactFieldValue['label'])</label>
                                        <select class="form-control custom-select select2-multiple-state" multiple data-placeholder="@defaultValue(empty($contactFieldValue['label']) ? 'Select State' : $contactFieldValue['label'])" name="state_id[]" id="state_id">
                                            {{-- <option value="all" @if ($state_id == 'all') selected @endif>All
                                            </option>
                                            --}}
                                        </select>
                                    </div>
                                    @endsessionContactField
                                    @sessionContactField('city')

                                    <div class="col-2">
                                        <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Select City' : $contactFieldValue['label'])</label>
                                        <select class="form-control custom-select select2-multiple-city" multiple data-placeholder="@defaultValue(empty($contactFieldValue['label']) ? 'Select City' : $contactFieldValue['label'])" name="city_id[]" id="city_id">
                                            {{-- <option value="all" @if ($city_id == 'all') selected @endif>All
                                            </option> --}}
                                        </select>
                                    </div>
                                    @endsessionContactField
                                    @sessionContactField('area')

                                    <div class="col-2">
                                        <label for="">@defaultValue(empty($contactFieldValue['label']) ? 'Select Area' : $contactFieldValue['label'])</label>
                                        <select class="form-control custom-select select2-multiple-area" multiple data-placeholder="@defaultValue(empty($contactFieldValue['label']) ? 'Select Area' : $contactFieldValue['label'])" name="area[]" id="area">
                                            {{--<option value="all" @if ($area == 'all') selected @endif>All
                                            </option>--}}
                                        </select>
                                    </div>
                                    @endsessionContactField

                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-2 bg-gradient-info btn-1 mr-2" style="color:white;">Submit</button>
                                    <a href="{{ route('client.dashboard') }}" target="_blank" class="btn btn-2 bg-gradient-info btn-1" style="color:white;" >Dashboard</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Client</h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                        title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>

                                </div>
                            </div>
                            <div class="card-body">
                                <form method="post" name="frm_no_kids" id="frm_no_kids" class="getstarted"
                                    action="{{ route('client.exportclientvisitorlist') }}">
                                    @csrf
                                    @if(request()->get('event_id'))
                                    @foreach(request()->get('event_id') as $val)
                                        <input type="hidden" id="event_id" name="event_id[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="event_id" name="event_id" value="">
                                    @endif

                                                                       {{-- CustomerID --}}
                                    @if(request()->get('CustomerID'))
                                    @foreach(request()->get('CustomerID') as $val)
                                        <input type="hidden" id="CustomerID" name="CustomerID[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="CustomerID" name="CustomerID" value="">
                                    @endif

                                    {{-- sourceoflead --}}
                                    @if(request()->get('sourceoflead'))
                                    @foreach(request()->get('sourceoflead') as $val)
                                        <input type="hidden" id="sourceofleadId" name="sourceoflead[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="sourceofleadId" name="sourceoflead" value="">
                                    @endif

                                    {{-- category_id --}}
                                    @if(request()->get('category_id'))
                                    @foreach(request()->get('category_id') as $val)
                                        <input type="hidden" id="categoryId" name="category_id[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="categoryId" name="category_id" value="">
                                    @endif

                                    {{-- sub_category_id --}}
                                    @if(request()->get('sub_category_id'))
                                    @foreach(request()->get('sub_category_id') as $val)
                                        <input type="hidden" id="subCategoryId" name="sub_category_id[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="subCategoryId" name="sub_category_id" value="">
                                    @endif

                                    {{-- state_id --}}
                                    @if(request()->get('state_id'))
                                    @foreach(request()->get('state_id') as $val)
                                        <input type="hidden" id="stateId" name="state_id[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="stateId" name="state_id" value="">
                                    @endif

                                    {{-- city_id --}}
                                    @if(request()->get('city_id'))
                                    @foreach(request()->get('city_id') as $val)
                                        <input type="hidden" id="cityId" name="city_id[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="cityId" name="city_id" value="">
                                    @endif

                                    {{-- area --}}
                                    @if(request()->get('area'))
                                    @foreach(request()->get('area') as $val)
                                        <input type="hidden" id="areaId" name="area[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="areaId" name="area" value="">
                                    @endif
                                    @if(request()->get('action'))
                                    @foreach(request()->get('action') as $val)
                                        <input type="hidden" id="actionId" name="action[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="actionId" name="action" value="">
                                    @endif

                                    {{-- is_international --}}
                                    {{-- @if(request()->get('is_international'))
                                    @foreach(request()->get('is_international') as $val)
                                        <input type="hidden" id="isInternational" name="is_international[]" value="{{ $val }}">
                                    @endforeach
                                    @else --}}
                                    <input type="hidden" id="isInternational" name="is_international" value="{{request()->get('is_international')}}">
                                    {{-- @endif --}}

                                    {{-- country_id --}}
                                    @if(request()->get('country_id'))
                                    @foreach(request()->get('country_id') as $val)
                                        <input type="hidden" id="countryId" name="country_id[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="countryId" name="country_id" value="">
                                    @endif

                                    {{-- region --}}
                                    @if(request()->get('region'))
                                    @foreach(request()->get('region') as $val)
                                        <input type="hidden" id="region" name="region[]" value="{{ $val }}">
                                    @endforeach
                                    @else
                                    <input type="hidden" id="region" name="region" value="">
                                    @endif

                                    <input type="hidden" id="startDate" name="start_date"
                                        value="@if (isset($_GET['start_date'])) {{ $_GET['start_date'] }} @endif">
                                    <input type="hidden" id="endDate" name="end_date"
                                        value="@if (isset($_GET['end_date'])) {{ $_GET['end_date'] }} @endif">

                                    @if(request()->get('product'))

                                    @foreach(request()->get('product') as $p)
                                        <input type="hidden" id="productid" name="product[]" value="{{ $p }}">
                                    @endforeach
                                    @else
                                        <input type="hidden" id="productid" name="product" value="">
                                    @endif




                                    <input type="submit" id="submit_export" name="submit_export" style="display:none;">
                                    <button class="btn btn-2 bg-gradient-info btn-1" data-toggle="tooltip"
                                        data-placement="left" title="Export" style="color:white">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Export
                                    </button>
                                </form>

                                <div class="row">
                                    <div class="col-12 mt-4 table-responsive">
                                        {{ $dataTable->table() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>





    <div id="overlay">
        <div class="cv-spinner">
            <span class="spinner"></span>
        </div>
    </div>

    @push('scripts')
        {!! $dataTable->scripts() !!}
        <script>

        </script>
    @endpush

    <script>


        function checkExportFilter(elm) {
            var type = elm.id;
            var name = $('#name').val();
            var event_name = $('#event_name').val();
            var CustomerName = $('#CustomerName').val();
            var mobile_no = $('#mobile_no').val();
            var email = $('#email').val();
            var action = $('#action').val();

            $('#data').val([name, event_name, CustomerName, mobile_no, email, action]);
            $('#submit_export').click();
        }



        function selectEmailType(id) {
            $('#visitor_id').val(id);
            $('#sendEmailModal').modal('show');
        }

        function editEmail(id) {
            $('#modalEmail').val($('.btn-' + id).data('email'));
            $('#modalId').val(id);
            $('#editEmailModal').modal('show');
        }



        {{--// $(document).ready(function() {
        //     var categoryId = "{{ $category_id }}";
        //     if (categoryId !== 'all') {
        //         fetchSubCategories(categoryId);
        //     }
        //     var region = "{{ $region }}";
        //     if (region !== 'all') {
        //         $('#is_international').attr('disabled', true);
        //         $('#country_id').attr('disabled', true);
        //         $('#state_id').attr('disabled', true);
        //         $('#city_id').attr('disabled', true);
        //         $('#area').attr('disabled', true);
        //     }
        //     var isInternational = "{{ $is_international }}";
        //     if (isInternational !== 'all' && isInternational !== 'false') {
        //         fetchCountries();
        //     } else if (isInternational !== 'all' && isInternational === 'false') {
        //         var options = [];
        //         var selectedValue = 'selected';
        //         var valueId = 99;
        //         var valueName = "India";
        //         selectData = '<option value="' + valueId + '" ' + selectedValue + ' >' + valueName +
        //             '</option>';
        //         options.push(selectData);
        //         $('#country_id').html('<option value="all">All</option>' +
        //             options);
        //         $('#country_id').attr('disabled', true);
        //         fetchStates('99');
        //     }
        //     var countryId = "{{ $country_id }}";
        //     console.log('countryId_2'+countryId)
        //     if (countryId !== 'all') {
        //         fetchStates(countryId);
        //     }
        //     var stateId = "{{ $state_id }}";
        //     if (stateId !== 'all') {
        //         fetchCities(stateId);
        //     }
        //     var cityId = "{{ $city_id }}";
        //     if (cityId !== 'all') {
        //         fetchArea(cityId);
        //     }
        //     console.log($('meta[name="csrf-token"]').attr('content'));
        //     $('.token').val($('meta[name="csrf-token"]').attr('content'));
        // });--}}

        function showImage(elm) {
            var id = $(elm).attr('data-id');
            $.ajax({
                url: "{{ url('ajax/get_image') }}",
                type: "GET",
                data: {
                    id: id,
                },
                success: function(response) {
                    if (response) {
                        $("#showImage").html('');

                        $.each(response['data'], function(i, item) {
                            var imageUrl = item['front_image'];
                            var static_image = '../no-image.png';
                            var images = imageUrl.substring(imageUrl.indexOf('/frenzincrm_api'));

                            var html = '<tr>' + '<td>';

                            if (imageUrl && imageUrl.trim() !== '') {
                                html += '<img src="' + images +
                                    '" alt="" class="img" style="height: 240px; width: 450px">';
                            } else {
                                html += '<img src="' + static_image +
                                    '" alt="" class="img" style="height: 240px; width: 450px">';
                            }

                            html += '</td>' +
                                '</tr>';
                            // html =  `<tr>
                        //             <td>
                        //                 <img  src="` + imageUrl + `" alt=""  class="img" style="height: 240px;width:450px">
                        //             </td>
                        //         </tr>`;
                            $("#showImage").append(html);
                            $("#modalimageshow").modal('show');
                        });
                    } else {
                        alert('no data found!')
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        function showfilewithimage(elm) {
            var mobile_number = $(elm).attr('data-mobile_number');
            $.ajax({
                url: "{{ url('ajax/get_productlist') }}",
                type: "GET",
                data: {
                    mobile_number: mobile_number,
                },
                success: function(response) {
                    if (response) {
                        $("#showfilewithimage").html('');
                        $.each(response['data'], function(i, item) {

                            var imageName = item.image.split('/').pop();
                            var imageNameX = item.image.split('.').pop();

                            var html = `<tr>
                        <td><strong>${item['id']}</strong></td>
                        <td>
                            <a href="${item['image']}" target="_blank" style="text-decoration: none;">
                                ${imageNameX === 'pdf' ? `<i class="far fa-file-pdf pdf-icon fa-2x" style="color:red;"></i> ${imageName}` : `<img src="${item['image']}" alt="" class="img">`}
                            </a>
                        </td>
                        <td>${item['description']}</td>
                        <td>
                            <a href="https://wa.me/${mobile_number}?text=(${item['image']})" target="_blank">
                                <i class="fab fa-whatsapp" style="font-size: 31px; color: #25D366; margin-left: 37px;"></i>
                            </a>
                        </td>
                    </tr>`;
                            $("#showfilewithimage").append(html);
                            $("#modalimagefile").modal('show');
                        });
                    } else {
                        alert('no data found!')
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        function deletePopupvisitor(elm) {
            let id = $(elm).data('id');
            let url = $(elm).data('url');
            swal({
                title: 'Are you sure!',
                icon: 'error',
                dangerMode: true,
                buttons: true,
                confirm: "Confirm",
            }).then(function(isConfirm) {
                if (isConfirm === true) {
                    $.ajax({
                        type: 'GET',
                        url: url,
                        dataType: 'json',
                        success: function(data) {
                            location.reload(true);
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }
            });
        }
{{--
    //     $('#category_id').change(function() {
    //         var id = $(this).val();
    //         if (id !== 'all') {
    //             fetchSubCategories(id);
    //         }
    //     });

    //     function fetchSubCategories(id) {
    //         var url = "{{ route('get_sub_categories') }}";
    //         $.ajax({
    //             url: url,
    //             type: "GET",
    //             data: {
    //                 category_id: id,
    //             },
    //             success: function(response) {
    //                 var options = [];
    //                 var rData = [];
    //                 rData = response.data;
    //                 $.each(rData, function(index, value) {
    //                     var selectData = '';
    //                     var subCategory = "{{ $sub_category_id }}";
    //                     var selectedValue = subCategory == value.id ? 'selected' : '';
    //                     selectData = '<option value="' + value.id + '" ' + selectedValue + ' >' + value
    //                         .name +
    //                         '</option>';
    //                     options.push(selectData);
    //                 });
    //                 $('#sub_category_id').html('<option value="all">All</option>' +
    //                     options);
    //             },
    //             error: function(error) {
    //                 console.log(error);
    //             }
    //         });
    //     }

    //     $('#is_international').change(function() {
    //         var isInternational = $(this).val();
    //         $('#country_id').html('<option value="all">All</option>');
    //         $('#state_id').html('<option value="all">All</option>');
    //         $('#city_id').html('<option value="all">All</option>');
    //         $('#country_id').attr('disabled', false);
    //         if (isInternational !== 'all' && isInternational !== 'false') {
    //             fetchCountries();
    //         } else if (isInternational !== 'all' && isInternational === 'false') {
    //             var options = [];
    //             var selectedValue = 'selected';
    //             var valueId = 99;
    //             var valueName = "India";
    //             selectData = '<option value="' + valueId + '" ' + selectedValue + ' >' + valueName +
    //                 '</option>';
    //             options.push(selectData);
    //             $('#country_id').html('<option value="all">All</option>' +
    //                 options);
    //             $('#country_id').attr('disabled', true);
    //             fetchStates('99');
    //             // fetchStates('99');
    //         }
    //     });

    //     function fetchCountries() {
    //         var url = "{{ route('get_countries') }}";
    //         $.ajax({
    //             url: url,
    //             type: "GET",
    //             success: function(response) {
    //                 var options = [];
    //                 var rData = [];
    //                 rData = response.data;
    //                 $.each(rData, function(index, value) {
    //                     var selectData = '';
    //                     var country = "{{ $country_id }}";
    //                     var selectedValue = country == value.name ? 'selected' : '';
    //                     selectData = '<option value="' + value.name + '" ' + selectedValue + ' >' + value
    //                         .name +
    //                         '</option>';
    //                     options.push(selectData);
    //                 });
    //                 $('#country_id').html('<option value="all">All</option>' +
    //                     options);
    //             },
    //             error: function(error) {
    //                 console.log(error);
    //             }
    //         });
    //     }

    //     $('#country_id').change(function() {
    //         var countryId = $(this).val();
    //         if (countryId !== 'all') {
    //             fetchStates(countryId);
    //         }
    //     });

    //     function fetchStates(countryId) {
    //         var url = "{{ route('get_states') }}";
    //         $.ajax({
    //             url: url,
    //             type: "GET",
    //             data: {
    //                 countryId: countryId,
    //             },
    //             success: function(response) {
    //                 var options = [];
    //                 var rData = [];
    //                 rData = response.data;
    //                 $.each(rData, function(index, value) {
    //                 console.log('value__'+value);
    //                     var selectData = '';
    //                     var state = "{{ $state_id }}";
    //                     var selectedValue = state == value.state ? 'selected' : '';
    //                     selectData = '<option value="' + value.state + '" ' + selectedValue + ' >' + value
    //                         .state +
    //                         '</option>';
    //                     options.push(selectData);
    //                 });
    //                 $('#state_id').html('<option value="all">All</option>' +
    //                     options);
    //             },
    //             error: function(error) {
    //                 console.log(error);
    //             }
    //         });
    //     }



    //     $('#state_id').change(function() {
    //         var stateId = $(this).val();
    //         var selectedOption = $(this).find('option:selected');
    //         var countryUid = selectedOption.data('country_id');
    //         if (stateId !== 'all') {
    //             // alert(selectedText);
    //             fetchCities(stateId,countryUid);
    //         }
    //     });

    //     function fetchCities(stateId) {
    //         var url = "{{ route('get_cities') }}";
    //         $.ajax({
    //             url: url,
    //             type: "GET",
    //             data: {
    //                 stateId: stateId,
    //             },
    //             success: function(response) {
    //                 var options = [];
    //                 var rData = [];
    //                 rData = response.data;
    //                 $.each(rData, function(index, value) {
    //                     var selectData = '';
    //                     var city = "{{ $city_id }}";
    //                     var selectedValue = city == value.district ? 'selected' : '';
    //                     selectData = '<option value="' + value.district + '" ' + selectedValue + ' >' + value
    //                         .district +
    //                         '</option>';
    //                     options.push(selectData);
    //                 });
    //                 $('#city_id').html('<option value="all">All</option>' +
    //                     options);
    //             },
    //             error: function(error) {
    //                 console.log(error);
    //             }
    //         });
    //     }
    //     $('#city_id').change(function() {
    //         var cityId = $(this).val();
    //         fetchArea(cityId);

    //     });
    //     function fetchArea(cityName) {
    //     var url = "{{ route('get_areas') }}";
    //     $.ajax({
    //         url: url,
    //         type: "GET",
    //         data: {
    //             city: cityName,
    //         },
    //         success: function(response) {
    //             var options = [];
    //             var rData = [];
    //             rData = response.data;

    //             $.each(rData, function(index, value) {
    //                 let selectData = '';
    //                 let area = "{{ $area }}";
    //                 let selectedValue = area == value.name ? 'selected' : '';
    //                 selectData = '<option value="' + value.name + '" ' + selectedValue + ' >' + value.name +
    //                     '</option>';
    //                 options.push(selectData);
    //             });
    //             $('#area').html('<option value="all">All</option>' +
    //                 options);
    //         },
    //         error: function(error) {
    //             console.log(error);
    //         }
    //     });
    // }



    //     $('#region').change(function() {
    //         var region = $(this).val();
    //         if (region !== 'all') {
    //             $('#is_international').attr('disabled', true);
    //             $('#country_id').attr('disabled', true);
    //             $('#state_id').attr('disabled', true);
    //             $('#city_id').attr('disabled', true);
    //             $('#area').attr('disabled', true);
    //         } else {
    //             $('#is_international').attr('disabled', false);
    //             $('#country_id').attr('disabled', false);
    //             $('#state_id').attr('disabled', false);
    //             $('#city_id').attr('disabled', false);
    //             $('#area').attr('disabled', false);
    //         }
    //     });
    --}}
    let subCategorySelected = @json($sub_category_id ?? []);

function fetchSubCategories(id) {
    var url = "{{ route('get_sub_categories_bulk') }}";
    $.ajax({
        url: url,
        type: "GET",
        data: {
            category_id: id,
        },
        success: function(response) {
            var options = [];
            var rData = [];
            rData = response.data;
            // console.log('rData__'+rData);
            $('#sub_category_id').html('');
            $.each(rData, function(index, value) {
                let selectData = '';
                console.log('subCategory__',subCategorySelected,value);
                options.push({
                    id: value.id,
                    text: value.name,
                    selected: subCategorySelected.includes((value.id).toString()),
                });
            });
            $('#sub_category_id').val(null).trigger('select2:change');
            $('#sub_category_id').select2('destroy');
            $('#sub_category_id').select2({
                data: options,
                placeholder: $("#sub_category_id").data('placeholder'),
            }).trigger('select2:change');
            subCategorySelected = [];
        },
        error: function(error) {
            console.log(error);
        }
    });
}


let countrySelected = @json($country_id);

function clearAndInitSelect2(id,data = []){
    $(id).html('');
    $(id).val(null).trigger('select2:change');
    $(id).select2('destroy');
    $(id).select2({
        data: data,
        placeholder: $(id).data('placeholder'),
    });
}
function fetchCountries() {
    var url = "{{ route('get_countries') }}";
    $.ajax({
        url: url,
        type: "GET",
        success: function(response) {
            var options = [];
            var rData = [];
            rData = response.data;
            $.each(rData, function(index, value) {
                var selectData = '';
                var selectedValue = countrySelected.includes(value.name);
                options.push({
                    id: value.name,
                    text: value.name,
                    selected: selectedValue,
                });
            });
            clearAndInitSelect2('#country_id',options);
            countrySelected = [];
        },
        error: function(error) {
            console.log(error);
        }
    });
}

let stateSelected = @json($state_id);
let stateCount = 1;
function fetchStates(countryId,isInternational = false,firstTime = true) {
    var url = "{{ route('get_states_bulk') }}";
    $.ajax({
        url: url,
        type: "GET",
        data: {
            countryId: countryId,
        },
        success: function(response) {
            var options = [];
            var rData = [];
            rData = response.data;

            if(!firstTime){
                stateSelected = $("#state_id").val();
                console.log('stateSelected__',stateSelected);
            }

            $.each(rData, function(index, value) {
                var selectData = '';
                options.push({
                    id: value.state,
                    text: value.state,
                    selected: stateSelected.includes((value.state).toString()),
                });
            });
            clearAndInitSelect2('#state_id',options);
            if(stateCount == 2){
                stateSelected = [];
            }
            stateCount++;
            console.log('stateSelected__',stateSelected,isInternational);

        },
        error: function(error) {
            console.log(error);
        }
    });
}




let citySelected = @json($city_id);
function fetchCities(stateId,firstTime = true) {
    var url = "{{ route('get_cities_bulk') }}";
    $.ajax({
        url: url,
        type: "GET",
        data: {
            stateId: stateId,
        },
        success: function(response) {
            var options = [];
            var rData = [];
            rData = response.data;
            // console.log('fetchCities__'+rData);
            if(!firstTime){
                citySelected = $("#city_id").val();
                console.log('citySelected__',citySelected);
            }
            $.each(rData, function(index, value) {
                var selectData = '';
                var selectedValue = citySelected.includes(value.district);
                options.push({
                    id: value.district,
                    text: value.district,
                    selected: selectedValue,
                });
            });
            clearAndInitSelect2('#city_id',options);
            citySelected = [];
        },
        error: function(error) {
            console.log(error);
        }
    });
}

let areaSelected = @json($area);
function fetchArea(cityName,firstTime = true) {
var url = "{{ route('get_areas_bulk') }}";
$.ajax({
    url: url,
    type: "GET",
    data: {
        city: cityName,
    },
    success: function(response) {
        var options = [];
        var rData = [];
        rData = response.data;
        if(!firstTime){
            areaSelected = $("#area").val();
            console.log('areaSelected__',areaSelected);
        }
        $.each(rData, function(index, value) {
            let selectData = '';
            let selectedValue = areaSelected.includes(value.name);
            options.push({
                id: value.name,
                text: value.name,
                selected: selectedValue,
            });
        });
        clearAndInitSelect2('#area',options);
        areaSelected = [];
    },
    error: function(error) {
        console.log(error);
    }
});
}


function checkRegion(region) {
    console.log('region__',region);
    if (region.length > 0) {
        $('#is_international').attr('disabled', true);
        $('#country_id').attr('disabled', true);
        $('#state_id').attr('disabled', true);
        $('#city_id').attr('disabled', true);
        $('#area').attr('disabled', true);
        // clearAndInitSelect2("#country_id");
        // clearAndInitSelect2("#state_id");
        // clearAndInitSelect2("#city_id");
        // clearAndInitSelect2("#area");

    } else {
        $('#is_international').attr('disabled', false);
        $('#country_id').attr('disabled', false);
        $('#state_id').attr('disabled', false);
        $('#city_id').attr('disabled', false);
        $('#area').attr('disabled', false);
    }
}

function changeIsInternational(isInternational) {
    console.log('isInternational__',isInternational);
    // $('#country_id').html('<option value="all">All</option>');
    // $('#state_id').html('<option value="all">All</option>');
    // $('#city_id').html('<option value="all">All</option>');
    $('#country_id').attr('disabled', false);
    clearAndInitSelect2("#country_id");
        clearAndInitSelect2("#state_id");
        clearAndInitSelect2("#city_id");
        clearAndInitSelect2("#area");
    if (isInternational !== 'all' && isInternational !== 'false') {
        fetchCountries();
    } else if (isInternational !== 'all' && isInternational === 'false') {
        var options = [];
        var selectedValue = 'selected';
        var valueId = 99;
        var valueName = "India";
        options.push({
            id: valueName,
            text: valueName,
            selected: true,
        });
        $('#country_id').val(null).trigger('select2:change');
        $('#country_id').select2('destroy');
        $('#country_id').select2({
            data: options,
            placeholder: $("#country_id").data('placeholder'),
        }).trigger('select2:change');
        fetchStates([valueName],true);
    }
}
$(document).ready(function() {
        let initSelect2Classes = ['select2-multiple-event','select2-multiple-action', 'select2-multiple-subcategory', 'select2-multiple-category', 'select2-multiple-sourceoflead', 'select2-multiple-customer', 'select2-multiple-region', 'select2-multiple-country', 'select2-multiple-state', 'select2-multiple-city', 'select2-multiple-area'];
            $(initSelect2Classes).each(function(index, value) {
                $(`.${value}`).select2({
                    placeholder: $(`.${value}`).data('placeholder'),
                });
            });
        var categoryId = @json($category_id ?? []);
            if (categoryId.length > 0) {
                fetchSubCategories(categoryId);
            }

            var isInternational = @json($is_international);
            changeIsInternational(isInternational);

            var countryId = @json($country_id);
            if (countryId.length > 0) {
                fetchStates(countryId);
            }
            var stateId = @json($state_id);
            if (stateId.length > 0) {
                fetchCities(stateId);
            }
            var cityId = @json($city_id);
            if (cityId.length > 0) {
                fetchArea(cityId);
            }
            console.log($('meta[name="csrf-token"]').attr('content'));
            $('.token').val($('meta[name="csrf-token"]').attr('content'));

        $('#category_id').change(function() {
            var id = $(this).val();
            if (id.length > 0) {
                fetchSubCategories(id);
            }
        });
        $('#city_id').change(function() {
            var cityId = $(this).val();
            fetchArea(cityId,true);
            clearAndInitSelect2("#area");

        });
        $('#is_international').change(function() {
            var isInternational = $(this).val();
            changeIsInternational(isInternational);
        });
        $('#region').change(function() {
            var region = $(this).val();
            checkRegion(region);
        });

        $('#country_id').change(function() {
            var countryId = $(this).val();
            if (countryId.length > 0) {
                fetchStates(countryId,false,false);

            }
            clearAndInitSelect2("#state_id");
            clearAndInitSelect2("#city_id");
            clearAndInitSelect2("#area");
        });
        $('#state_id').change(function() {
            var stateId = $(this).val();
            var selectedOption = $(this).find('option:selected');
            var countryUid = selectedOption.data('country_id');
            if (stateId.length > 0) {
                // alert(selectedText);
                fetchCities(stateId,false);
            }
            clearAndInitSelect2("#city_id");
            clearAndInitSelect2("#area");
        });
        checkRegion(@json($region ?? []));
      });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>


    <script>
        var selectedData = [];

        function getid(elm) {

            var id = $(elm).attr('data-id');
            if (!selectedData.includes(id)) {
                selectedData.push(id);
            }
            var event_id = $(elm).attr('data-event_id');
        }
        $(document).ready(function() {
            var table = $('#showevetlist').DataTable({
                paging: true,
                searching: true
            });

            $('#move-button').click(function() {
                if (selectedData.length > 0) {
                    var jsonData = JSON.stringify(selectedData);
                    $.ajax({
                        url: "{{ url('ajax/get_eventlist') }}",
                        type: "GET",
                        data: {
                            id: jsonData,
                        },
                        success: function(response) {
                            if (response && response.data.length > 0) {
                                // Clear existing table data
                                table.clear();

                                // Add new data to the table
                                response.data.forEach(function(item) {
                                    table.row.add([
                                        item.event_name,
                                        '<input type="radio" name="eventid" value="' +
                                        item.id + '" required>'
                                    ]).draw();
                                });

                                // Show the modal
                                $('#modalvisitor_id').val(jsonData);
                                $("#modalieventlist").modal('show');
                            } else {
                                alert('No data found!');
                            }
                        },
                        error: function(error) {
                            console.log(error);
                        }
                    });
                }
            });
        });

        function show_visitor(elm) {
            var id = $(elm).attr('data-id');
            var email = $(elm).attr('data-email');
            var mobile_no = $(elm).attr('data-mobile_no');

            $.ajax({
                url: "{{ url('ajax/get_visitorlist_id') }}",
                type: "GET",
                data: {
                    id: id,
                    email: email,
                    mobile_no: mobile_no,
                },
                success: function(response) {
                    if (response) {
                        $("#show_visitor").html('');
                        $.each(response['data'], function(i, item) {
                            var visitedDate = moment(item['visited_date'], 'YYYY-MM-DD HH:mm:ss');
                            var detailUrl = "{{ route('visitor.detail', ['id' => '__ID__']) }}".replace('__ID__', item['id']);
                            if (visitedDate.isValid()) {
                                var formattedVisitedDate = visitedDate.format('D/M/Y');
                            } else {
                                var formattedVisitedDate = '';
                            }

                            var deleteUrl = "{{ route('visitor.Multiple_Entries_destroy', ':id') }}";
                            deleteUrl = deleteUrl.replace(':id', item['id']);

                            var html = `<tr>
                            <td> <a href="${detailUrl}"">
                                  ${item['id']}
                                </a></td>
                            <td>${formattedVisitedDate}</td>
                            <td>${item['event_name']}</td>
                            <td>${item['CustomerName']}</td>
                            <td>${item['mobile_no'] || '-'}</td>
                            <td>${item['email'] || '-'}</td>
                            <td>

                                <a data-toggle="modal" data-target="#deletePopup" data-url="${deleteUrl}"  data-id="${item['id']}"
                                    onclick="deletePopupvisitor_Multiple(this)">
                                    <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete " style="margin-top: 10px;margin-left: 9px;">
                                        <i class="fas fa-trash" aria-hidden="true"></i>
                                    </button>
                                </a>
                            </td>
                        </tr>`;
                            $("#show_visitor").append(html);
                            $("#show_visitordata").modal('show');
                        });
                    } else {
                        alert('no data found!')
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        function deletePopupvisitor_Multiple(elm) {
            let id = $(elm).data('id');
            let url = $(elm).data('url');
            swal({
                title: 'Are you sure!',
                icon: 'error',
                dangerMode: true,
                buttons: true,
                confirm: "Confirm",
            }).then(function(isConfirm) {
                if (isConfirm === true) {
                    $.ajax({
                        type: 'GET',
                        url: url,
                        dataType: 'json',
                        success: function(data) {
                            location.reload(true);
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }
            });
        }


        // Visit data Modal
        $(document).on("click", ".sendEmail", function() {
            // alert('dsfsdf');
            $('.sendEmail').prop('disabled', true);
            const modal = $(this).data('modal')
            const Url = $(this).data('url')
            const event_id = $(this).data('event_id')
            const visitor_id = $(this).data('visitor_id')
            const visit_data_id = $(this).data('visit_data_id')

            if ((Url !== undefined && Url !== null) && (modal !== undefined && modal !== null)) {

                $.ajax({
                    type: "GET",
                    url: Url,
                    dataType: "json",
                    cache: false,
                    data: {
                        event_id: event_id,
                        visitor_id: visitor_id,
                        visit_data_id: visit_data_id
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        $('.sendEmail').prop('disabled', false);
                        $('#ajaxModalHtml').html(response.modalHtml)
                        $('#' + modal).modal('show')
                    },
                    error: function(error) {
                        $('.sendEmail').prop('disabled', false);
                        console.log('something went wrong');
                    }
                });
            }
        });
        // Visit data Modal End

        <?php
            if(session('dataInvalid')){
        ?>
            $('#exampleModal').modal('show');
        <?php

            }
        ?>

        $('.importbtndata').click(function() {
            $('#importbtndata').html('');
        });
        <?php
            if(session('dataImported')){
            ?>
                $('#dataimportsuccess').modal('show');
            <?php

            }
        ?>
    $(document).ready(function() {
        $('#product_data').select2({
            placeholder: "Select a product...",
        });
    });
    </script>


@endsection
