<div class="modal fade bd-example-modal-lg" id="addVisitModal" tabindex="-1" role="dialog"
    aria-labelledby="addVisitModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addVisitModalLabel">{{$title}} Visit Data</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form data-url="{{ $form_url }}" id="addVisitDataForm" method="post" enctype='multipart/form-data'>
                <div class="modal-body">
                    <div class="row">
                        <input type="hidden" name="fk_visitor_id" value="{{ $data['visitor_id'] }}">
                        <input type="hidden" name="visit_data_id" value="{{ $data['visit_data']->id ?? '' }}">

                        <div class="col-md-6">

                            @if(Auth::user()->getUser() && Auth::user()->getUser()->is_admin == "true")

                            <div class="form-group" style="display: grid">
                                <label for="fk_teammember_id">Select Team Member</label>
                                <select name="fk_teammember_id" id="fk_teammember_id" class="form-control" required>
                                    <option value="">Select Team Member</option>
                                    @foreach ($data['members'] as $member_id => $member_name)
                                        <option value="{{ $member_id }}"
                                            {{ (isset($data['visit_data']) && $data['visit_data']->fk_teammember_id == $member_id) ? 'selected' : (Auth::user()->getUser()->CustomerID == $member_id ? 'selected': '')  }}>
                                            {{ $member_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            @else
                                <input type="hidden" name="fk_teammember_id" value="{{ Auth::user()->getUser()->CustomerID }}" >
                            @endif

                            @sessionContactField('follow_up')
                            <div class="form-group">
                                <label for="follow_up_time">@defaultValue(empty($contactFieldValue['label']) ? 'Follow up time' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                <input type="datetime-local" name="follow_up_time" id="follow_up_time" class="form-control"
                                    placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Follow Up Time')"
                                    value="{{ isset($data['visit_data']) ? \Carbon\Carbon::parse($data['visit_data']->follow_up_time)->format('Y-m-d\TH:i') : '' }}" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                            </div>
                            @endsessionContactField
                            @sessionContactField('products')

                            <div class="form-group" style="display: grid">
                                <label for="products">@defaultValue(empty($contactFieldValue['label']) ? 'Follow up time' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                <select name="products[]" id="products" class="form-control" multiple @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    <option value="">@defaultValue(empty($contactFieldValue['hint']) ? 'Select Products' : $contactFieldValue['hint'])</option>
                                    @foreach ($data['allProducts'] as $p => $product)
                                        <option value="{{ $p }}"
                                            {{ isset($data['visit_data']) && in_array($p, $data['visit_data']->products->pluck('fk_product_id')->toArray()) ? 'selected' : '' }}>
                                            {{ $product }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            @endsessionContactField
                            <div class="form-group">
                                <label for="audio_file">Audio File</label>
                                <input type="file" name="audio_file" class="form-control" id="audio_file">
                            </div>
                        </div>

                        <div class="col-md-6">
                            @sessionContactField('visit_time')
                            <div class="form-group">
                                <label for="visit_time">@defaultValue(empty($contactFieldValue['label']) ? 'Visit Time' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                <input type="datetime-local" name="visit_time" id="visit_time" class="form-control"
                                    placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Visit Time')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)
                                    value="{{ isset($data['visit_data']) ? \Carbon\Carbon::parse($data['visit_data']->visit_time)->format('Y-m-d\TH:i') : \carbon\Carbon::now('Asia/Kolkata')->format('Y-m-d H:i') }}">
                            </div>
                            @endsessionContactField
                            @sessionContactField('action')

                            <div class="form-group">
                                <label for="action">@defaultValue(empty($contactFieldValue['label']) ? 'Action' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                <select name="action" id="action" class="form-control" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>
                                    <option value="">@defaultValue(empty($contactFieldValue['hint']) ? 'Select Action' : $contactFieldValue['hint'])</option>
                                    @foreach ($data['actions'] as $a => $action)
                                        <option value="{{ $action }}"
                                            {{ isset($data['visit_data']) && $data['visit_data']->action == $action ? 'selected' : (isset($data['action']) && $data['action'] == $action ? 'selected': '')  }}>
                                            {{ $action }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            @endsessionContactField
                            @sessionContactField('remarks')

                            <div class="form-group">
                                <label for="remarks">@defaultValue(empty($contactFieldValue['label']) ? 'Remarks' : $contactFieldValue['label']) @requiredStart(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)</label>
                                <textarea name="remarks" id="remarks" class="form-control" placeholder="@defaultValue(!empty($contactFieldValue['hint']) ? $contactFieldValue['hint'] : 'Enter Remarks')" @required(!empty($contactFieldValue['is_mandatory']) && $contactFieldValue['is_mandatory'] == true)>{{ isset($data['visit_data']) ? $data['visit_data']->remarks : '' }}</textarea>
                            </div>
                            @endsessionContactField

                            <div class="form-group">
                                <label for="visit_images">Images/Documents</label>
                                <input type="file" name="visit_images[]" class="form-control" id="visit_images"
                                    accept="image/jpeg, image/jpg, application/pdf" multiple>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="addVisitDataBtn">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
