<div class="modal-header">
    <h5 class="modal-title" id="settingsModalLabel">Member Details</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<div class="modal-body">
    <div class="container">
        <div class="row">
            <div class="col">
                <!-- User Info -->
                <div class="mb-3">
                    <p><strong>Name:</strong> <span id="MemberDetailModalName">{{$user->CustomerName}}</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  <button style="padding:1px 5px;" type="button" data-toggle="modal" class="updateUserName btn btn-primary btn-sm" data-customer-id="{{$user->CustomerID}}" data-user-id="{{$user->user_id}}" data-user-name="{{$user->CustomerName}}" data-target="#userNameModal">Change</button></p>
                    <p><strong>Phone:</strong> <span id="MemberDetailModalPhone">{{$user->Phone ?? '-'}}</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  <button style="padding:1px 5px;" type="button" data-toggle="modal" class="updateUserPhone btn btn-primary btn-sm" data-customer-id="{{$user->CustomerID}}" data-user-phone="{{$user->Phone}}" data-target="#updateUserPhoneModal">Change</button></p>
                    <p><strong>Email:</strong> <span id="MemberDetailModalEmail">{{$user->Email ?? '-'}}</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  <button style="padding:1px 5px;" type="button" data-toggle="modal" class="updateUserEmail btn btn-primary btn-sm" data-customer-id="{{$user->CustomerID}}" data-user-email="{{$user->Email}}" data-target="#updateUserEmailModal">Change</button></p>
                </div>
                
                <!-- Action Buttons -->
                <div class="d-flex gap-2 mb-3">
                    <a target="_blank" onclick="change_password(this)" data-id="{{$user->user_id}}" >
                        <button class=" btn btn-primary btn-sm" title="Change Password" type="button" style="color: #f8f9fa;">
                            <i class="bx bxs-edit"></i>Change Password
                        </button>
                    </a>
                    @if ($user->is_delete === 'false')
                        <a 
                            data-toggle="modal" 
                            data-target="#deletePopup" 
                            data-url="{{ route('users.destroy', ['user_id' => $user->user_id, 'type' => 'block']) }}"  
                            data-id="{{ $user->user_id }}" 
                            data-user="User"
                            onclick="blockUnblockMember(this)" {{ ($user->CustomerID == "0" && auth()->user()->getUser()->is_admin == 'false') ? 'style="pointer-events: none;"' : '' }}>
                            <button  class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Block">
                                <i class="fas fa-lock" aria-hidden="true"></i> Block
                            </button>
                        </a> 
                    @else
                        <a 
                            data-toggle="modal" 
                            data-target="#deletePopup" 
                            data-url="{{ route('users.destroy', ['user_id' => $user->user_id, 'type' => 'unblock']) }}"  
                            data-id="{{ $user->user_id }}" 
                            data-user="User"
                            onclick="blockUnblockMember(this)" {{ ($user->CustomerID == "0" && auth()->user()->getUser()->is_admin == 'false') ? 'style="pointer-events: none;"' : '' }}>
                            <button class="btn btn-secondary btn-sm" data-toggle="tooltip" data-placement="right" title="Unblock">
                                <i class="fas fa-unlock" aria-hidden="true"></i> Unblock
                            </button>
                        </a>
                    @endif
                </div>
            </div>
            <div class="col">
                <!-- Checkboxes -->
                <div class="mb-3">
                    <div class="form-check">
                        <input id="markAsAdmin" {{ ($user->CustomerID == "0" && auth()->user()->getUser()->is_admin == 'false') ? 'style="pointer-events: none;"' : '' }} type="checkbox" class="btn bg-gradient-success btn-sm" {{ $user->is_admin == "true" ? 'checked' : '' }} data-CustomerID="{{ $user->CustomerID }}" data-user_id="{{ $user->user_id }}" onclick="updateIsAdmin(this)" value="{{ $user->is_admin }}" >
                        <label class="form-check-label" for="markAsAdmin">Mark as Admin</label>
                    </div>
                    <div class="form-check">
                        @if($adminEntry == 'true')
                            <input id="pcAccess" {{ ($user->CustomerID == "0" && auth()->user()->getUser()->is_admin == 'false') ? 'style="pointer-events: none;"' : '' }} type="checkbox" class="btn bg-gradient-success btn-sm" checked data-CustomerID="{{ $user->CustomerID }}" data-toggle="modal" data-target="#addremoveAdmin" data-url="{{ route('users.addremoveAdmin', ['user_id' => $user->user_id, 'type' => 'remove']) }}" data-id="{{ $user->user_id }}" onclick="addremoveAdmin(this)" value="true" >
                        @else
                            <input id="pcAccess" {{ ($user->CustomerID == "0" && auth()->user()->getUser()->is_admin == 'false') ? 'style="pointer-events: none;"' : '' }} type="checkbox" class="btn bg-gradient-success btn-sm" data-CustomerID="{{ $user->CustomerID }}" data-toggle="modal" data-target="#addremoveAdmin" data-url="{{ route('users.addremoveAdmin', ['user_id' => $user->user_id, 'type' => 'add']) }}" data-id="{{ $user->user_id }}" onclick="addremoveAdmin(this)" value="false" >
                        @endif
                        <label class="form-check-label" for="pcAccess">PC Access</label>
                    </div>
                </div>
                <!-- Action Buttons -->
                <div class="d-flex gap-2 mb-3">
                    <a {{ $user->CustomerID == "0" && auth()->user()->getUser()->is_admin == 'false' ? 'style="pointer-events: none;"' : '' }} 
                        target="_blank" href="{{ route('users.edit_email',['CustomerID'=>$user->CustomerID]) }}" >
                        <button class="{{ !empty($user->primary_email)  && !empty($user->sender_email) ? 'btn btn-success' : 'btn btn-secondary' }} btn-sm" title="Configure Email" type="button" style="color: #f8f9fa;">
                            <i class="bx bxs-edit"></i>Email Configuration
                        </button>
                    </a>
                </div>
            </div>
        </div>

        <!-- Permissions Table -->
        <div class="row">
            <div class="form-group">
                <table id="example2" class="table table-bordered table-hover dataTable dtr-inline"
                    aria-describedby="example2_info">
                    <thead>
                        <tr>
                            <th>
                                Permissions
                            </th>
                            <th>

                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0" name="Contact_Share">
                                Contact Share
                            </td>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0">
                                <input type="checkbox"  $selected name="Contact_Share"
                                    id="contactShare" data-url="{{ route('users.updatePermissionNew') }}"
                                    data-userid="{{ $user->user_id }}"
                                    data-customerid="{{ $user->CustomerID }}" data-permissionname="Contact_Share" onclick="updatePermissionNew(this)"
                                    class="btn bg-gradient-success btn-sm" value="1" @if((isset($permissions)) && ($permissions->Contact_Share == "1"))
                                    checked @endif>
                            </td>
                        </tr>
                        <tr>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0" name="Call_Contact">
                                Call Contact
                            </td>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0">
                                <input type="checkbox" name="Call_Contact"
                                    id="callContact" data-url="{{ route('users.updatePermissionNew') }}"
                                    data-userid="{{ $user->user_id }}"
                                    data-customerid="{{ $user->CustomerID }}" data-permissionname="Call_Contact" onclick="updatePermissionNew(this)"
                                    class="btn bg-gradient-success btn-sm" value="1" @if((isset($permissions)) && ($permissions->Call_Contact == "1"))
                                    checked @endif>
                            </td>
                        </tr>
                        <tr>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0" name="Send_Whatsapp">
                                Send Whatsapp
                            </td>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0">
                                <input type="checkbox" name="Send_Whatsapp"
                                    id="sendWhatsapp" data-url="{{ route('users.updatePermissionNew') }}"
                                    data-userid="{{ $user->user_id }}"
                                    data-customerid="{{ $user->CustomerID }}" data-permissionname="Send_Whatsapp" onclick="updatePermissionNew(this)"
                                    class="btn bg-gradient-success btn-sm" value="1" @if((isset($permissions)) && ($permissions->Send_Whatsapp == "1"))
                                    checked @endif>
                            </td>
                        </tr>

                        <tr>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0" name="Save_Contact">
                                Save Contact
                            </td>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0">
                                <input type="checkbox" name="Save_Contact"
                                    id="saveContact" data-url="{{ route('users.updatePermissionNew') }}"
                                    data-userid="{{ $user->user_id }}"
                                    data-customerid="{{ $user->CustomerID }}" data-permissionname="Save_Contact" onclick="updatePermissionNew(this)"
                                    class="btn bg-gradient-success btn-sm" value="1" @if((isset($permissions)) && ($permissions->Save_Contact == "1"))
                                    checked @endif>
                            </td>
                        </tr>
                        <tr>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0" name="Export_Excel">
                                Export Excel
                            </td>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0">
                                <input type="checkbox" name="Export_Excel"
                                    id="exportExcel" data-url="{{ route('users.updatePermissionNew') }}"
                                    data-userid="{{ $user->user_id }}"
                                    data-customerid="{{ $user->CustomerID }}" data-permissionname="Export_Excel" onclick="updatePermissionNew(this)"
                                    class="btn bg-gradient-success btn-sm" value="1"  @if((isset($permissions)) && ($permissions->Export_Excel == "1"))
                                    checked @endif>
                            </td>
                        </tr>
                        <tr>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0" name="location_config">
                                Enable Location
                            </td>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0">
                                <input type="checkbox" name="location_config"
                                    id="locationConfig" data-url="{{ route('users.updatePermissionNew') }}"
                                    data-userid="{{ $user->user_id }}"
                                    data-customerid="{{ $user->CustomerID }}" data-permissionname="location_config" onclick="updatePermissionNew(this)"
                                    class="btn bg-gradient-success btn-sm" value="1"  @if((isset($user)) && ($user->location_config == "1")) checked @endif>
                            </td>
                        </tr>
                        <tr>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0" name="send_email">
                                Send Email
                            </td>
                            <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                tabindex="0">
                                <input type="checkbox" name="send_email"
                                    id="sendEmail" data-url="{{ route('users.updatePermissionNew') }}"
                                    data-userid="{{ $user->user_id }}"
                                    data-customerid="{{ $user->CustomerID }}" data-permissionname="send_email" onclick="updatePermissionNew(this)"
                                    class="btn bg-gradient-success btn-sm" value="1"  @if((isset($permissions)) && ($permissions->send_email == "1")) checked @endif>
                            </td>
                        </tr>
                        @if(Session::get('bulk_whatsapp') == 1)
                            <tr>
                                <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                    tabindex="0" name="Bulk_Whatsapp">
                                    Send Bulk Whatsapp
                                </td>
                                <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                    tabindex="0">
                                    <input type="checkbox" name="Bulk_Whatsapp"
                                        id="bulkWhatsapp" data-url="{{ route('users.updatePermissionNew') }}"
                                        data-userid="{{ $user->user_id }}"
                                        data-customerid="{{ $user->CustomerID }}" data-permissionname="Bulk_Whatsapp" onclick="updatePermissionNew(this)"
                                        class="btn bg-gradient-success btn-sm" value="1"  @if((isset($permissions)) && ($permissions->Bulk_Whatsapp == "1")) checked @endif>
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Division Section -->
        @if(json_decode($divisions))
            <div class="row">
                <div class="form-group">
                    <table id="example2" class="table table-bordered table-hover dataTable dtr-inline"
                        aria-describedby="example2_info">
                        <thead>
                            <tr>
                                <th>
                                   Assign Division
                                </th>
                                <th>
    
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach(json_decode($divisions) as $division)
                                <tr>
                                    <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                        tabindex="0" name="division-name">
                                        {{ $division->name }}
                                    </td>
                                    <td class="dtr-control sorting_1" style="border-bottom: 2px solid;"
                                        tabindex="0">
                                        <input type="checkbox"  $selected name="division_Name"
                                            id="division-{{$division->id}}" data-url="{{ route('users.updateDivisionNew') }}"
                                            data-userid="{{ $user->user_id }}"
                                            data-customerid="{{ $user->CustomerID }}" data-divisionid="{{$division->id}}" onclick="updateDivisionNew(this)"
                                            class="btn bg-gradient-success btn-sm" value="1" @if(in_array($division->id,$selectedDivisionIdsString))
                                            checked @endif>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endif
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
</div>
