@extends('layouts.master')
@section('content')
<style>
.class-link {
    color: #6cc417;
    text-decoration: none;
}

.class-link:hover {
    color: #ffbb00;
}
.select2-selection__choice {
    color: black !important;
}

</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Sub-Admin </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('setting.subAdminList') }}">Sub-Admin List</a></li>
                        <li class="breadcrumb-item active">Edit Sub-Admin</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('setting.subAdminUpdate') }}" name="form"
                                enctype="multipart/form-data">
                                @csrf
                                <input type='hidden' name="id" value="{{$subAdmin->id}}">
                                <div class="form-group">
                                    <label for="">Name</label>
                                    <input type="text" name="name" class="form-control" id="" placeholder="Name"
                                        value="{{$subAdmin->name}}" required>
                                </div>
                                <div class="form-group">
                                    <label for="">Email</label>
                                    <input type="email" name="email" class="form-control" id="" placeholder="Email"
                                           value="{{$subAdmin->email}}" required>
                                </div>
                                <div class="form-group">
                                    <label for="">Password</label>
                                    <input type="password" name="password" class="form-control" id="" placeholder="Password"
                                           value="">
                                </div>
                                <div class="form-group">
                                    <label for="">Division</label>
                                    <select class="form-control custom-select" name="divisions[]" id="division_id">
                                        <option></option>
                                    </select>
                                    @error('divisions')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="card-footer">
                                    <button type="submit" id="submit-button" class="btn btn-primary">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $("#division_id").select2({
            placeholder: "Select Division",
            multiple: true,
        });
        setDivisions();
    });

    function setDivisions() {
        var divisionIds = {!! json_encode($selectedDivisionIdsString) !!};
        var divisions = {!! $divisions !!};

        var options = [];
        var divisionId = $('#division_id');
        divisionId.html(''); // Clear existing options

        $.each(divisions, function(index, value) {
            var selected = divisionIds.includes(value.id.toString());
            var option = new Option(value.name, value.id, false, selected);
            divisionId.append(option);
            options.push({id:value.id,text:value.name});
        });

        divisionId.trigger({
            type: 'select2:select',
            params: {
                data: options
            }
        });

        divisionId.val(divisionIds).trigger('change');
    }
</script>

@endsection
