@extends('layouts.master')
@section('content')
<style>
.class-link {
    color: #6cc417;
    text-decoration: none;
}

.class-link:hover {
    color: #ffbb00;
}
.select2-selection__choice {
    color: black !important;
}

</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Region </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('setting.region') }}">Region List</a></li>
                        <li class="breadcrumb-item active">Edit Region</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('edit_store') }}" name="form"
                                enctype="multipart/form-data">
                                @csrf
                                <input type='hidden' name="id" value="{{$data_region->id}}">
                                <div class="form-group">
                                    <label for="">Name</label>
                                    <input type="text" name="name" class="form-control" id="" placeholder="Region Name"
                                        value="{{$data_region->name}}" required>
                                </div>
                                <div class="form-group">
                                    <label for="">Country</label>
                                    <select class="form-control custom-select" name="Country[]" id="country_id">
                                        <option></option>
                                    </select>
                                    @error('Country')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="card-footer">
                                    <button type="submit" id="submit-button" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $("#country_id").select2({
            placeholder: "Select Country",
            multiple: true,
        });
        setCountry();
    });

    function setCountry() {
        var visitorCountryIds = {!! json_encode($selectedCountryIdsString) !!};
        var allCountry = {!! $allCountry !!};

        var options = [];
        var countryId = $('#country_id');
        countryId.html(''); // Clear existing options

        $.each(allCountry, function(index, value) {
            var selected = visitorCountryIds.includes(value.id.toString());
            var option = new Option(value.name, value.id, false, selected);
            countryId.append(option);
            options.push({id:value.id,text:value.name});
        });

        countryId.trigger({
            type: 'select2:select',
            params: {
                data: options
            }
        });

        countryId.val(visitorCountryIds).trigger('change');
    }
</script>

@endsection