@extends('layouts.master')
@section('content')
<style>
    #category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">{{ empty($lead) ? 'Add Referred By' : 'Edit Referred By' }}</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('referred_by_master.list') }}">Referred By List</a></li>
                        <li class="breadcrumb-item active">{{ empty($lead) ? 'Add Referred By' : 'Edit Referred By' }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('referred_by_master.store') }}" name="form" enctype="multipart/form-data">
                                <input type="hidden" name="action" value="{{ empty($lead) ? 'insert' : 'update' }}">
                                <input type="hidden" name="id" value="{{ $lead->id ?? 0 }}">
                                @csrf
                                <div class="form-group" id="category-names-container">
                                    <label for="">Name</label>
                                    <input type="text" name="{{ empty($lead) ? 'name[]' : 'name' }}" class="form-control" id="" placeholder="Enter Referred By Name"
                                        value="{{ empty($lead) ? old('name') : $lead->name }}" required>
                                    @if($errors->has('name'))
                                        <div class="form-text text-danger">{{ $errors->first('name') }}</div>
                                    @endif
                                </div>

                                <div class="card-footer">
                                     @if(empty($lead))
                                    <div class="col-md-2 mt-30 append-buttons float-right">
                                        <div class="clearfix">
                                            <button type="button" id="add-button" class="btn btn-success float-left text-uppercase shadow-sm">
                                                <i class="fa fa-plus fa-fw"></i>Add
                                            </button>
                                            <button type="button" id="remove-button" class="btn btn-danger float-left text-uppercase ml-1" disabled>
                                                <i class="fa fa-minus fa-fw"></i>Remove
                                            </button>
                                        </div>
                                    </div>
                                    @endif
                                <button type="submit" class="btn btn-primary" >{{ empty($lead) ? 'Add' : 'Edit' }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        var categoryCount = 1; // Start with one input field for category name

        // Handle Add button click event
        $('#add-button').click(function() {
            categoryCount++;

            // Clone the first input field and update the name attribute
            var newInput = $('#category-names-container input:first').clone();
            newInput.val(''); // Clear the value of the cloned input field

            newInput.removeAttr('required');
            // Update the name attribute to ensure all inputs are part of the 'name[]' array
            newInput.attr('name', 'name[]');

            // Append the cloned input field to the container
            $('#category-names-container').append(newInput);

            // Enable remove button after adding a new input field
            $('#remove-button').prop('disabled', false);
        });

        // Handle Remove button click event
        $('#remove-button').click(function() {
            if (categoryCount > 1) {
                // Remove the last input field
                $('#category-names-container input').last().remove();
                categoryCount--;
            }

            // Disable remove button if only one input field is left
            if (categoryCount <= 1) {
                $('#remove-button').prop('disabled', true);
            }
        });
    });
</script>
@endsection
