@extends('layouts.master')
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">
        <a href="{{ route('dashboard') }}">
            <i class="menu-icon tf-icons bx bx-home-circle"></i>Home /
        </a>
        <a href="{{ route('plan.list') }}">
            <i class="menu-icon tf-icons bx bx-home-circle"></i>Plan List /
        </a> {{ empty($plan) ? 'Add Plan' : 'Edit Plan' }}
    </h4>

    <div class="row">
        <div class="col-xxl">
            <div class="card mb-4">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="mb-0">{{ empty($plan) ? 'Add Plan' : 'Edit Plan' }}</h5>
                </div>
                <hr>
                <div class="card-body">

                    <form class="form-horizontal" method="post" action="{{ route('plan.store')}}" enctype="multipart/form-data">
                        <input type="hidden" name="action" value="{{ empty($plan) ? 'insert' : 'update' }}">
                        <input type="hidden" name="id" value="{{ $plan->id ?? 0 }}">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">                        

                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="basic-icon-default-fullname">Name</label>
                            <div class="col-sm-10">
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text"><i class="bx bx-user"></i></span>
                                    <input type="text" class="form-control" name="name" value="{{ empty($plan) ? old('name') : $plan->name }}"
                                        placeholder="Enter Name">
                                </div>
                                @if($errors->has('name'))
                                    <div class="form-text text-danger">{{ $errors->first('name') }}</div>
                                @endif
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="basic-icon-default-email">Validity</label>
                            <div class="col-sm-10">
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text"><i class="bx bx-envelope"></i></span>
                                    <input type="text" name="validity" class="form-control" value="{{ empty($plan) ? old('validity') : $plan->validity }}"
                                        placeholder="Enter Validity" />
                                </div>
                                @if($errors->has('validity'))
                                    <div class="form-text text-danger">{{ $errors->first('validity') }}</div>
                                @endif
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="basic-icon-default-email">Description</label>
                            <div class="col-sm-10">
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text"><i class="bx bx-envelope"></i></span>                                    
                                    <textarea class="form-control" name="description" placeholder="Enter Description">{{ empty($plan) ? old('description') : $plan->description }}</textarea>
                                </div>
                                @if($errors->has('description'))
                                <div class="form-text text-danger">{{ $errors->first('description') }}</div>
                                @endif
                            </div>
                        </div>                       

                        <div class="row mb-3">
                            <label class="col-sm-2 col-form-label" for="basic-icon-default-email">Amount</label>
                            <div class="col-sm-10">
                                <div class="input-group input-group-merge">
                                    <span class="input-group-text"><i class="bx bx-envelope"></i></span>
                                    <input type="text" name="amount" class="form-control" value="{{ empty($plan) ? old('amount') : $plan->amount }}"
                                        placeholder="Enter Amount" />
                                </div>
                                @if($errors->has('amount'))
                                    <div class="form-text text-danger">{{ $errors->first('amount') }}</div>
                                @endif
                            </div>
                        </div>

                        <div class="row justify-content-end">
                            <div class="col-sm-10">
                                <button type="submit" class="btn btn-primary">{{ empty($plan) ? 'Add' : 'Edit' }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection