<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Proforma Invoice</title>
    <style>
        
        body {
          font-family: 'Carlito', Calibri, 'Segoe UI', sans-serif;
          font-size: 11px;
        }
        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
        }

        th.border,
        td.border {
            border: 1px solid black;
            padding: 3px;
            /* Adjust padding for spacing */
            text-align: left;
            vertical-align: top;
            line-height: 1.2;
            /* Adjust line height for spacing */
        }

        th {
            text-align: center;
        }

        .no-border {
            border: none;
        }

        .bold-text {
            font-weight: bold;
        }

        .underline {
            text-decoration: underline;
        }

        .small-text {
            font-size: smaller;
        }

        .combined-border-left {
            border-left: 1px solid black;
        }

        .combined-border-top {
            border-top: 1px solid black;
        }

        .combined-border-bottom {
            border-bottom: 1px solid black;
        }

        .combined-border-right {
            border-right: 1px solid black;
        }

        .remove-bottom-border {
            border-bottom: none;
        }

        .remove-top-border {
            border-top: none;
        }

        .remove-right-border {
            border-right: none;
        }

        .remove-left-border {
            border-left: none;
        }

        .outer-border {
            border: 1px solid black;
        }

        hr {
            border: none;
            border-top: 1px solid black;
            /* margin: 20px 0; */
        }

        .border-top-none {
            border-top: none !important
        }

        .border-bottom-none {
            border-bottom: none !important
        }

        .border-left-none {
            border-left: none !important
        }

        .border-right-none {
            border-right: none !important
        }

        /* table */
    </style>
</head>

<body>

    <table>
        <tbody>
            <tr>
                <td style="width:100%;text-align: center;vertical-align: middle;"> 
                    @if($quotationconfig != "" && $quotationconfig->header_image != "")
                    <img src="{{ $quotationconfig->header_image }}" style="width:100%;height: 120px;">
                    @endif
                </td>
            </tr>
            
            <tr>
                <td style="text-align:center;background-color: #eeece1;font-weight: 600;"><p>Quotation</p></td> 
            </tr>
            <tr>
                <td>
                    <table>
                        <tr>
                            <td style="width:50%;font-weight: 600;padding-left: 10px;"> <p>Quotation No.: {{ $refno }} </p></td>
                            <td style="width:50%;font-weight: 600;text-align: right;padding-right: 50px;"> <p>Date : {{ $invoicedate }}</p></td>
                        </tr>
                    </table>
                </td> 

            </tr>
            <tr>
                <td style="font-weight: 600;padding-left: 10px;">
                    To,<br>
                    {{ $visitor->name }},<br>
                    {{ $visitor->company_name }},<br>
                    {{ $visitor->address }},{{ $visitor->city }},<br>
                    {{ $visitor->state }},{{ $visitor->getCountryName($visitor->country_code) }}{{ $visitor->pincode }}<br>
                </td>
            </tr>
        </tbody>
    </table>

    <table style="margin-top: 15px;">
        <thead>
            <tr>
                <th class="border">Sr.No</th>
                <th class="border">Equipment's</th>
                <th class="border">Image</th>
                <th class="border">Rate</th>
                <th class="border">QTY</th>
                <th class="border">Amount</th>
                <th class="border">GST</th>
                <th class="border">GST Amount</th>
                <th class="border">Grand Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $i = 1;
            $total = 0;
            $qtytotal = 0;
            foreach ($machinList as $obj) {
            ?>
                <tr>
                    <td class="border" style="text-align:center;">{{ $i }}</td>
                    <td class="border">
                        <strong>{{ $obj->name }}</strong>
                        {!! $obj->technical_specification !!}
                    </td>
                    <td class="border"> 
                        @if($obj->quotation_image != "")
                            <img src="{{ $obj->quotation_image }}" style="width:100%;">
                        @endif
                    </td>
                    <td class="border" style="text-align:right;">{{ number_format($obj->price,2) }}</td>
                    <td class="border" style="text-align:center;">{{ $obj->qty }}</td> 
                    <td class="border" style="text-align:right;">{{ number_format($obj->machineamount,2) }}</td>

                    <td class="border" style="text-align:right;">{{ number_format($obj->gst,2) }} %</td>
                    <td class="border" style="text-align:right;">{{ number_format($obj->gsttotalamount,2) }}</td>

                    <td class="border" style="text-align:right;">{{ number_format($obj->grand_total,2) }}</td>
                </tr>
            <?php
                $total += $obj->grand_total;
                $qtytotal = $qtytotal + $obj->qty;
                $i++;
            }
            ?> 
            

            <tr >
                <td class="border" colspan="8" style="text-align:right;">Total</td>
                <td class="border" style="text-align:right;"> <img height="10" width="10" src="{{asset('assets/images/rupee-indian.png')}}" alt=""> {{ number_format($total,2) }}</td>
            </tr>
            <tr >
                <td class="border" colspan="8" style="text-align:right;font-weight: bold;">Net Payable Amount</td>
                <td class="border" style="text-align:right;font-weight: bold;"> <img height="10" width="10" src="{{asset('assets/images/rupee-indian.png')}}" alt=""> {{ number_format($total,2) }}</td>
            </tr>
            <tr >
                <td class="border" colspan="9" style="text-align:right;">&nbsp;</td>
            </tr>
        </tbody>
    </table>
    @if($quotationconfig != "" && ($quotationconfig->term_condition != "" || $quotationconfig->footer_image != ""))
        <table style="margin-top: 15px;">
            <tbody>
                @if($quotationconfig != "" && $quotationconfig->term_condition != "")
                    <tr >
                        <td style="text-align:left;font-weight: bold;"><span style="text-decoration: underline;display: inline-block;padding-bottom: 3px;">TERMS & CONDITIONS:</span> <br>
                            {!! nl2br($quotationconfig->term_condition) !!}
                        </td>
                    </tr>
                @endif
                @if($quotationconfig != "" && $quotationconfig->footer_image != "")
                    <tr>
                        <td style="width:100%;text-align: center;vertical-align: middle;"> 
                            <img src="{{ $quotationconfig->footer_image }}" style="width:100%;height: 120px;">
                        </td>
                    </tr>
                @endif
            </tbody>
        </table>
    @endif
</body>

</html>
