@extends('layouts.master')
@section('content')
    <style>
        .card-header {
            color: #fff;
            background-color: #007bff;
        }
        .error{
            color: red;
        }
        .select2-container--default .select2-selection--multiple .select2-selection__choice{
            color: #000;
        }

        #fullpage {
            display: none;
            position: absolute;
            top: 0;
            left: 0;
            width: 81.4vw;
            height: 60vh;
            background-size: contain;
            background-repeat: no-repeat no-repeat;
            background-position: center center;
            background-color: black;
        }


        .item {
            width: 200px;
            text-align: center;
            display: block;
            background-color: transparent;
            border: 1px solid transparent;
            margin-right: 10px;
            margin-bottom: 1px;
            margin-top: 10px;
            float: left;
        }

        img {
            height: auto;
            width: 60px;
            object-fit: scale-down;
        }
        div.dataTables_wrapper div.dataTables_filter {
            text-align: right;
            float: left;
        }
        #overlay {
            position: fixed;
            top: 0;
            z-index: 1070;
            width: 100%;
            height: 100%;
            display: none;
            background: rgba(0, 0, 0, 0.6);
        }

        .cv-spinner {
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 4px #ddd solid;
            border-top: 4px #2e93e6 solid;
            border-radius: 50%;
            animation: sp-anime 0.8s infinite linear;
        }
    </style>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Quotation List</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">Quotation List</li>
                        </ol>
                    </div>
                    <div class="container-fluid">
                        <div class="card-body">
                            <form method="get" id="myform" name="myform" action="{{ route('quotations.list') }}"
                                enctype="multipart/form-data">
                                <div class="form-group row" style="align-items: flex-end;">
                                    @if(Auth::user()->type != "user")
                                        <div class="col-2">
                                            <label for="">Select Team Member</label>
                                            <select class="form-control custom-select" name="CustomerID" id="CustomerID">
                                                <option value="all" @if ($CustomerID == 'all') selected @endif>All
                                                </option>
                                                @foreach ($users as $username)
                                                    @if($username->is_delete == 'true')
                                                        <option value="{{ $username->CustomerID }}" @if ($CustomerID == $username->CustomerID) selected @endif style="color:red;"> {{ $username->CustomerName }} (Blocked)</option>
                                                    @else
                                                        <option value="{{ $username->CustomerID }}" @if ($CustomerID == $username->CustomerID) selected @endif> {{ $username->CustomerName }}</option>
                                                    @endif
                                                @endforeach
                                            </select>
                                        </div>
                                        
                                    @endif
                                    <div class="col-2">
                                        <label for="">Select Start Date</label>
                                        <input type="date" name="start_date" id="start_date" class="form-control" value="{{ $start_date }}">
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select End Date</label>
                                        <input type="date" name="end_date" id="end_date" class="form-control" value="{{ $end_date }}">
                                    </div>
                                    <div class="col-2">
                                        <button type="submit" class="btn btn-2 bg-gradient-info btn-1" style="color:white;">Submit</button>
                                    </div>

                                    @if($quotation_total != "")
                                        <div class="col-4">
                                           <h4>Total Quotation Amount :  {{ number_format($quotation_total,2) }}</h4>
                                        </div>
                                    @endif
                                    
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Quotation</h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                        title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row mb-2">
                                    <div class="col-12">
                                        <a href="{{ route('quotations.generate_quotation') }}" class="btn btn-primary">Generate Quotation</a>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                {{ $dataTable->table() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    

    <div id="overlay">
        <div class="cv-spinner">
            <span class="spinner"></span>
        </div>
    </div>

    @push('scripts')
        {!! $dataTable->scripts() !!}
    @endpush

    <script>
        function deleteData(elm) {
            let id = $(elm).data('id');
            let url = $(elm).data('url');
            swal({
                title: 'Are you sure!',
                icon: 'error',
                dangerMode: true,
                buttons: true,
                confirm: "Confirm",
            }).then(function(isConfirm) {
                if (isConfirm === true) {
                    $.ajax({
                        type: 'GET',
                        url: url,
                        dataType: 'json',
                        success: function(data) {
                            location.reload(true);
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }
            });
        }
    </script>
@endsection
