@extends('layouts.master')
@section('content')
    <style>
        .select2-container .select2-selection--single {
        height: 40px !important;
        }
        
        .select2-container--default .select2-selection--single .select2-selection__clear {
        height: 39px !important;
        margin-top: -5px !important;
        }
        .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 39px !important;
        }
        .select2-container .select2-selection--single .select2-selection__clear {
        font-size: 1.8em !important;
        }
        .select2-container--default .select2-selection--single .select2-selection__arrow{
               height: 38px !important;
        }
        #cke_notifications_area_content{
            display: none !important;
        }
    </style>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Generate Quotation</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('quotations.list') }}">Quotation List</a></li>
                            <li class="breadcrumb-item active">Generate Quotation</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Generate Quotation</h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                        title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <form method="post" id="quotationform" action="{{ route('quotations.savegenerate_quotation') }}" name="quotationform" autocomplete="off">
                                    @csrf
                                    <input type="hidden" name="userid" value="{{ $userdata->CustomerID }}">
                                    <div class="row">
                                        <div class="col-md-12 mt-2">
                                            <label for="visitorid" class="form-label">Client</label>
                                            <select name="visitorid" class="form-control" id="visitorid" onchange="visitorOnChange()" required>
                                                <option value="" >Select</option>
                                                @foreach($visitorList as $visitor)
                                                    <option value="{{ $visitor->id }}" data-id="{{ $visitor->gstn }}">{{ $visitor->name }}</option>
                                                @endforeach 
                                            </select>
                                        </div>
                                        <div class="col-md-12 mt-2">
                                            <label for="invoicedate" class="form-label">INVOICE DATE</label>
                                            <input type="text" class="form-control" id="invoicedate" name="invoicedate" value="" readonly required>
                                        </div>
                                        <div class="col-md-12 mt-2">
                                            <label for="gstn" class="form-label">GSTN</label>
                                            <input type="text" class="form-control" id="gstn" name="gstn" value="">
                                        </div>
                                        <div class="col-md-12 mt-2">
                                            <h5>Add Product</h5>
                                            <hr>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="dynamic-machine mb-4" id="dynamic-machine-1">
                                                    <div class="mb-1 mt-1" >
                                                        <select name="machine[]" class="form-control" id="dynamic-machine-list-1" onchange="machineOnChange('1')" required>
                                                            <option value="" >Select</option>
                                                            @foreach($machinList as $machin)
                                                                <option value="{{ $machin->id }}" data-id="{{ $machin->price }}">{{ $machin->name }}</option>
                                                            @endforeach 
                                                        </select>
                                                    </div>
                                                    <div class="mb-1 mt-1" >
                                                        <input type="number" name="machineprice[]" class="form-control" id="machineprice-1" placeholder="Price"  value="" onkeyup="calculatePrice('1')" required>
                                                    </div>
                                                    <div class="mb-1 mt-1" >
                                                        <input type="number" name="machinqty[]" class="form-control" id="machinqty-1" placeholder="QTY"  value=""  onkeyup="calculatePrice('1')" required>
                                                    </div>
                                                    <div class="mb-3 mt-1" >
                                                        <input type="number" name="machinetotalprice[]" class="form-control" id="machinetotalprice-1" placeholder="Total Price"  value="" readonly style="background-color: #f2f2f2;">
                                                    </div>
                                            </div>
                                        </div>
                                        

                                        <div class="col-md-12 text-right">
                                            <button type="button" id="add-machinebutton" class="btn btn-secondary btn-sm text-uppercase shadow-sm"><i class="fa fa-plus fa-fw"></i> </button>
                                            <button type="button" id="remove-machinebutton" class="btn btn-danger btn-sm text-uppercase ml-1" disabled="disabled"><i class="fa fa-minus fa-fw"></i> </button>
                                        </div>

                                        <div class="col-md-12 mt-2">
                                            <label class="form-label">Terms and Conditions:</label>
                                            <textarea class="form-control" name="term_condition" id="content" cols="30" rows="30">{{ $quotationconfig ? nl2br($quotationconfig->term_condition) : ''}}</textarea>
                                        </div>
                                        <div class="col-md-12 mt-2">
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </div>
                                    
                                  </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            /*$(document).ready(function () {
                CKEDITOR.replace('content', {
                    height: 250
                });
                
            });*/
            $(function () {
                $('#visitorid').val('');
                $('#visitorid').select2({
                  placeholder: 'Select Client'
                });

                $("#invoicedate").datepicker({ 
                    autoclose: true, 
                    todayHighlight: true,
                    format: 'dd-mm-yyyy' 
                }).datepicker('update', new Date());

                
            });
            $(document).ready(function() {
                // Add and remove dynamic machine
                var dynamicmachineCounter = 1;

                $('#dynamic-machine-list-1').val('');
                $('#dynamic-machine-list-1').select2({
                  placeholder: 'Select Product'
                });

                $('#add-machinebutton').click(function() {
                    dynamicmachineCounter++;
                    var dynamicField = '<div class="dynamic-machine mb-4" id="dynamic-machine-'+dynamicmachineCounter+'"><div class="mb-1 mt-1" ><select name="machine[]" class="form-control" id="dynamic-machine-list-'+dynamicmachineCounter+'" onchange="machineOnChange('+dynamicmachineCounter+')">@foreach($machinList as $machin)<option value="{{ $machin->id }}"  data-id="{{ $machin->price }}">{{ $machin->name }}</option>=@endforeach</select></div><div class="mb-1 mt-1" ><input type="number" name="machineprice[]" class="form-control" id="machineprice-'+dynamicmachineCounter+'" placeholder="Price"  value="" onkeyup="calculatePrice('+dynamicmachineCounter+')" required></div><div class="mb-1 mt-1" ><input type="number" name="machinqty[]" class="form-control" id="machinqty-'+dynamicmachineCounter+'" placeholder="QTY"  value="" required></div><div class="mb-3 mt-1" ><input type="number" name="machinetotalprice[]" class="form-control" id="machinetotalprice-'+dynamicmachineCounter+'" placeholder="Total Price"  value="" readonly style="background-color: #f2f2f2;"></div></div>';
                    $('.dynamic-machine').last().after(dynamicField);
                    $('#dynamic-machine-list-'+dynamicmachineCounter).val('');
                    $('#dynamic-machine-list-'+dynamicmachineCounter).select2({
                        placeholder: 'Select Product'
                    });
                    $('#remove-machinebutton').prop('disabled', false);
                });

                $('#remove-machinebutton').click(function() {
                            console.log(dynamicmachineCounter);
                    if (dynamicmachineCounter > 1) {
                        $('#dynamic-machine-' + dynamicmachineCounter).remove();
                        dynamicmachineCounter--;

                        // Disable remove button if only one dynamic machine left
                        if (dynamicmachineCounter === 1) {
                            $(this).prop('disabled', true);
                        }
                    }
                });
            });
            function machineOnChange(index){
                var id = $('#dynamic-machine-list-'+index).val();
                var price = $('#dynamic-machine-list-'+index).find(':selected').data('id');
                //console.log(id,price,index);
                $('#machineprice-'+index).val(price);
                $('#machinqty-'+index).val(1);
                $('#machinetotalprice-'+index).val(price);
            }
            function calculatePrice(index){
                    var machineprice = $('#machineprice-'+index).val();
                    var machinqty = $('#machinqty-'+index).val();
                    var totalprice = machineprice * machinqty;
                    //console.log(machineprice,machinqty,totalprice);
                    $('#machinetotalprice-'+index).val(totalprice);
            }
            function visitorOnChange(index){
                var gstn = $('#visitorid').find(':selected').data('id');
                $('#gstn').val(gstn);
            }
        </script>
    @endpush

    
@endsection
