@extends('layouts.master')
@section('content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <style>
        #category-names-container input {
            margin-bottom: 10px;
            /* Add margin at the bottom of each input field */
        }

        #modal-category-names-container input {
            margin-bottom: 10px;
            /* Add margin at the bottom of each input field */
        }

        .error {
            color: red;
        }

        .password-wrapper {
            position: relative;
            display: flex;
            align-items: center;
            /* Center align items vertically */
            height: 2.5em;
            /* Adjust based on your input field height */
        }

        .password-toggle {
            position: absolute;
            right: 10px;
            cursor: pointer;
            font-size: 1.2em;
            z-index: 1;
            /* Ensure it's on top of other elements */
        }

        input.form-control {
            /* padding-right: 40px; */
            /* Add padding to ensure text does not overlap with the icon */
        }

        #overlay {
            position: fixed;
            top: 0;
            z-index: 1070;
            width: 100%;
            height: 100%;
            display: none;
            background: rgba(0, 0, 0, 0.6);
        }

        .cv-spinner {
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 4px #ddd solid;
            border-top: 4px #2e93e6 solid;
            border-radius: 50%;
            animation: sp-anime 0.8s infinite linear;
        }

        #empList {
            max-height: 60vh;
            overflow-y: auto;
            padding-right: 5px;
        }

        .emp-card {
            background-color: #fdfdfd;
            border: 1px solid #e0e0e0;
            border-left: 4px solid transparent;
            transition: all 0.2s ease-in-out;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05);
        }

        .emp-card:hover {
            /* background-color: #f8f9fa; */
        }

        .selected-card {
            background-color: #e9f5ff;
            border-left: 4px solid #0d6efd;
            box-shadow: 0 2px 4px rgba(13, 110, 253, 0.2);
        }

        @keyframes sp-anime {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Location Tracking</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">Location Tracking</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="card-body">

                </div>
            </div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Location Tracking</h3>
                                <div class="float-right">
                                    <span><b>Location Interval : </b><span class="location-interval"> {{ $duration }} Minute</span></span>
                                    <button type="button" class="ml-3 btn btn-primary btn-sm ajaxModelOpenBtn"
                                        data-url="{{ route('location_tracking.locationTrackingModal') }}">
                                        <span class="submit-text">Edit Location Interval</span>
                                        <div class="spinner-border text-light submit-loader" role="status"
                                            style="width:16px;height:16px;display:none;">
                                            <span class="visually-hidden"></span>
                                        </div>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-9 col-sm-6">
                                        <div id="googleMap" style="width:100%;height:64vh;"></div>
                                    </div>
                                    <div class="col-md-3 col-sm-6">

                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    <input type="date" class="form-control" id="date_filter"
                                                        name="date_filter" placeholder="Select Date"
                                                        value="{{ now()->format('Y-m-d') }}">
                                                    <small class="text-danger date_filter-error "></small>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <button type="button" class="btn btn-sm btn-primary filter_btn"
                                                        data-filter="date_filter">
                                                        <span class="submit-text">Filter</span>
                                                        <div class="spinner-border text-light submit-loader" role="status"
                                                            style="width:16px;height:16px;display:none;">
                                                            <span class="visually-hidden"></span>
                                                        </div>

                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card mb-4">
                                            <div class="card-header">

                                                <strong>Team Members</strong>
                                                <button style="float: right;" type="button"
                                                    class="btn btn-sm btn-primary rounded-pill" id="refreshTeamMemberBtn">
                                                    <i class="fa-solid fa-arrows-rotate"></i>
                                                </button>

                                            </div>
                                            <div class="card-body p-2" id="empList">
                                                <!-- User 1 -->



                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <!-- Modal -->

    <div id="overlay">
        <div class="cv-spinner">
            <span class="spinner"></span>
        </div>
    </div>




    @push('scripts')
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        <script>
            function setAjaxLoader(btn, state) {
                var text = btn.find(".submit-text");
                var loader = btn.find(".submit-loader");
                if (state) {
                    loader.show()
                    btn.prop("disabled", true);
                } else {
                    btn.prop("disabled", false);
                    loader.hide()
                }
            }

            function setTeamMemberRefresLoader(show = true) {
                if (show) {
                    $("#refreshTeamMemberBtn i").addClass('fa-spin');
                    $("#refreshTeamMemberBtn").prop("disabled", true);
                } else {
                    $("#refreshTeamMemberBtn i").removeClass('fa-spin');
                    $("#refreshTeamMemberBtn").prop("disabled", false);
                }
            }

            function setLoader(id = "overlay", show = true) {
                if (show) {
                    $('#' + id).fadeIn(150);
                } else {
                    $('#' + id).fadeOut(150);
                }
            }

            // let teamMemberAjaxInterval = null;
            function reloadTeamMemberList(memberId = 0, is_filter = true, is_on_reload = false) {

                let Url = "{{ route('location_tracking.teamMemeberList', ':memberId') }}"
                Url = Url.replace(':memberId', memberId);
                // if(teamMemberAjaxInterval){
                //     teamMemberAjaxInterval.abort();
                // }
                if (is_filter) {
                    setAjaxLoader($(".filter_btn"), true);
                } else {
                    setTeamMemberRefresLoader();
                }

                teamMemberAjaxInterval = $.ajax({
                    url: Url,
                    method: "GET",
                    data: {
                        date_filter: $("#date_filter").val()
                    },
                    success: function(response) {
                        if (is_filter) {
                            setAjaxLoader($(".filter_btn"), false);

                        } else {
                            setTeamMemberRefresLoader(false);
                        }
                        console.log(response);
                        addSideBarList(response.data);
                        if(is_on_reload){
                            displayMarkersOnReload(response.data);
                        }
                    },
                    error: function(xhr) {
                        if (is_filter) {
                            setAjaxLoader($(".filter_btn"), false);

                        } else {
                            setTeamMemberRefresLoader(false);
                        }
                        $("#empList").html(xhr?.responseJSON?.message || "Some thing went wrong");
                    }
                });

            }
            let map;
            let markers = [];
            let gmarkers = [];
            let flightPath = [];
            let markerCluster;
            let infowindow = new google.maps.InfoWindow();

            $(document).ajaxStart(function() {
                setLoader(true);
            });

            $(document).ajaxStop(function() {
                setLoader(false);
            });

            function setGoogleMap() {
                const defaultCenter = {
                    lat: 22.9540961,
                    lng: 79.3824058
                };
                infowindow = new google.maps.InfoWindow();
                map = new google.maps.Map(document.getElementById("googleMap"), {
                    zoom: 3,
                    center: defaultCenter,
                    mapTypeId: google.maps.MapTypeId.ROADMAP,
                    scrollwheel: true,
                });

                // Example trigger (optional)
                reloadTeamMemberList(0,true,true);


                // setInterval(() => {
                //     reloadTeamMemberList();
                // }, 15000);

            }
            setGoogleMap();



            function changeDateFormat(isoString) {
                const date = new Date(isoString);

                // Check if the date is valid
                if (isNaN(date.getTime())) {
                    return null;
                }

                const hours = date.getUTCHours().toString().padStart(2, '0');
                const minutes = date.getUTCMinutes().toString().padStart(2, '0');
                const seconds = date.getUTCSeconds().toString().padStart(2, '0');

                return `${hours}:${minutes}:${seconds}`;
            }

            function addSideBarList(data) {
                // removeMarkers();

                $("#empList").html("");


                data.forEach((item, i) => {

                    const name = item.CustomerName;
                    const user_readable_time = item.user_location_time;
                    const on_demand = item.on_demand;
                    const date_time = item.date_time;
                    const lat = item.lat;
                    const lng = item.lng;
                    const user_id = item.user_id;
                    const content = `
                    <div data-id="${user_id}" data-lat="${lat}" data-lng="${lng}" style="cursor: pointer;" data-customername="${name}" data-user_readable_time="${user_readable_time}" class="d-flex justify-content-between align-items-center mb-2 p-1 emp-card emp-card-${user_id}" style="border:1px solid #CAD5E2;border-radius:5px;padding:2px 5px;">
                                                    <div>
                                                        <b class="emp-card-${user_id}-name">${name}</b><br>
                                                        <small class="emp-card-${user_id}-time">${user_readable_time}</small>
                                                    </div>
                                                    <div>
                                                    <button class="btn btn-sm btn-warning emp-card-btn emp-card-${user_id}-btn" data-id="${user_id}">
                                                        <span class="submit-text">Get Location</span>
                                                        <div class="spinner-border text-dardk submit-loader" role="status"
                                                            style="width:16px;height:16px;display:none;">
                                                            <span class="visually-hidden"></span>
                                                        </div>
                                                    </button>
                                                </div>
                    `;
                    $("#empList").append(content);



                });


            }
            function disableButtonForTime(className, timeMs) {
    const buttons = document.querySelectorAll('.' + className);

    buttons.forEach(btn => {
        btn.disabled = true; // disable
        btn.classList.add("disabled"); // optional styling if needed

        setTimeout(() => {
            btn.disabled = false; // enable again
            btn.classList.remove("disabled");
        }, timeMs);
    });
}

            function zoomMapOnVisitor(lat, lng,zoom=15) {
                map.setCenter({
                    lat: parseFloat(lat),
                    lng: parseFloat(lng)
                });
                map.setZoom(zoom);
            }




            function removeMarkers() {
                if (flightPath.length) {
                    flightPath.forEach(path => path.setMap(null));
                    flightPath = [];
                }

                markers.forEach(marker => marker.setMap(null));
                gmarkers.forEach(marker => marker.setMap(null));

                markers = [];
                gmarkers = [];

                if (markerCluster) {
                    markerCluster.clearMarkers();
                }
            }

            function reloadMap() {
                // setLoader($("#refreshBtn"),true);
                setGoogleMap();
                // setLoader($("#refreshBtn"),false);

            }
            $(document).ready(function() {

                $(document).on('click', ".ajaxModelOpenBtn", function(e) {
                    e.preventDefault();
                    const Url = $(this).data('url')
                    const btn = $(this);
                    if ((Url !== undefined && Url !== null)) {
                        setAjaxLoader(btn, true);
                        $.ajax({
                            type: "POST",
                            url: Url,
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                                    'content')
                            },
                            success: function(response) {
                                setAjaxLoader(btn, false);

                                console.log(response);
                                if (response.status) {

                                    $('body').find('#ajaxModal').remove();
                                    $('body').append(response.html);
                                    $('body').find('#ajaxModal').modal('show');
                                    if (window['afterOpenAjaxModal']) {
                                        window['afterOpenAjaxModal']();
                                    }

                                } else {
                                    Swal.fire('Error!', response.message,
                                        'error');
                                }
                            },
                            error: function(xhr) {
                                setAjaxLoader(btn, false);

                                var error = xhr.responseJSON;
                                if (xhr.status == 422) {
                                    Object.entries(error.error).forEach(function(item, index) {
                                        const [key, value] = item;
                                        form.find(`.${key}-error`).html(value);
                                    })
                                } else {
                                    Swal.fire('Error!', error.message,
                                        'error');
                                }


                            }
                        });
                    }
                })

                $(document).on('submit', ".ajaxForm", function(e) {
                    e.preventDefault();
                    const Url = $(this).prop('action')
                    const redirect = $(this).data('redirect')
                    const form = $(this)
                    const beforeSubmitFunction = form.data('before-ajax-function');
                    const Btn = $(this).find('button[type="submit"]');
                    if ((Url !== undefined && Url !== null)) {
                        var form_id = form[
                            0];
                        var formData = new FormData(form_id);
                        // formData.append("deleteProblemIds", deleteIds);
                        form.find(".common-ajax-error").html("");
                        if (window[beforeSubmitFunction]) {
                            res = window[beforeSubmitFunction](form, formData, Btn);
                            if (res == false) {
                                return true;
                            }
                        }
                        setAjaxLoader(Btn, true);
                        $.ajax({
                            type: form.prop('method'),
                            url: Url,
                            data: formData,
                            dataType: "json",
                            cache: false,
                            processData: false,
                            contentType: false,
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                                    'content')
                            },
                            success: function(response) {
                                setAjaxLoader(Btn, false);

                                console.log(response);
                                if (response.status) {
                                    $('body').find('#ajaxModal').modal('hide');

                                    if ($(".ajaxReloadDatatable")) {
                                        $(".ajaxReloadDatatable").DataTable().ajax.reload();
                                    }
                                    $(".location-interval").text((response?.location_interval || 0) + " Minute");
                                    Swal.fire('Success!', response.message,
                                        'success').then((result) => {

                                    });
                                } else {
                                    Swal.fire('Error!', response.message,
                                        'error');
                                }
                            },
                            error: function(xhr) {
                                setAjaxLoader(Btn, false);
                                var error = xhr.responseJSON;
                                // console.log(xhr.responseJSON);
                                if (xhr.status == 422) {
                                    Object.entries(error.error).forEach(function(item, index) {
                                        const [key, value] = item;
                                        form.find(`.${key.replaceAll('.', '-')}-error`)
                                            .html(value);
                                    })
                                } else {
                                    Swal.fire('Error!', error.message,
                                        'error');
                                }


                            }
                        });
                    }
                });
                $("#refreshTeamMemberBtn").click(function() {
                    reloadTeamMemberList(0, false);
                })
                $(".filter_btn").click(function() {
                    reloadTeamMemberList(0, true);
                })


                $(document).on('click', '.emp-card-btn', function() {
                    const id = $(this).data('id');

                    const btn = $(this);
                    let Url = "{{ route('location_tracking.getLatestLocation', ':memberId') }}"
                    Url = Url.replace(':memberId', id);

                    setAjaxLoader(btn, true);
                    $.ajax({
                        url: Url,
                        method: "GET",
                        success: function(response) {
                            console.log(response);
                            setAjaxLoader(btn, false);
                            disableButtonForTime("emp-card-"+id+"-btn", 25000);
                        },
                        error: function(xhr) {
                            setAjaxLoader(btn, false);

                            alert(xhr?.responseJSON?.message ||
                                "Some thing went wrong in get latest location");
                        }
                    });


                })


                $(document).on('click', '.emp-card', function(e) {
                    if ($(e.target).closest('.emp-card-btn').length) {
                        console.log("Button inside emp-card clicked");
                        return; // stop if button clicked
                    }

                    setLoader("overlay", true);

                    let card = $(this);
                    removeMarkers();
                    const id = $(this).data('id');
                    const date = $("#date_filter").val();
                    let Url = "{{ route('location_tracking.getAllLocationOfUser', ':memberId') }}"
                    Url = Url.replace(':memberId', id);
                    $.ajax({
                        url: Url,
                        method: "GET",
                        data: {
                            date: date
                        },
                        success: function(response) {
                            displayMarkers(response?.data || []);
                            setLoader("overlay", false);

                            // Optional: highlight selected card
                            $('.emp-card').removeClass('selected-card');
                            card.addClass('selected-card');
                        },
                        error: function(xhr) {
                            setLoader("overlay", false);
                            alert(xhr?.responseJSON?.message ||
                                "Some thing went wrong in get latest location");
                        }
                    });





                    // Do something like centering map, showing details, etc.
                });
            })

            function displayMarkersOnReload(data) {
    // Clear old markers first
    removeMarkers();

    if (!Array.isArray(data) || data.length === 0) {
        return;
    }

    // Find last valid location
    const lastMatch = data.filter(item => item?.lat && item?.lng).pop();

    data.forEach(element => {
        const lat = parseFloat(element?.lat ?? 0);
        const lng = parseFloat(element?.lng ?? 0);

        if (!lat || !lng) return; // Skip invalid coords

        const customerName = element?.CustomerName ?? "Unknown";
        const userLocationTime = element?.display_time ?? "";
        const iconUrl = "http://maps.google.com/mapfiles/ms/icons/green-dot.png";

        const marker = new google.maps.Marker({
            position: { lat, lng },
            map,
            icon: iconUrl,
            title: customerName
        });

        // Marker click event
        marker.addListener("click", () => {
            const content = `
    <div style="
        font-family: 'Segoe UI', sans-serif;
        font-size: 13px;
        min-width: 260px;
        max-width: 300px;
        padding: 12px;
        border-radius: 10px;
        background: #ffffff;
        box-shadow: 0 4px 10px rgba(0,0,0,0.15);
    ">
        <!-- Header -->
        <div style="display: flex; align-items: center; margin-bottom: 8px;">
            <div style="flex-shrink: 0; margin-right: 10px; width: 36px; height: 36px; border-radius: 50%; background: #f8d7da; display: flex; justify-content: center; align-items: center;">
                <i class="fa-solid fa-user" style="color: #dc3545; font-size: 16px;"></i>
            </div>
            <strong style="font-size: 16px; color: #333;">${customerName}</strong>
        </div>

        <hr style="margin: 8px 0; border: 0; border-top: 1px solid #eee;">

        <!-- Time -->
        <div style="display: flex; align-items: center; color: #0d6efd; margin-top: 5px;">
            <i class="fa-regular fa-clock" style="margin-right: 6px;"></i>
            <span><strong>Time:</strong> ${userLocationTime}</span>
        </div>
    </div>
`;

            infowindow.setContent(content);
            infowindow.open(map, marker);
        });

        markers.push(marker);
    });

    // Zoom on last valid visitor
    if (lastMatch?.lat && lastMatch?.lng) {
        zoomMapOnVisitor(parseFloat(lastMatch.lat), parseFloat(lastMatch.lng));
    }
}

            function displayMarkers(data) {
                removeMarkers();
                if (data && typeof data == "object" && Object.keys(data).length != 0) {
                    const lastMatch = data.filter(item => item.lat && item.lng).pop();



                    data.forEach((element, index) => {

                        const lat = parseFloat(element?.lat) || 0.0;
                        const lng = parseFloat(element?.lng) || 0.0;
                        const customername = element.CustomerName;
                        const user_location_time = element.display_time;

                        if (lat && lng && lat != 0.0 && lng != 0.0) {
                            let icon = "http://maps.google.com/mapfiles/ms/icons/red-dot.png";
                            if(index == data.length - 1){
                                icon = "http://maps.google.com/mapfiles/ms/icons/green-dot.png";
                            }
                            const marker = new google.maps.Marker({
                                position: {
                                    lat: parseFloat(lat),
                                    lng: parseFloat(lng)
                                },
                                map,
                                icon: icon,
                                title: `${customername}`
                            });
                            marker.addListener("click", () => {
                                const content = `
        <div style="font-family:'Segoe UI', sans-serif; font-size: 13px; min-width: 240px; padding: 10px; border-radius: 8px; box-shadow: 0 2px 6px rgba(0,0,0,0.1); background: #e9fbee;">
            <div style="display: flex; align-items: center; color: #198754;">
                <span><strong>Time:</strong> ${user_location_time}</span>
            </div>
        </div>
    `;
                                infowindow.setContent(content);
                                infowindow.open(map, marker);

                            });
                            markers.push(marker);

                        }

                    });


if (lastMatch?.lat && lastMatch?.lng) {
    zoomMapOnVisitor((lastMatch?.lat), parseFloat(lastMatch?.lng));
}



                }

            }
        </script>
    @endpush
@endsection
