@extends('layouts.master')
@section('content')
<style>
    #category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }

    #modal-category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }

    .error {
        color: red;
    }

    .password-wrapper {
        position: relative;
        display: flex;
        align-items: center;
        /* Center align items vertically */
        height: 2.5em;
        /* Adjust based on your input field height */
    }

    .password-toggle {
        position: absolute;
        right: 10px;
        cursor: pointer;
        font-size: 1.2em;
        z-index: 1;
        /* Ensure it's on top of other elements */
    }

    input.form-control {
        padding-right: 40px;
        /* Add padding to ensure text does not overlap with the icon */
    }
    #overlay {
        position: fixed;
        top: 0;
        z-index: 1070;
        width: 100%;
        height: 100%;
        display: none;
        background: rgba(0, 0, 0, 0.6);
    }

    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }
</style>
<link
  rel="stylesheet"
  href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.css"
/>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Expense List</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Expense</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="card-body">
                <form method="get" id="myform" name="myform" action="{{ route('expence.list') }}" enctype="multipart/form-data">
                    <div class="form-group row">
                        <div class="col-2">
                            <label for="">Select Team Member</label>
                            <select class="form-control custom-select" name="customer_id" id="customer_id">
                                <option value="all" selected="" @if('all' == $customer_id) selected @endif >All
                                </option>
                                @foreach($usersList as $obj)
                                <option @if($obj->CustomerID == $customer_id) selected @endif value="{{$obj->CustomerID}}">{{$obj->CustomerName}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-2 mb-2">
                            <label for="">Select Start Date</label>
                            <input type="date" name="start_date" id="start_date" class="form-control"
                                value="{{ $start_date }}">
                        </div>

                        <div class="col-2">
                            <label for="">Select End Date</label>
                            <input type="date" name="end_date" id="end_date" class="form-control"
                                value="{{ $end_date }}">
                        </div>
                        <div class="col-2">
                            <div class="form-group mb-0">
                                <button type="submit" class="btn btn-2 bg-gradient-info btn-1 mr-2" style="color:white;margin-top: 30px;">Submit</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Expense </h3>
                            <div class="card-tools">

                            </div>
                        </div>
                        <div class="card-body table-responsive">
                            {{ $dataTable->table() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<div id="overlay">
    <div class="cv-spinner">
        <span class="spinner"></span>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.umd.js"></script>
{{ $dataTable->scripts() }}
<script>
    function showImages(expenceData,images) {
        console.log(images,expenceData);
  // Build Fancybox slides
  const slides = images.map(img => ({
        src: img,   // large image
        thumb: img  // optional thumbnail
    }));

    // Show gallery
    Fancybox.show(slides, {
        Thumbs: {
            autoStart: true
        }
    });
    }
$(document).ready(function () {

    $(document).on('click', ".expence-images-btn", function (e) {
        const expenceData = $(this).data('expence-data');
        const images = $(this).data('images');
        showImages(expenceData,images);
    });
    // $(document).on('click', ".ajaxModelOpenBtn", function (e) {
    //     e.preventDefault();
    //     const Url = $(this).data('url')
    //     const btn = $(this);
    //     if ((Url !== undefined && Url !== null)) {
    //         setAjaxLoader(btn, true);
    //         $.ajax({
    //             type: "POST",
    //             url: Url,
    //             headers: {
    //                 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
    //                     'content')
    //             },
    //             success: function (response) {
    //                 setAjaxLoader(btn, false);

    //                 console.log(response);
    //                 if (response.status) {

    //                     $('body').find('#ajaxModal').remove();
    //                     $('body').append(response.html);
    //                     $('body').find('#ajaxModal').modal('show');
    //                     if (window['afterOpenAjaxModal']) {
    //                         window['afterOpenAjaxModal']();
    //                     }

    //                 } else {
    //                     Swal.fire('Error!', response.message,
    //                         'error');
    //                 }
    //             },
    //             error: function (xhr) {
    //                 setAjaxLoader(btn, false);

    //                 var error = xhr.responseJSON;
    //                 if (xhr.status == 422) {
    //                     Object.entries(error.error).forEach(function (item, index) {
    //                         const [key, value] = item;
    //                         form.find(`.${key}-error`).html(value);
    //                     })
    //                 } else {
    //                     Swal.fire('Error!', error.message,
    //                         'error');
    //                 }


    //             }
    //         });
    //     }
    // })
});


function setAjaxLoader(btn, state) {
    var text = btn.find(".submit-text");
    var loader = btn.find(".submit-loader");
    if (state) {
        loader.show()
        btn.prop("disabled", true);
    } else {
        btn.prop("disabled", false);
        loader.hide()
    }
}
</script>
@endpush
@endsection
