@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Event/Folder</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('event.list') }}">Event/Folder List</a></li>
                        <li class="breadcrumb-item active">Edit Event/Folder</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('event.editeventstore') }}" name="form" enctype="multipart/form-data">
                                @csrf
                                <input type='hidden' name="id" value="{{isset($get_data->id) ? $get_data->id : ''}}">
                                <div class="form-group">
                                    <label for="">Event/Folder Name</label>
                                    <input type="text" name="eventname" class="form-control" id="" placeholder="Enter Event/Folder Name"
                                        value="{{$get_data->event_name}}" >
                                </div>
                                <div class="form-group">
                                    <label for="">City</label>
                                    <input type="text" name="city" class="form-control" id="" placeholder="Enter City Name"
                                        value="{{$get_data->city}}">
                                </div>
                                <div class="form-group">
                                    <label for="">Details</label>
                                    <input type="text" name="details" class="form-control" id="" placeholder="Enter details "
                                        value="{{$get_data->details}}" >
                                </div>
                                <div class="form-group">
                                    <label for="" >Start Date</label>
                                    <input type="date" name="start_date" class="form-control" id="" placeholder="Enter Start Date "
                                        value="{{isset($get_data->start_date) ? \Carbon\Carbon::parse($get_data->start_date)->format('Y-m-d') : $now}}" >
                                </div>
                                <div class="form-group">
                                    <label for="">End Date</label>
                                    <input type="date" name="end_date" class="form-control" id="" placeholder="Enter End Date "
                                        value="{{isset($get_data->end_date) ? \Carbon\Carbon::parse($get_data->end_date)->format('Y-m-d') : $now}}" >
                                </div>
                                <input type="hidden" name="type_show_all" value="{{$get_data->type_show_all}}">
                                <!-- <div class="form-group">
                                    <label for="">Show all Clients</label>&nbsp;&nbsp;&nbsp;
                                    <input type="radio" name="type_show_all" id=""  value="true" {{ $get_data->type_show_all == 'true' ? 'checked' : '' }}>
                                    <label for="">Yes</label>
                                    <input type="radio" name="type_show_all" id="" value="false" {{ $get_data->type_show_all == 'false' ? 'checked' : '' }}> <label for="">No</label>
                                </div> -->
                                @if($integrationConfigCount > 0)
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label for="">Facebook Form Names</label> <span class="text-secondary">(Form name should exactly match on meta)</span>
                                            <input type="text" class="form-control" id="meta_form_name" placeholder="Enter Meta Form Name"
                                                value="">
                                                <span class="text-danger meta_form_name_error" ></span>

                                        </div>
                                    </div>
                                    <div class="col-2">
                                    <div style="height: 100%;display: flex;align-items: center;padding-top: 10px;">
                                        <button type="button" class="btn btn-primary"  id="add_meta_form">Add</button>

                                    </div>
                                    </div>
                                </div>
                                <div class="formsContainer mb-3 d-flex flex-wrap gap-2">

                                </div>
                                @endif
                                <div class="card-footer">
                                <button type="submit" class="btn btn-primary" >Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    function addMetaForm(name){
        let html = `
        <div class="meta-form-item" style="background-color: #E2E8F0;padding:5px;display: flex;flex-direction: row;gap: 10px;border: 1px solid #ccc;border-radius: 5px;width:fit-content;">
                                        <div class="text-center" style="vertical-align: middle;">
                                            <div class="meta-form-name">${name}</div>
                                            <input type="hidden" class="meta-form-input" name="metaForms[]" value="${name}">
                                        </div>
                                        <div class="">
                                            <button type="button" class="btn btn-danger btn-sm remove_meta_form" style="padding: 0px 6px;border-radius: 10px;"><i class="fas fa-times"></i></button>
                                        </div>
                                    </div>
        `;
        $(".formsContainer").append(html);
    }

    @if(!empty($meta_forms))
        @foreach($meta_forms as $meta_form)
            addMetaForm(@json($meta_form?->form_name));
        @endforeach
    @endif
    $(document).ready(function(){
        $('#add_meta_form').click(function(){
            let name = $("#meta_form_name").val();
            let nameArray = [];
            $(".meta_form_name_error").text("");
            $(".meta-form-input").each((elem,item)=>{
                nameArray.push(item.value);
            })
            let flag = true;
            if(nameArray.includes(name)){
                $(".meta_form_name_error").text("Form name already exists");
                flag = false;
            }
            if(name.length == 0){
                $(".meta_form_name_error").text("Form name is required");
                flag = false;
            }
            if(flag){
                addMetaForm(name);
                $("#meta_form_name").val("");
            }
        });
        $(document).on("click", ".remove_meta_form", function(){
            $(this).parents(".meta-form-item").remove();
            console.log("remove",$(this).parents(".meta-form-item"));
        });
    });
</script>
@endpush
