<div class="modal fade bd-example-modal-lg" id="sendEmail_Modal" tabindex="-1" role="dialog"
    aria-labelledby="sendEmailModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="sendEmailModalLabel">{{ $title }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{route('send.email')}}" id="sendEmailDataForm" method="post" enctype='multipart/form-data'>
                @csrf
                <input type="hidden" name="visitor_id" id="visitor_id" value="{{$visitor_id}}">
                <div class="modal-body">
                    <!-- Radio buttons for choosing between Action and Category -->
                    <label>Select Email Type:</label><br>
                    <div class="form-group d-flex">                       
                        <div>
                            <input type="radio" id="actionRadio" name="selection" value="action" checked>
                            <label for="actionRadio">Action</label><br>
                        </div>
                        <div class="ml-2">
                            <input type="radio" id="categoryRadio" name="selection" value="category">
                            <label for="categoryRadio">Category</label>
                        </div>
                    </div>

                    <!-- Dropdowns for Action and Category -->
                    <div class="form-group" id="actionDropdown">
                        <label for="actionSelect">Action:</label>
                        <select id="actionSelect" name="email_type_action" class="form-control">
                             <option value="primary">Primary</option>
                            @foreach ($actionList as $id => $action)                           
                                <option value="{{ $action }}">{{ $action }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group" id="categoryDropdown" style="display: none;">
                        <label for="categorySelect">Category:</label>
                        <select id="categorySelect" name="email_type_category" class="form-control">
                            @foreach ($categoryList as $id => $name)
                                <option value="{{ $name }}">{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="sendEmailDataBtn">Send Email</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        // Function to show/hide dropdowns based on radio button selection
        function toggleDropdowns() {
            var isActionSelected = $('#actionRadio').is(':checked');

            if (isActionSelected) {
                $('#actionDropdown').show();
                $('#categoryDropdown').hide();
            } else {
                $('#actionDropdown').hide();
                $('#categoryDropdown').show();
            }
        }

        // Initialize the dropdown visibility based on the default selected radio button
        toggleDropdowns();

        // Add event listeners to radio buttons using jQuery
        $('input[name="selection"]').on('change', function() {
            toggleDropdowns();
        });
    });
</script>
