@extends('layouts.master')
@section('content')
    <style>
        .cke_button__customimageupload_icon {
            background-image: url('{{ asset('assets/images/dashboard_icons/file.png') }}');
            background-size: cover;
            width: 16px;
            height: 16px;
            border: none;
            display: inline-block;
        }

        /* Container for radio buttons and labels */
        .radio-group {
            display: flex;
            align-items: center;
            gap: 10px;
            /* Space between radio buttons and labels */
        }

        /* Style for individual radio buttons */
        .radio-large {
            transform: scale(1.5);
            /* Adjust size here (1.5 means 150%) */
            margin-right: 5px;
            /* Space between radio button and label */
        }

        /* Optional: Adjust label for better alignment */
        .radio-label {
            display: inline-block;
            vertical-align: middle;
            /* Align label with radio button */
        }
        #cke_notifications_area_content{
            display: none !important;
        }
    </style>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Add Email Draft</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('emails.index') }}">Email Draft</a></li>
                            <li class="breadcrumb-item active">Add Email Draft</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <!-- Default box -->
                        <div class="card">
                            <div class="card-header">
                                <!-- <h3 class="card-title">Select Members For </h3> -->
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                        title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="card-body">
                                <form method="post" action="{{ route('emails.store') }}" name="form"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="radio_type" id="radio_type">
                                    <div class="form-group radio-group ml-3">
                                        <input type="radio" name="etype" id="action" class="radio-large" checked>
                                        <label style="margin-top: 6px;" for="action" class="radio-label">Action</label>
                                        <input type="radio" name="etype" id="category" class="radio-large">
                                        <label style="margin-top: 6px;" for="category" class="radio-label">Category</label>
                                    </div>
                                    
                                    <div class="ml-3" id="actionList">
                                        <label class="form-label emailLabel">Select Email Type</label>
                                        <select class="form-control col-lg-10" name="email_action_type">
                                            <!-- <option value="" selected disabled>Select Email Type</option> -->
                                            <option value="primary" selected>Primary</option>
                                            @foreach ($actionList as $action)
                                                <option value="{{ $action->title }}">
                                                    {{ $action->title }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <div class="ml-3" id="categoryList">
                                        <label class="form-label emailLabel">Select Email Type</label>
                                        <select class="form-control col-lg-10" name="email_category_type">
                                            <option value="" selected disabled>Select Email Type</option>
                                            @foreach ($categoryList as $c => $category)
                                                <option value="{{ $category }}" {{ old('email_category_type') == $category ? 'selected' : '' }}>
                                                    {{ $category }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                    <div class="form-group ml-3">
                                        <label class="form-label">Subject</label>
                                        <input type="text" name="subject" class="form-control col-lg-10" id="subject"
                                        value="{{ old('subject', $emails->subject ?? '') }}" placeholder="Enter Subject" required>
                                    </div>
                                    <div class="form-group ml-3">
                                        <label class="form-label">Content</label>
                                        <textarea class="editor" cols="30" rows="30" name="content" id="content">{{ empty($emails->content) ? $body : $emails->content   }}</textarea>
                                    </div>
                                    <div class="form-group ml-3">
                                        <label class="form-label">Attachment</label>
                                        <input class="form-control col-lg-10" type="file" name="attachment[]"
                                            id="attachment" multiple>
                                    </div>
                                    <div class="card-footer">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            function updateVisibilityAndRequirements() {
                if ($('#action').is(':checked')) {
                    $('#actionList').show();
                    $('#categoryList').hide();
                    $('#email_action_type').prop('required', true);
                    $('#email_category_type').prop('required', false);
                    $('#radio_type').val('action')
                } else if ($('#category').is(':checked')) {
                    $('#actionList').hide();
                    $('#categoryList').show();
                    $('#email_action_type').prop('required', false);
                    $('#email_category_type').prop('required', true);
                    $('#radio_type').val('category')
                }
            }
    
            // Attach change event listener to radio buttons
            $('input[type=radio][name=etype]').change(updateVisibilityAndRequirements);
    
            // Initialize visibility and requirements on page load
            updateVisibilityAndRequirements();
        });
    </script>

    <script>
        $(document).ready(function() {
            // CKEDITOR.replace( 'content' );
            CKEDITOR.replace('content', {
                extraPlugins: 'customImageUpload',
                height: 500
            });
        });

        (function() {
            CKEDITOR.plugins.add('customImageUpload', {
                icons: 'image',
                init: function(editor) {
                    // Add the command for uploading images
                    editor.addCommand('uploadImage', {
                        exec: function(editor) {
                            var fileInput = document.createElement('input');
                            fileInput.type = 'file';
                            fileInput.accept = 'image/*';
                            fileInput.onchange = function(event) {
                                var file = event.target.files[0];
                                var formData = new FormData();
                                formData.append('image', file);

                                $.ajax({
                                    type: 'POST',
                                    url: "{{ route('email-upload-image') }}",
                                    data: formData,
                                    cache: false,
                                    contentType: false,
                                    processData: false,
                                    headers: {
                                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]')
                                            .attr('content')
                                    },
                                    success: function(data) {
                                        if (data.status === 200 && data.url) {
                                            // Open the image dialog and set the URL field
                                            // editor.execCommand('image');
                                            // editor.once('dialogShow', function(evt) {
                                            //     var dialog = evt.data;
                                            //     if (dialog.getName() === 'image') {
                                            //         var urlField = dialog.getContentElement('info', 'url');
                                            //         if (urlField) {
                                            //             urlField.setValue(data.url);
                                            //         }
                                            //     }
                                            // });
                                            if (data.status === 200 && data
                                                .url) {
                                                editor.insertHtml('<img src="' +
                                                    data.url +
                                                    '" alt="Image">');
                                            } else {
                                                alert('Image upload failed!');
                                            }

                                        } else {
                                            alert('Image upload failed!');
                                        }
                                    },
                                    error: function(xhr, status, error) {
                                        console.error('Upload failed:', error);
                                        alert('Image upload failed!');
                                    }
                                });
                            };
                            fileInput.click();
                        }
                    });

                    // Add a custom button to the image dialog
                    CKEDITOR.on('dialogDefinition', function(ev) {
                        var dialogName = ev.data.name;
                        var dialogDefinition = ev.data.definition;

                        if (dialogName === 'image') {
                            var infoTab = dialogDefinition.getContents('info');
                            infoTab.elements.push({
                                type: 'button',
                                id: 'uploadImageButton',
                                label: 'Upload Image',
                                filebrowser: {
                                    action: 'Upload',
                                    url: '{{ route('email-upload-image') }}',
                                    title: 'Upload Image'
                                },
                                onClick: function() {
                                    editor.execCommand('uploadImage');
                                }
                            });
                        }
                    });

                    // Add the custom button to the toolbar
                    editor.ui.addButton('CustomImageUpload', {
                        label: 'Upload Image',
                        command: 'uploadImage',
                        toolbar: 'insert',
                        icon: 'customimageupload' // Referencing the CSS class for your custom icon
                    });
                }
            });
        })();


        // ClassicEditor
        // .create( document.querySelector( '#content' ), {
        //     toolbar: [ 'bold', 'italic' ]
        // } )
        // .then( editor => {
        //     console.log( 'Editor was initialized', editor );
        // } )
        // .catch( error => {
        //     console.error( error.stack );
        // } );
    </script>
@endsection
