@extends('layouts.master')
@section('content')
<style>
    #category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }

    #modal-category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }

    .error {
        color: red;
    }

    .password-wrapper {
        position: relative;
        display: flex;
        align-items: center;
        /* Center align items vertically */
        height: 2.5em;
        /* Adjust based on your input field height */
    }

    .password-toggle {
        position: absolute;
        right: 10px;
        cursor: pointer;
        font-size: 1.2em;
        z-index: 1;
        /* Ensure it's on top of other elements */
    }

    input.form-control {
        padding-right: 40px;
        /* Add padding to ensure text does not overlap with the icon */
    }
    #overlay {
        position: fixed;
        top: 0;
        z-index: 1070;
        width: 100%;
        height: 100%;
        display: none;
        background: rgba(0, 0, 0, 0.6);
    }

    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Category List</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Category</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="card-body">
                <form method="get" id="myform" name="myform" action="{{ route('category.list') }}" enctype="multipart/form-data">
                    <input type="hidden" value="" name="type" id="formType">
                    <div class="form-group row">
                        <div class="col-2">
                            <label for="">Select Category</label>
                            <select class="form-control custom-select" name="category_id" id="category_id">
                                <option value="all" selected="">All
                                </option>
                                @foreach($categories as $key => $value)
                                <option @if($key == request()->get('category_id')) selected @endif value="{{$key}}">{{$value}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-2 bg-gradient-info btn-1" style="color:white;">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Category</h3>
                            <div class="card-tools">
                                <a onclick="openAddCategoryModal(this)" data-url="{{ route('category.add') }}" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Add Category</a>
                            </div>
                        </div>
                        <div class="card-body table-responsive">
                            {{ $dataTable->table() }}
                        </div>
                    </div>
                </div>
                <!-- <div class="col-4" style="margin-top: -100px;">
                    <img style="width: 800px;height:800px;" src="https://frenzinsoftwares.com/frenzincrm_help/category.gif" alt="category.gif">

                </div> -->
            </div>
        </div>
    </div>
</div>

<!-- Add Category Modal -->
<div class="modal fade" id="addCategoryModal" tabindex="-1" role="dialog" aria-labelledby="addCategoryModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="addCategoryContent">
            <div class="modal-header">
                <h5 class="modal-title" id="addCategoryModalLabel">Add Category</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('category.store') }}" method="POST" id="addCategoryForm">
                    <input type="hidden" name="action" value="insert">
                    @csrf
                    <div class="form-group" id="category-names-container">
                        <label for="">Category Name</label>
                        <input type="text" class="form-control" id="category-name-1"
                            placeholder="Enter Category Name"
                            name="name[]"
                            value="{{ old('name') }}" required>

                        @if($errors->has('name'))
                            <div class="form-text text-danger">{{ $errors->first('name') }}</div>
                        @endif
                    </div>

                    <div class="card-footer">
                        <div class="col-md-4 mt-30 append-buttons float-right">
                            <div class="clearfix">
                                <button type="button" id="add-button" class="btn btn-success float-left text-uppercase shadow-sm">
                                    <i class="fa fa-plus fa-fw"></i>Add
                                </button>
                                <button type="button" id="remove-button" class="btn btn-danger float-left text-uppercase ml-1" disabled>
                                    <i class="fa fa-minus fa-fw"></i>Remove
                                </button>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Add</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Edit Category Modal -->
<div class="modal fade" id="editCategoryModal" tabindex="-1" role="dialog" aria-labelledby="editCategoryModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content" id="editCategoryContent">
        </div>
    </div>
</div>

<!-- SubCategory Modal -->
<div class="modal fade" id="subCategoryModal" tabindex="-1" role="dialog" aria-labelledby="subCategoryModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="subCategoryContent">
        </div>
    </div>
</div>

<div id="overlay">
    <div class="cv-spinner">
        <span class="spinner"></span>
    </div>
</div>

@push('scripts')
{{ $dataTable->scripts() }}
<script>
    $(document).ready(function() {
        var categoryCount = 1; // Start with one input field for category name

        // Handle Add button click event
        $('#add-button').click(function() {
            categoryCount++;

            // Clone the first input field and update the name attribute
            var newInput = $('#category-names-container input:first').clone();
            newInput.val(''); // Clear the value of the cloned input field

            newInput.removeAttr('required');
            // Update the name attribute to ensure all inputs are part of the 'name[]' array
            newInput.attr('name', 'name[]');

            // Append the cloned input field to the container
            $('#category-names-container').append(newInput);

            // Enable remove button after adding a new input field
            $('#remove-button').prop('disabled', false);
        });

        // Handle Remove button click event
        $('#remove-button').click(function() {
            if (categoryCount > 1) {
                // Remove the last input field
                $('#category-names-container input').last().remove();
                categoryCount--;
            }

            // Disable remove button if only one input field is left
            if (categoryCount <= 1) {
                $('#remove-button').prop('disabled', true);
            }
        });
    });
</script>
<script>
    
    function openSubCategoryModal(elm) {
        // alert('hi'); return false;
        $("#overlay").fadeIn(300);
        let url = $(elm).data('url');
        $.ajax({
            url: url,
            method: 'GET',
            success: function (result) {
                $('#subCategoryContent').html(result.html);
                $('#subCategoryModal').modal('show');
                setTimeout(function() {
                    $("#overlay").fadeOut(300);
                }, 500);
            }, error: function (error) {
                console.log(error);
            }
        });
    }

    function openEditCategoryModal(elm) {
        // alert('hi'); return false;
        $("#overlay").fadeIn(300);
        let url = $(elm).data('url');
        $.ajax({
            url: url,
            method: 'GET',
            success: function (result) {
                $('#editCategoryContent').html(result.html);
                $('#editCategoryModal').modal('show');
                setTimeout(function() {
                    $("#overlay").fadeOut(300);
                }, 500);
            }, error: function (error) {
                console.log(error);
            }
        });
    }

    function openAddCategoryModal(elm) {
        $('#addCategoryModal').modal('show');
    }

    $(document).ready(function() {

        $('#addCategoryCloseBtn').click(function() {
            $('#addCategoryForm')[0].reset();
            $('.error').html('')
            $('#addCategoryModal').modal('hide');
        });

        $('#addCategoryForm').validate({
            rules: {
                name: {
                    required: true,
                }
            },
            errorPlacement: function(error, element) {
                error.insertAfter(element);
            },
            submitHandler: function(form) {
                $("#overlay").fadeIn(300);
                // alert('ajax call');
                // return;
                // console.log($('#addCategoryForm').serialize()); return false;
                $.ajax({
                    url: "{{ route('category.store') }}",
                    type: "POST",
                    data: $('#addCategoryForm').serialize(),
                    success: function(response) {
                        // console.log(response.status);
                        if (response.status) {
                            swal({
                                title: "Success!",
                                text: response.message,
                                icon: "success"
                            });
                            $('#addCategoryForm')[0].reset();
                            $('#addCategoryModal').modal('hide');
                            window.LaravelDataTables["category-table"].ajax.reload();
                        }
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                    },
                    error: function(data) {
                        console.log(data);
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                    }
                });
            }
        });

    });
</script>

@endpush
@endsection