@extends('layouts.app')

@section('content')
<style>
.error {
    color: red;
}
#overlay {
    position: fixed;
    top: 0;
    z-index: 1070;
    width: 100%;
    height: 100%;
    display: none;
    background: rgba(0, 0, 0, 0.6);
}

.cv-spinner {
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
}

.spinner {
    width: 40px;
    height: 40px;
    border: 4px #ddd solid;
    border-top: 4px #2e93e6 solid;
    border-radius: 50%;
    animation: sp-anime 0.8s infinite linear;
}
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Reset Password') }}</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    <form method="POST" id="passwordSendOtpForm">
                        @csrf

                        <div class="row mb-3">
                            <label for="phone" class="col-md-4 col-form-label text-md-end">{{ __('Mobile Number') }}</label>

                            <div class="col-md-6">
                                <input id="phone" maxlength="10" type="text" class="form-control @error('phone') is-invalid @enderror" name="phone" value="{{ old('phone') }}" required>

                                @error('phone')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('Submit') }}
                                </button>
                            </div>
                        </div>

                        <div class="row mt-1 mb-0">
                            <div class="col-md-6 offset-md-4">
                                <div class="error" id="cf-response-message"></div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="passwordResetModal" tabindex="-1" role="dialog" aria-labelledby="passwordResetModalLabel"
aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="passwordResetModalLabel">Enter OTP & New Password</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="passwordResetForm" data-url="{{ route('password.newCreate') }}" method="post">
                    @csrf
                    <input type="hidden" name="id" id="modalId" class="form-control" value="">
                    <input type="hidden" name="phone" id="modalPhone" class="form-control" value="">
                    <div class="form-group">
                        <label for="">Otp</label>
                        <input type="text" name="otp" class="form-control" id="modalOtp" value=""
                            required>
                    </div>
                    <div class="form-group">
                        <label for="new_password">New Password</label>
                        <input type="password" name="new_password" class="form-control" id="modalNewPassword" value=""
                            required>
                    </div>
                    <div class="form-group">
                        <label for="confirm_password">Confirm Password</label>
                        <input type="password" name="confirm_password" class="form-control" id="modalConfirmPassword" value=""
                            required>
                        <div class="error" id="otp-message"></div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" id="passwordResetBtn"  class="btn btn-primary">Submit</button>
            </div>
            </form>
        </div>
    </div>
</div>

<div id="overlay">
    <div class="cv-spinner">
        <span class="spinner"></span>
    </div>
</div>

<script>
    // $('#passwordResetForm').reset();
    // $('#cf-response-message').text(' ');
    $('#passwordResetForm').validate({
        rules: {
            phone: {
                required: true,
                digits: true, 
                maxlength: 10,
                minlength: 10,
            },
            otp: {
                required: true,
            },
            new_password: {
                minlength: 6,
            },
            confirm_password: {
                minlength: 6,
                equalTo: '[name="new_password"]'
            }
        },
        errorPlacement: function(error, element) {
            error.insertAfter(element);
        },
        submitHandler: function(form) {
            // alert('ajax call');
            $("#overlay").fadeIn(300);
            // console.log($('#passwordResetForm').serialize()); return false;
            $.ajax({
                url: '{{ route('password.newCreate') }}',
                type: "POST",
                data: $('#passwordResetForm').serialize(),
                success: function(response) {
                    if (response) {
                        if (!response.status) {
                            $('#otp-message').text(response.message);
                        }else{
                            $('#passwordResetModal').modal('hide');
                            window.location.href = response.redirectPath;
                        }
                    }
                    setTimeout(function() {
                        $("#overlay").fadeOut(300);
                    }, 500);
                },
                error: function(data) {
                    console.log(data);
                    $('#otp-message').text(data.responseText);
                    setTimeout(function() {
                        $("#overlay").fadeOut(300);
                    }, 500);
                }
            });
        }
    });
    $('#passwordSendOtpForm').validate({
        rules: {
            phone: {
                required: true,
                digits: true, 
                maxlength: 10,
                minlength: 10,
            }
        },
        errorPlacement: function(error, element) {
            error.insertAfter(element);
        },
        submitHandler: function(form) {
            // alert('ajax call');
            $("#overlay").fadeIn(300);
            // console.log($('#registerForm').serialize()); return false;
            $.ajax({
                url: '{{ route('password.getOtp') }}',
                type: "POST",
                data: {
                    "_token": "{{ csrf_token() }}",
                    "mobile": $('#phone').val()
                },
                success: function(response) {
                    // console.log(response.status);
                    if (response) {
                        $('#cf-response-message').text(response.message);
                    }
                    if (response.status) {
                        $('#modalPhone').val($('#phone').val());
                        $('#passwordResetModal').modal('show');
                    }
                    setTimeout(function() {
                        $("#overlay").fadeOut(300);
                    }, 500);
                },
                error: function(data) {
                    console.log(data);
                    $('#cf-response-message').text(data.responseText);
                    setTimeout(function() {
                        $("#overlay").fadeOut(300);
                    }, 500);
                }
            });
        }
    });

    $('#passwordResetModal').on('hidden.bs.modal', function () {
        $('#passwordResetForm').reset();
        $('#cf-response-message').text(' ');
    });
</script>

@endsection
