@extends('layouts.master')
@section('content')
<style>
    #category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }

    #modal-category-names-container input {
        margin-bottom: 10px;
        /* Add margin at the bottom of each input field */
    }

    .error {
        color: red;
    }

    .password-wrapper {
        position: relative;
        display: flex;
        align-items: center;
        /* Center align items vertically */
        height: 2.5em;
        /* Adjust based on your input field height */
    }

    .password-toggle {
        position: absolute;
        right: 10px;
        cursor: pointer;
        font-size: 1.2em;
        z-index: 1;
        /* Ensure it's on top of other elements */
    }

    input.form-control {
        padding-right: 40px;
        /* Add padding to ensure text does not overlap with the icon */
    }
    #overlay {
        position: fixed;
        top: 0;
        z-index: 1070;
        width: 100%;
        height: 100%;
        display: none;
        background: rgba(0, 0, 0, 0.6);
    }

    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }
    .select2-container{
        width: 100% !important;
        height: 40px !important;

    }
    .select2-container--default.select2-container--focus .select2-selection--multiple, .select2-container--default.select2-container--focus .select2-selection--single
    {
        height: 40px !important;
    }

    .select2-container .select2-selection--single {
        height: 38px !important;
    }

</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Areas List</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Areas</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Areas </h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-primary btn-sm ajaxModelOpenBtn" data-after-ajax-call="afterOpenAjaxModal" data-url="{{ route('areas.addEdit', null) }}">
                                    <span class="submit-text">Add Area</span>
                                    <div class="spinner-border text-light submit-loader" role="status"
                                        style="width:16px;height:16px;display:none;">
                                        <span class="visually-hidden"></span>
                                    </div>
                                </button>
                                <button type="button" class="btn btn-warning btn-sm ajaxModelOpenBtn" data-url="{{ route('areas.importOpen') }}">
                                    <span class="submit-text">Import Area</span>
                                    <div class="spinner-border text-light submit-loader" role="status"
                                        style="width:16px;height:16px;display:none;">
                                        <span class="visually-hidden"></span>
                                    </div>
                                </button>
                                <a href="{{ route('areas.exportArea') }}" class="btn btn-success btn-sm">Export Area</a>
                            </div>
                        </div>
                        <div class="card-body table-responsive">
                            {{ $dataTable->table() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<div id="overlay">
    <div class="cv-spinner">
        <span class="spinner"></span>
    </div>
</div>

@push('scripts')
{{ $dataTable->scripts() }}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{{ asset('js/commonAjax.js') }}"></script>
<script>

function afterAreaStore(form, btn, response) {
    if (response.status) {
        $(".dataTable").DataTable().ajax.reload();
        // Swal.fire('Success!', response?.message, 'success');
    }
}

function afterImportArea(form, btn, response) {
    if (response.status) {
        $(".dataTable").DataTable().ajax.reload();
        // Swal.fire('Success!', response?.message, 'success');
    }
}
function afterOpenAjaxModal(btn, response, data) {
    $('#city_name').select2({
        dropdownParent: $('body').find('#ajaxModal')
    });
    console.log(response);
}
</script>
@endpush
@endsection
