@extends('layouts.master')
@section('content')
<style>
    .error {
        color: red;
    }

    .password-wrapper {
        position: relative;
        display: flex;
        align-items: center;
        /* Center align items vertically */
        height: 2.5em;
        /* Adjust based on your input field height */
    }

    .password-toggle {
        position: absolute;
        right: 10px;
        cursor: pointer;
        font-size: 1.2em;
        z-index: 1;
        /* Ensure it's on top of other elements */
    }

    input.form-control {
        padding-right: 40px;
        /* Add padding to ensure text does not overlap with the icon */
    }
    #overlay {
        position: fixed;
        top: 0;
        z-index: 1070;
        width: 100%;
        height: 100%;
        display: none;
        background: rgba(0, 0, 0, 0.6);
    }

    .cv-spinner {
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px #ddd solid;
        border-top: 4px #2e93e6 solid;
        border-radius: 50%;
        animation: sp-anime 0.8s infinite linear;
    }
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Action List</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Action</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Action</h3>
                            <div class="card-tools">
                                <a onclick="openAddActionModal(this)" data-url="{{ route('action.add') }}" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Add Action</a>
                            </div>
                        </div>
                        <div class="card-body table-responsive">
                            {{ $dataTable->table() }}
                        </div>
                    </div>
                </div>

                <!-- <div class="col-4" style="margin-top: -50px;">
                    <img style="width: 800px;height:800px;" src="https://frenzinsoftwares.com/frenzincrm_help/actions.gif" alt="actions.gif">
                </div> -->
            </div>
        </div>
    </div>
</div>

<!-- Add Action Modal -->
<div class="modal fade" id="addActionModal" tabindex="-1" role="dialog" aria-labelledby="addActionModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content" id="addActionContent">
        <div class="modal-header">
            <h5 class="modal-title" id="addActionModalLabel">Add Action</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form action="{{ route('action.store') }}" method="POST" id="addActionForm">
                @csrf
                <div class="form-group">
                    <label for="">Title Name</label>
                    <input type="text" name="title" class="form-control" id="title" placeholder="Enter Title Name"
                        value="{{ old('title') }}" required>
                    @if($errors->has('title'))
                        <div class="form-text text-danger">{{ $errors->first('title') }}</div>
                    @endif
                </div>
                <div class="form-group">
                    <label for="">WhatsApp Message</label>
                    <textarea name="description" id="description" class="form-control" placeholder="Enter WhatsApp Message" cols="30" rows="10" required>{{ old('description') }}</textarea>
                    @if($errors->has('description'))
                        <div class="form-text text-danger">{{ $errors->first('description') }}</div>
                    @endif
                </div>

        </div>
        <div class="modal-footer">
            <button type="button" id="addActionCloseBtn" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" id="addActionSubmitBtn"  class="btn btn-primary">Submit</button>
        </div>
        </form>
        </div>
    </div>
</div>

<!-- Edit Action Modal -->
<div class="modal fade" id="editActionModal" tabindex="-1" role="dialog" aria-labelledby="editActionModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content" id="editActionContent">
        </div>
    </div>
</div>

<div id="overlay">
    <div class="cv-spinner">
        <span class="spinner"></span>
    </div>
</div>

@push('scripts')
{{ $dataTable->scripts() }}

<script>
    
    function openEditActionModal(elm) {
        // alert('hi'); return false;
        $("#overlay").fadeIn(300);
        let url = $(elm).data('url');
        $.ajax({
            url: url,
            method: 'GET',
            success: function (result) {
                $('#editActionContent').html(result.html);
                $('#editActionModal').modal('show');
                setTimeout(function() {
                    $("#overlay").fadeOut(300);
                }, 500);
            }, error: function (error) {
                console.log(error);
            }
        });
    }

    function openAddActionModal(elm) {
        $('#addActionModal').modal('show');
    }

    $(document).ready(function() {

        $('#addActionCloseBtn').click(function() {
            $('#addActionForm')[0].reset();
            $('.error').html('')
            $('#addActionModal').modal('hide');
        });

        $('#addActionForm').validate({
            rules: {
                title: {
                    required: true,
                },
                description: {
                    required: true,
                }
            },
            errorPlacement: function(error, element) {
                error.insertAfter(element);
            },
            submitHandler: function(form) {
                $("#overlay").fadeIn(300);
                // alert('ajax call');
                // return;
                // console.log($('#addActionForm').serialize()); return false;
                $.ajax({
                    url: "{{ route('action.store') }}",
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "action": 'insert',
                        "title": $('#title').val(),
                        "description": $('#description').val()
                    },
                    success: function(response) {
                        // console.log(response.status);
                        if (response.status) {
                            swal({
                                title: "Success!",
                                text: response.message,
                                icon: "success"
                            });
                            $('#addActionForm')[0].reset();
                            $('#addActionModal').modal('hide');
                            window.LaravelDataTables["action-table"].ajax.reload();
                        }
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                    },
                    error: function(data) {
                        console.log(data);
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                    }
                });
            }
        });

    });
</script>

@endpush
@endsection

