<div class="modal-header">
    <h5 class="modal-title" id="addEditActionModalLabel">Edit Action</h5>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<div class="modal-body">
    <form data-url="{{ route('action.store') }}" method="POST" id="editActionForm">
        <input type="hidden" name="action" value="{{ empty($Action) ? 'insert' : 'update' }}">
        <input type="hidden" id="editId" name="id" value="{{ $Action->id ?? 0 }}">
        @csrf
        <div class="form-group">
            <label for="">Title Name</label>
            <input type="text" name="title" class="form-control" id="editTitle" placeholder="Enter Title Name"
                value="{{ empty($Action) ? old('title') : $Action->title }}" required>
            @if($errors->has('title'))
                <div class="form-text text-danger">{{ $errors->first('title') }}</div>
            @endif
        </div>
        <div class="form-group">
            <label for="">WhatsApp Message</label>
            <textarea name="description" id="editDescription" class="form-control" placeholder="Enter WhatsApp Message" cols="30" rows="10" required>{{ empty($Action) ? old('description') : $Action->description }}</textarea>
            @if($errors->has('description'))
                <div class="form-text text-danger">{{ $errors->first('description') }}</div>
            @endif
        </div>
        <div class="modal-footer">
            <button type="button" id="editActionCloseBtn" class="btn btn-secondary">Close</button>
            <button type="submit" id="editSubmitBtn"  class="btn btn-primary">Submit</button>
        </div>
    </form>
</div>

<script>
    $(document).ready(function() {
    
        $('#editActionForm').validate({
            rules: {
                title: {
                    required: true,
                },
                description: {
                    required: true,
                }
            },
            errorPlacement: function(error, element) {
                error.insertAfter(element);
            },
            submitHandler: function(form) {
                $("#overlay").fadeIn(300);
                // alert('ajax call');
                // return;
                // console.log($('#addActionForm').serialize()); return false;
                $.ajax({
                    url: "{{ route('action.store') }}",
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "id": $('#editId').val(),
                        "action": 'update',
                        "title": $('#editTitle').val(),
                        "description": $('#editDescription').val()
                    },
                    success: function(response) {
                        // console.log(response.status);
                        if (response.status) {
                            swal({
                                title: "Success!",
                                text: response.message,
                                icon: "success"
                            });
                            $('#editActionModal').modal('hide');
                            window.LaravelDataTables["action-table"].ajax.reload();
                        }
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                    },
                    error: function(data) {
                        console.log(data);
                        setTimeout(function() {
                            $("#overlay").fadeOut(300);
                        }, 500);
                    }
                });
            }
        });

    });
</script>