<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use PHPMailer\PHPMailer\PHPMailer;
require 'vendor/autoload.php';
include 'db_connection.php';

class VisitorCron {
    public function getEmailConfig()
    {
        $dbConnectionClass = new DBConnection();
        $conn = $dbConnectionClass->dbConnect();
        $sql = "SELECT * FROM email_config LIMIT 1";
        $result = $conn->query($sql);
        $rows = 0;
        if ($result->num_rows > 0) {
            $rows = $result->fetch_assoc();
        }
        return $rows;
    }
    public function getVisitorData($visitorId)
    {
        $dbConnectionClass = new DBConnection();
        $conn = $dbConnectionClass->dbConnect();
        $sql = " select * from `visitors` where `visitors`.`id` = ".$visitorId." limit 1 ";
        $result = $conn->query($sql);
        $rows = 0;
        if ($result->num_rows > 0) {
            $rows = $result->fetch_assoc();
        }
        return $rows;
    }
    public function getTeamMemberData($userId)
    {
        $dbConnectionClass = new DBConnection();
        $conn = $dbConnectionClass->dbConnect();
        $sql = " select * from `users` where `CustomerID` = ".$userId." limit 1 ";
        $result = $conn->query($sql);
        $rows = 0;
        if ($result->num_rows > 0) {
            $rows = $result->fetch_assoc();
        }
        return $rows;
    }
    public function getEmailDraftData($id)
    {
        $dbConnectionClass = new DBConnection();
        $conn = $dbConnectionClass->dbConnect();
        $sql = " select * from `email_drafts` where `email_drafts`.`id` = ".$id." limit 1 ";
        $result = $conn->query($sql);
        $rows = 0;
        if ($result->num_rows > 0) {
            $rows = $result->fetch_assoc();
        }
        return $rows;
    }
    public function getBatchData()
    {
        $dbConnectionClass = new DBConnection();
        $conn = $dbConnectionClass->dbConnect();
        $sql = " select * from `email_batch` where `status` = 'pending' and date(`schedule_date`) <= CURDATE() ";
        $result = $conn->query($sql);
        $rows = 0;
        if ($result->num_rows > 0) {
            $rows = $result->fetch_all(MYSQLI_ASSOC);
        }
        return $rows;
    }
    public function getBatchLogData($batchData)
    {
        $dbConnectionClass = new DBConnection();
        $conn = $dbConnectionClass->dbConnect();
        $sql = " select * from `email_batch_logs` where `batch_id` = ". $batchData['id'] ." and `id` > ". $batchData['last_id_sent'] ." and `status` = 'pending' LIMIT ". $batchData['hour_interval_mails'];
        $result = $conn->query($sql);
        $rows = 0;
        if ($result->num_rows > 0) {
            $rows = $result->fetch_all(MYSQLI_ASSOC);
        }
        return $rows;
    }
    public function getBatchLogLastData($batchData)
    {
        $dbConnectionClass = new DBConnection();
        $conn = $dbConnectionClass->dbConnect();
        $sql = " select * from `email_batch_logs` where `batch_id` = ". $batchData['id'] ." and `id` > ". $batchData['last_id_sent'] ." and `status` = 'pending' ORDER BY id ASC LIMIT ". $batchData['hour_interval_mails'];
        $result = $conn->query($sql);
        $rows = 0;
        if ($result->num_rows > 0) {
            $rows = $result->fetch_all(MYSQLI_ASSOC);
        }
        return $rows;
    }
    public function updateBatchLog($id,$status)
    {
        $dbConnectionClass = new DBConnection();
        $conn = $dbConnectionClass->dbConnect();
        $sql = " update `email_batch_logs` set `status` = '".$status."', `email_batch_logs`.`updated_at` = '".date('Y-m-d H:i:s')."' where `email_batch_logs`.`id` = ".$id;
        $conn->query($sql);
        return true;
    }
    public function updateBatch($id,$field,$value)
    {
        $dbConnectionClass = new DBConnection();
        $conn = $dbConnectionClass->dbConnect();
        $sql = " update `email_batch` set `".$field."` = '".$value."', `email_batch`.`updated_at` = '".date('Y-m-d H:i:s')."' where `email_batch`.`id` = ".$id;
        $conn->query($sql);
        return true;
    }
    public function processMail()
    {
        $pendingMailBatches = $this->getBatchData();
        $mailConfigData = $this->getEmailConfig();
        if(empty($mailConfigData)){
            return json_encode([
                'status' => false,
                'message' => 'Mail could not be sent because config data not found!'
            ]);
        }
        if(!empty($pendingMailBatches)){
            foreach($pendingMailBatches as $batchData)
            {
                $pendingBatchEmails = $this->getBatchLogData($batchData);
                $lastRecord = $this->getBatchLogLastData($batchData);
                $lastRecord_Id = "0";
               foreach ($lastRecord as $rowitem)
               {
                   $lastRecord_Id = $rowitem['id'];
               }
                echo "last record : ".$lastRecord_Id;
                if($pendingBatchEmails != 0) {
                    foreach ($pendingBatchEmails as $emailBatchLog)
                    {
                        $visitor = $this->getVisitorData($emailBatchLog['visitor_id']);
                        
                        echo "batch log : ".$emailBatchLog['visitor_id'];
                        if(!empty($visitor))
                        {
                            echo "visitor : ".$visitor['id'];
                            $teamMember = $this->getTeamMemberData($visitor['customer_id']);
                            if(!empty($teamMember)){
                                $emailDraft = null;
                                switch ($batchData['email_type']){
                                    case 'primary' :
                                        if($teamMember['primary_email']){
                                            $emailDraft = $this->getEmailDraftData($teamMember['primary_email']);
                                        }
                                        break;
                                    case 'followup' :
                                        if($teamMember['follow_up_email']) {
                                            $emailDraft = $this->getEmailDraftData($teamMember['follow_up_email']);
                                        }
                                        break;
                                    case 'other' :
                                        if($batchData['email_draft_id']) {
                                            $emailDraft = $this->getEmailDraftData($batchData['email_draft_id']);
                                        }
                                        break;
                                }
                                if(!empty($emailDraft))
                                {
                                    $data = [];
                                    $data['from_email'] = $teamMember['sender_email'];
                                    $data['password'] = '';
                                    $data['from_name'] = $teamMember['sender_name'];
                                    $data['receiver_email'] = $visitor['email'];
                                    $data['subject'] = $emailDraft['subject'];
                                    $data['body'] = $emailDraft['content'];

                                    if(!empty($data['from_email']) && !empty($data['receiver_email']))
                                    {
                                        $result = $this->sendEmail($data);
                                        if($result) {
                                            $this->updateBatchLog($emailBatchLog['id'],'sent');
                                        }else{
                                            $this->updateBatchLog($emailBatchLog['id'],'fail');
                                        }
                                    }
                                }
                            }
                        }
                        else
                        {
                         echo "visitor : not found";
                        }
                    }
                    $this->updateBatch($batchData['id'],'last_id_sent',$lastRecord_Id);
                }
                $newPendingBatchEmails = $this->getBatchLogData($batchData);
                if($newPendingBatchEmails == 0) {
                    $this->updateBatch($batchData['id'],'status','sent');
                }
            }
            return json_encode([
                'status' => true,
                'message' => 'Mail sent successfully!'
            ]);
        }else{
            return json_encode([
                'status' => false,
                'message' => 'No Batch found!'
            ]);
        }
    }
    public function sendEmail($data)
    {
        $emailConfig = $this->getEmailConfig();
        $mail = new PHPMailer();
        $mail->IsSMTP(); // Set mailer to use SMTP
        $mail->Host = $emailConfig['host']; // Specify main and backup server
        //$mail->Host = "Give IP Address"; // If the above does not work.
        $mail->Port = $emailConfig['smtp_port'];; // Set the SMTP port
        $mail->SMTPAuth = true; // Enable SMTP authentication
        $mail->Username = $emailConfig['username']; // SMTP username
        $mail->Password = $emailConfig['password']; // SMTP password
        $mail->SMTPSecure = "tls"; // Enable encryption, 'ssl' also accepted

        $mail->From = $data['from_email'];
        $mail->FromName = $data['from_name'];

        $mail->AddAddress($data['receiver_email']); // Add a recipient

        $mail->IsHTML(true); // Set email format to HTML

        $mail->Subject = $data['subject'];
        $mail->Body = $data['body'];

        $response = $mail->Send();
        if($response) {
            return true;
        } else {
            return false;
        }

    }
}
$class = new VisitorCron();
echo $class->processMail();
?>
