<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddExtraFieldsVisitorJsonToVisitorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('visitors', function (Blueprint $table) {
            // Add extra_fields_visitor_json column with longText data type for MySQL/MariaDB compatibility
            $table->longText('extra_fields_visitor_json')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('visitors', function (Blueprint $table) {
            // Drop extra_fields_visitor_json column
            $table->dropColumn('extra_fields_visitor_json');
        });
    }
}

