<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDefaultWhatsappApiLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('default_whatsapp_api_log', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sent_by')->nullable()->comment('User ID that initiates the WhatsApp message');
            $table->string('sent_to', 20)->nullable()->comment('Recipient mobile number');
            $table->string('template_name',1000)->nullable()->comment('Name or ID of the template sent');
            $table->unsignedBigInteger('event_id')->nullable()->comment('Event ID');
            $table->dateTime('date_time')->nullable()->comment('Date and time when the message was sent');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('default_whatsapp_api_log');
    }
}
