<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIntegrationConfigsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('integration_configs', function (Blueprint $table) {
            $table->id();
            $table->text('event_name')->nullable();
            $table->text('event_id')->nullable();
            $table->text('access_token')->nullable();
            $table->text('app_id')->nullable();
            $table->text('key')->nullable();
            $table->bigInteger('customer_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('integration_configs');
    }
}
