<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRegionCountryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('region_country', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('fk_country_id');
            $table->unsignedBigInteger('fk_region_id');
          
            $table->foreign('fk_country_id')->references('id')->on('countries')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('fk_region_id')->references('id')->on('region')->onDelete('cascade')->onUpdate('cascade');
          
            $table->unique(['fk_country_id', 'fk_region_id']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('region_country');
    }
}
