<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class UserAttendance extends Model
{
    // Table associated with the model
    protected $table = 'user_attendances';

 
    public $timestamps = true;

    // Fillable attributes for mass assignment
    protected $fillable = [
        'customer_id',
        'type',
        'lat',
        'lng',
    ];

    protected $dates = ['check_in_time', 'check_out_time'];

    public function fetchAllUserAttendance($teammember_id,$month,$year){
        $data = UserAttendance::with('customer')->orderBy('id', 'desc'); // Return the query builder, not the result

        if($teammember_id != 'all'){
           $data->where('customer_id',$teammember_id);
        }
        if($month != 'all'){
           $data->whereMonth('check_in_time',$month);
        }
        if($year != 'all'){
           $data->whereYear('check_in_time',$year);
        }
        return $data;
    }
    public static function fetchAllUserAttendanceexport($teammember_id,$month,$year){
        $data = UserAttendance::with('customer')->orderBy('id', 'desc'); // Return the query builder, not the result

        if($teammember_id != 'all'){
           $data->where('customer_id',$teammember_id);
        }
        if($month != 'all'){
           $data->whereMonth('check_in_time',$month);
        }
        if($year != 'all'){
           $data->whereYear('check_in_time',$year);
        }
        return $data->get();
    }

    public function customer(){
        return $this->hasOne(User::class,'CustomerID','customer_id');
    }
}
