<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuotationList extends Model
{
    use HasFactory;
    protected $table ='quotation_list';
	protected $casts = [
        'detail' => 'json'
    ];

    public static function fetchQuotationList($startDate = null, $endDate = null, $CustomerID)
    {

        $query = QuotationList::select('quotation_list.*','users.CustomerName','visitors.name','visitors.company_name')
            ->leftJoin('users', 'users.CustomerID', 'quotation_list.userid')
            ->leftJoin('visitors', 'visitors.id', 'quotation_list.visitorid');
        
        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('quotation_list.created_at', '>=', $startDateFormatted)
                    ->whereDate('quotation_list.created_at', '<=', $endDateFormatted);
            });
        }
        
        if ($CustomerID != "all") {
            $query = $query->where('CustomerID', $CustomerID);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        return $query->groupBy('quotation_list.id')->orderBy('quotation_list.id', 'desc');
    }
}
