<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventMetaForms extends Model
{
    use HasFactory;
    public $timestamps = false;
    protected $fillable = ['event_id', 'form_name'];
    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    public static function addMetaForms($event_id,array $form_names)
    {
        self::where('event_id', $event_id)->delete();
        $records = collect($form_names)->map(function($form_name) use ($event_id){
            return [
                'event_id' => $event_id,
                'form_name' => $form_name,
            ];
        });
        self::insert($records->toArray());
    }
}
