<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use App\Models\User;

class Admin extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $table = "admin";

    protected $fillable = [
        'name', 'email', 'password','type','user_id'
    ];

    public static function fetchSubAdminData()
    {
        $query = Admin::where('type','sub-admin')->orderBy('id','desc');
        return $query;
    }

    public static function getUser()
    {
        $authAdmin = auth()->user();
        $result = User::where('user_id','=',$authAdmin->user_id)->first();
        return $result;
    }

}
