<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\notification_to_cust;
use App\Models\Sendpush;
use App\Models\User;
use App\Models\customer_notifications;

class SendNotificationToUser implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $pushObj = new Sendpush();
        $notificationdata = notification_to_cust::where('is_sent', '0')->get();
        foreach($notificationdata as $data){
            $user_id = $data->user_id;
            $main_id = $data->id;
            $notification_id = $data->notification_id;
            $user = User::find($user_id);
            // $lang = $user->language;
            $notificationmesage = customer_notifications::where('id', $notification_id)->first();
                $title = $notificationmesage->titile_en;
                $msg = $notificationmesage->message_en;
            $message = array("notification_type" => "admin_notification", "message" => $msg, "title" => $title);
            if($user->device_type == 'android'){
                $push = $pushObj->sendPushAndroid($user->device_token, $message);
                $updatenotification = notification_to_cust::where('id', $main_id)->update(['is_sent' => '1']);
            }else{
                $push = $pushObj->sendPushIOS($user->device_token, $message, $title);
                $updatenotification = notification_to_cust::where('id', $main_id)->update(['is_sent' => '1']);
            }
        }
    }
}
