<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\notification_to_driver;
use App\Models\Sendpush;
use App\Models\User;
use App\Models\driver_notifications;

class SendNotification implements ShouldQueue
{
  
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $id,$type;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($id,$type)
    {
       
        $this->id = $id;
        $this->type = $type;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $pushObj = new Sendpush();
        $notificationdata = User::where('user_id', $this->id)->first();
      
        $user_id = $notificationdata->user_id;
          
        //         $title = $notificationmesage->titile_en;
        //         $msg = $notificationmesage->message_en;
            // $message = array("notification_type" => "admin_notification", "message" => $msg, "title" => $title);

           
               
                if($this->type == "eventassign"){
                    $title = "Event Assigned";
                    $msg = "You have been assigned an event.";
                    $message = array("notification_type" => "event_assigned","message" => $msg, "title" => $title);
                }else{
                    $title = "Admin Assigned";
                    $msg = "You have been activated as admin.";
                    $message = array("notification_type" => "admin_assigned","message" => $msg, "title" => $title);
                }
                
            if( $notificationdata->device_type == 'android'){
                $device_token = $notificationdata->push_token;
                $push = $pushObj->sendPushAndroid($user_id, $device_token, $message);
                // $updatenotification = notification_to_driver::where('id', $main_id)->update(['is_sent' => '1']);
            }else{
                $device_token = $notificationdata->push_token;
                $push = $pushObj->sendPushIOS($device_token, $message, $title);
            //     $updatenotification = notification_to_driver::where('id', $main_id)->update(['is_sent' => '1']);
            }
        // }
    }
}
