<?php

namespace App\Imports;

use App\Models\Visitor;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\PHPExcel_Shared_Date;
use Carbon\Carbon;
use DB;
use Illuminate\Support\Facades\Log;
use App\Models\Event;

class Importvisitorlist implements  ToCollection,WithStartRow
{
    protected $eventid,$customer_id;

    function __construct($eventid,$customer_id)
    {
        $this->eventid=$eventid;
        $this->customer_id=$customer_id;
    }
 /**
    * @param Collection $collection
    */
    public function collection(Collection $collection)
    {
        $response =array();
        //dd($collection);
        foreach ($collection->toArray() as $key => $value) {

            $originalDate = $value[1];

            if($originalDate != "" && $originalDate != null){

                //dd($originalDate);
                // $parsedDate = strtotime($originalDate);
                // $carbonDate = Carbon::createFromTimestamp($parsedDate);
                // $formattedDate = $carbonDate->format('Y-m-d');

                // Create a Carbon instance from the imported date
                // $carbonDate = Carbon::parse($originalDate);
                // $formattedDate = $carbonDate->format('Y-m-d');
                //dd($originalDate);
                if (str_contains($originalDate, '/')) {
                    $carbonDate = Carbon::createFromFormat('d/m/Y', $originalDate);
                    if ($carbonDate) {
                        $formattedDate = $carbonDate->format('Y-m-d');
                    } else {
                        $formattedDate = null;
                    }
                }else if (str_contains($originalDate, '-')) {
                                    $parsedDate = strtotime($originalDate);
                                    $carbonDate = Carbon::createFromTimestamp($parsedDate);
                                    $formattedDate = $carbonDate->format('Y-m-d');
                } else {
                    $formattedDatenew = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($originalDate);
                    $formattedDate = $formattedDatenew->format('Y-m-d');
                }

                //dd($formattedDate);
                //check if mobile_no & email exists -- start
                //$value[10] $value[13]
                $visitor = '';
                if(!empty($value[12]) && !empty($value[15]))
                {
                    $visitor = Visitor::where(function ($query) use ($value) {
                        $query->orWhere('mobile_no',$value[12])
                              ->orWhere('email',$value[15]);
                    })->first();
                }
                if(!empty($value[12]) && empty($value[15]))
                {
                    $visitor = Visitor::where(function ($query) use ($value) {
                        $query->orWhere('mobile_no',$value[12]);
                    })->first();
                }
                if(empty($value[12]) && !empty($value[15]))
                {
                    $visitor = Visitor::where(function ($query) use ($value) {
                        $query->orWhere('email',$value[15]);
                    })->first();
                }
                $country_code = 'IN';
                if(!empty($value[3]))
                {
                    $countryobj = DB::table('countries')->whereRaw('LOWER(`name`) LIKE ? ',[trim(strtolower($value[3]))])->first();

                    if(!empty($countryobj)){
                        $country_code = $countryobj->iso_code;
                    }
                }
                $is_international = 'false';
                if($country_code != "IN"){
                    $is_international = 'true';
                }
                //dd($is_international);
                //check if mobile_no & email exists -- end
                $eventids = ',';
                if(!empty($value[25]))
                {
                    $eventIdsArray = $value[25] ? explode(',', $value[25]) : [];
                    for ($i=0; $i < count($eventIdsArray) ; $i++) {
                        $eventdata = Event::where('event_name' , '=' ,[trim($eventIdsArray[$i])])->first();
                        if($eventdata){
                            $eventids = $eventids.$eventdata->id.',';
                        }
                    }
                }
                $data=([
                    'event_id' =>$this->eventid,
                    'customer_id' =>$this->customer_id,
                    'visited_date' => $formattedDate,
                    'company_name' => $value[2],
                    'country_code' => $country_code,
                    'address_country_code' => $country_code,
                    'is_international' => $is_international,
                    'state' => $value[4],
                    'city' => $value[5],
                    'area' => $value[6],
                    'pincode' => $value[7],
                    'address' => $value[8],
                    'website' => $value[9],
                    'name' => $value[10],
                    'designation' => $value[11],
                    'mobile_no' => $value[12],
                    'mobile_no2' => $value[13],
                    'mobile_no3' => $value[14],
                    'email' => $value[15],
                    'email2' => $value[16],
                    'category' => $value[17],
                    'sub_category' => $value[18],
                    'remarks' => $value[20],
                    'action' => $value[21],
                    'attended_by' => $value[22],
                    'monthly_requirement' => $value[23],
                    'rating' => $value[24],
					'source_of_lead' => $value[26],
                    'event_ids' => $eventids,
                    'created_at'=>Carbon::now('Asia/Kolkata'),
                    'updated_at'=>Carbon::now('Asia/Kolkata')
                ]);

                // array_push($response, $data);
                Log::build([
                    'driver' => 'single',
                    'path' => storage_path('logs/import.log'),
                ])->info('--------------------------------------------------------------------------------------------------');
                if($visitor) {
                    unset($data['event_id']);
                    unset($data['event_ids']);
                    $visitor->update($data);
                    //Log::channel('custom')->info('Update Data =>'.json_encode($data));
                    Log::build([
                        'driver' => 'single',
                        'path' => storage_path('logs/import.log'),
                    ])->info('Update Data =>'.json_encode($data));
                }else{
                    $adddata = Visitor::insert($data);
                    //Log::channel('custom')->info('Add Data =>'.json_encode($data));
                    //Log::channel('custom')->info('Add Data Result =>'.json_encode($adddata));
                    Log::build([
                        'driver' => 'single',
                        'path' => storage_path('logs/import.log'),
                    ])->info('Add Data =>'.json_encode($data));
                    Log::build([
                        'driver' => 'single',
                        'path' => storage_path('logs/import.log'),
                    ])->info('Add Data Result =>'.json_encode($adddata));
                }
                Log::build([
                    'driver' => 'single',
                    'path' => storage_path('logs/import.log'),
                ])->info('---------------------------------------------------------------------------------------------------');
            }
        }
        //return 'data';
        // $response =array();
        // foreach ($collection->toArray() as $key => $value) {
        //         $data=([
        //             'event_id' =>$this->eventid,
        //             'customer_id' =>$this->customer_id,
        //             'created_at' => $value[1],
        //             'company_name' => $value[2],
        //             'state' => $value[3],
        //             'city' => $value[4],
        //             'pincode' => $value[5],
        //             'address' => $value[6],
        //             'website' => $value[7],
        //             'name' => $value[8],
        //             'designation' => $value[9],
        //             'mobile_no' => $value[10],
        //             'mobile_no2' => $value[11],
        //             'mobile_no3' => $value[12],
        //             'email' => $value[13],
        //             'email2' => $value[14],
        //             'category' => $value[15],
        //             'remarks' => $value[16],
        //             'action' => $value[17],
        //             'attended_by' => $value[18],
        //         ]);

        //             // array_push($response, $data);
        //             Visitor::insert($data);
        //     }
            //    echo "<pre>";print_r($response);die;
    }
    public function startRow(): int
    {
        return 2;
    }
}
