<?php

namespace App\Http\Controllers;

use App\DataTables\VisitorBatchDataTable;
use App\Models\AssignDivisionAdmin;
use App\Models\AssignDivisionTeamMember;
use App\Models\EmailBatch;
use App\Models\EmailBatchLog;
use App\Models\EmailDraft;
use Illuminate\Http\Request;
use App\DataTables\VisitorsDataTable;
use App\Models\Visitor;
use App\Models\EventImage;
use App\Models\Sendpush;
use App\Models\Event;
use DB;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\VisitorlistExport;
use App\Imports\Importvisitorlist;
use Alert;
use App\Models\Action;
use App\Models\Product;
use App\Models\User;
use App\Models\Visit_data_images;
use App\Models\VisitData;
use App\Models\VisitorProduct;
use App\Models\Template;
use App\Models\WhatsappLog;

use ZipArchive;
use Carbon\Carbon;
use PDF;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use App\DataTables\EventsVisitorsDataTable;
use App\Exports\VisitorlistByEventExport;
use Illuminate\Support\Facades\Http;
use App\Models\Category;
use App\DataTables\VisitorBatchLogDataTable;
use App\DataTables\ClientCompanyDataTable;
use App\DataTables\ClientVisitorsDataTable;
use App\Exports\CliectVisitorlistExport;
use App\Exports\GoogleContactExport;
use App\Models\SourceOfLead;
use Exception;
use App\DataTables\ClientDashboardVisitorsDataTable;
use App\DataTables\ClientUserDataTable;

use App\Exports\ClientDashboardVisitorslistExport;
use App\Helpers\Helper;
use App\Models\ReferredByMaster;

class VisitorController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->_visitor = new Visitor();
    }

    public function index(Request $request, VisitorsDataTable $dataTable)
    {
        $data['regions'] = DB::table('region')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['region'] = [];
        $data['categories'] = DB::table('category')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['category_id'] = [];
        $data['sub_category_id'] = [];
        $data['is_international'] = 'all';
        //$data['start_date'] = Carbon::now()->subYear()->format('Y-m-d');


        $data['start_date'] = Carbon::now()->subDays(30)->format('Y-m-d');
        $data['end_date'] = Carbon::now()->addDay()->format('Y-m-d');
        $data['actionList'] = Action::orderBy('id', 'asc')->get();
        $data['sourceofleadList'] = SourceOfLead::orderBy('id', 'asc')->get();


        //$data['countries'] = DB::table('countries')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['country_id'] = [];
        $data['follow_up_time'] = '';
        //$data['states'] = DB::table('states')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['state_id'] = [];
        $data['city_id'] = [];
        $data['area'] = [];
        $data['action'] = [];
        $data['sourceoflead'] = [];

        $data['events'] = DB::table('events')->select('event_name', 'id')->orderBy('event_name', 'asc')
            // ->where('type_show_all','=','true')
            ->get();
        $data['event_id'] = [];
        $data['users'] = DB::table('users');
        //->where('is_delete', '=', 'false');
        $authAdmin = auth()->user();
        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $data['users'] = $data['users']->whereIn('CustomerID', $divisionTeamMemberIds);
        }
        $data['users'] = $data['users']->select('CustomerName', 'CustomerID', 'is_delete')->orderBy('CustomerName', 'asc')->get();
        $data['CustomerID'] = [];
        $data['otherEmailDrafts'] = EmailDraft::get();

        $data['username'] = DB::table('users')
            ->where('users.is_delete', '=', 'false')
            ->get();
        $data['user'] = json_decode($data['username']);

        if (isset($request->event_id)) {
            $data['event_id'] = $request->event_id;
        }
        if (isset($request->CustomerID)) {
            $data['CustomerID'] = $request->CustomerID;
        }
        if (isset($request->category_id)) {
            $data['category_id'] = $request->category_id;
        }
        if (isset($request->sub_category_id)) {
            $data['sub_category_id'] = $request->sub_category_id;
        }

        if (isset($request->country_id)) {
            $data['country_id'] = $request->country_id;
        }
        if (isset($request->state_id)) {
            $data['state_id'] = $request->state_id;
        }
        if (isset($request->city_id)) {
            $data['city_id'] = $request->city_id;
        }
        if (isset($request->area)) {
            $data['area'] = $request->area;
        }
        if (isset($request->is_international)) {
            $data['is_international'] = $request->is_international;
        }
        if (isset($request->region)) {
            $data['region'] = $request->region;
        }
        if (isset($request->start_date)) {
            $data['start_date'] = $request->start_date;
        }
        if (isset($request->end_date)) {
            $data['end_date'] = $request->end_date;
        }
        if (isset($request->action)) {
            $data['action'] = $request->action;
        }

        if (isset($request->follow_up_time)) {
            $data['follow_up_time'] = $request->follow_up_time;
        }

        if (isset($request->sourceoflead)) {
            $data['sourceoflead'] = $request->sourceoflead;
        }

        // return $data;
        // return [
        //     'event_id'        => (array) $request->get('event_id'),
        //     'CustomerID'      => (array) $request->get('CustomerID'),
        //     'category_id'     => (array) $request->get('category_id'),
        //     'sub_category_id' => (array) $request->get('sub_category_id'),
        //     'state_id'        => (array) $request->get('state_id'),
        //     'city_id'         => (array) $request->get('city_id'),
        //     'is_international' =>  $request->get('is_international'),
        //     'country_id'      => (array) $request->get('country_id'),
        //     'region'          => (array) $request->get('region'),
        //     'start_date'       => $request->get('start_date'),
        //     'end_date'         => $request->get('end_date'),
        //     'action'          => (array) $request->get('action'),
        //     'sourceoflead'    => (array) $request->get('sourceoflead'),
        //     'area'            => (array) $request->get('area'),
        // ];


        $data['templates'] = Template::where('status', 'APPROVED')->get();
        return $dataTable->with([
            'event_id' => $data['event_id'],
            'CustomerID' => $data['CustomerID'],
            'category_id' => $data['category_id'],
            'sub_category_id' => $data['sub_category_id'],
            'country_id' => $data['country_id'],
            'state_id' => $data['state_id'],
            'city_id' => $data['city_id'],
            'area' => $data['area'],
            'is_international' => $data['is_international'],
            'region' => $data['region'],
            'start_date' => $data['start_date'],
            'end_date' => $data['end_date'],
            'action' => $data['action'],
            'follow_up_time' => $data['follow_up_time'],
            'sourceoflead' => $data['sourceoflead'],
        ])->render('visitor.index', $data);
    }
    public function mapView(Request $request, VisitorsDataTable $dataTable)
    {

        $data['regions'] = DB::table('region')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['region'] = [];
        $data['categories'] = DB::table('category')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['category_id'] = [];
        $data['sub_category_id'] = [];
        $data['is_international'] = "all";
        $data['start_date'] = Carbon::now()->subYear()->format('Y-m-d');
        $data['end_date'] = Carbon::now()->addDay()->format('Y-m-d');
        $data['actionList'] = Action::orderBy('id', 'asc')->get();
        $data['sourceofleadList'] = SourceOfLead::orderBy('id', 'asc')->get();


        //$data['countries'] = DB::table('countries')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['country_id'] = [];
        $data['follow_up_time'] = '';
        //$data['states'] = DB::table('states')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['state_id'] = [];
        $data['city_id'] = [];
        $data['area'] = [];
        $data['action'] = [];
        $data['sourceoflead'] = [];

        $data['events'] = DB::table('events')->select('event_name', 'id')->orderBy('event_name', 'asc')
            // ->where('type_show_all','=','true')
            ->get();
        $data['event_id'] = [];
        $data['users'] = DB::table('users');
        $authAdmin = auth()->user();
        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $data['users'] = $data['users']->whereIn('CustomerID', $divisionTeamMemberIds);
        }
        $data['users'] = $data['users']->select('CustomerName', 'CustomerID', 'is_delete')->orderBy('CustomerName', 'asc')->get();

        $data['CustomerID'] = [];
        $data['otherEmailDrafts'] = EmailDraft::get();

        $data['username'] = DB::table('users')
            ->where('users.is_delete', '=', 'false')
            ->get();
        $data['user'] = json_decode($data['username']);

        if (isset($request->event_id)) {
            $data['event_id'] = $request->event_id;
        }
        if (isset($request->CustomerID)) {
            $data['CustomerID'] = $request->CustomerID;
        }
        if (isset($request->category_id)) {
            $data['category_id'] = $request->category_id;
        }
        if (isset($request->sub_category_id)) {
            $data['sub_category_id'] = $request->sub_category_id;
        }

        if (isset($request->country_id)) {
            $data['country_id'] = $request->country_id;
        }
        if (isset($request->state_id)) {
            $data['state_id'] = $request->state_id;
        }
        if (isset($request->city_id)) {
            $data['city_id'] = $request->city_id;
        }
        if (isset($request->area)) {
            $data['area'] = $request->area;
        }
        if (isset($request->is_international)) {
            $data['is_international'] = $request->is_international;
        }
        if (isset($request->region)) {
            $data['region'] = $request->region;
        }
        if (isset($request->start_date)) {
            $data['start_date'] = $request->start_date;
        }
        if (isset($request->end_date)) {
            $data['end_date'] = $request->end_date;
        }
        if (isset($request->action)) {
            $data['action'] = $request->action;
        }

        if (isset($request->follow_up_time)) {
            $data['follow_up_time'] = $request->follow_up_time;
        }

        if (isset($request->sourceoflead)) {
            $data['sourceoflead'] = $request->sourceoflead;
        }


        $data['templates'] = Template::where('status', 'APPROVED')->get();
        return $dataTable->with([
            'event_id' => $data['event_id'],
            'CustomerID' => $data['CustomerID'],
            'category_id' => $data['category_id'],
            'sub_category_id' => $data['sub_category_id'],
            'country_id' => $data['country_id'],
            'state_id' => $data['state_id'],
            'city_id' => $data['city_id'],
            'area' => $data['area'],
            'is_international' => $data['is_international'],
            'region' => $data['region'],
            'start_date' => $data['start_date'],
            'end_date' => $data['end_date'],
            'action' => $data['action'],
            'follow_up_time' => $data['follow_up_time'],
            'sourceoflead' => $data['sourceoflead'],
        ])->render('visitor.map', $data);
    }
    public function mapData(Request $request)
    {
        // return $request->event_id;
        try {

            $visitors = Visitor::fetchAllvisitorMultipleSelection($request?->event_id, $request?->CustomerID, $request?->category_id, $request?->sub_category_id, $request?->state_id, $request?->city_id, $request?->is_international, $request?->country_id, $request?->region, $request?->start_date, $request?->end_date, $request?->action, $request?->follow_up_time, $request?->sourceoflead, $request?->area);
            return response()->json([
                "message" => "visitors",
                "status" => true,
                "filter" => $request->all(),
                "data" => $visitors->orderByDesc("id")->get(),
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                "message" => $e->getMessage(),
                "status" => false,
            ], 500);
        }
    }
    public function detailview(Request $request, ClientUserDataTable $dataTable)
    {
        $data['data'] = DB::table('visitors')
            ->select('events.event_name', 'users.CustomerName', 'visitors.*')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->where('visitors.id', $request->id)->first();



        $data['event_images'] = DB::table('event_images')
            ->where('visitor_id', $request->id)
            ->get();

        $data['visitor_products'] = DB::table('visitor_products')
            ->select('products.name as productname', 'visitor_products.*')
            ->leftjoin('products', 'products.id', 'visitor_products.product_id')
            ->where('visitor_products.visitor_id', $request->id)
            ->get();

        $eventIdsArray = [];
        if ($data['data']) {
            $eventIdsString = $data['data']->event_ids;
            $eventIdsArray = explode(',', $eventIdsString);
        }
        $data['eventNames'] = DB::table('events')
            ->whereIn('id', $eventIdsArray)
            ->pluck('event_name')
            ->toArray();

        $data['visit_all'] = DB::table('visit_data')
            ->where('fk_visitor_id', $request->id)->orderBy('id', 'desc')
            ->get();
        // ->pluck('action')
        // ->toArray();

        // dd($data['visit_action']);



        $companyName = urldecode($request->id);
        // $companyName = $request->id;
        $data['company_name'] = $companyName;

        $data['visitors'] = DB::table('visitors')
            ->whereRaw('LOWER(customer_id) = ?', [strtolower($companyName)])
            ->pluck('name')
            ->unique()
            ->values();

        $data['members'] = DB::table('visit_data')
            ->join('visitors', 'visitors.id', '=', 'visit_data.fk_visitor_id')
            ->whereRaw('visitors.customer_id = ?', $companyName)
            ->whereNotNull('visit_data.attend_by')
            ->pluck('visit_data.attend_by')
            ->unique()
            ->values();

        if ($request->export === 'excel') {
            return Excel::download(
                new \App\Exports\ClientUserExport($request),
                'user_visits.xlsx'
            );
        }

        $data['companyVisitTable'] = $dataTable;
        return view('visitor.visitordetail', $data);
    }
    public function companyVisitAjax(ClientUserDataTable $dataTable)
    {
        return $dataTable->ajax(); // 🔥 JSON only
    }
    public function companydetailview(Request $request, ClientCompanyDataTable $dataTable)
    {
        $companyName = urldecode($request->company_name);

        $visitors = DB::table('visitors')
            ->whereRaw('LOWER(company_name) = ?', [strtolower($companyName)])
            ->pluck('name')
            ->unique()
            ->values();

        $members = DB::table('visit_data')
            ->join('visitors', 'visitors.id', '=', 'visit_data.fk_visitor_id')
            ->whereRaw('visitors.company_name = ?', $companyName)
            ->whereNotNull('visit_data.attend_by')
            ->pluck('visit_data.attend_by')
            ->unique()
            ->values();

        if ($request->export === 'excel') {
            return Excel::download(
                new \App\Exports\ClientCompanyExport($request),
                'company_visits.xlsx'
            );
        }
        return $dataTable->render(
            'visitor.clientcompanyvisit',
            [
                'company_name' => $companyName,
                'visitors' => $visitors,
                'members' => $members,
                'visitor_name' => $request->visitor_name,
                'attend_by' => $request->attend_by,
            ]
        );
    }

    public function userdetailview(Request $request, ClientUserDataTable $dataTable)
    {
        $companyName = urldecode($request->id);

        $visitors = DB::table('visitors')
            ->whereRaw('LOWER(customer_id) = ?', [strtolower($companyName)])
            ->pluck('name')
            ->unique()
            ->values();

        $members = DB::table('visit_data')
            ->join('visitors', 'visitors.id', '=', 'visit_data.fk_visitor_id')
            ->whereRaw('visitors.customer_id = ?', $companyName)
            ->whereNotNull('visit_data.attend_by')
            ->pluck('visit_data.attend_by')
            ->unique()
            ->values();

        if ($request->export === 'excel') {
            return Excel::download(
                new \App\Exports\ClientUserExport($request),
                'user_visits.xlsx'
            );
        }

        return $dataTable->render(
            'visitor.clientuservisit',
            [
                'company_name' => $companyName,
                'visitors' => $visitors,
                'members' => $members,
                'visitor_name' => $request->visitor_name,
                'attend_by' => $request->attend_by,
            ]
        );
    }

    public function exportvisitorlist(Request $request)
    {
        // return $request->all();
        if (!empty($request->event_id) && is_array($request->event_id) && count($request->event_id) > 0) {
            $eventid = $request->event_id;
            $event = DB::table('events')->select('events.event_name')->where('id', $eventid[0])->first();
            $event = $event?->event_name;
        } else {
            $event = "all";
        }


        // if ($request->event_id == '' && $request->CustomerID == '' && $request->category_id == '' && $request->sub_category_id == '' && $request->state_id == '' && $request->city_id == '' && $request->country_id == null && $request->region == null && $request->start_date == null && $request->end_date == null && $request->product == null && $request->sourceoflead == '' && ($request->area == null || $request->area == '')) {
        //     $event_id = 'all';
        //     $customer_id = 'all';
        //     $category_id = 'all';
        //     $sub_category_id = 'all';
        //     $state_id = 'all';
        //     $city_id = 'all';
        //     $is_international = 'all';
        //     $country_id = 'all';
        //     $region = 'all';
        //     $area = 'all';
        //     $start_date = Carbon::now()->subYear()->format('Y-m-d');
        //     $end_date = Carbon::now()->addDay()->format('Y-m-d');
        //     $product = 'all';
        //     $sourceoflead = 'all';
        // } else {
        //     $event_id = $request->event_id;
        //     $customer_id = $request->CustomerID;
        //     $category_id = $request->category_id;
        //     $sub_category_id = $request->sub_category_id;
        //     $state_id = $request->state_id;
        //     $city_id = $request->city_id;
        //     $area = $request->area;
        //     $is_international = $request->is_international;
        //     $country_id = $request->country_id;
        //     $region = $request->region;
        //     $area = $request->area;
        //     $start_date = $request->start_date;
        //     $end_date = $request->end_date;
        //     $sourceoflead = $request->sourceoflead;
        // }
        $event_id = $request->event_id;
        $customer_id = $request->CustomerID;
        $category_id = $request->category_id;
        $sub_category_id = $request->sub_category_id;
        $state_id = $request->state_id;
        $city_id = $request->city_id;
        $area = $request->area;
        $is_international = $request->is_international;
        $country_id = $request->country_id;
        $region = $request->region;
        $area = $request->area;
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $sourceoflead = $request->sourceoflead;
        $actions = $request->action;
        // $categoryNames = DB::table('category')->whereIn('id', $category_id)->select('name', 'id')->get()->pluck('name')->toArray();
        // return implode(',',$categoryNames);
        $data = Visitor::getvisitorByFilterExportMultiple($event_id, $customer_id, $category_id, $sub_category_id, $state_id, $city_id, $is_international, $country_id, $region, $start_date, $end_date, $sourceoflead, $area, $actions);
        // return ["data" => $data,"filter"=>$request->all()];
        return Excel::download(new VisitorlistExport($event_id, $customer_id, $category_id, $sub_category_id, $state_id, $city_id, $is_international, $country_id, $region, $start_date, $end_date, $sourceoflead, $area, $actions), $event . '.xlsx', \Maatwebsite\Excel\Excel::XLSX);
    }

    public function export_pdf(Request $request)
    {
        // return $request->all();
        if (!empty($request->event_id) && is_array($request->event_id) && count($request->event_id) > 0) {
            $eventid = $request->event_id;
            $event = DB::table('events')->select('events.event_name')->where('id', $eventid[0])->first();
            $event = $event?->event_name;
        } else {
            $event = "all";
        }


        // if ($request->event_id == '' && $request->CustomerID == '' && $request->category_id == '' && $request->sub_category_id == '' && $request->state_id == '' && $request->city_id == '' && $request->country_id == null && $request->region == null && $request->start_date == null && $request->end_date == null && $request->product == null && $request->sourceoflead == '' && ($request->area == null || $request->area == '')) {
        //     $event_id = 'all';
        //     $customer_id = 'all';
        //     $category_id = 'all';
        //     $sub_category_id = 'all';
        //     $state_id = 'all';
        //     $city_id = 'all';
        //     $is_international = 'all';
        //     $country_id = 'all';
        //     $region = 'all';
        //     $area = 'all';
        //     $start_date = Carbon::now()->subYear()->format('Y-m-d');
        //     $end_date = Carbon::now()->addDay()->format('Y-m-d');
        //     $product = 'all';
        //     $sourceoflead = 'all';
        // } else {
        //     $event_id = $request->event_id;
        //     $customer_id = $request->CustomerID;
        //     $category_id = $request->category_id;
        //     $sub_category_id = $request->sub_category_id;
        //     $state_id = $request->state_id;
        //     $city_id = $request->city_id;
        //     $area = $request->area;
        //     $is_international = $request->is_international;
        //     $country_id = $request->country_id;
        //     $region = $request->region;
        //     $area = $request->area;
        //     $start_date = $request->start_date;
        //     $end_date = $request->end_date;
        //     $sourceoflead = $request->sourceoflead;
        // }
        // return $request->all();
        $eventids = $request->event_id;
        $CustomerIDs = $request->CustomerID;
        $categoryIds = $request->category_id;
        $subCategoryIds = $request->sub_category_id;
        $stateIds = $request->state_id;
        $cityIds = $request->city_id;
        $isInternational = $request->is_international;
        $countryIds = $request->country_id;
        $regions = $request->region;
        $areas = $request->area;
        $startDate = $request->start_date;
        $endDate = $request->end_date;
        $sourceofleads = $request->sourceoflead;
        $actions = $request->action;

        $query = DB::table('visitors')
            ->select('events.event_name', 'users.CustomerName', 'visitors.*')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            // ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
            // ->leftjoin('products', 'products.id', 'visitor_products.product_id')
            ->orderBy('visitors.id', 'desc');




        // $event_check = DB::table('events')->where
        if (!empty($eventids) && count($eventids) > 0) {
            $query = $query->where(function ($query) use ($eventids) {
                $query->whereIn('event_id', $eventids);
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $eventids);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->orWhereRaw("event_ids REGEXP ?", [$pattern]);
            });
        }

        if (!empty($CustomerIDs) && count($CustomerIDs) > 0) {
            $query = $query->whereIn('CustomerID', $CustomerIDs);
        } else {
            $authAdmin = auth()->user();
            if ($authAdmin->type == 'sub-admin') {
                $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID', $divisionTeamMemberIds);
            }
        }

        if (!empty($categoryIds) && count($categoryIds) > 0) {
            $categoryNames = DB::table('category')->whereIn('id', $categoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($categoryNames) {
                // $query->whereRaw('FIND_IN_SET(?, visitors.category)', [implode(',',$categoryNames[0])]);

                // foreach($categoryNames as $categoryName){
                //     $query->orWhereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
                // }
                // escape for safety (if any category contains regex special chars)
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $categoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.category REGEXP ?", [$pattern]);
                // $pattern = '(^|,)(' . implode('|', array_map('preg_quote', $categoryNames)) . ')(,|$)';
                // $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);

            });
        }

        if (!empty($subCategoryIds) && count($subCategoryIds) > 0) {
            $subCategoryNames = DB::table('sub_categories')->whereIn('id', $subCategoryIds)->select('name', 'id')->get()->pluck('name')->toArray();
            $query = $query->where(function ($query) use ($subCategoryNames) {
                $escaped = array_map(function ($v) {
                    return preg_quote($v, '/');
                }, $subCategoryNames);

                $pattern = '(^|,)(' . implode('|', $escaped) . ')(,|$)';

                $query->whereRaw("visitors.sub_category REGEXP ?", [$pattern]);
                // $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [implode(',',$subCategoryNames)]);
            });
        }

        if (!empty($stateIds) && count($stateIds) > 0) {
            // $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.state', $stateIds);
        }

        if (!empty($cityIds) && count($cityIds) > 0) {
            // $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->whereIn('visitors.city', $cityIds);
        }

        if (!empty($areas) && count($areas) > 0) {
            $query = $query->whereIn('visitors.area', $areas);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query->where(function ($query) use ($isInternational) {
                $query->where('visitors.is_international', $isInternational)
                    ->orWhere('visitors.country_code', '!=', 'IN');
            });

            //$query = $query->where('visitors.is_international', $isInternational);
        }

        if (!empty($actions) && count($actions) > 0) {
            $query = $query->whereIn('visitors.action', $actions);
        }

        if (!empty($countryIds) && count($countryIds) > 0) {
            $countryISOCodes = DB::table('countries')->whereIn('name', $countryIds)->select('iso_code', 'name', 'id')->get()->pluck('iso_code')->toArray();
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
            // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            $query = $query->where(function ($query) use ($countryISOCodes) {
                $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
            });
        }

        if (!empty($regions) && count($regions) > 0) {
            $regionCountries = DB::table('region_country')->whereIn('fk_region_id', $regions)->get();
            if ($regionCountries) {
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id', $regionCountryIds)->select('iso_code', 'name', 'id')->get();
                if ($countries) {
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                    // $query = $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    $query = $query->where(function ($query) use ($countryISOCodes) {
                        $query->whereIn('visitors.country_code', $countryISOCodes)->orWhereIn('visitors.address_country_code', $countryISOCodes);
                    });
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            //dd($startDateFormatted);
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                $query->whereDate('visitors.visited_date', '>=', $startDateFormatted)
                    ->whereDate('visitors.visited_date', '<=', $endDateFormatted);
            });
        }


        if (!empty($sourceofleads) && count($sourceofleads) > 0) {
            $query = $query->whereIn('visitors.source_of_lead', $sourceofleads);
        }

        // $query = $query->get();
        $query = $query->groupBy('visitors.id')->get();

        $pdfPaths = [];
        $dataChunks = collect($query)->chunk(50);

        foreach ($dataChunks as $chunk) {
            $pdf = PDF::loadView('visitor.list_pdf1', ['data' => $chunk])
                ->setOption('page-size', 'A4')
                ->setOption('orientation', 'landscape');

            $pdfFileName = 'pdf_' . Str::uuid() . '.pdf';
            $pdfPath = storage_path('app/' . $pdfFileName);

            $pdf->save($pdfPath);
            $pdfPaths[] = $pdfPath;

            unset($pdf);
        }

        $zipFileName = 'all_pdfs.zip';
        $zipPath = storage_path('app/' . $zipFileName);

        $zip = new ZipArchive;
        if ($zip->open($zipPath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
            foreach ($pdfPaths as $path) {
                $zip->addFile($path, basename($path));
            }
            $zip->close();
        }

        foreach ($pdfPaths as $path) {
            unlink($path);
        }

        return response()->download($zipPath)->deleteFileAfterSend(true);

        // $query = $query->get();

        // $pdf = PDF::loadView('visitor.list_pdf', ['event_id' => $event_id, 'customer_id' => $customer_id, 'query' => $query])
        // ->setOption('page-size', 'A4')
        // ->setOption('orientation', 'landscape');
        // // $pdf->stream(); // Set the page orientation to landscape

        // $filename = $event . '.pdf';
        // return $pdf->download($filename);

        // $query = $query->get();
        // $pdfPaths = [];
        // $dataChunks = collect($query)->chunk(100);

        // foreach ($dataChunks as $chunk) {
        //     $pdf = PDF::loadView('visitor.list_pdf1', ['event_id' => $event_id, 'customer_id' => $customer_id, 'data' => $chunk])
        //         ->setOption('page-size', 'A4')
        //         ->setOption('orientation', 'landscape');

        //     $pdfFileName = 'pdf_' . Str::uuid() . '.pdf';
        //     $pdf->save(storage_path('app/pdf/' . $pdfFileName));
        //     $pdfPaths[] = storage_path('app/pdf/' . $pdfFileName);
        // }

        // $zipFileName = 'all_pdfs.zip';
        // $zip = new ZipArchive;
        // if ($zip->open(storage_path('app/pdf/' . $zipFileName), ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
        //     foreach ($pdfPaths as $path) {
        //         $zip->addFile($path, basename($path));
        //     }
        //     $zip->close();
        // }

        // // Delete original PDF files
        // foreach ($pdfPaths as $path) {
        //     unlink($path);
        // }
        // return response()->download(storage_path('app/pdf/' . $zipFileName))->deleteFileAfterSend(true);

        // $query = $query->limit(50)->get();

    }

    public function insertexportfile(Request $request)
    {
        $isSubscriptionExpired = HomeController::checkSubscriptionExpired();
        if ($isSubscriptionExpired) {
            $expiryTitle = !empty(Session::get('expiryTitle')) ? Session::get('expiryTitle') : "Your Subscription is Expired";
            $expiryMessage = !empty(Session::get('expiryMessage')) ? Session::get('expiryMessage') : "Your Subscription is Expired , Please Contact support for Activation.";

            Alert::error($expiryTitle, $expiryMessage);
            return redirect()->back();
        }
        $eventid = $request->event_id;
        $customer_id = $request->CustomerID;
        $exceldata = Excel::toCollection(null, $request->file('importfile'));
        $dataInvalid = [];
        $dataDuplicate = [];
        $totalData = 0;
        if (!empty($exceldata) && $exceldata->count()) {
            foreach ($exceldata as $dataobj) {
                $i = 0;
                foreach ($dataobj as $objdata) {
                    if ($i > 0) {

                        $exceldate = $objdata['1'];
                        $name = $objdata['10'];
                        if ($exceldate != "" && $exceldate != null) {
                            //print_r($exceldate);
                            if (str_contains($exceldate, '/')) {
                                $carbonDate = Carbon::createFromFormat('d/m/Y', $exceldate);
                                if ($carbonDate) {
                                    $formattedDate = $carbonDate->format('Y-m-d');
                                } else {
                                    $formattedDate = null;
                                }
                            } else if (str_contains($exceldate, '-')) {
                                $parsedDate = strtotime($exceldate);
                                $carbonDate = Carbon::createFromTimestamp($parsedDate);
                                $formattedDate = $carbonDate->format('Y-m-d');
                            } else {
                                $formattedDatenew = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($exceldate);
                                $formattedDate = $formattedDatenew->format('Y-m-d');
                            }
                            $objdata['1'] = $formattedDate;

                            if ($name != "" && $name != null) {
                            } else {
                                $dataInvalid[] = $objdata;
                            }

                            $visitor = '';
                            $mobile_no = $objdata['12'];
                            $email = $objdata['15'];
                            if (!empty($mobile_no) && !empty($email)) {
                                $visitor = Visitor::where(function ($query) use ($mobile_no, $email) {
                                    $query->orWhere('mobile_no', $mobile_no)
                                        ->orWhere('email', $email);
                                })->first();
                            }
                            if (!empty($mobile_no) && empty($email)) {
                                $visitor = Visitor::where(function ($query) use ($mobile_no) {
                                    $query->orWhere('mobile_no', $mobile_no);
                                })->first();
                            }
                            if (empty($mobile_no) && !empty($email)) {
                                $visitor = Visitor::where(function ($query) use ($email) {
                                    $query->orWhere('email', $email);
                                })->first();
                            }
                            if ($visitor) {
                                $dataDuplicate[] = $objdata;
                            }
                            $totalData++;
                        } else {
                            //$dataInvalid[]=$objdata;
                        }
                    }

                    $i++;
                }
            }
        }
        if (count($dataInvalid) > 0) {
            //dd($totalData);
            return redirect()->back()->with(['dataInvalid' => $dataInvalid, 'totalData' => $totalData, 'dataDuplicate' => $dataDuplicate]);
        } else {
            Excel::import(new Importvisitorlist($eventid, $customer_id), $request->file('importfile')->store('importfile'));

            return redirect()->back()->with(['dataImported' => 'successful', 'totalData' => $totalData, 'dataDuplicate' => $dataDuplicate]);
            ;
        }
    }

    // public function edit(Request $request)
    // {
    //     $data['data'] = DB::table('visitors')
    //     ->select('events.event_name','users.CustomerName','visitors.*')
    //     ->join('events', 'events.id', 'visitors.event_id')
    //     ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
    //     ->where('visitors.id', $request->id)->first();

    //     $data['event_images'] = DB::table('event_images')
    //     ->where('visitor_id', $request->id)
    //     ->get();

    //     return view('visitor.editvisitor');
    // }

    public function downloadImages(Request $request)
    {

        $event_ids = !empty($request->event_id) ? explode(',', $request->event_id) : [];
        $customer_ids = !empty($request->CustomerID) ? explode(',', $request->CustomerID) : [];
        // return $event_ids;
        // return $customer_ids;
        // return $request->all();

        if (!empty($event_ids) && !empty($customer_ids)) {
            if (count($event_ids) > 0 && count($customer_ids) > 0) {
                $visitors = Visitor::select('front_image', 'back_image')->whereIn('customer_id', $customer_ids)->whereIn('event_id', $event_ids)->get()->toArray();
                $event_images = EventImage::select('event_images.event_image')
                    ->join('visitors', 'visitors.id', '=', 'event_images.visitor_id')
                    ->whereIn('visitors.customer_id', $customer_ids)->whereIn('event_images.event_id', $event_ids)
                    ->groupby('event_images.id')
                    ->get()
                    ->toArray();
            } elseif (count($event_ids) == 0 && count($customer_ids) > 0) {
                $visitors = Visitor::select('front_image', 'back_image')->whereIn('customer_id', $customer_ids)->get()->toArray();
                $event_images = EventImage::select('event_images.event_image')
                    ->join('visitors', 'visitors.id', '=', 'event_images.visitor_id')
                    ->whereIn('visitors.customer_id', $customer_ids)
                    ->groupby('event_images.id')
                    ->get()
                    ->toArray();
            } elseif (count($event_ids) > 0 && count($customer_ids) == 0) {
                $visitors = Visitor::select('front_image', 'back_image')->whereIn('event_id', $event_ids)->get()->toArray();
                $event_images = EventImage::select('event_images.event_image')
                    ->join('visitors', 'visitors.id', '=', 'event_images.visitor_id')
                    ->whereIn('event_images.event_id', $event_ids)
                    ->groupby('event_images.id')
                    ->get()
                    ->toArray();
            } else {
                $visitors = Visitor::select('front_image', 'back_image')->get()->toArray();
                $event_images = EventImage::select('event_image')->get()->toArray();
            }
        } else {
            $visitors = Visitor::select('front_image', 'back_image')->get()->toArray();
            $event_images = EventImage::select('event_image')->get()->toArray();
        }
        $visitors_front_images = array_column($visitors, 'front_image');
        $visitors_back_images = array_column($visitors, 'back_image');
        $event_images = array_column($event_images, 'event_image');

        $images = array_merge($visitors_front_images, $visitors_back_images, $event_images);

        $fileName = $this->downloadZip($images);
        $filePath = public_path($fileName);

        if (file_exists($filePath)) {
            return response()->download($filePath)->deleteFileAfterSend(true);
        }
        return redirect('visitor/list');
    }

    public function downloadZip($files)
    {

        $files = array_filter($files);
        $zip = new ZipArchive;

        $fileName = env('ZIP_IMAGE_PATH', 'Images.zip');
        $filePath = public_path($fileName);
        if (file_exists($filePath)) {
            unlink($filePath);
        }

        if ($zip->open($filePath, ZipArchive::CREATE) === TRUE) {
            foreach ($files as $key => $value) {
                $relativeNameInZipFile = basename($value);
                $download_file = file_get_contents($value);
                $zip->addFromString($relativeNameInZipFile, $download_file);
                // $zip->addFile($download_file, $relativeNameInZipFile);
            }

            $zip->close();
        }

        return $fileName;
    }

    public function updateEmail(Request $request)
    {
        $request->validate([
            'id' => 'required',
            'email' => 'required',
        ]);
        $visitor = Visitor::find($request->id);
        if (!empty($visitor)) {
            $visitor->email = $request->email;
            $visitor->updated_at = Carbon::now();
            $visitor->save();
        }
        return redirect()->back();
    }

    public function setMail(Request $request)
    {
        $isSubscriptionExpired = HomeController::checkSubscriptionExpired();
        if ($isSubscriptionExpired) {
            $expiryTitle = !empty(Session::get('expiryTitle')) ? Session::get('expiryTitle') : "Your Subscription is Expired";
            $expiryMessage = !empty(Session::get('expiryMessage')) ? Session::get('expiryMessage') : "Your Subscription is Expired , Please Contact support for Activation.";

            Alert::error($expiryTitle, $expiryMessage);
            return redirect()->back();
        }
        $mailConfigData = DB::table('email_config')->first();
        if (empty($mailConfigData)) {
            return response()->json([
                'status' => false,
                'message' => 'Mail could not be sent because config data not found!'
            ]);
        }
        $requestData = $request->all();
        $requestData['created_by'] = auth()->id();
        $requestData['hour_interval_mails'] = $mailConfigData->hour_limit ?? 20;
        $requestData['schedule_date'] = $request->schedule_date ? Carbon::parse($request->schedule_date) : Carbon::now();
        $requestData['status'] = 'pending';
        $requestData['email_type'] = $request->type;
        // return $request->all();
        $event_ids = !empty($request->event_id) ? explode(',', $request->event_id) : [];
        $customer_ids = !empty($request->CustomerID) ? explode(',', $request->CustomerID) : [];
        $category_ids = !empty($request->category_id) ? explode(',', $request->category_id) : [];
        $sub_category_ids = !empty($request->sub_category_id) ? explode(',', $request->sub_category_id) : [];
        $state_ids = !empty($request->state_id) ? explode(',', $request->state_id) : [];
        $city_ids = !empty($request->city_id) ? explode(',', $request->city_id) : [];
        $is_international = $request->is_international;
        $country_ids = !empty($request->country_id) ? explode(',', $request->country_id) : [];
        $regions = !empty($request->region) ? explode(',', $request->region) : [];
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $actions = !empty($request->action) ? explode(',', $request->action) : [];
        $areas = !empty($request->area) ? explode(',', $request->area) : [];
        $sourceofleads = !empty($request->sourceoflead) ? explode(',', $request->sourceoflead) : [];
        // return [
        //     'event_ids' => $event_ids,
        //     'customer_ids' => $customer_ids,
        //     'category_ids' => $category_ids,
        //     'sub_category_ids' => $sub_category_ids,
        //     'state_ids' => $state_ids,
        //     'city_ids' => $city_ids,
        //     'is_international' => $is_international,
        //     'country_ids' => $country_ids,
        //     'regions' => $regions,
        //     'start_date' => $start_date,
        //     'end_date' => $end_date,
        //     'actions' => $actions,
        //     'areas' => $areas,
        //     'sourceofleads' => $sourceofleads,
        // ];
        $visitorEmails = Visitor::fetchEmailVisitorsMultipleSelection($event_ids, $customer_ids, $category_ids, $sub_category_ids, $state_ids, $city_ids, $is_international, $country_ids, $regions, $start_date, $end_date, $actions, $areas, $sourceofleads)->get();
        // dd($visitorEmails);
        if ($visitorEmails->count() == 0) {
            Alert::error('Error', 'No Visitors found!');
            return redirect()->back();
        }
        $error = "";
        $groupByCustomerId = collect($visitorEmails)->groupBy('customer_id');
        foreach ($groupByCustomerId as $customerId => $emails) {
            $customer = User::where('CustomerID', $customerId)->first();
            if (empty($customer->sender_name) || empty($customer->sender_email)) {
                $totalVisitor = $emails->count();
                $error .= "<b>-> " . $customer?->CustomerName . "</b> : " . $totalVisitor . " visitors<br>";
            }
        }
        if (!empty($error)) {
            $errorMessage = "<div style='text-align: left;'><b>Please enter email config for following team members : </b><br>" . $error . "</div>";
            Alert::html("Error", $errorMessage, "error")->width('580px')->persistent(true);

            return redirect()->back();
        }
        $schedule = EmailBatch::create($requestData);
        foreach ($visitorEmails as $visitorEmail) {
            EmailBatchLog::create([
                'batch_id' => $schedule->id,
                'visitor_id' => $visitorEmail->id,
                'user_id' => $visitorEmail->customer_id,
                'status' => 'pending'
            ]);
        }
        Alert::success('Success', 'Schedule mail set successfully!');
        return redirect()->back();
    }

    public function sendBulkMessage(Request $request)
    {
        // dd($request->all());
        $requestData = $request->all();
        // return $requestData;
        $event_ids = !empty($request->event_id) ? explode(',', $request->event_id) : [];
        $customer_ids = !empty($request->CustomerID) ? explode(',', $request->CustomerID) : [];
        $category_ids = !empty($request->category_id) ? explode(',', $request->category_id) : [];
        $sub_category_ids = !empty($request->sub_category_id) ? explode(',', $request->sub_category_id) : [];
        $state_ids = !empty($request->state_id) ? explode(',', $request->state_id) : [];
        $city_ids = !empty($request->city_id) ? explode(',', $request->city_id) : [];
        $is_international = $request->is_international;
        $country_ids = !empty($request->country_id) ? explode(',', $request->country_id) : [];
        $regions = !empty($request->region) ? explode(',', $request->region) : [];
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $actions = !empty($request->action) ? explode(',', $request->action) : [];
        $areas = !empty($request->area) ? explode(',', $request->area) : [];
        $sourceofleads = !empty($request->sourceoflead) ? explode(',', $request->sourceoflead) : [];
        $visitors = Visitor::fetchBulkMessageVisitorsMultipleSelection($event_ids, $customer_ids, $category_ids, $sub_category_ids, $state_ids, $city_ids, $is_international, $country_ids, $regions, $start_date, $end_date, $actions, $areas, $sourceofleads)->get();
        // dd($visitors->count());
        if ($visitors->count() == 0) {
            // Alert::error('Error', 'No Visitors found!');
            // return redirect()->back();
            return response()->json([
                "status" => false,
                "message" => 'No Visitors found!'
            ]);
        }
        $whatsappConfig = DB::table('whatsapp_configs')->first();
        if (empty($whatsappConfig)) {
            // Alert::error('Error', 'Message could not be sent because config data not found!');
            // return redirect()->back();
            return response()->json([
                "status" => false,
                "message" => 'Message could not be sent because config data not found!'
            ]);
        }
        foreach ($visitors as $visitor) {
            $template = Template::where('id', $request->template_id)->first();
            $visitorNumber = $visitor->mobile_no;
            if ($whatsappConfig) {
                $sendTestMessageUrl = 'https://graph.facebook.com/v21.0/' . $whatsappConfig->phone_id . '/messages';
                if ($template->file_type) {
                    if ($template->file_type == 'image') {
                        $data = [
                            "messaging_product" => "whatsapp",
                            "to" => $visitorNumber,
                            "type" => "template",
                            "template" => [
                                "name" => $template->name,
                                "language" => [
                                    "code" => "en"
                                ],
                                "components" => [
                                    [
                                        "type" => "header",
                                        "parameters" => [
                                            [
                                                "type" => "image",
                                                "image" => [
                                                    "id" => $template->whatsapp_file_id
                                                ]
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ];
                    } else {
                        $data = [
                            "messaging_product" => "whatsapp",
                            "to" => $visitorNumber,
                            "type" => "template",
                            "template" => [
                                "name" => $template->name,
                                "language" => [
                                    "code" => "en"
                                ],
                                "components" => [
                                    [
                                        "type" => "header",
                                        "parameters" => [
                                            [
                                                "type" => "DOCUMENT",
                                                "document" => [
                                                    "id" => $template->whatsapp_file_id
                                                ]
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ];
                    }
                } else {
                    $data = [
                        "messaging_product" => "whatsapp",
                        "to" => $visitorNumber,
                        "type" => "template",
                        "template" => [
                            "name" => $template->name,
                            "language" => [
                                "code" => "en"
                            ]
                        ]
                    ];
                }
                $ch = curl_init($sendTestMessageUrl);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $whatsappConfig->token
                ]);
                $sendTestMessageResponse = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                $sendTestMessageResponse = json_decode($sendTestMessageResponse);
                //dd($sendTestMessageResponse);
            }
            $requestData['user_id'] = auth()->id();
            $requestData['visitor_id'] = $visitor->id;
            $requestData['template_id'] = $request->template_id;
            $requestData['mobile'] = $visitorNumber;
            WhatsappLog::create($requestData);
        }
        // Alert::success('Success', 'All messages are sent successfully!');
        // return redirect()->back();
        return response()->json([
            "status" => true,
            "message" => "Message send successfully"
        ]);
    }

    public function batchList(Request $request, VisitorBatchDataTable $dataTable)
    {
        return $dataTable->render('visitor.batch-list');
    }

    public function batchDelete($batch_id)
    {
        $emailBatch = EmailBatch::whereId($batch_id)->first();
        if (empty($emailBatch)) {
            return response()->json([
                "status" => false,
            ]);
        }
        EmailBatchLog::whereBatchId($emailBatch->id)->delete();
        $emailBatch->delete();
        return response()->json([
            "status" => true,
        ]);
    }
    public function getimage(Request $request)
    {
        try {
            $data = DB::table('visitors')->where('id', $request->id)->get();
            // dd($data);
            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function geteventlist_multi(Request $request)
    {
        try {
            $data = DB::table('events')->select('event_name', 'id')->get();

            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function get_visitdata(Request $request)
    {
        try {

            $data = DB::table('visit_data')->where('id', $request->id)->get();

            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function get_visit_images(Request $request)
    {
        try {

            $data = DB::table('visit_data_images')->where('fk_visit_id', $request->id)->get();

            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function get_visit_product(Request $request)
    {
        try {

            $data = DB::table('visit_data_product')
                ->select('visit_data_product.*', 'products.name as productname')
                ->leftjoin('products', 'products.id', 'visit_data_product.fk_product_id')
                ->where('fk_visit_data_id', $request->id)
                ->get();

            // dd($data);
            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function geteventlist(Request $request)
    {
        try {
            $data = DB::table('events')->select('event_name', 'id')->get();

            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function updateeventname(Request $request)
    {
        try {
            $dataArray = $request->visitor_id;
            $jsonStr = $dataArray[0];
            $idArray = json_decode($jsonStr);

            foreach ($idArray as $id) {
                $visitor = Visitor::find($id);

                if (!empty($visitor)) {
                    $visitor->event_id = $request->eventid;
                    $visitor->updated_at = Carbon::now();
                    $visitor->save();
                }
            }
            return redirect()->back();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function addevent_ids(Request $request)
    {
        $event_id = $request->event_id;
        $status = $request->status;
        $visitor_id = $request->visitor_id;

        // Retrieve the existing row
        $existingRow = DB::table('visitors')->where('id', $visitor_id)->first();

        if ($existingRow) {
            // Get the current event_ids from the existing row
            $currentEventIds = $existingRow->event_ids;

            // Convert the current event_ids string to an array
            $eventIdsArray = $currentEventIds ? explode(',', $currentEventIds) : [];

            if ($status === 'add') {
                // Add the event_id to the array if it's not already present
                if (!in_array($event_id, $eventIdsArray)) {
                    $eventIdsArray[] = $event_id;
                }
            } elseif ($status === 'remove') {
                // Remove the event_id from the array
                $eventIdsArray = array_filter($eventIdsArray, function ($id) use ($event_id) {
                    return $id != $event_id;
                });
            }

            // Convert the array back to a comma-separated string
            $updatedEventIdsString = implode(',', $eventIdsArray);

            // Update the event_ids field in the database
            DB::table('visitors')
                ->where('id', $visitor_id)
                ->update(['event_ids' => ',' . $updatedEventIdsString . ',', 'updated_at' => Carbon::now('Asia/Kolkata')]);

            // give notification to assignen used in this events
            if ($status == "add") {

                // $eventIDs =  explode(',', $data['event_ids']);
                $visitor = Visitor::where('id', $request->visitor_id)->first();
                $main_admins_ids = User::where('is_admin', 'true')->pluck('user_id')->toArray();
                // $eventData = Event::with('assignes_admins')->where('id', $data['event_id'])->first();
                $eventData = Event::with([
                    'assignes_admins' => function ($query) use ($main_admins_ids) {
                        $query->whereNotIn('fk_user_id', $main_admins_ids);
                    }
                ])->where('id', $visitor->event_id)->first();
                if (!empty($eventData)) {
                    $assignes_admins_ids = $eventData->assignes_admins->pluck('fk_user_id')->toArray();
                    $push_notifications_users_ids = array_merge($main_admins_ids, $assignes_admins_ids);
                } else {
                    $push_notifications_users_ids = $main_admins_ids;
                }
                $current_user_id = Auth::user()->user_id ?? null;
                if ($current_user_id !== null) {
                    $push_notifications_users_ids = array_diff($push_notifications_users_ids, [$current_user_id]);
                }
                $push_users = User::whereIn('user_id', $push_notifications_users_ids)->get();

                $eventData = Event::with('assignes_admins', 'assignes_admins.user')->where('id', $visitor->event_id)->first();

                if (!empty($eventData)) {
                    $eventName = $eventData->event_name;
                    if (count($push_users) > 0) {
                        $androidTokens = [];
                        $iosTokens = [];
                        foreach ($push_users as $assignee) {
                            if ($assignee->device_type == 'android') {
                                array_push($androidTokens, $assignee->push_token);
                            } else {
                                array_push($iosTokens, $assignee->push_token);
                            }
                        }
                        $title = "Client Added";
                        $pushObj = new Sendpush();
                        $msg = $visitor->name . "is added to " . $eventName;
                        $message = array("notification_type" => "visitor_visited", "message" => $msg, "title" => $title, 'visitor_id' => $visitor->id, 'event_id' => $visitor->event_id);
                        if (count($androidTokens) > 0) {
                            $pushObj->sendAndriodNotification($androidTokens, $message);
                        }
                        if (count($iosTokens) > 0) {
                            $pushObj->sendIOSNotification($iosTokens, $message, $title);
                        }
                    }
                }
            }
        }



        if ($status == 'add') {
            Alert::success('Success', 'Assigned Client Successfully!');
        } else {
            Alert::success('Success', 'Removed Client Successfully!');
        }
        return redirect()->back();
    }
    public function assigneventids(Request $request)
    {
        $visitorids = $request->visitor_id;
        $jsonStr = $visitorids[0];
        $visitor_ids = json_decode($jsonStr);
        $event_id = $request->event_id;

        for ($i = 0; $i < count($visitor_ids); $i++) {
            $visitor_id = $visitor_ids[$i];
            //dd($visitor_id);
            $existingRow = DB::table('visitors')->where('id', $visitor_id)->first();

            if ($existingRow) {

                $currentEventIds = $existingRow->event_ids;

                $eventIdsArray = $currentEventIds ? explode(',', $currentEventIds) : [];

                if (count($eventIdsArray) > 0) {
                    // Merge the arrays
                    $mergedArr = array_merge($event_id, $eventIdsArray);

                    // Remove duplicates
                    $eventIdsArray = array_unique($mergedArr);
                } else {
                    $eventIdsArray = $event_id;
                }

                //print_r($eventIdsArray);
                $updatedEventIdsString = implode(',', $eventIdsArray);

                DB::table('visitors')
                    ->where('id', $visitor_id)
                    ->update(['event_ids' => ',' . $updatedEventIdsString . ',', 'updated_at' => Carbon::now('Asia/Kolkata')]);
            }
        }
        //dd($request);
        Alert::success('Success', 'Assigned Client Successfully!');
        return redirect()->back();
    }



    function fetchevent(Request $request)
    {
        if ($request->get('query')) {
            $query = $request->get('query');
            $data = DB::table('events')
                ->where('event_name', 'LIKE', "%{$query}%")
                ->get();
            $output = '
                    <div class="menu" style="display:block; position:relative"></div>
                    ';
            foreach ($data as $row) {
                $output .= '
                <li><a href="#">' . $row->event_name . '</a></li>
                ';
            }
            $output .= '</ul>';
            echo $output;
        }
    }
    function getname_search(Request $request)
    {
        try {
            $getFields = DB::table('events')
                ->select('event_name')
                ->where('event_name', $request->search)
                ->first();

            return response()->json($getFields, 200);
        } catch (\Exception $e) {
            return response()->json([
                'message' => $e->getMessage()
            ], 500);
        }
    }
    public function destroy($id)
    {
        try {
            DB::table('visitor_products')->where('visitor_id', $id)->delete();
            Visitor::where('id', $id)->delete();

            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
    public function getproductlist(Request $request)
    {
        try {
            $data = DB::table('product_images')->select('image', 'id', 'description')->get();

            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function edit(Request $request, Visitor $visitor)
    {
        //  $isSubscriptionExpired = HomeController::checkSubscriptionExpired();
        // if ($isSubscriptionExpired) {
        //     $expiryTitle = !empty(Session::get('expiryTitle')) ? Session::get('expiryTitle') : "Your Subscription is Expired";
        //     $expiryMessage = !empty(Session::get('expiryMessage')) ? Session::get('expiryMessage') : "Your Subscription is Expired , Please Contact support for Activation.";

        //     Alert::error($expiryTitle, $expiryMessage);
        //     return redirect()->back();
        // }
        $event_images = DB::table('event_images')
            ->where('visitor_id', $visitor->id)
            ->get();
        $visitor->category = explode(',', $visitor->category);
        $visitor->sub_category = explode(',', $visitor->sub_category);
        $actions = DB::table('actions')->select('title', 'id')->orderBy('title', 'asc')->get();
        $categories = json_encode(DB::table('category')->select('name', 'id')->orderBy('name', 'asc')->get()->toArray());
        $categoryIds = DB::table('category')->whereIn('name', $visitor->category)->get()->pluck('id');
        $subcategories = [];
        if ($categoryIds) {
            $subcategories = DB::table('sub_categories')->whereIn('fk_category_id', $categoryIds)->select('name', 'id')->get();
        }
        $countries = DB::table('countries')->select('iso_code', 'name', 'id')->orderBy('name', 'asc')->get();
        $states = [];
        if ($visitor->address_country_code && $visitor->address_country_code == 'IN') {
            $states = DB::table('states')->where('country_code', $visitor->address_country_code)->select('name', 'id')->orderBy('name', 'asc')->get();
        }
        $state = DB::table('states')->where('name', $visitor->state)->first();
        $cities = [];
        if ($state) {
            $cities = DB::table('cities')->where('state_id', $state->id)->select('name', 'id')->orderBy('name', 'asc')->get();
        }
        $city = DB::table('cities')->where('name', $visitor->city)->first();
        $isOtherArea = false;
        $areas = [];
        if (!empty($city?->name)) {
            $areas = DB::table('areas')->where('city_name', $city?->name)->select('name', 'id')->orderBy('name', 'asc')->get();
            $hasAreas = $areas->where('name', $visitor->area)->first();
            if (empty($hasAreas)) {
                $isOtherArea = true;
            }
        } else {
            $isOtherArea = true;
        }
        $visitor->products = DB::table('visitor_products')
            ->select('products.id as id')
            ->leftjoin('products', 'products.id', 'visitor_products.product_id')
            ->where('visitor_products.visitor_id', $visitor->id)
            ->get()->pluck('id')->toArray();
        $allProducts = json_encode(DB::table('products')->get()->toArray());
        $source_of_leads = SourceOfLead::pluck('name')->toArray();
        $members = DB::table('users')->select('CustomerName', 'user_id', 'CustomerID')->where('is_delete', '=', 'false');

        $authAdmin = auth()->user();
        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $members = $members->whereIn('CustomerID', $divisionTeamMemberIds);
        }
        $members = $members->orderBy('CustomerName', 'asc')->get();
        $referredBy = ReferredByMaster::pluck('name')->toArray();
        return view('visitor.editvisitor', compact('areas', 'isOtherArea', 'referredBy', 'visitor', 'actions', 'categories', 'subcategories', 'states', 'cities', 'allProducts', 'event_images', 'countries', 'source_of_leads', 'members'));
    }

    public static function getNewUrl()
    {
        $appUrl = config('app.url');
        $newUrlArray = explode('/', $appUrl);
        array_pop($newUrlArray);
        return implode('/', $newUrlArray);
    }
    public function update(Request $request, Visitor $visitor)
    {
        $requestData = $request->all();
        //dd($requestData);
        $requestData['updated_at'] = Carbon::now('Asia/Kolkata');
        $requestData['category'] = implode(',', $request->category ?? []);
        $requestData['sub_category'] = implode(',', $request->sub_category ?? []);
        $requestData['source_of_lead'] = isset($request->source_of_lead) ? $request->source_of_lead : null;
        if (isset($request->othercity) && $request->othercity != '') {
            $requestData['city'] = $request->othercity;
        }
        // Front Image Upload
        if ($request->file('front_image')) {

            if ($visitor->front_image) {
                $frontimageName = basename(parse_url($visitor->front_image, PHP_URL_PATH));
                $oldFrontImagePath = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $frontimageName);
                // Check if the file exists and delete it
                if (file_exists($oldFrontImagePath)) {
                    unlink($oldFrontImagePath); // Delete the old front image
                }
            }

            $name = str_replace(' ', '_', $request->file('front_image')->getClientOriginalName());
            $ext = $request->file('front_image')->getClientOriginalExtension();
            $image = md5(microtime() . $name) . "." . $ext;
            $path = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/');
            $request->file('front_image')->move($path, $name);
            $requestData['front_image'] = isset($name) && $name != '' ? self::getNewUrl() . '/' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $name : '';
        }
        // Back Image upload
        if ($request->file('back_image')) {

            if ($visitor->back_image) {
                $backImageName = basename(parse_url($visitor->back_image, PHP_URL_PATH));
                $oldBackImagePath = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $backImageName);
                if (file_exists($oldBackImagePath)) {
                    unlink($oldBackImagePath); // Delete the old back image
                }
            }

            $name = str_replace(' ', '_', $request->file('back_image')->getClientOriginalName());
            $ext = $request->file('back_image')->getClientOriginalExtension();
            $image = md5(microtime() . $name) . "." . $ext;
            $path = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/');
            $request->file('back_image')->move($path, $name);
            $requestData['back_image'] = isset($name) && $name != '' ? self::getNewUrl() . '/' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $name : '';
        }

        // Event Images Uploads
        $event_images_all = $request->file('event_images');
        if (isset($event_images_all) && !empty($event_images_all)) {
            foreach ($event_images_all as $key => $value) {
                if (isset($value) && $value != '') {
                    $event_image = \str_replace(' ', '_', $value->getClientOriginalName());
                    if ($value->move(\public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/event/'), $event_image)) {
                        $event_image = isset($event_image) && $event_image != '' ? self::getNewUrl() . '/' . config('constants.API_PROJECT_NAME') . '/public/uploads/event/' . $event_image : '';

                        if (isset($event_image) && $event_image != '') {
                            EventImage::create([
                                'visitor_id' => $visitor->id,
                                'event_id' => $visitor->event_id,
                                'event_image' => $event_image,
                            ]);
                        }
                    }
                }
            }
        }


        if (!empty($requestData['source_of_lead']) && $requestData['source_of_lead'] == 'Referred By') {
            $requestData['referred_by'] = $request->referred_by_name ?? null;
        } else {
            $requestData['referred_by'] = null;
        }
        $visitor->update($requestData);
        if ($request->products) {
            DB::table('visitor_products')->where('visitor_id', $visitor->id)->delete();
            foreach ($request->products as $productId) {
                DB::table('visitor_products')->insert([
                    'visitor_id' => $visitor->id,
                    'product_id' => $productId,
                    'created_at' => Carbon::now('Asia/Kolkata'),
                    'updated_at' => Carbon::now('Asia/Kolkata'),
                ]);
            }
        }



        //call zoho api here
        $response = $this->sendZohoRequest($visitor);
        //call zoho api end

        Alert::success('Success', 'Visitor data updated successfully!');
        return redirect()->back();
    }

    public function getSubCategories(Request $request)
    {
        try {
            if ($request->categoryNames) {
                $categoryIds = DB::table('category')
                    ->whereIn('name', $request->categoryNames)
                    ->select('name', 'id')->pluck('id')->toArray();
                $data = DB::table('sub_categories')->whereIn('fk_category_id', $categoryIds)->get();
                $selectedSubCategoryIds = DB::table('sub_categories')
                    ->whereIn('name', explode(',', $request->selectedSubCategoryNames))
                    ->select('name', 'id')->pluck('id')->toArray();

                if (!empty($data->toArray())) {
                    return response()->json(['data' => $data, 'selectedSubCategoryIds' => $selectedSubCategoryIds]);
                }
            } elseif ($request->category_id) {
                $data = DB::table('sub_categories')->where('fk_category_id', $request->category_id)->get();
                if (!empty($data->toArray())) {
                    return response()->json(['data' => $data]);
                }
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function getSubCategoriesBulk(Request $request)
    {
        try {
            $categoryNames = $request?->categoryNames ?? [];
            $categoryIds = $request?->category_id ?? [];
            if (!empty($categoryNames) && count($categoryNames) > 0) {
                $categoryIds = DB::table('category')
                    ->whereIn('name', $categoryNames)
                    ->select('name', 'id')->pluck('id')->toArray();
                $data = DB::table('sub_categories')->whereIn('fk_category_id', $categoryIds)->get();
                $selectedSubCategoryIds = DB::table('sub_categories')
                    ->whereIn('name', explode(',', $request->selectedSubCategoryNames))
                    ->select('name', 'id')->pluck('id')->toArray();

                if (!empty($data->toArray())) {
                    return response()->json(['data' => $data, 'selectedSubCategoryIds' => $selectedSubCategoryIds]);
                }
            } elseif (!empty($categoryIds) && count($categoryIds) > 0) {
                $data = DB::table('sub_categories')->whereIn('fk_category_id', $categoryIds)->get();
                if (!empty($data->toArray())) {
                    return response()->json(['data' => $data]);
                }
            }
        } catch (\Throwable $th) {
            throw $th;
        }
    }



    public function getCities(Request $request)
    {
        try {
            if ($request->stateName) {
                $stateId = DB::table('states')->where('name', $request->stateName)->select('name', 'id')->first()->id;
            } elseif ($request->stateId) {
                $cities = DB::table('AddressDataTBL')->select('district', 'id')->where('state', $request->stateId)->groupBy('district')->orderBy('district', 'asc')->get();
                return response()->json(['data' => $cities]);
            }
            $data = DB::table('cities')->where('state_id', $stateId)->get();

            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function getCitiesBulk(Request $request)
    {
        try {
            $stateNames = $request?->stateId ?? [];

            $cities = DB::table('AddressDataTBL')->select('district', 'id')->whereIn('state', $stateNames)->groupBy('district')->orderBy('district', 'asc')->get();
            if (empty($cities) && count($cities) == 0) {
                $cities = DB::table('cities')->select('cities.name as district', 'cities.id')->join('states', 'states.id', 'cities.state_id')->whereIn('states.name', $stateNames)->get();
            }
            if (!empty($cities->toArray())) {
                return response()->json(['data' => $cities]);
            } else {
                return response()->json(['data' => []]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function getAreas(Request $request)
    {
        try {
            $city = $request->city;
            $areas = DB::table('areas')->select('areas.name', 'areas.id')->where('city_name', $city)->orderBy('areas.name', 'asc')->get();
            return response()->json(['data' => $areas]);
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function getAreasBulk(Request $request)
    {
        try {
            $city = $request->city ?? [];
            $areas = DB::table('areas')->select('areas.name', 'areas.id')->whereIn('city_name', $city)->orderBy('areas.name', 'asc')->get();
            return response()->json(['data' => $areas]);
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function getStates(Request $request)
    {
        try {
            if ($request->countryName) {
                $countryId = DB::table('countries')->where('name', $request->countryName)->select('name', 'id')->first()->id;
            } elseif ($request->countryId) {
                $states = DB::table('AddressDataTBL')->select('state', 'id')->groupBy('state')->orderBy('state', 'asc')->get();
                return response()->json(['data' => $states]);
            } elseif ($request->countryCode) {
                $countryId = DB::table('countries')->where('iso_code', $request->countryCode)->select('name', 'id')->first()->id;
            }
            $data = DB::table('states')->where('country_id', $countryId)->orderBy('name', 'asc')->get();
            // dd($countryId);
            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function getStatesBulk(Request $request)
    {
        try {
            $countryIds = $request?->countryId ?? [];

            $indiaCountryExists = DB::table('countries')->whereIn('name', $countryIds)->whereRaw('LOWER(name) = ?', ['india'])->exists();
            if ($indiaCountryExists) {
                $states = DB::table('AddressDataTBL')->select('state', 'id')->groupBy('state')->orderBy('state', 'asc')->get();
                return response()->json(['data' => $states]);
            }
            return response()->json(['data' => []]);

            // $data = DB::table('states')->select('states.name as state', 'states.id as id')->join('countries', 'countries.id', 'states.country_id')->whereIn('countries.name', $countryIds)->orderBy('states.name', 'asc')->get();
            // // dd($countryId);
            // if (!empty($data->toArray())) {
            //     return response()->json(['data' => $data]);
            // }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function getCountries(Request $request)
    {
        try {
            $data = DB::table('countries')->where('iso_code', '!=', 'IN')->select('name', 'id')->orderBy('name', 'asc')->get();

            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }


    public function add()
    {
        $isSubscriptionExpired = HomeController::checkSubscriptionExpired();
        if ($isSubscriptionExpired) {
            $expiryTitle = !empty(Session::get('expiryTitle')) ? Session::get('expiryTitle') : "Your Subscription is Expired";
            $expiryMessage = !empty(Session::get('expiryMessage')) ? Session::get('expiryMessage') : "Your Subscription is Expired , Please Contact support for Activation.";

            Alert::error($expiryTitle, $expiryMessage);
            return redirect()->back();
        }
        $authAdmin = auth()->user();

        $source_of_leads = SourceOfLead::pluck('name')->toArray();
        $events = DB::table('events')->select('events.event_name', 'events.id')
            ->join('event_assignments', 'event_assignments.fk_event_id', 'events.id')
            ->where('event_assignments.fk_user_id', '=', $authAdmin->user_id)
            ->orderBy('events.event_name', 'asc')->get();


        $members = DB::table('users')->select('CustomerName', 'user_id', 'CustomerID')->where('is_delete', '=', 'false');

        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $members = $members->whereIn('CustomerID', $divisionTeamMemberIds);
        }
        $members = $members->orderBy('CustomerName', 'asc')->get();
        $actions = DB::table('actions')->select('title', 'id')->orderBy('title', 'asc')->get();
        $referredBy = ReferredByMaster::pluck('name')->toArray();
        $categories = json_encode(DB::table('category')->select('name', 'id')->orderBy('name', 'asc')->get()->toArray());
        $countries = DB::table('countries')->select('iso_code', 'name', 'id')->orderBy('name', 'asc')->get();
        $allProducts = json_encode(DB::table('products')->get()->toArray());
        $countryCode = '99';
        return view('visitor.add_visitor', compact('referredBy', 'actions', 'categories', 'countries', 'events', 'members', 'allProducts', 'countryCode', 'source_of_leads'));
    }

    public function store(Request $request)
    {


        $request->validate([
            'event_id' => 'required',
            'customer_id' => 'required',
            // 'name' => 'required',
        ]);
        $requestData = $request->all();
        // $requestData['follow_up_time'] = Carbon::now('Asia/Kolkata');
        $requestData['created_at'] = Carbon::now('Asia/Kolkata');
        $requestData['updated_at'] = Carbon::now('Asia/Kolkata');

        $requestData['visited_date'] = $request->visited_date;
        $requestData['category'] = implode(',', $request->category ?? []);
        $requestData['sub_category'] = implode(',', $request->sub_category ?? []);
        $requestData['source_of_lead'] = isset($request->source_of_lead) ? $request->source_of_lead : null;
        if (!empty($requestData['source_of_lead']) && $requestData['source_of_lead'] == 'Referred By') {
            $requestData['referred_by'] = $request->referred_by_name ?? null;
        } else {
            $requestData['referred_by'] = null;
        }
        if (isset($request->othercity) && $request->othercity != '') {
            $requestData['city'] = $request->othercity;
        }
        if (!empty($request->area) && $request->area == 'Other') {
            $requestData['area'] = $request?->otherarea ?? '';
        }
        //$request->request->remove('othercity');
        // dd($requestData);
        $visitor = Visitor::create($requestData);
        $requestData['front_image'] = null;
        $requestData['back_image'] = null;
        if ($request->file('front_image')) {
            $name = str_replace(' ', '_', $request->file('front_image')->getClientOriginalName());
            $ext = $request->file('front_image')->getClientOriginalExtension();
            $image = md5(microtime() . $name) . "." . $ext;
            $path = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/');
            $request->file('front_image')->move($path, $name);
            $requestData['front_image'] = isset($name) && $name != '' ? self::getNewUrl() . '/' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $name : '';
        }
        if ($request->file('back_image')) {
            $name = str_replace(' ', '_', $request->file('back_image')->getClientOriginalName());
            $ext = $request->file('back_image')->getClientOriginalExtension();
            $image = md5(microtime() . $name) . "." . $ext;
            $path = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/');
            $request->file('back_image')->move($path, $name);
            $requestData['back_image'] = isset($name) && $name != '' ? self::getNewUrl() . '/' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $name : '';
        }
        $visitor->update([
            'front_image' => $requestData['front_image'],
            'back_image' => $requestData['back_image']
        ]);

        // Event Images Uploads
        $event_images_all = $request->file('event_images');
        if (isset($event_images_all) && !empty($event_images_all)) {
            foreach ($event_images_all as $key => $value) {
                if (isset($value) && $value != '') {
                    $event_image = \str_replace(' ', '_', $value->getClientOriginalName());
                    if ($value->move(\public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/event/'), $event_image)) {
                        $event_image = isset($event_image) && $event_image != '' ? self::getNewUrl() . '/' . config('constants.API_PROJECT_NAME') . '/public/uploads/event/' . $event_image : '';

                        if (isset($event_image) && $event_image != '') {
                            EventImage::create([
                                'visitor_id' => $visitor->id,
                                'event_id' => $visitor->event_id,
                                'event_image' => $event_image,
                            ]);
                        }
                    }
                }
            }
        }

        if ($request->products) {
            DB::table('visitor_products')->where('visitor_id', $visitor->id)->delete();
            foreach ($request->products as $productId) {
                DB::table('visitor_products')->insert([
                    'visitor_id' => $visitor->id,
                    'product_id' => $productId,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now()
                ]);
            }
        }

        //call zoho api here
        $response = $this->sendZohoRequest($visitor);
        //call zoho api end

        Alert::success('Success', 'Visitor data added successfully!');

        if (Auth::user()->getUser() && Auth::user()->getUser()->is_admin == "true") {
            return redirect()->route('visitor.list');
        } else {
            return redirect('visitor/listbyevent?event_id=' . $request->event_id);
        }
    }


    private function sendZohoRequest($visitor)
    {

        $zoho_crm_data = DB::table('zoho_crm')->first();
        if (empty($zoho_crm_data)) {
            return false;
        }

        $names = explode(' ', $visitor->name);
        $eventData = Event::where('id', $visitor->event_id)->first();

        $visitorData = [
            'Company' => $visitor->company_name,
            'Last_Name' => isset($names[1]) ? implode(' ', array_slice($names, 1)) : 'last name',
            'First_Name' => $names[0],
            'Email' => $visitor->email,
            'State' => $visitor->state ?? 'state',
            'Lead_Source' => $eventData->event_name ?? '',
            'front_image' => $visitor->front_image ?? '',
            'back_image' => $visitor->back_image ?? '',
            'Phone' => $visitor->mobile_no2 ?? '',
            'Industry' => $visitor->category ?? '',
            'Secondary_Email' => $visitor->email2 ?? '',
            'Website' => $visitor->website ?? '',
            'City' => $visitor->city ?? '',
            'Country' => $visitor->country_code ?? '',
            'Street' => $visitor->address ?? '',
            'Zip_Code' => $visitor->pincode ?? '',
            'Title' => $visitor->designation ?? ''
        ];

        if (!empty($visitor->mobile_no)) {
            $visitorData['Mobile'] = $visitor->mobile_no;
        }

        // Product and remarks
        $Description = '';
        $products = '';
        $visitorProducts = VisitorProduct::where('visitor_id', $visitor->id)->get();
        if (count($visitorProducts) > 0) {
            $productNames = [];
            foreach ($visitorProducts as $vproduct) {
                $productNames[] = $vproduct->ProductName;
            }
            $products = implode(',', $productNames);
        }

        if (!empty($products)) {
            $Description .= "\n\nProducts: $products";
        }

        if (!empty($visitor->remarks)) {
            if (!empty($products)) {
                $Description .= "\n\n";
            }
            $Description .= "Remarks: $visitor->remarks";
        }

        $visitorData['Description'] = $Description;
        // Product and remarks end

        //Image upload code start here
        $images = [];

        if (!empty($visitor['front_image'])) {

            $frontImageName = basename($visitor['front_image']);

            $imagePath = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $frontImageName);
            if (file_exists($imagePath)) {
                $images[] = new \CURLFile($imagePath);
            }
        }

        if (!empty($visitor['back_image'])) {
            $backImageName = basename($visitor['back_image']);
            $imagePath = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $backImageName);
            if (file_exists($imagePath)) {
                $images[] = new \CURLFile($imagePath);
            }
        }

        $image_upload_response = "";
        if (count($images) > 0) {
            $image_upload_response = $this->uploadDynamicFilesToZoho($images, $zoho_crm_data);
        }


        if (is_array($image_upload_response) && count($image_upload_response) > 0) {
            $visitorData['Record_Image'] = $image_upload_response[0]->File_Id__s;
            if (count($image_upload_response) == '2') {
                unset($image_upload_response[0]);
                $visitorData['File_upload'] = $image_upload_response;
            }
        }

        //Image upload code end here

        $data = [
            'data' => [$visitorData],
            "duplicate_check_fields" => [
                "Email",
            ],
            'trigger' => ['approval', 'workflow', 'blueprint']
        ];


        $ch = curl_init('https://www.zohoapis.in/crm/v7/Leads/upsert');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: Zoho-oauthtoken ' . $zoho_crm_data->access_token
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        $response = json_decode($response);
        // Check for errors and log them
        if (isset($response->code) && $response->code === 'INVALID_TOKEN') {
            $refreshResponse = $this->refreshAccessToken($zoho_crm_data);
            if (isset($refreshResponse->access_token)) {
                DB::table('zoho_crm')->where('id', $zoho_crm_data->id)->update(['access_token' => $refreshResponse->access_token]);
                $response = $this->sendZohoRequest($visitor);
            }
        }

        $zohoId = $response->data[0]->details->id ?? '';
        DB::table('visitors')->where('id', $visitor->id)->update(['zoho_id' => $zohoId]);

        return $response;
    }

    private function uploadDynamicFilesToZoho($images, $zoho_crm_data)
    {

        $apiUrl = 'https://www.zohoapis.in/crm/v7/files';

        $headers = [
            'Authorization' => 'Zoho-oauthtoken ' . $zoho_crm_data->access_token,
        ];

        if (empty($images)) {
            return 'Error: No images to upload.';
        }

        $request = Http::withHeaders($headers);

        foreach ($images as $index => $image) {
            $request = $request->attach('file', fopen($image->getFilename(), 'r'), $image->getPostFilename());
        }

        $response = $request->post($apiUrl, [
            'type' => 'inline',
        ]);


        if ($response->successful()) {
            $responseData = $response->json();
            $fileIds = [];  // Initialize the array

            foreach ($responseData['data'] as $fileData) {
                if (isset($fileData['details']['id'])) {
                    $fileIds[] = (object) [
                        'File_Id__s' => $fileData['details']['id'],
                    ];
                }
            }
            return $fileIds;
        } else {
            $refreshResponse = $this->refreshAccessToken($zoho_crm_data);
            if (isset($refreshResponse->access_token)) {
                DB::table('zoho_crm')->where('id', $zoho_crm_data->id)->update(['access_token' => $refreshResponse->access_token]);
                $response = $this->uploadDynamicFilesToZoho($images, $zoho_crm_data);
                return $response;
            }
        }

        return 'Error uploading files: ' . $response->body();
    }

    public function refreshAccessToken($zoho_crm_data)
    {
        $refreshData = [
            'client_id' => $zoho_crm_data->client_id,
            'client_secret' => $zoho_crm_data->client_secret,
            'refresh_token' => $zoho_crm_data->refresh_token,
            'grant_type' => 'refresh_token'
        ];

        $ch = curl_init('https://accounts.zoho.in/oauth/v2/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($refreshData));

        $refreshResponse = curl_exec($ch);
        curl_close($ch);

        return json_decode($refreshResponse);
    }


    public function get_visitorlist_id(Request $request)
    {
        try {
            // \DB::enableQueryLog();
            // dd(\DB::getQueryLog());

            $data = DB::table('visitors')
			->where(function ($data_all) use ($request) {
                    $data_all->where('visitors.mobile_no', $request->mobile_no)
                        ->where('visitors.mobile_no', '!=', '')
                        ->orWhere(function ($query) use ($request) {
                            $query->where('visitors.email', $request->email)
                                ->where('visitors.email', '!=', '');
                        });
                    //->orWhere('visitors.email', $request->email);
                })
                // ->where('visitors.email','!=',"")
                // ->where('visitors.email','!=',null)
                // ->where('visitors.mobile_no','!=',"")
                // ->orWhere(function($data_all) use ($request) {
                //     $data_all->where('visitors.mobile_no', '!=', $request->mobile_no)
                //           ->where('visitors.email', $request->email)
                //           ->where('visitors.email','!=',"null");
                // })

                // ->where('visitors.mobile_no','!=',"")
                ->leftjoin('events', 'events.id', 'visitors.event_id')
                ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
                ->select('visitors.*', 'events.event_name as event_name', 'users.CustomerName as CustomerName')
                ->get();

            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function Multiple_Entries_destroy($id)
    {
        try {
            DB::table('visitor_products')->where('visitor_id', $id)->delete();
            Visitor::where('id', $id)->delete();
            // DB::table('visit_data')->where('fk_visitor_id',$id)->get();
            DB::table('visit_data')->where('fk_visitor_id', $id)->delete();

            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    public function addVisitDataModal(Request $request)
    {
        $event_id = $request->event_id;
        $visit_data_id = $request->visit_data_id ?? null;
        $action = $request->action ?? null;
        $data['action'] = $action;
        $title = 'Add';
        $data['visitor_id'] = $request->visitor_id;
        $data['allProducts'] = Product::pluck('name', 'id')->toArray();
        $data['actions'] = Action::latest()->pluck('title', 'id')->toArray();
        $data['members'] = User::where('is_delete', '=', 'false')->pluck('CustomerName', 'CustomerID')->toArray();
        $data['current_time'] = Carbon::now('Asia/Kolkata')->format('Y-m-d h:i');
        if (!empty($visit_data_id)) {
            $visitData = VisitData::with('products')->where('id', $visit_data_id)->first();
            $data['visit_data'] = $visitData;
            $title = 'Edit';
        }

        $form_url = route('visit.data.store', $event_id);
        $modalHtml = view('visitor.add_visit_data_modal', compact('form_url', 'data', 'title'))->render();
        return response()->json(['modalHtml' => $modalHtml]);
    }

    public function addVisitDataStore(Request $request)
    {
        try {
            $data = $request->all();
            $data['created_at'] = Carbon::now('Asia/Kolkata');
            $data['updated_at'] = Carbon::now('Asia/Kolkata');
            $fk_visitor_id = $request->fk_visitor_id;
            $visit_data_id = $request->visit_data_id ?? null;

            // audio_file
            // $data['audio_file'] = null;
            if ($request->hasFile('audio_file')) {
                $audio_file = $request->file('audio_file');
                $audio = \str_replace(' ', '_', $audio_file->getClientOriginalName());
                $path = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/');
                $request->file('audio_file')->move($path, $audio);
                $audio_file = $audio;
                $data['audio_file'] = isset($audio_file) && $audio_file != '' ? self::getNewUrl() . '/' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $audio_file : '';
            }
            $team_member = user::where('CustomerID', $request->fk_teammember_id)->first();
            $data['attend_by'] = $team_member->CustomerName;
            $visit_data = VisitData::updateOrCreate(['id' => $visit_data_id], $data);
            Visitor::where('id', $fk_visitor_id)->update(['action' => $request->action, 'follow_up_time' => $request->follow_up_time, 'updated_at' => Carbon::now('Asia/Kolkata')]);

            $visit_images_all = $request->file('visit_images');

            if (isset($visit_images_all) && !empty($visit_images_all)) {
                foreach ($visit_images_all as $key => $value) {
                    if (isset($value) && $value != '') {
                        $visit_image = \str_replace(' ', '_', $value->getClientOriginalName());
                        if ($value->move(\public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/event/'), $visit_image)) {
                            $visit_image = isset($visit_image) && $visit_image != '' ? self::getNewUrl() . '/' . config('constants.API_PROJECT_NAME') . '/public/uploads/event/' . $visit_image : '';

                            if (isset($visit_image) && $visit_image != '') {
                                $image_data = new Visit_data_images();
                                $image_data->fk_visit_id = $visit_data->id;
                                $image_data->visit_image = $visit_image;
                                $image_data->created_at = date('Y-m-d H:i:s');
                                $image = $image_data->save();
                            }
                        }
                    }
                }
            }

            // Visit Products
            if (isset($request->products)) {
                DB::table('visit_data_product')->where('fk_visit_data_id', $visit_data->id)->delete();
                foreach ($request->products as $key1 => $product_id) {
                    $dataInsert = ([
                        'fk_visit_data_id' => $visit_data->id,
                        'fk_product_id' => $product_id,
                        'created_at' => Carbon::now('Asia/Kolkata')
                    ]);
                    DB::table('visit_data_product')->insert($dataInsert);
                }
            }
            $message = empty($visit_data_id) ? 'Visit data added successfully!' : 'Visit data updated successfully!';
            Alert::success('Success', $message);
            return response()->json(['result' => '1', 'message' => 'Visit Data']);
        } catch (\Exception $e) {
            return response()->json(['result' => '0', 'message' => $e->getMessage()]);
        }
    }

    public function visit_delete(Request $request, $visitId)
    {
        try {
            $visitData = VisitData::where('id', $visitId)->first();

            if (!$visitData) {
                return response()->json(['result' => '0', 'message' => 'Visit Data not found']);
            }

            Visitor::where('id', $visitData->visitor_id)->update(['updated_at' => Carbon::now('Asia/Kolkata')]);

            // Delete the audio file if it exists
            if ($visitData->audio_file) {
                $imagePath = parse_url($visitData->audio_file, PHP_URL_PATH);
                $imageName = basename($imagePath);
                $image_path = \public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/') . $imageName;
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }
            }

            // Fetch and delete associated visit images
            $visitImages = Visit_data_images::where('fk_visit_id', $visitId)->get();
            foreach ($visitImages as $image) {
                $vimageFilePath = parse_url($image->visit_image, PHP_URL_PATH);
                $vimageName = basename($vimageFilePath);
                $vimageFilePath = \public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/event/') . $vimageName;
                if (file_exists($vimageFilePath)) {
                    unlink($vimageFilePath);
                }
                $image->delete();
            }

            $visitData->delete();
            Alert::success('Success', 'Visit data Deleted successfully!');
            return response()->json(['result' => '1', 'message' => 'Visit Data Deleted']);
        } catch (\Exception $e) {
            return response()->json(['result' => '0', 'message' => $e->getMessage()]);
        }
    }

    public function listbyevent(Request $request, EventsVisitorsDataTable $dataTable)
    {
        $data['categories'] = DB::table('category')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['category_id'] = "all";
        $data['sub_category_id'] = "all";
        $data['is_international'] = "all";
        $data['start_date'] = Carbon::now()->subYear()->format('Y-m-d');
        $data['end_date'] = Carbon::now()->addDay()->format('Y-m-d');

        $data['sourceofleadList'] = SourceOfLead::orderBy('id', 'asc')->get();

        //$data['countries'] = DB::table('countries')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['country_id'] = "all";

        //$data['states'] = DB::table('states')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['state_id'] = "all";
        $data['city_id'] = "all";
        $data['sourceoflead'] = "all";

        $data['events'] = DB::table('events')->select('events.id', 'events.event_name', 'events.city', 'events.details', 'events.start_date', 'events.end_date', 'events.created_at', 'events.updated_at', 'events.type_show_all', 'event_assignments.is_admin')->leftjoin('event_assignments', 'event_assignments.fk_event_id', 'events.id')
            ->where('event_assignments.fk_user_id', Auth::user()->user_id)->orderBy('events.id', 'desc')
            ->get();
        $data['event_id'] = "all";
        $data['users'] = DB::table('users')->where('is_delete', '=', 'false');
        $authAdmin = auth()->user();
        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $data['users'] = $data['users']->whereIn('CustomerID', $divisionTeamMemberIds);
        }

        $user_id = Auth::user()->user_id;
        $userdetail = Auth::user()->getUser();
        $currentUserCustomerId = $userdetail->CustomerID;

        $data['users'] = $data['users']->select('CustomerName', 'CustomerID')->where('CustomerID', $currentUserCustomerId)->orderBy('CustomerName', 'asc')->get();

        $data['CustomerID'] = "all";

        $data['otherEmailDrafts'] = EmailDraft::get();

        $data['follow_up_time'] = '';
        $data['username'] = DB::table('users')
            ->where('users.is_delete', '=', 'false')
            ->where('CustomerID', $currentUserCustomerId)
            ->get();
        $data['user'] = json_decode($data['username']);

        $data['action'] = "all";
        $data['actions'] = DB::table('actions')->select('title', 'id')->orderBy('title', 'asc')->get();

        if (isset($request->event_id)) {
            $data['event_id'] = $request->event_id;
        }
        if (isset($request->category_id)) {
            $data['category_id'] = $request->category_id;
        }
        if (isset($request->sub_category_id)) {
            $data['sub_category_id'] = $request->sub_category_id;
        }

        if (isset($request->country_id)) {
            $data['country_id'] = $request->country_id;
        }
        if (isset($request->state_id)) {
            $data['state_id'] = $request->state_id;
        }
        if (isset($request->city_id)) {
            $data['city_id'] = $request->city_id;
        }
        if (isset($request->is_international)) {
            $data['is_international'] = $request->is_international;
        }
        if (isset($request->start_date)) {
            $data['start_date'] = $request->start_date;
        }
        if (isset($request->end_date)) {
            $data['end_date'] = $request->end_date;
        }
        if (isset($request->action)) {
            $data['action'] = $request->action;
        }

        if (isset($request->follow_up_time)) {
            $data['follow_up_time'] = $request->follow_up_time;
        }

        if (isset($request->follow_up_start_date)) {
            $data['follow_up_start_date'] = $request->follow_up_start_date;
            $data['start_date'] = null;
            $data['end_date'] = null;
        } else {
            $data['follow_up_start_date'] = "";
        }
        if (isset($request->follow_up_end_date)) {
            $data['follow_up_end_date'] = $request->follow_up_end_date;
        } else {
            $data['follow_up_end_date'] = "";
        }

        if (isset($request->sourceoflead)) {
            $data['sourceoflead'] = $request->sourceoflead;
        }

        $data['event_obj'] = DB::table('events')->where('id', '=', $request->event_id)->get();
        $authAdmin = auth()->user()->getUser();
        //dd($authAdmin);
        $data['permissions'] = DB::table('permissions')->where('fk_customer_id', $authAdmin->CustomerID)->first();
        //dd($data['permissions']);
        //dd($data);
        return $dataTable->with([
            'event_id' => $data['event_id'],
            'category_id' => $data['category_id'],
            'sub_category_id' => $data['sub_category_id'],
            'country_id' => $data['country_id'],
            'state_id' => $data['state_id'],
            'city_id' => $data['city_id'],
            'is_international' => $data['is_international'],
            'start_date' => $data['start_date'],
            'end_date' => $data['end_date'],
            'action' => $data['action'],
            'follow_up_time' => $data['follow_up_time'],
            'follow_up_start_date' => $data['follow_up_start_date'],
            'follow_up_end_date' => $data['follow_up_end_date'],
            'sourceoflead' => $data['sourceoflead']
        ])->render('visitor.listbyevent', $data);
    }

    public function exportvisitorlistbyevent(Request $request)
    {
        if (isset($request->event_id) && $request->event_id != "all") {
            $eventid = $request->event_id;
            $event = DB::table('events')->select('events.event_name')->where('id', $eventid)->first();
            $event = $event->event_name;
        } else {
            $event = "all";
        }

        if ($request->event_id == '' || $request->event_id == null) {
            $event_id = 'all';
        } else {
            $event_id = $request->event_id;
        }
        if ($request->category_id == '' || $request->category_id == null) {
            $category_id = 'all';
        } else {
            $category_id = $request->category_id;
        }
        if ($request->sub_category_id == '' || $request->sub_category_id == null) {
            $sub_category_id = 'all';
        } else {
            $sub_category_id = $request->sub_category_id;
        }
        if ($request->state_id == '' || $request->state_id == null) {
            $state_id = 'all';
        } else {
            $state_id = $request->state_id;
        }
        if ($request->city_id == '' || $request->city_id == null) {
            $city_id = 'all';
        } else {
            $city_id = $request->city_id;
        }
        if ($request->city_id == '' || $request->city_id == null) {
            $city_id = 'all';
        } else {
            $city_id = $request->city_id;
        }
        if ($request->is_international == '' || $request->is_international == null) {
            $is_international = 'all';
        } else {
            $is_international = $request->is_international;
        }
        if ($request->country_id == '' || $request->country_id == null) {
            $country_id = 'all';
        } else {
            $country_id = $request->country_id;
        }
        if ($request->action == '' || $request->action == null) {
            $action = 'all';
        } else {
            $action = $request->action;
        }
        if ($request->start_date == '' || $request->start_date == null) {
            $start_date = null;
        } else {
            $start_date = $request->start_date;
        }
        if ($request->end_date == '' || $request->end_date == null) {
            $end_date = null;
        } else {
            $end_date = $request->end_date;
        }

        if ($request->sourceoflead == '' || $request->sourceoflead == null) {
            $sourceoflead = 'all';
        } else {
            $sourceoflead = $request->sourceoflead;
        }

        return Excel::download(new VisitorlistByEventExport($event_id, $category_id, $sub_category_id, $state_id, $city_id, $is_international, $country_id, $action, $start_date, $end_date, $sourceoflead), $event . '.xlsx', \Maatwebsite\Excel\Excel::XLSX);
    }

    public function sendEmailModal(Request $request)
    {
        $visitor_id = $request->visitor_id;
        $title = 'Send Email';
        $actionList = Action::pluck('title', 'id')->toArray();
        $categoryList = Category::pluck('name', 'id')->toArray();

        $modalHtml = view('email.sendEmail', compact('title', 'actionList', 'categoryList', 'visitor_id'))->render();
        return response()->json(['modalHtml' => $modalHtml]);
    }
    public function batchDetail($batchid, $status, VisitorBatchLogDataTable $dataTable)
    {
        $batchdetail = EmailBatch::find($batchid);

        $emaildraft = EmailDraft::where('id', $batchdetail->email_draft_id)->first();

        return $dataTable->with([
            'batchid' => $batchid,
            'status' => $status
        ])->render('visitor.batchlog-list', ['batchdetail' => $batchdetail, 'emaildraft' => $emaildraft]);
    }
    public function setMailbyevent(Request $request)
    {
        $mailConfigData = DB::table('email_config')->first();
        if (empty($mailConfigData)) {
            return response()->json([
                'status' => false,
                'message' => 'Mail could not be sent because config data not found!'
            ]);
        }
        $requestData = $request->all();
        $requestData['created_by'] = auth()->id();
        $requestData['hour_interval_mails'] = $mailConfigData->hour_limit ?? 20;
        $requestData['schedule_date'] = $request->schedule_date ? Carbon::parse($request->schedule_date) : Carbon::now();
        $requestData['status'] = 'pending';
        $requestData['email_type'] = $request->type;

        //$user_id = Auth::user()->user_id;
        //$userdetail = Auth::user()->getUser();
        //$currentUserCustomerId = $userdetail->CustomerID;
        //dd($currentUserCustomerId);
        $currentUserCustomerId = "all";
        $visitorEmails = Visitor::fetchEmailVisitorsByEvent($request->event_id, $request->category_id, $request->sub_category_id, $request->state_id, $request->city_id, $request->is_international, $request->country_id, $request->start_date, $request->end_date, $request->action)->get();
        // dd($visitorEmails);
        if ($visitorEmails->count() == 0) {
            Alert::error('Error', 'No Visitors found!');
            return redirect()->back();
        }
        $schedule = EmailBatch::create($requestData);
        foreach ($visitorEmails as $visitorEmail) {
            EmailBatchLog::create([
                'batch_id' => $schedule->id,
                'visitor_id' => $visitorEmail->id,
                'user_id' => $visitorEmail->customer_id,
                'status' => 'pending'
            ]);
        }
        Alert::success('Success', 'Schedule mail set successfully!');
        return redirect()->back();
    }


    public function clientVisit(Request $request, ClientVisitorsDataTable $dataTable)
    {
        $data['regions'] = DB::table('region')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['region'] = [];
        $data['categories'] = DB::table('category')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['category_id'] = [];
        $data['sub_category_id'] = [];
        $data['is_international'] = "all";
        //$data['start_date'] = Carbon::now()->subYear()->format('Y-m-d');
        $data['start_date'] = Carbon::now()->subDays(30)->format('Y-m-d');
        $data['end_date'] = Carbon::now()->addDay()->format('Y-m-d');
        $data['actionList'] = Action::orderBy('id', 'asc')->get();
        $data['productList'] = Product::orderBy('id', 'asc')->get();
        $data['sourceofleadList'] = SourceOfLead::orderBy('id', 'asc')->get();

        //$data['countries'] = DB::table('countries')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['country_id'] = [];
        $data['follow_up_time'] = '';
        //$data['states'] = DB::table('states')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['state_id'] = [];
        $data['city_id'] = [];
        $data['area'] = [];
        $data['action'] = [];
        $data['product'] = [];
        $data['events'] = DB::table('events')->select('event_name', 'id')->orderBy('event_name', 'asc')
            // ->where('type_show_all','=','true')
            ->get();
        $data['event_id'] = [];
        $data['sourceoflead'] = [];
        $data['users'] = DB::table('users');
        //->where('is_delete', '=', 'false');
        $authAdmin = auth()->user();
        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $data['users'] = $data['users']->whereIn('CustomerID', $divisionTeamMemberIds);
        }
        $data['users'] = $data['users']->select('CustomerName', 'CustomerID', 'is_delete')->orderBy('CustomerName', 'asc')->get();
        $data['CustomerID'] = [];
        $data['otherEmailDrafts'] = EmailDraft::get();

        $data['username'] = DB::table('users')
            ->where('users.is_delete', '=', 'false')
            ->get();
        $data['user'] = json_decode($data['username']);

        if (isset($request->event_id)) {
            $data['event_id'] = $request->event_id;
        }
        if (isset($request->CustomerID)) {
            $data['CustomerID'] = $request->CustomerID;
        }
        if (isset($request->category_id)) {
            $data['category_id'] = $request->category_id;
        }
        if (isset($request->sub_category_id)) {
            $data['sub_category_id'] = $request->sub_category_id;
        }

        if (isset($request->country_id)) {
            $data['country_id'] = $request->country_id;
        }
        if (isset($request->state_id)) {
            $data['state_id'] = $request->state_id;
        }
        if (isset($request->city_id)) {
            $data['city_id'] = $request->city_id;
        }
        if (isset($request->area)) {
            $data['area'] = $request->area;
        }
        if (isset($request->is_international)) {
            $data['is_international'] = $request->is_international;
        }
        if (isset($request->region)) {
            $data['region'] = $request->region;
        }
        if (isset($request->start_date)) {
            $data['start_date'] = $request->start_date;
        }
        if (isset($request->end_date)) {
            $data['end_date'] = $request->end_date;
        }
        if (isset($request->action)) {
            $data['action'] = $request->action;
        }
        if (isset($request->product)) {
            $data['product'] = $request->product;
        }
        if (isset($request->follow_up_time)) {
            $data['follow_up_time'] = $request->follow_up_time;
        }
        if (isset($request->sourceoflead)) {
            $data['sourceoflead'] = $request->sourceoflead;
        }
        //dd($data['product']);
        $data['templates'] = Template::where('status', 'APPROVED')->get();
        return $dataTable->with([
            'event_id' => $data['event_id'],
            'CustomerID' => $data['CustomerID'],
            'category_id' => $data['category_id'],
            'sub_category_id' => $data['sub_category_id'],
            'country_id' => $data['country_id'],
            'state_id' => $data['state_id'],
            'city_id' => $data['city_id'],
            'is_international' => $data['is_international'],
            'region' => $data['region'],
            'start_date' => $data['start_date'],
            'end_date' => $data['end_date'],
            'action' => $data['action'],
            'follow_up_time' => $data['follow_up_time'],
            'product' => $data['product'],
            'area' => $data['area'],
            'sourceoflead' => $data['sourceoflead'],
        ])->render('visitor.clientvisit', $data);
    }
    public function exportclientvisitorlist(Request $request)
    {
        if (!empty($request->event_id) && is_array($request->event_id) && count($request->event_id) > 0) {
            $eventid = $request->event_id;
            $event = DB::table('events')->select('events.event_name')->where('id', $eventid[0])->first();
            $event = $event?->event_name;
        } else {
            $event = "all";
        }
        // //dd($request->product);
        // if ($request->event_id == '' && $request->CustomerID == '' && $request->category_id == '' && $request->sub_category_id == '' && $request->state_id == '' && $request->city_id == '' && $request->country_id == null && $request->region == null && $request->start_date == null && $request->end_date == null && $request->action == '' && $request->product == null && ($request->area == null || $request->area == '')) {
        //     $event_id = 'all';
        //     $customer_id = 'all';
        //     $category_id = 'all';
        //     $sub_category_id = 'all';
        //     $state_id = 'all';
        //     $city_id = 'all';
        //     $area = 'all';
        //     $is_international = 'all';
        //     $country_id = 'all';
        //     $region = 'all';

        //     $start_date = Carbon::now()->subYear()->format('Y-m-d');
        //     $end_date = Carbon::now()->addDay()->format('Y-m-d');

        //     $action = 'all';

        //     $product = 'all';
        // } else {
        //     $event_id = $request->event_id;
        //     $customer_id = $request->CustomerID;
        //     $category_id = $request->category_id;
        //     $sub_category_id = $request->sub_category_id;
        //     $state_id = $request->state_id;
        //     $city_id = $request->city_id;
        //     $area = $request->area;
        //     $is_international = $request->is_international;
        //     $country_id = $request->country_id;
        //     $region = $request->region;
        //     $start_date = $request->start_date;
        //     $end_date = $request->end_date;
        //     $action = $request->action;
        //     $product = $request->product;
        // }
        $event_id = $request->event_id;
        $customer_id = $request->CustomerID;
        $category_id = $request->category_id;
        $sub_category_id = $request->sub_category_id;
        $state_id = $request->state_id;
        $city_id = $request->city_id;
        $area = $request->area;
        $is_international = $request->is_international;
        $country_id = $request->country_id;
        $region = $request->region;
        $area = $request->area;
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $sourceoflead = $request->sourceoflead;
        $actions = $request->action;
        $product = $request->product;

        return Excel::download(new CliectVisitorlistExport($event_id, $customer_id, $category_id, $sub_category_id, $state_id, $city_id, $is_international, $country_id, $region, $start_date, $end_date, $actions, $product, $area, $sourceoflead), $event . '.xlsx', \Maatwebsite\Excel\Excel::XLSX);
    }

    // public function visitorImageDelete(Request $request)
    // {
    //     $visitorId = $request->visitor_id;
    //     $imageType = $request->type;

    //     // Find the visitor by ID
    //     $visitor = Visitor::where('id', $visitorId)->first();

    //     // If the visitor doesn't exist, return an error
    //     if (!$visitor) {
    //         return redirect()->back()->with('error', 'Visitor not found!');
    //     }

    //     $data = []; // Initialize the $data array for the fields to be updated

    //     // Delete front image
    //     if ($imageType == 'front_image') {
    //         if ($visitor->front_image) {
    //             $frontImageName = basename(parse_url($visitor->front_image, PHP_URL_PATH));
    //             $oldFrontImagePath = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $frontImageName);

    //             // Check if the file exists and delete it
    //             if (file_exists($oldFrontImagePath)) {
    //                 unlink($oldFrontImagePath); // Delete the old front image
    //             }
    //             // Set the front image field to null
    //             $data['front_image'] = null;
    //         } else {
    //             return redirect()->back()->with('error', 'Front image not found!');
    //         }
    //     }
    //     // Delete back image
    //     elseif ($imageType == 'back_image') {
    //         if ($visitor->back_image) {
    //             $backImageName = basename(parse_url($visitor->back_image, PHP_URL_PATH));
    //             $oldBackImagePath = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $backImageName);

    //             // Check if the file exists and delete it
    //             if (file_exists($oldBackImagePath)) {
    //                 unlink($oldBackImagePath); // Delete the old back image
    //             }
    //             // Set the back image field to null
    //             $data['back_image'] = null;
    //         } else {
    //             return redirect()->back()->with('error', 'Back image not found!');
    //         }
    //     }

    //     // Update the visitor record in the database
    //     $visitor->update($data);

    //     // Return success message after successful image deletion
    //     return redirect()->back()->with('success', 'Image deleted successfully!');
    // }

    public function visitorImageDelete(Request $request)
    {
        $visitorId = $request->visitor_id;
        $imageType = $request->type;

        // Find the visitor by ID
        $visitor = Visitor::where('id', $visitorId)->first();

        // If the visitor doesn't exist, return an error response
        if (!$visitor) {
            return response()->json(['error' => 'Visitor not found!'], 404);
        }

        $data = []; // Initialize the $data array for the fields to be updated

        // Delete front image
        if ($imageType == 'front_image') {
            if ($visitor->front_image) {
                $frontImageName = basename(parse_url($visitor->front_image, PHP_URL_PATH));
                $oldFrontImagePath = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $frontImageName);

                // Check if the file exists and delete it
                if (file_exists($oldFrontImagePath)) {
                    unlink($oldFrontImagePath); // Delete the old front image
                }
                // Set the front image field to null
                $data['front_image'] = null;
            } else {
                return response()->json(['error' => 'Front image not found!'], 404);
            }
        }
        // Delete back image
        elseif ($imageType == 'back_image') {
            if ($visitor->back_image) {
                $backImageName = basename(parse_url($visitor->back_image, PHP_URL_PATH));
                $oldBackImagePath = public_path('../../' . config('constants.API_PROJECT_NAME') . '/public/uploads/visitor/' . $backImageName);

                // Check if the file exists and delete it
                if (file_exists($oldBackImagePath)) {
                    unlink($oldBackImagePath); // Delete the old back image
                }
                // Set the back image field to null
                $data['back_image'] = null;
            } else {
                return response()->json(['error' => 'Back image not found!'], 404);
            }
        }

        // Update the visitor record in the database
        $visitor->update($data);

        // Return a success response after successful image deletion
        return response()->json(['success' => 'Image deleted successfully!']);
    }

    public function clientdashboard(Request $request, ClientVisitorsDataTable $dataTable)
    {

        $data['users'] = DB::table('users')->where('is_delete', '=', 'false');
        $authAdmin = auth()->user();
        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $data['users'] = $data['users']->whereIn('CustomerID', $divisionTeamMemberIds);
        }
        $users = $data['users']->select('CustomerName', 'CustomerID')->orderBy('CustomerName', 'asc')->get();

        $CustomerID = "all";
        $start_date = Carbon::now()->subYear()->format('Y-m-d');
        $end_date = Carbon::now()->addDay()->format('Y-m-d');

        if (isset($request->CustomerID)) {
            $CustomerID = $request->CustomerID;
        }
        if (isset($request->start_date)) {
            $start_date = $request->start_date;
        }
        if (isset($request->end_date)) {
            $end_date = $request->end_date;
        }


        $actiondataList = Action::select('id', 'title')->orderBy('title', 'asc')->get();
        foreach ($actiondataList as $obj) {
            //$visitdataquery = VisitData::where('action', $obj->title);
            $visitdataquery = VisitData::select('visit_data.id', 'visit_data.action as visit_action', 'visit_data.remarks as visit_remarks', 'visit_data.fk_visitor_id', 'visit_data.follow_up_time as visit_follow_up_time', 'visit_data.visit_time', 'users.CustomerName', 'visitors.id as visitors_id', 'visitors.name', 'visitors.company_name', 'visitors.mobile_no', 'visitors.email', 'events.event_name', 'visitors.event_ids')
                ->with('products')
                ->join('visitors', 'visitors.id', 'visit_data.fk_visitor_id')
                ->leftJoin('events', 'events.id', 'visitors.event_id')
                ->leftJoin('users', 'users.CustomerID', 'visit_data.fk_teammember_id')
                ->orderBy('visit_data.id', 'desc');
            $visitdataquery = $visitdataquery->where('visit_data.action', $obj->title);
            if ($CustomerID != 'all') {
                $visitdataquery = $visitdataquery->where('visit_data.fk_teammember_id', $CustomerID);
            }
            if ($start_date != null && $end_date != null) {
                $startDateFormatted = date('Y-m-d', strtotime($start_date));
                $endDateFormatted = date('Y-m-d', strtotime($end_date));
                $visitdataquery = $visitdataquery->where(function ($query) use ($startDateFormatted, $endDateFormatted) {
                    $query->whereDate('visit_data.visit_time', '>=', $startDateFormatted)
                        ->whereDate('visit_data.visit_time', '<=', $endDateFormatted);
                });
            }
            $totalvisitdata = $visitdataquery->get();
            $obj->totalvisitdata = count($totalvisitdata);
        }
        //dd($actiondataList);
        return view('visitor.clientdashboard', compact('users', 'CustomerID', 'start_date', 'end_date', 'actiondataList'));
    }

    public function clientdashboarddetails(Request $request, ClientDashboardVisitorsDataTable $dataTable)
    {

        $data['users'] = DB::table('users')->where('is_delete', '=', 'false');
        $authAdmin = auth()->user();
        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $data['users'] = $data['users']->whereIn('CustomerID', $divisionTeamMemberIds);
        }
        $data['users'] = $data['users']->select('CustomerName', 'CustomerID')->orderBy('CustomerName', 'asc')->get();

        $data['CustomerID'] = "all";
        $data['start_date'] = Carbon::now()->subYear()->format('Y-m-d');
        $data['end_date'] = Carbon::now()->addDay()->format('Y-m-d');
        $data['action'] = '';

        if (isset($request->CustomerID)) {
            $data['CustomerID'] = $request->CustomerID;
        }
        if (isset($request->start_date)) {
            $data['start_date'] = $request->start_date;
        }
        if (isset($request->end_date)) {
            $data['end_date'] = $request->end_date;
        }
        if (isset($request->action)) {
            $data['action'] = $request->action;
        }
        return $dataTable->with([
            'CustomerID' => $data['CustomerID'],
            'start_date' => $data['start_date'],
            'end_date' => $data['end_date'],
            'action' => $data['action'],
        ])->render('visitor.clientdashboarddetails', $data);

        //dd($actiondataList);
        /*return view('visitor.clientdashboarddetails', compact('users', 'CustomerID', 'start_date', 'end_date', 'actiondataList'));*/
    }

    public function exportclientdashboarddetails(Request $request)
    {

        if ($request->CustomerID == '' && $request->start_date == null && $request->end_date == null && $request->action == '') {
            $customer_id = 'all';
            $start_date = Carbon::now()->subYear()->format('Y-m-d');
            $end_date = Carbon::now()->addDay()->format('Y-m-d');
            $action = 'all';
        } else {
            $customer_id = $request->CustomerID;
            $start_date = $request->start_date;
            $end_date = $request->end_date;
            $action = $request->action;
        }
        $filename = $customer_id . '_' . $action;
        return Excel::download(new ClientDashboardVisitorslistExport($customer_id, $start_date, $end_date, $action), $filename . '.xlsx', \Maatwebsite\Excel\Excel::XLSX);
    }


    public function exportgooglecontactlist(Request $request)
    {
        if (isset($request->event_id) && $request->event_id != "all") {
            $eventid = $request->event_id;
            $event = DB::table('events')->select('events.event_name')->where('id', $eventid)->first();
            $event = $event->event_name;
        } else {
            $event = "all";
        }

        if ($request->event_id == '' && $request->CustomerID == '' && $request->category_id == '' && $request->sub_category_id == '' && $request->state_id == '' && $request->city_id == '' && $request->country_id == null && $request->region == null && $request->start_date == null && $request->end_date == null && $request->product == null && $request->sourceoflead == '') {
            $event_id = 'all';
            $customer_id = 'all';
            $category_id = 'all';
            $sub_category_id = 'all';
            $state_id = 'all';
            $city_id = 'all';
            $is_international = 'all';
            $country_id = 'all';
            $region = 'all';
            $start_date = Carbon::now()->subYear()->format('Y-m-d');
            $end_date = Carbon::now()->addDay()->format('Y-m-d');
            $product = 'all';
            $sourceoflead = 'all';
        } else {
            $event_id = $request->event_id;
            $customer_id = $request->CustomerID;
            $category_id = $request->category_id;
            $sub_category_id = $request->sub_category_id;
            $state_id = $request->state_id;
            $city_id = $request->city_id;
            $is_international = $request->is_international;
            $country_id = $request->country_id;
            $region = $request->region;
            $start_date = $request->start_date;
            $end_date = $request->end_date;
            $sourceoflead = $request->sourceoflead;
        }
        return Excel::download(new GoogleContactExport($event_id, $customer_id, $category_id, $sub_category_id, $state_id, $city_id, $is_international, $country_id, $region, $start_date, $end_date, $sourceoflead), $event . '.csv', \Maatwebsite\Excel\Excel::CSV);
    }

    public function whatsappVisitMessageCron(Request $request)
    {
        try {
            $today = Carbon::now()->format('Y-m-d');

            $visitorsThatNotHasVisits = Visitor::whereDoesntHave('visits') // ← correct spelling
                ->whereDate('follow_up_time', $today)->get();
            $visitorsThatHasVisits = Visitor::with([
                'visits' => function ($q) use ($today) {
                    $q->whereDate('follow_up_time', $today);
                }
            ])->WhereHas('visits', function ($q) use ($today) {
                $q->whereDate('follow_up_time', $today);
            })->get();
            $message = [];
            $i = 0;
            foreach ($visitorsThatNotHasVisits as $visitor) {
                $message[$i]['time'] = $visitor?->follow_up_time;
                $message[$i]['company_name'] = $visitor?->company_name;
                $i++;
            }
            foreach ($visitorsThatHasVisits as $visitor) {
                $message[$i]['time'] = $visitor?->visits[0]?->follow_up_time;
                $message[$i]['company_name'] = $visitor?->company_name;
                $i++;
            }
            $sorted = collect($message)->sortBy('time')->values()->all();
            $messages = collect($sorted)->map(function ($i, $index) {
                $i['message'] = $index + 1 . ". " . $i['company_name'] . " at " . Carbon::parse($i['time'])->format('h:i A');
                return $i;
            })->pluck('message')->all();
            $visitDetails = join("\n", $messages);
            $message = "🗓️ *Today's Follow-ups* (" . Carbon::now()->format('d/m/Y') . ")\n\n";
            $message .= "Here are the scheduled follow-ups for today:\n\n";
            $message .= $visitDetails;
            //send whatsapp message
            $whatsappConfig = DB::table('whatsapp_configs')->first();
            $template = Template::orderBy('id', 'desc')->first();


            if (!empty($whatsappConfig) && !empty($template)) {
                // $response = Helper::sendTemplateMessage($whatsappConfig, $template, "+918156060143",[],'en',$message);
                return $response;
            } else {
                Log::channel('whatsapp_visit_message')->error('Whatsapp Visit Message Cron Error: Whatsapp Config or Template not found');
            }
        } catch (Exception $e) {
            Log::channel('whatsapp_visit_message')->error('Whatsapp Visit Message Cron Error', ['error' => $e->getMessage()]);
        }
    }
}
