<?php

namespace App\Http\Controllers;

use Alert;
use App\Models\AssignDivisionTeamMember;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Hash;
use Illuminate\Http\Request;
use App\DataTables\UsersDataTable;
use App\Models\User;
use App\Models\EmailDraft;
use DB;
use App\Jobs\SendNotification;
use App\Models\Admin;
use App\Classes\PHPMailer;
use Illuminate\Support\Facades\Http;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->_user = new User();
    }
    public function index(Request $request, UsersDataTable $dataTable)
    {
        $CustomerID = $request->CustomerID;
        $data = DB::table('users')->orderBy('CustomerID', 'desc')->get();

        return $dataTable->render('users.index', compact('CustomerID'));
    }
    public function updateUserName(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "userUpdateName" => "required",
            "userIdHidden" => "required",
        ], [
            "userUpdateName.required" => "Please enter user name",
        ]);
        if ($validator->fails()) {
            return response()->json([
                "error" => $validator->errors(),
                "message" => "invalid input",
                "status" => false,
            ], 422);
        }
        $custId = $request?->userNameUpdateCustomerId;
        $payload = [
            'name' => $request->userUpdateName,
            'CustomerID' => $custId,
        ];
        // return $request->all();

        try {
            DB::beginTransaction();

            $response = Http::withHeaders([
                'Accept' => 'application/json',
                'Content-Type' => 'application/json',
            ])->post('https://frenzinsoftwares.com/visitor/webservice_v4/v1/updateCustomer', $payload);

            $apiRes =  $response->json();
            if ($apiRes["status"]) {
                $user = DB::table('users')->where("user_id", $request->userIdHidden)->first();
                if (empty($user)) {
                    return response()->json([
                        "message" => "user not found",
                        "status" => false
                    ], 400);
                }

                DB::table('users')->where("user_id", $request->userIdHidden)->update(['CustomerName' => $request->userUpdateName]);
                DB::table('admin')->where("user_id", $request->userIdHidden)->update(['name' => $request->userUpdateName]);

                DB::commit();


                return response()->json([
                    "message" => "user name updated",
                    "status" => true,
                    "apiResponse" => $apiRes,
                    'newName' => $request->userUpdateName
                ]);
            } else {
                DB::rollback();
                return response()->json([
                    "message" => $apiRes['msg'],
                    "status" => false,
                ], 400);
            }
        } catch (Exception $e) {
            DB::rollback();

            return response()->json([
                "message" => "Something went wrong",
                "status" => false,
            ], 500);
        }
    }
    public function updateUserEmail(Request $request)
    {

        $validator = Validator::make($request->all(), [
            "userEmailUpdate" => "required|email",
            "userEmailcustomerIdHidden" => "required",
        ], [
            "userEmailUpdate.required" => "Please enter user email",
        ]);
        if ($validator->fails()) {
            return response()->json([
                "error" => $validator->errors(),
                "message" => "invalid input",
                "status" => false,
            ], 422);
        }
        // return ;
        $newEmailDomain = explode("@", $request->userEmailUpdate);
        $loginUserDomain = explode('@', auth()->user()->email);
        if (!empty($newEmailDomain[1]) && !empty($loginUserDomain[1])) {
            if ($newEmailDomain[1] != $loginUserDomain[1]) {
                return response()->json([
                    "message" => "Invalid domain for new email.",
                    "status" => false,
                ], 400);
            }
        }

        $custId = $request?->userEmailcustomerIdHidden;
        $payload = [
            'email' => $request->userEmailUpdate,
            'CustomerID' => $custId,
        ];

        try {
            DB::beginTransaction();

            $response = Http::withHeaders([
                'Accept' => 'application/json',
                'Content-Type' => 'application/json',
            ])->post('https://frenzinsoftwares.com/visitor/webservice_v4/v1/updateCustomer', $payload);

            $apiRes =  $response->json();
            if ($apiRes["status"]) {
                $user = DB::table('users')->where("CustomerID", $request->userEmailcustomerIdHidden)->first();
                if (empty($user)) {
                    return response()->json([
                        "message" => "user not found",
                        "status" => false
                    ], 400);
                }

                DB::table('users')->where("CustomerID", $request->userEmailcustomerIdHidden)->update(['Email' => $request->userEmailUpdate]);
                DB::table('admin')->where("user_id", $user->user_id)->update(['email' => $request->userEmailUpdate]);

                DB::commit();

                return response()->json([
                    "message" => "user email updated",
                    "status" => true,
                    "apiResponse" => $apiRes,
                    "newEmail" => $request->userEmailUpdate
                ]);
            } else {
                DB::rollback();
                return response()->json([
                    "message" => $apiRes['msg'],
                    "status" => false,
                ], 400);
            }
        } catch (Exception $e) {
            DB::rollback();

            return response()->json([
                "message" => "Something went wrong",
                "status" => false,
            ], 500);
        }
    }

    public function updateUserPhone(Request $request)
    {

        $validator = Validator::make($request->all(), [
            "userNewPhoneUpdate" => "required",
            "userPhoneUpdate" => "required",
            "userPhoneUpdate" => "required",
            "userUpdatePhoneOtp" => "required",
        ], [
            "userPhoneUpdate.required" => "Please enter old phone number",
            "userNewPhoneUpdate.required" => "Please enter new phone number",
            "userUpdatePhoneOtp.required" => "Please enter OTP",
        ]);
        if ($validator->fails()) {
            return response()->json([
                "error" => $validator->errors(),
                "message" => "invalid input",
                "status" => false,
            ], 422);
        }
        // return $request->all();

        $custId = $request?->userPhonecustomerIdHidden;
        $payload = [
            'mobile' => $request->userNewPhoneUpdate,
            'otp' => $request->userUpdatePhoneOtp,
            'CustomerID' => $custId,
        ];

        try {
            DB::beginTransaction();

            $response = Http::withHeaders([
                'Accept' => 'application/json',
                'Content-Type' => 'application/json',
            ])->post('https://frenzinsoftwares.com/visitor/webservice_v4/v1/updateCustomer', $payload);

            $apiRes =  $response->json();
            if ($apiRes["status"]) {
                $user = DB::table('users')->where("CustomerID", $request->userPhonecustomerIdHidden)->first();
                if (empty($user)) {
                    return response()->json([
                        "message" => "user not found",
                        "status" => false
                    ], 400);
                }

                DB::table('users')->where("CustomerID", $request->userPhonecustomerIdHidden)->update(['Phone' => $request->userNewPhoneUpdate]);
                // DB::table('admin')->where("user_id", $user->user_id)->update(['email' => $request->userEmailUpdate]);

                DB::commit();

                return response()->json([
                    "message" => "User phone updated",
                    "status" => true,
                    "apiResponse" => $apiRes,
                    "newPhone" => $request->userNewPhoneUpdate

                ]);
            } else {
                DB::rollback();
                return response()->json([
                    "message" => $apiRes['msg'],
                    "status" => false,
                ], 400);
            }
        } catch (Exception $e) {
            DB::rollback();

            return response()->json([
                "message" => "Something went wrong",
                "status" => false,
            ], 500);
        }
    }

    public function sendUserPhoneUpdateOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "userNewPhoneUpdate" => "required",
            "userPhoneUpdate" => "required",
            "userPhonecustomerIdHidden" => "required",
        ], [
            "userPhoneUpdate.required" => "Please enter old phone number",
            "userNewPhoneUpdate.required" => "Please enter new phone number",
        ]);
        if ($validator->fails()) {
            return response()->json([
                "error" => $validator->errors(),
                "message" => "invalid input",
                "status" => false,
            ], 422);
        }
        // return $request->all();

        try {
            $custId = $request?->userPhonecustomerIdHidden;
            // return $request->all();

            $payload = [
                'mobile' => $request->userPhoneUpdate,
                'new_mobile' => $request->userNewPhoneUpdate,
                'type' => 'changeNumber',
                'CustomerID' => $custId,
            ];
            $response = Http::withHeaders([
                'Accept' => 'application/json',
                'Content-Type' => 'application/json',
            ])->post('https://frenzinsoftwares.com/visitor/webservice_v4/v1/sendOtp', $payload);

            $apiRes =  $response->json();
            if ($apiRes["status"]) {
                return response()->json([
                    "message" => "Otp sent on new phone number",
                    "status" => true,
                    "apiResponse" => $apiRes
                ]);
            } else {
                return response()->json([
                    "message" => $apiRes["msg"],
                    "status" => false,
                    "apiResponse" => $apiRes
                ]);
            }
        } catch (Exception $e) {
            DB::rollback();

            return response()->json([
                "message" => "Something went wrong",
                "status" => false,
            ], 500);
        }
    }
    public function permissionsview(Request $request)
    {
        $CustomerID  = $request->CustomerID;
        $data['users'] = DB::table('users')
            ->select('CustomerName', 'CustomerID', 'location_config', 'email')
            ->where('CustomerID', $CustomerID)
            ->first();

        $data['permissions'] = DB::table('permissions')->where('fk_customer_id', $CustomerID)->first();
        $selectedDivisionIdsString = DB::table('assign_division_team_members')
            ->select('divisions.id as id')
            ->leftJoin('divisions', 'divisions.id', 'assign_division_team_members.division_id')
            ->where('assign_division_team_members.customer_id', $CustomerID)
            ->get()->pluck('id')->toArray();

        $allDivisions = DB::table('divisions')->get()->toArray();
        $encodedDivisions = [];

        foreach ($allDivisions as $division) {
            $division->name = htmlspecialchars($division->name, ENT_QUOTES);
            $encodedDivisions[] = $division;
        }
        $data['divisions'] = json_encode($encodedDivisions);
        $data['selectedDivisionIdsString'] = $selectedDivisionIdsString;

        // dd(json_decode($data['divisions']));
        // dd($selectedDivisionIdsString,in_array(2,$selectedDivisionIdsString));

        return view('users.permissionsdetails', $data);
    }
    public function update_user_password(Request $request)
    {
        $this->validate($request, [
            'password' => 'required|min:6',
        ]);
        $password = Hash::make($request->password);
        $data['user'] = DB::table('users')->where('user_id', $request->CustomerID)->update(['password' => $password]);

        $userobj = DB::table('users')
            ->where('user_id', $request->CustomerID)
            ->first();
        $result = Admin::where('user_id', '=', $userobj->user_id)->first();
        if ($result) {
            $updateAdmin = Admin::find($result->id);
            $updateAdmin->password = $password;
            $updateAdmin->save();
        }

        $data['user'] = $userobj;
        $adminEntry = Admin::where('user_id', '=', $userobj->user_id)->first();
        if ($adminEntry) {
            $data['adminEntry'] = "true";
        } else {
            $data['adminEntry'] = "false";
        }
        $data['permissions'] = DB::table('permissions')->where('fk_customer_id', $userobj->CustomerID)->first();
        $selectedDivisionIdsString = DB::table('assign_division_team_members')
            ->select('divisions.id as id')
            ->leftJoin('divisions', 'divisions.id', 'assign_division_team_members.division_id')
            ->where('assign_division_team_members.customer_id', $userobj->CustomerID)
            ->get()->pluck('id')->toArray();

        $allDivisions = DB::table('divisions')->get()->toArray();
        $encodedDivisions = [];

        foreach ($allDivisions as $division) {
            $division->name = htmlspecialchars($division->name, ENT_QUOTES);
            $encodedDivisions[] = $division;
        }
        $data['divisions'] = json_encode($encodedDivisions);
        $data['selectedDivisionIdsString'] = $selectedDivisionIdsString;
        $html = view('users.memberModalData', $data)->render();
        // return view('users.memberModalData', $data);
        return response()->json([
            "status" => true,
            "message" => 'You have Successfully Changed Password',
            "html" => $html,
        ]);

        // Alert::success('Congrats', 'You have Successfully Password Change');

        // return redirect('user/list');
    }
    public function edit_email(Request $request)
    {
        $CustomerID  = $request->CustomerID;
        $data['users'] = DB::table('users')
            ->where('CustomerID', $CustomerID)
            ->first();

        $data['user_emailconfig'] = DB::table('user_email_config')
            ->where('fk_user_id', $CustomerID)
            ->first();

        $data['CustomerID']  = $CustomerID;
        $data['primary_emails'] = EmailDraft::where('email_type', 'primary')->get();
        return view('users.edit_email', $data);
    }
    public function store_email(Request $request)
    {
        $get_user_id = DB::table('user_email_config')->where('fk_user_id', $request->id)->first();
        if (isset($get_user_id->fk_user_id) && $get_user_id->fk_user_id != null) {
            $data = [
                'host' => $request->host,
                'username'     => $request->username,
                'password'    => $request->password,
                'port'    => $request->port,
                'smtp_transport'    => $request->smtp_transport,
                'smtp_encryption'    => $request->smtp_encryption,
                'updated_at'    => date('Y-m-d H:i:s'),
            ];
            $result = DB::table('user_email_config')->where('fk_user_id', $request->id)->update($data);
        } else {
            if ($request->host == null) {
                return redirect()->route('users.list');
            } else {
                $data = [
                    'fk_user_id'  => $request->id,
                    'host' => $request->host,
                    'username'     => $request->username,
                    'password'    => $request->password,
                    'port'    => $request->port,
                    'smtp_transport'    => $request->smtp_transport,
                    'smtp_encryption'    => $request->smtp_encryption,
                    'created_at'    => date('Y-m-d H:i:s'),
                ];
                $result = DB::table('user_email_config')->insert($data);
            }
        }
        Alert::success('Congrats', 'Updated successfully!');
        return redirect()->route('users.list');
    }
    public function store_email_admin(Request $request)
    {
        //    dd($request->all());
        // ADMIN CONFIGURATION
        $data = [
            'sender_name'  => $request->sender_name,
            'sender_email' => $request->sender_email,
            'cc_email'     => $request->cc_email,
            'bcc_email'    => $request->bcc_email,
            'primary_email' => $request->primary_email,
            'signature'     => $request->signature
        ];
        if ($request->submit == 'apply_for_all') {
            $result = DB::table('users')->update($data);
        } else {
            DB::table('permissions')->where('fk_customer_id', $request->id)->update(['send_email' => '1']);
            $result = DB::table('users')->where('CustomerID', $request->id)->update($data);
        }


        // SET DEFAULT EMAIL
        // $update = User::where('CustomerID', $request->id)->update(['primary_email' => $request->primary_email]);

        // SMTP DETAILS
        // SMTP DETAILS
        if ($request->submit == 'apply_for_all') {
            // Retrieve all user IDs
            $userIds = User::pluck('CustomerID')->toArray();

            $Data = [
                'host' => $request->host,
                'username' => $request->username,
                'password' => $request->password,
                'smtp_port' => $request->port,
                'smtp_transport' => $request->smtp_transport,
                'smtp_encryption' => $request->smtp_encryption,
                'updated_at' => now(),
            ];

            $record = DB::table('email_config')
                ->orderBy('id', 'desc')
                ->first();

            if ($record) {
                DB::table('email_config')
                    ->where('id', $record->id)
                    ->update($Data);
            } else {
                DB::table('email_config')
                    ->insert($Data);
            }

            foreach ($userIds as $userId) {

                $permissions =   DB::table('permissions')
                    ->where('fk_customer_id', $userId)
                    ->first();

                if ($permissions) {
                    DB::table('permissions')->where('fk_customer_id', $permissions->fk_customer_id)->update(['send_email' => '1']);
                } else {
                    DB::table('permissions')->where('fk_customer_id', $userId)->insert(['fk_customer_id' => $userId, 'send_email' => '1']);
                }

                // Define the SMTP data
                $smtpData = [
                    'host' => $request->host,
                    'username' => $request->username,
                    'password' => $request->password,
                    'port' => $request->port,
                    'smtp_transport' => $request->smtp_transport,
                    'smtp_encryption' => $request->smtp_encryption,
                    'updated_at' => now(),
                ];

                // Check if the SMTP configuration exists for the user
                $existingConfig = DB::table('user_email_config')->where('fk_user_id', $userId)->first();

                if ($existingConfig) {
                    // Update the existing configuration
                    DB::table('user_email_config')->where('fk_user_id', $userId)->update($smtpData);
                } else {
                    // Insert a new configuration
                    DB::table('user_email_config')->insert(array_merge(['fk_user_id' => $userId, 'created_at' => now()], $smtpData));
                }
            }
        } else {
            // Apply SMTP details for specific user
            $get_user_id = DB::table('user_email_config')->where('fk_user_id', $request->id)->first();
            if (isset($get_user_id->fk_user_id) && $get_user_id->fk_user_id != null) {
                $smtpData = [
                    'host' => $request->host,
                    'username' => $request->username,
                    'password' => $request->password,
                    'port' => $request->port,
                    'smtp_transport' => $request->smtp_transport,
                    'smtp_encryption' => $request->smtp_encryption,
                    'updated_at' => now(),
                ];
                $result = DB::table('user_email_config')->where('fk_user_id', $request->id)->update($smtpData);
            } else {
                if ($request->host == null) {
                    return redirect()->route('users.list');
                } else {
                    $smtpData = [
                        'fk_user_id' => $request->id,
                        'host' => $request->host,
                        'username' => $request->username,
                        'password' => $request->password,
                        'port' => $request->port,
                        'smtp_transport' => $request->smtp_transport,
                        'smtp_encryption' => $request->smtp_encryption,
                        'created_at' => now(),
                    ];
                    $result = DB::table('user_email_config')->insert($smtpData);
                }
            }
        }

        Alert::success('Congrats', 'Applied sucessfully!');
        return redirect()->route('users.edit_email', ['CustomerID' => $request->id]);
    }
    public function updatepermission(Request $request)
    {
        $data = [
            'fk_customer_id' => $request->CustomerID,
            'Contact_Share' => isset($request->Contact_Share) ? $request->Contact_Share : '0',
            'Call_Contact' =>  isset($request->Call_Contact) ? $request->Call_Contact : '0',
            'Send_Whatsapp' => isset($request->Send_Whatsapp) ? $request->Send_Whatsapp : '0',
            'Save_Contact' =>  isset($request->Save_Contact) ? $request->Save_Contact : '0',
            'Export_Excel' => isset($request->Export_Excel) ? $request->Export_Excel : '0',
            'send_email' => isset($request->send_email) ? $request->send_email : '0',
            'Bulk_Whatsapp' => isset($request->Bulk_Whatsapp) ? $request->Bulk_Whatsapp : '0',

        ];
        $check = DB::table('permissions')->where('fk_customer_id', $request->CustomerID)->count();

        if ($check == 0) {
            $insert = DB::table('permissions')->insert($data);
            if ($insert) {
                Alert::success('Congrats', 'Insert successfully!');
            }
        } else {
            $update = DB::table('permissions')->where('fk_customer_id', $request->CustomerID)->update($data);
            if ($update) {
                Alert::success('Congrats', 'Updated successfully!');
            }
        }
        $locationConfig = $request->has('location_config') ? $request->location_config : 0;
        $updatedata = [
            'location_config' => $locationConfig,
        ];
        $response = DB::table('users')->where('CustomerID', $request->CustomerID)->update($updatedata);

        return redirect()->back();
    }
    public function destroy($user_id, $type)
    {

        try {
            if ($type == 'block') {
                $delete = 'true';
                $result = Admin::where('user_id', '=', $user_id)->first();
                if ($result) {
                    $result->delete();
                }
            } else {
                $delete = 'false';
            }
            $data = [
                'is_delete' => $delete,
            ];
            User::where('user_id', $user_id)->update($data);

            $userobj = DB::table('users')
                ->where('user_id', $user_id)
                ->first();;
            $data['user'] = $userobj;
            $adminEntry = Admin::where('user_id', '=', $userobj->user_id)->first();
            if ($adminEntry) {
                $data['adminEntry'] = "true";
            } else {
                $data['adminEntry'] = "false";
            }
            $data['permissions'] = DB::table('permissions')->where('fk_customer_id', $userobj->CustomerID)->first();
            $selectedDivisionIdsString = DB::table('assign_division_team_members')
                ->select('divisions.id as id')
                ->leftJoin('divisions', 'divisions.id', 'assign_division_team_members.division_id')
                ->where('assign_division_team_members.customer_id', $userobj->CustomerID)
                ->get()->pluck('id')->toArray();

            $allDivisions = DB::table('divisions')->get()->toArray();
            $encodedDivisions = [];

            foreach ($allDivisions as $division) {
                $division->name = htmlspecialchars($division->name, ENT_QUOTES);
                $encodedDivisions[] = $division;
            }
            $data['divisions'] = json_encode($encodedDivisions);
            $data['selectedDivisionIdsString'] = $selectedDivisionIdsString;
            $html = view('users.memberModalData', $data)->render();
            // return view('users.memberModalData', $data);
            return response()->json([
                "status" => true,
                "message" => 'Updated Successfully',
                "html" => $html,
            ]);
            // return response()->json([
            //     "status" => true,
            // ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
    // protected function store(Request $request)
    // {

    //     $id = $request->id;
    //     var_dump($request->customerids);
    //     foreach($request->customerids as $key=>$user_id)
    //     {
    //          $data =  [
    //              'fk_user_id' => $user_id,
    //              'fk_event_id' => $id,
    //          ];
    //          $insert =DB::table('event_assignments')->insert($data);
    //      }
    //      return redirect('event/list');

    // }
    public function updateIsAdmin(Request $request)
    {

        $check_data = DB::table('event_assignments')->where('fk_user_id', $request->user_id)->get();
        if ($request->isadminvalue == 'true') {
            // isadminvalue true means remove Admin
            $isadmin = 'false';

            if ($check_data != null) {
                $data =  [
                    'is_admin' => 'false',
                ];
                $update = DB::table('event_assignments')->where('fk_user_id', $request->user_id)->update($data);
            }
        } else {
            // isadminvalue flase means make Admin
            $isadmin = 'true';
            $get_all_event = DB::table('events')->get();

            foreach ($get_all_event as $event) {
                $event_id = $event->id;

                $is_assigned = $check_data->contains('fk_event_id', $event_id);

                if (!$is_assigned) {
                    DB::table('event_assignments')->insert([
                        'fk_user_id' => $request->user_id,
                        'fk_event_id' => $event_id,
                        'is_admin' => true,
                    ]);
                }

                if ($check_data != null) {
                    $data =  [
                        'is_admin' => 'true',
                    ];
                    $update = DB::table('event_assignments')->where('fk_user_id', $request->user_id)->update($data);
                }
            }
            $id = $request->user_id;
            $type = "admin_assign";
            SendNotification::dispatch($id, $type);
        }

        $data = [
            'CustomerID' => $request->CustomerID,
            'is_admin' => $isadmin,
        ];
        $result = DB::table('users')->where('CustomerID', $request->CustomerID)->update($data);

        $adminresult = Admin::where('user_id', '=', $request->user_id)->first();
        if ($adminresult) {
            if ($isadmin == 'true') {
                $adminresult->type = 'admin';
            } else {
                $adminresult->type = 'user';
            }
            $adminresult->save();
        }

        $user = User::where('user_id', $request->user_id)->first();
        $data['user'] = $user;
        $adminEntry = Admin::where('user_id', '=', $user->user_id)->first();
        if ($adminEntry) {
            $data['adminEntry'] = "true";
        } else {
            $data['adminEntry'] = "false";
        }
        $data['permissions'] = DB::table('permissions')->where('fk_customer_id', $user->CustomerID)->first();
        $selectedDivisionIdsString = DB::table('assign_division_team_members')
            ->select('divisions.id as id')
            ->leftJoin('divisions', 'divisions.id', 'assign_division_team_members.division_id')
            ->where('assign_division_team_members.customer_id', $user->CustomerID)
            ->get()->pluck('id')->toArray();

        $allDivisions = DB::table('divisions')->get()->toArray();
        $encodedDivisions = [];

        foreach ($allDivisions as $division) {
            $division->name = htmlspecialchars($division->name, ENT_QUOTES);
            $encodedDivisions[] = $division;
        }
        $data['divisions'] = json_encode($encodedDivisions);
        $data['selectedDivisionIdsString'] = $selectedDivisionIdsString;
        $html = view('users.memberModalData', $data)->render();
        // return view('users.memberModalData', $data);
        return response()->json([
            "status" => true,
            "message" => 'Updated Successfully',
            "html" => $html,
        ]);

        // return redirect()->back();
    }

    public function updateEmail(Request $request)
    {
        try {
            $user = User::where('user_id', $request->user_id)->first();

            if (!empty($user)) {
                $update = User::where('user_id', $request->user_id)->update([
                    'sender_name' => $request->sender_name,
                    'sender_email' => $request->sender_email,
                    'cc_email' => $request->cc_email,
                    'bcc_email' => $request->bcc_email
                ]);

                if ($update) {
                    Alert::success('Congrats', 'Email updated successfully!');
                }
            } else {
                Alert::error('Sorry', 'Something went wrong!');
            }
        } catch (\Exception $e) {
            Alert::error('Sorry', 'Something went wrong!');
        }
        return redirect('user/list');
    }

    public function assignEmail(Request $request)
    {
        try {
            $update = User::where('user_id', $request->user_id)->update(['follow_up_email' => $request->follow_up_email, 'primary_email' => $request->primary_email]);

            if ($update) {
                Alert::success('Congrats', 'Email Assign successfully!');
            } else {
                Alert::error('Sorry', 'Something went wrong!');
            }
        } catch (\Exception $e) {
            Alert::error('Sorry', 'Something went wrong!');
        }
        return redirect()->back();
    }

    public function emailPopup(Request $request)
    {
        $follow_up_emails = EmailDraft::where('email_type', 'follow_up')->get();
        $primary_emails = EmailDraft::where('email_type', 'primary')->get();
        $user = User::where('user_id', $request->id)->first();

        $data = array(
            'user' => $user,
            'follow_up_emails' => $follow_up_emails,
            'primary_emails' => $primary_emails,
        );
        $html = view('users.assign-email-popup', $data)->render();

        $true_email = [
            'send_email' => "1",
        ];
        DB::table('permissions')->where('fk_customer_id', $request->CustomerID)->update($true_email);

        return response()->json(['html' => $html]);
    }
    public function getUserlist(Request $request)
    {
        try {
            $data = DB::table('users')->where('is_delete', '!=', 'true')->where('CustomerID', '!=', $request->db_CustomerID)->orderBy('CustomerID', 'desc')->get();

            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function addcustomer_id(Request $request)
    {
        $data = [
            'replaced_with' => $request->CustomerID,
            'is_delete' => 'true'
        ];
        $result = DB::table('users')->where('CustomerID', $request->db_customer_id)->update($data);
        // $result= DB::table('users')->where('CustomerID', $request->CustomerID)->update(['is_delete' => 'true']);

        Alert::success('Congrats', 'Updated successfully!');
        // return redirect()->back();
        return redirect('user/list');
    }

    public function updateCheckbox(Request $request)
    {
        if ($request->currentValue == 0) {
            $isChecked = 1;
        } else {
            $isChecked = 0;
        }
        $updatedata = [
            'location_config' => $isChecked,
        ];
        $response = DB::table('users')->where('user_id', $request->user_id)->update($updatedata);

        return response()->json(['message' => 'Checkbox status updated successfully']);
    }

    public function divisionUpdate(Request $request)
    {
        $teamMember = DB::table('users')->where('CustomerID', $request->CustomerID)->first();
        if (isset($request->divisions)) {
            AssignDivisionTeamMember::where('customer_id', $teamMember->CustomerID)->delete();
            foreach ($request->divisions as $divisionId) {
                $assignDivisionTeamMember =  new AssignDivisionTeamMember();
                $assignDivisionTeamMember->division_id  = $divisionId;
                $assignDivisionTeamMember->customer_id   = $teamMember->CustomerID;
                $assignDivisionTeamMember->save();
            }
        }
        Alert::success('Congrats', 'Division updated for TeamMember successfully');
        return redirect()->route('users.permissionsview', ['CustomerID' => $teamMember->CustomerID]);
    }

    public function addremoveAdmin($user_id, $type)
    {

        try {
            if ($type == 'remove') {
                $result = Admin::where('user_id', '=', $user_id)->first();
                $result->delete();
            } else {
                $user = User::where('user_id', $user_id)->first();
                $addAdmin =  new Admin();
                $addAdmin->user_id = $user->user_id;
                $addAdmin->name = $user->CustomerName;
                $addAdmin->email = $user->Email;
                $addAdmin->password = $user->password;
                $addAdmin->type = 'user';
                $addAdmin->save();
            }

            $user = User::where('user_id', $user_id)->first();
            $data['user'] = $user;
            $adminEntry = Admin::where('user_id', '=', $user->user_id)->first();
            if ($adminEntry) {
                $data['adminEntry'] = "true";
            } else {
                $data['adminEntry'] = "false";
            }
            $data['permissions'] = DB::table('permissions')->where('fk_customer_id', $user->CustomerID)->first();
            $selectedDivisionIdsString = DB::table('assign_division_team_members')
                ->select('divisions.id as id')
                ->leftJoin('divisions', 'divisions.id', 'assign_division_team_members.division_id')
                ->where('assign_division_team_members.customer_id', $user->CustomerID)
                ->get()->pluck('id')->toArray();

            $allDivisions = DB::table('divisions')->get()->toArray();
            $encodedDivisions = [];

            foreach ($allDivisions as $division) {
                $division->name = htmlspecialchars($division->name, ENT_QUOTES);
                $encodedDivisions[] = $division;
            }
            $data['divisions'] = json_encode($encodedDivisions);
            $data['selectedDivisionIdsString'] = $selectedDivisionIdsString;
            $html = view('users.memberModalData', $data)->render();
            // return view('users.memberModalData', $data);
            return response()->json([
                "status" => true,
                "message" => 'Updated Successfully',
                "html" => $html,
            ]);
            // return response()->json(['html' => $html]);

            // return response()->json([
            //     "status" => true,
            // ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
    public function testEMail(Request $request)
    {

        //dd($request);
        $mailConfigData = DB::table('email_config')->first();
        if (empty($mailConfigData)) {
            return response()->json([
                'status' => false,
                'message' => 'Mail could not be sent because config data not found!'
            ]);
        }

        $teamMember = User::where('CustomerID', $request->customer_id)->first();

        $emailDraft = EmailDraft::find($teamMember->primary_email);

        $data = [];
        if (isset($emailDraft->id)) {
            $data['attachments'] = DB::table('email_attachments')->where('email_id', $emailDraft->id)->get();
        } else {
            $data['attachments'] = null;
        }
        $data['from_email'] = $teamMember->sender_email;
        $data['password'] = '';
        $data['from_name'] = $teamMember->sender_name;
        $data['receiver_email'] = $request->email;
        $data['subject'] = $emailDraft->subject;
        $data['body'] = $emailDraft->content . '<br>' . $teamMember->signature;
        $data['cc_email'] = $teamMember->cc_email;

        if (!empty($request->email) && !empty($request->email)) {

            $emailConfig = DB::table('email_config')->first();
            $useremailconfig = DB::table('user_email_config')->where('fk_user_id', '=', $request->customer_id)->first();
            //send error if user email config not found
            if(empty($useremailconfig)) {
                return response()->json([
                    "message" => "User email config not found. Please enter email config in user profile."
                ]);
            }
            $mail = new PHPMailer();

            $mail->IsSMTP(); // Set mailer to use SMTP
            if (isset($useremailconfig) && $useremailconfig != null) {
                $emailConfig = $useremailconfig;

                $mail->Host = $emailConfig->host; // Specify main and backup server
                //$mail->Host = "Give IP Address"; // If the above does not work.
                $mail->Port = $emailConfig->port; // Set the SMTP port
                $mail->SMTPAuth = true; // Enable SMTP authentication
                $mail->Username = $emailConfig->username; // SMTP username
                $mail->Password = $emailConfig->password; // SMTP password
                $mail->SMTPSecure = $emailConfig->smtp_encryption; // Enable encryption, 'ssl' also accepted
            } else {
                $mail->Host = $emailConfig->host; // Specify main and backup server
                //$mail->Host = "Give IP Address"; // If the above does not work.
                $mail->Port = $emailConfig->port; // Set the SMTP port
                $mail->SMTPAuth = true; // Enable SMTP authentication
                $mail->Username = $emailConfig->username; // SMTP username
                $mail->Password = $emailConfig->password; // SMTP password
                $mail->SMTPSecure = $emailConfig->smtp_encryption; // Enable encryption, 'ssl' also accepted
            }


            $mail->From = $data['from_email'];
            $mail->FromName = $data['from_name'];

            $mail->AddAddress($data['receiver_email']); // Add a recipient

            if ($data['cc_email'] != null && $data['cc_email'] != "") {
                $recipients = explode(',', $data['cc_email']);

                foreach ($recipients as $ccemail) {
                    $mail->AddCC($ccemail, $data['from_name']);
                }
            }

            $mail->IsHTML(true); // Set email format to HTML
            $sub = '=?UTF-8?B?' . base64_encode($data['subject']) . '?=';
            $mail->Subject = $sub;
            $mail->Body = $data['body'];

            if (isset($data['attachments'])) {
                // $url = "../../frenzincrm_api/public/uploads/email/attachments/";
                //$url = "../../frenzincrm/public/uploads/email/attachments/";
                $url = public_path(UPLOAD_EMAIL);

                foreach ($data['attachments'] as $key => $attach) {
                    $attachmentPath = $url . $attach->attachment;
                    $mail->addAttachment($attachmentPath);
                }
            }
            $response = $mail->Send();
            if ($response) {
                return response()->json([
                    "message" => "Email send successfully"
                ]);
            } else {
                return response()->json([
                    "message" => $mail->ErrorInfo
                ]);
            }
        }
    }

    public function testEMailNew(Request $request)
    {


        $host = $request?->host ?? '';
        $customer_id = $request?->customer_id ?? '';
        $port = $request?->port ?? '';
        $username = $request?->username ?? '';
        $password = $request?->password ?? '';
        $smtp_encryption = $request?->smtp_encryption ?? '';
        $toEmail = $request?->email ?? '';
        $senderName = $request?->sender_name ?? '';
        $bccEmail = $request?->bcc_email ?? '';
        $senderEmail = $request?->sender_email ?? '';
        $ccEmail = $request?->cc_email ?? '';
        $primary_email = $request?->primary_email ?? '';
        $signature = $request?->signature ?? '';
        // $smtp_transport = $request?->smtp_transport ?? '';

        $requestValidator = Validator::make($request->all(),[
            'host' => 'required',
            'port' => 'required',
            'username' => 'required',
            'password' => 'required',
            'smtp_encryption' => 'required',
            'email' => 'required|email',
            'sender_name' => 'required',
            'sender_email' => 'required|email',
            'primary_email' => 'required',
            // 'smtp_transport' => 'required',
        ],[
            'host.required' => 'Host is required',
            'port.required' => 'Port is required',
            'username.required' => 'Username is required',
            'password.required' => 'Password is required',
            'smtp_encryption.required' => 'SMTP Encryption is required',
            'email.required' => 'Receiver Email is required',
            'email.email' => 'Receiver Email must be a valid email address',
            'sender_name.required' => 'Sender Name is required',
            'sender_email.required' => 'Sender Email is required',
            'sender_email.email' => 'Sender Email must be a valid email address',
            'primary_email.required' => 'Please select draft email to send test email.',
            // 'smtp_transport.required' => 'SMTP Transport is required',
        ]);

        if($requestValidator->fails()) {
            return response()->json([
                'message' => collect($requestValidator->errors())->values()->pluck('0')->implode('<br>')
            ]);
        }
        // return response()->json([
        //     "message" => $request->all()
        // ]);
        //dd($request);
        // $mailConfigData = DB::table('email_config')->first();
        // if (empty($mailConfigData)) {
        //     return response()->json([
        //         'status' => false,
        //         'message' => 'Mail could not be sent because config data not found!'
        //     ]);
        // }


        $emailDraft = EmailDraft::find($primary_email);

        $data = [];
        if (isset($emailDraft->id)) {
            $data['attachments'] = DB::table('email_attachments')->where('email_id', $emailDraft->id)->get();
        } else {
            $data['attachments'] = null;
        }
        $data['from_email'] = $senderEmail;
        $data['password'] = '';
        $data['from_name'] = $senderName;
        $data['receiver_email'] = $toEmail;
        $data['subject'] = $emailDraft?->subject ?? '';
        $data['body'] = $emailDraft?->content . '<br>' . $signature;
        $data['cc_email'] = $ccEmail;

        if (!empty($toEmail) && !empty($toEmail)) {

            // $emailConfig = DB::table('email_config')->first();

            $mail = new PHPMailer();

            $mail->IsSMTP(); // Set mailer to use SMTP
            if (!empty($host) && !empty($port) && !empty($username) && !empty($password) && !empty($smtp_encryption)) {

                $mail->Host = $host; // Specify main and backup server
                //$mail->Host = "Give IP Address"; // If the above does not work.
                $mail->Port = $port; // Set the SMTP port
                $mail->SMTPAuth = true; // Enable SMTP authentication
                $mail->Username = $username; // SMTP username
                $mail->Password = $password; // SMTP password
                $mail->SMTPSecure = $smtp_encryption; // Enable encryption, 'ssl' also accepted
            } else {
                // $mail->Host = $emailConfig->host; // Specify main and backup server
                // //$mail->Host = "Give IP Address"; // If the above does not work.
                // $mail->Port = $emailConfig?->port; // Set the SMTP port
                // $mail->SMTPAuth = true; // Enable SMTP authentication
                // $mail->Username = $emailConfig->username; // SMTP username
                // $mail->Password = $emailConfig->password; // SMTP password
                // $mail->SMTPSecure = $emailConfig->smtp_encryption; // Enable encryption, 'ssl' also accepted
            }


            $mail->From = $senderEmail;
            $mail->FromName = $senderName;

            $mail->AddAddress($toEmail); // Add a recipient

            if ($ccEmail != null && $ccEmail != "") {
                $recipients = explode(',', $ccEmail);

                foreach ($recipients as $ccemail) {
                    $mail->AddCC($ccemail, $senderName);
                }
            }

            $mail->IsHTML(true); // Set email format to HTML
            $sub = '=?UTF-8?B?' . base64_encode($data['subject']) . '?=';
            $mail->Subject = $sub;
            $mail->Body = $data['body'];

            if (isset($data['attachments'])) {
                // $url = "../../frenzincrm_api/public/uploads/email/attachments/";
                //$url = "../../frenzincrm/public/uploads/email/attachments/";
                $url = public_path(UPLOAD_EMAIL);

                foreach ($data['attachments'] as $key => $attach) {
                    $attachmentPath = $url . $attach->attachment;
                    $mail->addAttachment($attachmentPath);
                }
            }
            $response = $mail->Send();
            if ($response) {
                return response()->json([
                    "message" => "Email sent successfully"
                ]);
            } else {
                return response()->json([
                    "message" => $mail->ErrorInfo
                ]);
            }
        }
    }

    public function addUser(Request $request)
    {
        return view('users.addUser');
    }

    public function saveUser(Request $request)
    {

        // Validate the incoming request data
        $request->validate([
            'CustomerName' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required',
        ]);

        // Check if the domains match
        $authUser = auth()->user();
        $authDomain = substr(strrchr($authUser->email, "@"), 1);
        $providedEmail = $request->input('email');
        $providedDomain = substr(strrchr($providedEmail, "@"), 1);
        if ($providedDomain !== $authDomain) {
            return redirect()->back()->withErrors(['email' => 'Invalid email domain.'])->withInput();
        }

        // Save the user to the database
        $user = new User();
        $user->CustomerName = $request->input('CustomerName');
        $user->email = $request->input('email');
        $user->password = $request->has('password') ? Hash::make($request->input('password')) : NULL;
        $user->is_admin = $request->has('is_admin') ? 'true' : 'false';
        $user->status = 'true';
        $user->save();

        // Assign Events if is admin true
        $check_data = DB::table('event_assignments')->where('fk_user_id', $user->id)->get();
        if ($user->is_admin == 'true') {

            $isadmin = 'true';
            $get_all_event = DB::table('events')->get();

            foreach ($get_all_event as $event) {
                $event_id = $event->id;

                $is_assigned = $check_data->contains('fk_event_id', $event_id);

                if (!$is_assigned) {
                    DB::table('event_assignments')->insert([
                        'fk_user_id' => $user->id,
                        'fk_event_id' => $event_id,
                        'is_admin' => 'true',
                    ]);
                }

                if ($check_data != null) {
                    $data =  [
                        'is_admin' => 'true',
                    ];
                    $update = DB::table('event_assignments')->where('fk_user_id', $user->id)->update($data);
                }
            }
            $id = $user->id;
            $type = "admin_assign";
            SendNotification::dispatch($id, $type);
        }

        // Pc Accesss
        $user = User::where('user_id', $user->id)->first();
        $addAdmin =  new Admin();
        $addAdmin->user_id = $user->user_id;
        $addAdmin->name = $user->CustomerName;
        $addAdmin->email = $user->Email;
        $addAdmin->password = $user->password;
        $addAdmin->type = 'user';
        $addAdmin->save();


        // update Permissions
        // $data = [
        //     'fk_customer_id' => $user->CustomerID,
        //     'Contact_Share' => '1',
        //     'Call_Contact' =>  '1',
        //     'Send_Whatsapp' => '1',
        //     'Save_Contact' =>  '1',
        //     'Export_Excel' => '1',
        //     'send_email' =>  '0',
        // ];

        // $insert = DB::table('permissions')->insert($data);

        // Display success message and redirect
        Alert::success('Congrats', 'Team Member added successfully!');
        return redirect()->route('users.list');
    }

    public function getOtp(Request $request)
    {
        // return response()->json([
        //     "status" => true,
        //     "message" => 'OTP Received',
        //     "data" => base64_encode('789456'),
        // ]);
        // dd($request->all());
        $url = 'https://frenzinsoftwares.com/visitor/webservice_v3/v1/sendOtp';
        $data = [
            // "CustomerID" => 0,
            'email' => $request->email,
            'mobile' => $request->mobile,
            'type' => 'register'
        ];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        $getOtpResponse = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $getOtpResponse = json_decode($getOtpResponse);
        // dd($getOtpResponse->status);

        if ($getOtpResponse) {
            if (!$getOtpResponse->status) {
                return response()->json([
                    "status" => false,
                    "message" => $getOtpResponse->msg,
                ]);
            } else {
                return response()->json([
                    "status" => true,
                    "message" => $getOtpResponse->msg,
                    "data" => base64_encode($getOtpResponse->data->otp),
                    // "data" => base64_encode('789456'),
                ]);
            }
        } else {
            return response()->json([
                "status" => false,
                "message" => 'Api failed!',
            ]);
        }
    }

    public function userCreate(Request $request)
    {
        // dd($request->all());
        // return response()->json([
        //     "status" => true,
        //     "message" => "User Registered Successfully"
        // ]);

        $url = 'https://frenzinsoftwares.com/visitor/webservice_v3/v1/customerdetail';
        $data = [
            'CustomerID' => 0,
            'device_type' => 'web',
            "android_version" => "android_version",
            "appversion" => "appversion",
            "device_model" => "device_model",
            "token" => "token",
            "imei" => "imei",
            'customer_name' => $request->name,
            'email' => $request->email,
            'mobile' => $request->phone,
            'type' => 'register'
        ];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        $registerCustomerResponse = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $registerCustomerResponse = json_decode($registerCustomerResponse);
        // dd($registerCustomerResponse->status);

        if ($registerCustomerResponse) {
            if (!$registerCustomerResponse->status) {
                return response()->json([
                    "status" => false,
                    "message" => $registerCustomerResponse->msg
                ]);
            } else {
                $adminCount = Admin::count();
                // dd($adminCount);
                $isAdmin = 'false';
                $type = 'user';

                if ($adminCount == 0) {
                    $isAdmin = 'true';
                    $type = 'admin';
                }

                $userData = [
                    'CustomerID' => $registerCustomerResponse->CustomerID,
                    'CustomerName' => $request->name,
                    'Email' => $request->email,
                    'Phone' => $request->phone,
                    'is_admin' => $isAdmin,
                    'password' => Hash::make($request->password),
                ];

                $user_id = DB::table('users')->insertGetId($userData);

                DB::table('permissions')->updateOrInsert(
                    ['fk_customer_id' => $registerCustomerResponse->CustomerID], // Condition
                    [
                        'Contact_Share'  => '1',
                        'Call_Contact'   => '1',
                        'Send_Whatsapp'  => '1',
                        'Save_Contact'   => '1',
                        'Export_Excel'   => '1',
                        'Bulk_Whatsapp'  => '1',
                        'send_email'     => '0',
                        'updated_at'     => now(),
                        'created_at'     => now(), // Will only be used if inserting
                    ]
                );

                $admin = Admin::create([
                    'user_id' => $user_id,
                    'name' => $request->name,
                    'email' => $request->email,
                    'type' => $type,
                    'password' => Hash::make($request->password),
                ]);

                return response()->json([
                    "status" => true,
                    "message" => "Team Member Added Successfully."
                ]);
            }
        }
    }

    public function memberData($member_id)
    {
        $user = User::where('user_id', $member_id)->first();
        $data['user'] = $user;
        $adminEntry = Admin::where('user_id', '=', $user->user_id)->first();
        if ($adminEntry) {
            $data['adminEntry'] = "true";
        } else {
            $data['adminEntry'] = "false";
        }
        $data['permissions'] = DB::table('permissions')->where('fk_customer_id', $user->CustomerID)->first();

        $selectedDivisionIdsString = DB::table('assign_division_team_members')
            ->select('divisions.id as id')
            ->leftJoin('divisions', 'divisions.id', 'assign_division_team_members.division_id')
            ->where('assign_division_team_members.customer_id', $user->CustomerID)
            ->get()->pluck('id')->toArray();

        $allDivisions = DB::table('divisions')->get()->toArray();
        $encodedDivisions = [];

        foreach ($allDivisions as $division) {
            $division->name = htmlspecialchars($division->name, ENT_QUOTES);
            $encodedDivisions[] = $division;
        }
        $data['divisions'] = json_encode($encodedDivisions);
        $data['selectedDivisionIdsString'] = $selectedDivisionIdsString;

        return view('users.memberModalData', $data);
    }

    public function updatePermissionNew(Request $request)
    {
        // dd($request->all());
        if ($request->permissionName != "location_config") {
            switch ($request->permissionName) {
                case 'Contact_Share':
                    $data = ['Contact_Share' => $request->permissionValue];
                    break;
                case 'Call_Contact':
                    $data = ['Call_Contact' => $request->permissionValue];
                    break;
                case 'Send_Whatsapp':
                    $data = ['Send_Whatsapp' => $request->permissionValue];
                    break;
                case 'Save_Contact':
                    $data = ['Save_Contact' => $request->permissionValue];
                    break;
                case 'Export_Excel':
                    $data = ['Export_Excel' => $request->permissionValue];
                    break;
                case 'send_email':
                    $data = ['send_email' => $request->permissionValue];
                    break;
                case 'Bulk_Whatsapp':
                    $data = ['Bulk_Whatsapp' => $request->permissionValue];
                    break;
            }
            DB::table('permissions')->where('fk_customer_id', $request->CustomerID)->update($data);
        } else {
            $locationConfig = $request->permissionValue == '1' ? 1 : 0;
            $updatedata = [
                'location_config' => $locationConfig,
            ];
            DB::table('users')->where('CustomerID', $request->CustomerID)->update($updatedata);
        }

        $user = User::where('user_id', $request->userId)->first();
        $data['user'] = $user;
        $adminEntry = Admin::where('user_id', '=', $user->user_id)->first();
        if ($adminEntry) {
            $data['adminEntry'] = "true";
        } else {
            $data['adminEntry'] = "false";
        }
        $data['permissions'] = DB::table('permissions')->where('fk_customer_id', $user->CustomerID)->first();

        $selectedDivisionIdsString = DB::table('assign_division_team_members')
            ->select('divisions.id as id')
            ->leftJoin('divisions', 'divisions.id', 'assign_division_team_members.division_id')
            ->where('assign_division_team_members.customer_id', $user->CustomerID)
            ->get()->pluck('id')->toArray();

        $allDivisions = DB::table('divisions')->get()->toArray();
        $encodedDivisions = [];

        foreach ($allDivisions as $division) {
            $division->name = htmlspecialchars($division->name, ENT_QUOTES);
            $encodedDivisions[] = $division;
        }
        $data['divisions'] = json_encode($encodedDivisions);
        $data['selectedDivisionIdsString'] = $selectedDivisionIdsString;

        $html = view('users.memberModalData', $data)->render();
        // return view('users.memberModalData', $data);
        return response()->json([
            "status" => true,
            "message" => 'Updated Successfully',
            "html" => $html,
        ]);
    }

    public function updateDivisionNew(Request $request)
    {
        $teamMember = DB::table('users')->where('CustomerID', $request->CustomerID)->first();

        if ($request->has('divisionValue')) {
            $assignedTeamMember = AssignDivisionTeamMember::where('customer_id', $teamMember->CustomerID)
                ->where('division_id', $request->divisionId)
                ->first();
            if ($assignedTeamMember) {
                if ($request->divisionValue == '0') {
                    $assignedTeamMember->delete();
                } else {
                    $assignDivisionTeamMember =  new AssignDivisionTeamMember();
                    $assignDivisionTeamMember->division_id  = $request->divisionId;
                    $assignDivisionTeamMember->customer_id   = $teamMember->CustomerID;
                    $assignDivisionTeamMember->save();
                }
            } else {
                $assignDivisionTeamMember =  new AssignDivisionTeamMember();
                $assignDivisionTeamMember->division_id  = $request->divisionId;
                $assignDivisionTeamMember->customer_id   = $teamMember->CustomerID;
                $assignDivisionTeamMember->save();
            }
        }

        $user = User::where('user_id', $request->userId)->first();
        $data['user'] = $user;
        $adminEntry = Admin::where('user_id', '=', $user->user_id)->first();
        if ($adminEntry) {
            $data['adminEntry'] = "true";
        } else {
            $data['adminEntry'] = "false";
        }
        $data['permissions'] = DB::table('permissions')->where('fk_customer_id', $user->CustomerID)->first();

        $selectedDivisionIdsString = DB::table('assign_division_team_members')
            ->select('divisions.id as id')
            ->leftJoin('divisions', 'divisions.id', 'assign_division_team_members.division_id')
            ->where('assign_division_team_members.customer_id', $user->CustomerID)
            ->get()->pluck('id')->toArray();

        $allDivisions = DB::table('divisions')->get()->toArray();
        $encodedDivisions = [];

        foreach ($allDivisions as $division) {
            $division->name = htmlspecialchars($division->name, ENT_QUOTES);
            $encodedDivisions[] = $division;
        }
        $data['divisions'] = json_encode($encodedDivisions);
        $data['selectedDivisionIdsString'] = $selectedDivisionIdsString;

        $html = view('users.memberModalData', $data)->render();
        // return view('users.memberModalData', $data);
        return response()->json([
            "status" => true,
            "message" => 'Division updated for TeamMember successfully',
            "html" => $html,
        ]);
    }
}
