<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\Sub_categoriesDataTable;
use App\Models\Sub_category;
use App\Models\Category;
use DB;
use Alert;
use Carbon\Carbon;

class Sub_CategoryController extends Controller
{
    public function index(Request $request, Sub_categoriesDataTable $dataTable)
    {

        return $dataTable->render('sub_category.index');
    }
    public function addView(Request $request)
    {
        $data['Category'] = Category::get();
        if (isset($request->id)) {
            $data['subcategory'] = Sub_category::where('id', $request->id)->first();
        } else {
            $data['subcategory'] = '';
        }
        return view('sub_category.add', $data);
    }

    public function store(Request $request)
    {
        if ($request->action == 'insert') {      
            if (is_array($request->name)) {
                foreach ($request->name as $name) {
                    if(!empty($name)){
                        $obj = new Sub_category();
                        $obj->name = $name;
                        $obj->fk_category_id = $request->fk_category_id;
                        $obj->created_at = date('Y-m-d H:i:s');
                        $obj->save();
                    }                  
                }
                Alert::success('Congrats', 'You have successfully added the Sub Categories.');
            } else {
                Alert::error('Error', 'Invalid data format. Please provide an array of names.');
            }
            return redirect('sub_category/list');
        } else {           
            $obj = Sub_category::find($request->id);
            if ($obj) {
                $obj->name = $request->name ?? $obj->name; // Update name if provided
                $obj->fk_category_id = $request->fk_category_id ?? $obj->fk_category_id; // Update fk_category_id if provided
                $obj->updated_at = date('Y-m-d H:i:s');
                $obj->save();

                Alert::success('Congrats', 'Sub Category has been updated successfully.');
            } else {
                Alert::error('Error', 'Sub Category not found.');
            }
            return redirect('sub_category/list');
        }
    }

    public function destroy($id)
    {
        try {
            $subcategory = Sub_category::find($id);
            $categoryId = $subcategory->fk_category_id;
            $subcategory->delete();
            
            $data['category_id'] = $categoryId;
            $data['subcategories'] = Sub_category::where('fk_category_id', $categoryId)->get();
            $html = view('category.subCategoryModal',$data)->render();
            return response()->json([
                "status" => true,
                "message" => "Subcategory Deleted Successfully",
                "html" => $html,
            ]);
            // return response()->json([
            //     "status" => true,
            // ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
}
