<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\SourceOfLeadDataTable;
use App\Models\SourceOfLead;
use DB;
use Alert;
use App\DataTables\ReferredByMasterDataTable;
use App\Models\ReferredByMaster;
use Carbon\Carbon;

class ReferredByMasterController extends Controller
{
    public function index(Request $request, ReferredByMasterDataTable $dataTable)
    {
        $leads = ReferredByMaster::pluck('name', 'id')->toArray();
        return $dataTable->with([
            'lead_id' => $request->lead_id,
        ])->render('referredBy_master.index', compact('leads'));
    }
    public function addView(Request $request)
    {
        if (isset($request->id)) {
            $data['lead'] = ReferredByMaster::where('id', $request->id)->first();
        } else {
            $data['lead'] = '';
        }
        return view('referredBy_master.add', $data);
    }

    public function store(Request $request)
    {
        if ($request->action == 'insert') {

            foreach ($request->name as $name) {
                if(!empty($name)){
                    $obj = new ReferredByMaster();
                    $obj->name = $name;
                    $obj->created_at = Carbon::now('Asia/Kolkata');
                    $obj->save();
                }
            }
            Alert::success('Congrats', 'You have successfully submitted the data.');
            return redirect('referred_by_master/list');
        } else {
            // Update a single record for the edit action
            $obj = ReferredByMaster::find($request->id);

            if ($obj) {
                $obj->name = $request->name;
                $obj->updated_at =  Carbon::now('Asia/Kolkata');
                $obj->save();
                Alert::success('Congrats', 'Referred By has been updated successfully.');
                return redirect('referred_by_master/list');
            } else {
                Alert::error('Error', 'Category not found.');
                return redirect('referred_by_master/list');
            }
        }

    }
    public function destroy($id)
    {
        try {
            ReferredByMaster::where('id', $id)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
}
