<?php

namespace App\Http\Controllers;

use App\DataTables\ProductsDataTable;
use App\Models\Product;
use DB;
use Alert;
use Illuminate\Http\Request;
use Response;
use PDF;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Validator;

class ProductController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->_product = new Product();
    }
    public function index(Request $request, ProductsDataTable $dataTable)
    {

        return $dataTable->render('product.index');
    }
    public function addView()
    {
        return view('product.addproduct');
    }

    public function addproductstore(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'product_code' => 'nullable|unique:products,product_code',
        ]);
        if ($validator->fails()) {
            return response()->json(['status' => false, 'message' => $validator->errors()->first(), "error" => $validator->errors()], 422);
        }
        $data = [
            'id' => $request->id,
            'name' => $request->name,
            'hsn_code' => $request->hsn_code ?? null,
            'price' => $request->price ?? null,
            'technical_specification' => $request->technical_specification ?? null,
            'gst'   => $request->gst ?? null,
            'fk_user_id' => '4444',
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        if($request?->qrcodecheck){
            $data['product_code'] = $request->product_code;
            $data['product_message'] = $request->product_message;
        }
        DB::beginTransaction();
        try {

            $productid = DB::table('products')->insertGetId($data);
        if($request->qrcodecheck){

            $qr = Product::generateProductQr($productid);
        }

            foreach ($request->description as $key => $val) {
                $insertdescription = array();
                if (!empty($val)) {

                    $temp = array();

                    if ($request->file('image')[$key]) {
                        $name = str_replace(' ', '_', $request->file('image')[$key]->getClientOriginalName());
                        $ext = $request->file('image')[$key]->getClientOriginalExtension();
                        //$image = md5(microtime() . $name) . "." . $ext;
                        $path = public_path('../public/uploads/product/' . $productid . '/');
                        $success = $request->file('image')[$key]->move($path, $name);

                        $temp['image'] = $name;
                    }
                    $temp = [
                        'fk_product_id' => $productid,
                        'description' => $val,
                        'image' => url('uploads/product/' . $productid) . '/' . $name,
                    ];

                    array_push($insertdescription, $temp);

                    if (!empty($insertdescription)) {
                        $data['product_images'] = DB::table('product_images')->insert($insertdescription);
                    }
                }
            }

            if ($request->file('quotation_image') != "") {
                $name = 'quotation_' . microtime() . '_' . str_replace(' ', '_', $request->file('quotation_image')->getClientOriginalName());
                $ext = $request->file('quotation_image')->getClientOriginalExtension();
                //$image = md5(microtime() . $name) . "." . $ext;
                $path = public_path('../public/uploads/product/' . $productid . '/');
                $success = $request->file('quotation_image')->move($path, $name);
                $Productupdate = Product::find($productid);
                $Productupdate->quotation_image = url('uploads/product/' . $productid) . '/' . $name;
                $Productupdate->save();
            }
            // Alert::success('Congrats', 'You have Successfully Data Inserted');

            DB::commit();
            return response()->json(['status' => true, 'message' => 'Product added successfully', "redirect" => 'product/list'], 200);
            // return redirect('product/list');
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json(['status' => false, 'message' => $e->getMessage()], 500);
        }
    }

    public function detailview(Request $request)
    {
        $data['data'] = DB::table('products')
            ->where('products.id', $request->id)->first();

        $data['product_images'] = DB::table('product_images')
            ->where('fk_product_id', $request->id)
            ->get();

        return view('product.productdetail', $data);
    }
    public function productcount(Request $request)
    {
        $data = DB::table('visitor_products')
            ->select('visitors.name', 'visitor_products.*')
            ->leftjoin('visitors', 'visitors.id', 'visitor_products.visitor_id')
            ->where('visitor_products.product_id', $request->id)
            ->groupby('visitor_id')
            ->get();

        return view('product.visitorproductcount', compact('data'));
    }

    public function destroy($id)
    {
        try {
            Product::where('id', $id)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
    public function getimagefile(Request $request)
    {
        try {
            $data = DB::table('product_images')->select('image', 'id', 'description')->where('fk_product_id', $request->product_id)->get();

            if (!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function editimage(Request $request)
    {
        $data['iamges_name'] = DB::table('product_images')
            ->where('id', $request->file_id)
            ->first();

        return view('product.imageEdit', $data);
    }
    public function imageStore(Request $request)
    {
        $imagedata = DB::table('product_images')->where('product_images.id', $request->id)->first();

        if ($request->image != '') {
            $path = public_path() . '/uploads/product/' . $request->fk_product_id . '/';
            $file = $request->image;
            $filename = $file->getClientOriginalName();
            $file->move($path, $filename);

            $date_update = ([
                'updated_at' => Carbon::now(),
            ]);
            $data['products'] = DB::table('products')
                ->where('id', $request->fk_product_id)
                ->update($date_update);
        }
        $updatedata = ([
            'description' => isset($request->description) ? $request->description : $imagedata->description,
            'image' => isset($filename) ?  url('uploads/product/' . $request->fk_product_id) . '/' . $filename : $imagedata->image,
        ]);
        $data['iamges_name'] = DB::table('product_images')
            ->where('id', $request->id)
            ->update($updatedata);

        return redirect('product/list');
    }
    public function filedestroy(Request $request)
    {
        try {
            $data = DB::table('product_images')->where('product_images.id', $request->fileid)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
    public function updateName(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'product_code' => 'nullable|unique:products,product_code,'.$request->id,
        ]);
        if ($validator->fails()) {
            return response()->json(['status' => false, 'message' => $validator->errors()->first(), "error" => $validator->errors()], 422);
        }
        // return $request->all();
        DB::beginTransaction();
        try {


            $Product = Product::find($request->id);
            $old_product_code = $Product->product_code;
            if (!empty($Product)) {
                $Product->name = $request->name;
                $Product->hsn_code = $request->hsn_code ?? null;
                $Product->price = $request->price ?? null;
                $Product->gst = $request->gst ?? null;
                if($request?->qrcodecheck){
                if ($request?->product_code != $Product->product_code) {
                    $Product->product_code = $request?->product_code;
                }
                $Product->product_message = $request?->product_message ?? null;
                }else{
                    $Product->product_code = null;
                    $Product->product_message = null;
                    $Product->qr_file = null;
                }

                // $Product->product_code = $request?->product_code ?? null;
                $Product->technical_specification = $request->technical_specification ?? null;
                $Product->updated_at = Carbon::now();
                $Product->save();
                if($request?->product_code != $old_product_code && $request?->qrcodecheck){
                    $qr = Product::generateProductQr($request->id);
                }

                if ($request->file('quotation_image') != "") {
                    $name = 'quotation_' . microtime() . '_' . str_replace(' ', '_', $request->file('quotation_image')->getClientOriginalName());
                    $ext = $request->file('quotation_image')->getClientOriginalExtension();
                    //$image = md5(microtime() . $name) . "." . $ext;
                    $path = public_path('../public/uploads/product/' . $request->id . '/');
                    $success = $request->file('quotation_image')->move($path, $name);
                    $Productupdate = Product::find($request->id);
                    $Productupdate->quotation_image = url('uploads/product/' . $request->id) . '/' . $name;
                    $Productupdate->save();
                }
            }
            DB::commit();
            return response()->json(['status' => true, 'message' => 'Product updated successfully', "redirect" => 'product/list'], 200);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json(['status' => false, 'message' => $e->getMessage()], 500);
        }
    }
    public function addimageView(Request $request)
    {
        $data['iamges_name'] = DB::table('product_images')
            ->where('id', $request->product_id)
            ->first();
        $data['id_product'] = $request->product_id;

        return view('product.addimageproduct', $data);
    }
    public function imageStorenewadd(Request $request)
    {

        if ($request->image != '') {
            $path = public_path() . '/uploads/product/' . $request->fk_product_id . '/';
            $file = $request->image;
            $filename = $file->getClientOriginalName();
            $file->move($path, $filename);

            $date_update = ([
                'updated_at' => Carbon::now(),
            ]);
            $data['products'] = DB::table('products')
                ->where('id', $request->fk_product_id)
                ->update($date_update);
        }
        $addnew = ([
            'fk_product_id' => $request->fk_product_id,
            'description' => isset($request->description) ? $request->description : null,
            'image' => isset($filename) ?  url('uploads/product/' . $request->fk_product_id) . '/' . $filename : null,
        ]);
        $data['iamges_name'] = DB::table('product_images')->insert($addnew);
        Alert::success('Congrats', 'You have Successfully Data Inserted');

        return redirect()->back();
    }
}
