<?php

namespace App\Http\Controllers;

use App\Models\LocationConfig;
use App\Models\Sendpush;
use App\Models\User;
use App\Models\UserLocation;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Support\Facades\DB;

class LocationTrackingController extends Controller
{
    //
    public function index()
    {
        $duration = LocationConfig::first()?->location_interval ?? 0;


        return view('location_tracking.index',compact('duration'));
    }
    public function saveDuration(Request $request){
        DB::beginTransaction();
        try{
            $duration = $request->select_duration;
            $firstConfig  = LocationConfig::first();
            // ?->location_interval = $duration
            $id = $firstConfig->id ?? 0;

            $locationConfig = LocationConfig::updateOrCreate(['id' => $id],['location_interval' => $duration]);

            DB::commit();
            return response()->json(['status' => true,'message' => 'Duration saved successfully','location_interval' => $locationConfig?->location_interval ?? 0]);
        }catch(Exception $e){
            DB::rollBack();
            return response()->json(['status' => false,'message' => $e->getMessage()],500);
        }
    }
    public function teamMemberList(Request $request, $memberId = 0){
        try{

            $requestDate = $request->input('date_filter');

            $teamMember = UserLocation::select(
                'user_locations.*',
                'users.CustomerName',
            )
            ->join('users', 'users.user_id', '=', 'user_locations.user_id')
            ->whereIn('user_locations.id', function ($query) {
                $query->select(DB::raw('MAX(id)')) // latest record per user
                      ->from('user_locations')
                      ->groupBy('user_id');
            })
            ->when($requestDate, function ($query) use ($requestDate) {
                $query->whereDate('user_locations.date_time', $requestDate);
            })

            ->when($memberId, function ($query) use ($memberId) {
                $query->where('user_locations.user_id', $memberId);
            });
            if(empty($memberId)){
                $teamMember = $teamMember->orderBy('users.CustomerName')->get();

                return response()->json(['data' => $teamMember,'status' => true,'message' => 'Team member list fetched successfully']);
            }
            else{

                $teamMember = $teamMember
                ->when($memberId, function ($query) use ($memberId) {
                    $query->where('user_locations.user_id', $memberId);
                })
                ->where('on_demand','true')
                ->when($requestDate, function ($query) use ($requestDate) {
                    $query->whereDate('user_locations.date_time', $requestDate);
                })
                ->first();
                return response()->json(['data' => $teamMember,'status' => true,'message' => 'Team member list fetched successfully']);
            }

        }catch(Exception $e){
            return response()->json(['status' => false,'message' => $e->getMessage()],500);
        }
    }

    public function getAllLocationOfUser(Request $request,$memberId = 0){

        try{
            $date = $request->input('date');

            $getAllLocation = UserLocation::select(
                'user_locations.*',
                'users.CustomerName',
            )
            ->join('users', 'users.user_id', '=', 'user_locations.user_id')

            ->when($date, function ($query) use ($date) {
                $query->whereDate('user_locations.date_time', $date);
            })
            ->when($memberId, function ($query) use ($memberId) {
                $query->where('user_locations.user_id', $memberId);
            });

            $getAllLocation = $getAllLocation->get();

            return response()->json(['status' => true,'message' => "All Locations",'data' => $getAllLocation]);


        }catch(Exception $e){
            return response()->json(['status' => false,'message' => $e->getMessage()],500);

        }
    }
    public function locationTrackingModal(){

        try {
        $duration = LocationConfig::first()?->location_interval ?? 0;


            $html = view('location_tracking.location_tracking_modal',compact('duration'))->render();
            return response()->json([
                'message' => "Setting Modal",
                'status' => true,
                'html' => $html,
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'message' => $e->getMessage(),
                'status' => false,
            ], 500);
        }
        return view('location_tracking.location_tracking_modal');
    }
    public function getLatestLocation(Request $request, $memberId = 0){
        try{

            $pushObj = new Sendpush();
            $user = User::where('user_id',$memberId)->first();
            $title = "";
            $msg = "" ;
            $message = array("notification_type" => "store_user_location", "message" => $msg, "title" => $title);
            if ($user->device_type == "android" || $user->device_type == "Android")
            {

                $pushObj->sendPushAndroidForLocationTracking(0,$user->push_token, $message);
            }
            else
            {

                $pushObj->sendPushIOS($user->push_token, $message, $title);
            }

            return response()->json([
                'status' => true,
                'message'=>"Pusher Send Successfully",
            ], 200);
        }catch(Exception $e){
            return response()->json(['status' => false,'message' => $e->getMessage()],500);
        }
    }
    public function getUserCurrentLocation(Request $request){
        $user_id = $request?->user_id;
        $time_in_secodes = $request?->time_in_secodes;
        $past_time = Carbon::now()->subSeconds($time_in_secodes);

        $type = $request->type;
        if($type == "pusher"){



        }
        else{
            $latestPusherLocation = UserLocation::where('user_id',$user_id)->orderBy('created_at','desc')->where('on_demand','true')->where('created_at','>=',$past_time)->first();
            if(!empty($latestPusherLocation)){
                return response()->json([
                    'status' => true,
                    'message'=>"Get Latest Location From Pusher Entry",
                    'data' => $latestPusherLocation
                ], $this->successStatus);
            }
            else{
                $latestPusherLocation = UserLocation::where('user_id',$user_id)->orderBy('created_at','desc')->first();
                return response()->json([
                    'status' => true,
                    'message'=>"Get Latest Location From User Location",
                    'data' => $latestPusherLocation
                ], 200);
            }
        }


    }
}
