<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Models\Expence;
use App\Models\ExpenceType;
use App\Models\ExpenceImages;
use Carbon\Carbon;
use DB;

use App\Models\AssignDivisionAdmin;
use App\Models\AssignDivisionTeamMember;
use App\DataTables\ExpenceAdminDataTable;
use Exception;

class ExpenceAdminController extends Controller
{
    public function __construct()
    {

    }
    public function expenceImages(Request $request,$id){

        try {
            $html = view('expence.expenceImageModal')->render();
            return response()->json([
                'message' => "Expence Images Modal",
                'status' => true,
                'html' => $html,
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'message' => $e->getMessage(),
                'status' => false,
            ], 500);
        }
    }
    public function index(Request $request, ExpenceAdminDataTable $dataTable)
    {
        $users = DB::table('users')->where('is_delete', '=', 'false');
        $authAdmin = auth()->user();
        if ($authAdmin->type == 'sub-admin') {
            $divisionIds = AssignDivisionAdmin::where('admin_id', $authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id', $divisionIds)->pluck('customer_id')->toArray();
            $data['users'] = $data['users']->whereIn('CustomerID', $divisionTeamMemberIds);
        }
        $usersList = $users->select('CustomerName', 'CustomerID')->orderBy('CustomerName', 'asc')->get();
        $customer_id = "all";
        $start_date = Carbon::now()->subYear()->format('Y-m-d');
        $end_date = Carbon::now()->addDay()->format('Y-m-d');

        if (isset($request->customer_id)) {
            $customer_id = $request->customer_id;
        }
        if (isset($request->start_date)) {
            $start_date = $request->start_date;
        }
        if (isset($request->end_date)) {
            $end_date = $request->end_date;
        }
        return $dataTable->with([
            'customer_id' => $customer_id,
            'start_date' => $start_date,
            'end_date' => $end_date,
        ])->render('expence.index', compact('usersList','customer_id','start_date','end_date'));
    }
}
